/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.PublicationInfoNode;

public class PublicationInfo
implements Serializable {
    private static final long serialVersionUID = -5752968731917175200L;
    public static final int PUBLISHED = 1;
    public static final int MODIFIED = 3;
    public static final int NOT_PUBLISHED = 4;
    public static final int UNPUBLISHED = 5;
    public static final int MANDATORY_LANGUAGE_UNPUBLISHABLE = 6;
    public static final int LIVE_MODIFIED = 7;
    public static final int LIVE_ONLY = 8;
    public static final int CONFLICT = 9;
    public static final int MANDATORY_LANGUAGE_VALID = 10;
    public static final int DELETED = 11;
    public static final int MARKED_FOR_DELETION = 12;
    private static final Map<Integer, String> statusToLabel = new HashMap<Integer, String>();
    private transient Map<String, List<String>> allUuidsCache = new HashMap<String, List<String>>();
    private PublicationInfoNode root;
    private Boolean hasLiveNode;

    public static String getLabel(Integer status) {
        return statusToLabel.get(status);
    }

    public PublicationInfo() {
    }

    public PublicationInfo(String rootUuid, String path) {
        this(new PublicationInfoNode(rootUuid, path));
    }

    public PublicationInfo(PublicationInfoNode root) {
        this();
        this.root = root;
    }

    public PublicationInfoNode getRoot() {
        return this.root;
    }

    public void setRoot(PublicationInfoNode root) {
        this.root = root;
    }

    public List<String> getAllUuids() {
        return this.getAllUuids(true, true, true);
    }

    public List<String> getAllUuids(boolean includeDeleted, boolean includePublished) {
        return this.getAllUuids(includeDeleted, includePublished, true);
    }

    public List<String> getAllUuids(boolean includeDeleted, boolean includePublished, boolean includeWorkInProgress) {
        String cacheKey = this.getKey(includeDeleted, includePublished);
        List<String> allUuids = this.allUuidsCache.get(cacheKey);
        if (allUuids != null) {
            return allUuids;
        }
        allUuids = new ArrayList<String>();
        LinkedList<PublicationInfoNode> nodes = new LinkedList<PublicationInfoNode>();
        HashSet<PublicationInfoNode> processed = new HashSet<PublicationInfoNode>();
        nodes.add(this.root);
        processed.add(this.root);
        PublicationInfoNode node = (PublicationInfoNode)nodes.poll();
        while (node != null) {
            for (PublicationInfoNode infoNode : node.getChildren()) {
                if (processed.contains(infoNode)) continue;
                nodes.add(infoNode);
                processed.add(infoNode);
            }
            if (!(!includeDeleted && node.getStatus() == 11 || !includePublished && node.getStatus() == 1 || !includeWorkInProgress && node.isWorkInProgress())) {
                allUuids.add(node.getUuid());
            }
            node = (PublicationInfoNode)nodes.poll();
        }
        this.allUuidsCache.put(cacheKey, allUuids);
        return allUuids;
    }

    private String getKey(boolean includeDeleted, boolean includePublished) {
        return String.valueOf(includeDeleted) + String.valueOf(includePublished);
    }

    public List<PublicationInfo> getAllReferences() {
        LinkedHashSet<PublicationInfo> uuids = new LinkedHashSet<PublicationInfo>();
        LinkedList<PublicationInfoNode> nodes = new LinkedList<PublicationInfoNode>();
        HashSet<PublicationInfoNode> processed = new HashSet<PublicationInfoNode>();
        this.getAllReferences(uuids, nodes, processed);
        return new ArrayList<PublicationInfo>(uuids);
    }

    private void getAllReferences(LinkedHashSet<PublicationInfo> uuids, LinkedList<PublicationInfoNode> nodes, Set<PublicationInfoNode> processedNodes) {
        nodes.add(this.root);
        processedNodes.add(this.root);
        PublicationInfoNode node = nodes.poll();
        while (node != null) {
            for (PublicationInfoNode infoNode : node.getChildren()) {
                if (processedNodes.contains(infoNode)) continue;
                nodes.add(infoNode);
                processedNodes.add(infoNode);
            }
            for (PublicationInfo refInfo : node.getReferences()) {
                if (processedNodes.contains(refInfo.getRoot())) continue;
                refInfo.getAllReferences(uuids, nodes, processedNodes);
            }
            uuids.addAll(node.getReferences());
            node = nodes.poll();
        }
    }

    public void clearInternalAndPublishedReferences(List<String> uuids) {
        ArrayList<PublicationInfoNode> nodes = new ArrayList<PublicationInfoNode>();
        nodes.add(this.root);
        for (int i = 0; i < nodes.size(); ++i) {
            PublicationInfoNode node = (PublicationInfoNode)nodes.get(i);
            ArrayList<PublicationInfo> toRemove = new ArrayList<PublicationInfo>();
            for (PublicationInfo info : node.getReferences()) {
                if (!uuids.contains(info.getRoot().getUuid()) && info.needPublication(null)) continue;
                toRemove.add(info);
            }
            node.getReferences().removeAll(toRemove);
        }
    }

    public Set<Integer> getTreeStatus(String language) {
        String translationNodePath;
        HashSet<Integer> status = new HashSet<Integer>();
        LinkedList<PublicationInfoNode> nodes = new LinkedList<PublicationInfoNode>();
        HashSet<PublicationInfoNode> processed = new HashSet<PublicationInfoNode>();
        nodes.add(this.root);
        processed.add(this.root);
        PublicationInfoNode node = (PublicationInfoNode)nodes.poll();
        String string = translationNodePath = language != null && node.getChildren().size() > 0 ? "/j:translation_" + language : null;
        while (node != null) {
            for (PublicationInfoNode infoNode : node.getChildren()) {
                if (processed.contains(infoNode) || language != null && infoNode.getPath().contains("/j:translation_") && !infoNode.getPath().contains(translationNodePath)) continue;
                nodes.add(infoNode);
            }
            status.add(node.getStatus());
            node = (PublicationInfoNode)nodes.poll();
        }
        return status;
    }

    public boolean needPublication(String language) {
        Set<Integer> treeStatus = this.getTreeStatus(language);
        if (!treeStatus.contains(1) || treeStatus.size() != 1) {
            return true;
        }
        for (PublicationInfo info : this.getAllReferences()) {
            Set<Integer> subTreeStatus = info.getTreeStatus(language);
            if (subTreeStatus.contains(1) && subTreeStatus.size() == 1) continue;
            return true;
        }
        return false;
    }

    public boolean isUnpublicationPossible(String language) {
        Set<Integer> treeStatus = this.getTreeStatus(language);
        if (treeStatus.contains(1)) {
            return true;
        }
        for (PublicationInfo info : this.getAllReferences()) {
            Set<Integer> subTreeStatus = info.getTreeStatus(language);
            if (!subTreeStatus.contains(1)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAllPublishedLanguages() {
        final HashSet<String> result = new HashSet<String>();
        new Object(){

            public void getAllPublishedLanguages(PublicationInfoNode node) {
                if (node.getStatus() != 5 && node.getStatus() != 4 && node.getPath().contains("/j:translation_")) {
                    result.add(StringUtils.substringAfterLast((String)node.getPath(), (String)"/j:translation_"));
                }
                for (PublicationInfoNode childNode : node.getChildren()) {
                    this.getAllPublishedLanguages(childNode);
                }
            }
        }.getAllPublishedLanguages(this.root);
        return result;
    }

    public Boolean hasLiveNode() {
        return this.hasLiveNode;
    }

    public void setHasLiveNode(boolean hasLiveNode) {
        this.hasLiveNode = hasLiveNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationInfo that = (PublicationInfo)o;
        return this.root == that.root || this.root != null && this.root.equals(that.root);
    }

    public int hashCode() {
        return this.root != null ? 31 * super.hashCode() + this.root.hashCode() : super.hashCode();
    }

    public String toString() {
        return this.root != null ? this.root.toString() : super.toString();
    }

    static {
        statusToLabel.put(1, "published");
        statusToLabel.put(12, "markedfordeletion");
        statusToLabel.put(3, "modified");
        statusToLabel.put(4, "notpublished");
        statusToLabel.put(5, "unpublished");
        statusToLabel.put(6, "mandatorylanguageunpublishable");
        statusToLabel.put(7, "livemodified");
        statusToLabel.put(8, "liveonly");
        statusToLabel.put(9, "conflict");
        statusToLabel.put(10, "mandatorylanguagevalid");
        statusToLabel.put(11, "deleted");
    }
}

