/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRSessionWrapper;

public interface PublicationEvent {
    public long getTimestamp();

    public JCRSessionWrapper getSourceSession();

    public JCRSessionWrapper getDestinationSession();

    public Collection<ContentPublicationInfo> getContentPublicationInfos();

    public static class ContentPublicationInfo {
        private String nodeIdentifier;
        private String nodePath;
        private String nodeType;
        private Collection<String> publicationLanguages;

        public ContentPublicationInfo(String nodeIdentifier, String nodePath, String nodeType, Collection<String> publicationLanguages) {
            this.nodeIdentifier = nodeIdentifier;
            this.nodePath = nodePath;
            this.nodeType = nodeType;
            this.publicationLanguages = publicationLanguages == null || publicationLanguages.isEmpty() ? null : Collections.unmodifiableCollection(publicationLanguages);
        }

        public String getNodeIdentifier() {
            return this.nodeIdentifier;
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Collection<String> getPublicationLanguages() {
            return this.publicationLanguages;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodeIdentifier == null ? 0 : this.nodeIdentifier.hashCode());
            result = 31 * result + (this.publicationLanguages == null ? 0 : this.getPublicationLanguagesString().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContentPublicationInfo other = (ContentPublicationInfo)obj;
            if (this.nodeIdentifier == null ? other.nodeIdentifier != null : !this.nodeIdentifier.equals(other.nodeIdentifier)) {
                return false;
            }
            return !(this.publicationLanguages == null ? other.publicationLanguages != null : !this.getPublicationLanguagesString().equals(other.getPublicationLanguagesString()));
        }

        private String getPublicationLanguagesString() {
            return StringUtils.join(this.publicationLanguages, (char)',');
        }
    }
}

