/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIteratorImpl
implements PropertyIterator {
    private static Logger logger = LoggerFactory.getLogger(PropertyIteratorImpl.class);
    private PropertyIterator iterator;
    private JCRSessionWrapper session;
    private JCRStoreProvider jcrStoreProvider;
    private JCRPropertyWrapper nextProperty;

    public PropertyIteratorImpl(PropertyIterator iterator, JCRSessionWrapper session, JCRStoreProvider jcrStoreProvider) {
        this.iterator = iterator;
        this.session = session;
        this.jcrStoreProvider = jcrStoreProvider;
        this.prefetchNext();
    }

    public Property nextProperty() {
        if (this.nextProperty == null) {
            throw new NoSuchElementException();
        }
        JCRPropertyWrapper property = this.nextProperty;
        this.prefetchNext();
        return property;
    }

    private void prefetchNext() {
        this.nextProperty = null;
        while (this.nextProperty == null && this.iterator.hasNext()) {
            try {
                Property next = (Property)this.iterator.next();
                if (this.jcrStoreProvider.getMountPoint().equals("/")) {
                    for (Map.Entry<String, JCRStoreProvider> entry : JCRSessionFactory.getInstance().getMountPoints().entrySet()) {
                        if (!next.getPath().startsWith(entry.getKey() + '/')) continue;
                        this.nextProperty = entry.getValue().getPropertyWrapper(next, this.session);
                        break;
                    }
                }
                if (this.nextProperty != null) continue;
                this.nextProperty = this.jcrStoreProvider.getPropertyWrapper(next, this.session);
            }
            catch (RepositoryException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("failed to wrap property, skipping it...", (Throwable)e);
                } else {
                    logger.warn("failed to wrap property ({}), skipping it...", (Object)e.getMessage());
                }
                this.iterator.remove();
            }
        }
    }

    public void skip(long skipNum) {
        this.iterator.skip(skipNum);
    }

    public long getSize() {
        return this.iterator.getSize();
    }

    public long getPosition() {
        return this.iterator.getPosition();
    }

    public boolean hasNext() {
        return this.nextProperty != null;
    }

    public Object next() {
        return this.nextProperty();
    }

    public void remove() {
        this.iterator.remove();
    }
}

