/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.beans.CategoryBean;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRValueWrapperImpl
implements JCRValueWrapper {
    private static Logger logger = LoggerFactory.getLogger(JCRValueWrapperImpl.class);
    private Value value;
    private final ExtendedPropertyDefinition definition;
    private final JCRSessionWrapper session;

    public JCRValueWrapperImpl(Value value, ExtendedPropertyDefinition definition, JCRSessionWrapper session) {
        this.value = value;
        this.definition = definition;
        this.session = session;
    }

    @Override
    public CategoryBean getCategory() throws ValueFormatException, RepositoryException {
        try {
            Category category = null;
            if (this.getType() == 1) {
                category = Category.getCategory(this.getString().substring(this.getString().lastIndexOf(47) + 1));
            } else if (this.getType() == 9) {
                category = Category.getCategoryByUUID(this.getString());
            }
            if (category == null) {
                throw new ValueFormatException(this.getString() + " is not a valid Jahia Category");
            }
            return new CategoryBean(category);
        }
        catch (JahiaException e) {
            logger.error("Category not found");
            throw new ItemNotFoundException("category " + this.getString() + " not found");
        }
    }

    @Override
    public PropertyDefinition getDefinition() throws RepositoryException {
        return this.definition;
    }

    @Override
    public Date getTime() throws ValueFormatException, RepositoryException {
        return this.getDate().getTime();
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getString();
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        return this.value.getStream();
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getLong();
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getDouble();
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getDate();
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.getBoolean();
    }

    public Binary getBinary() throws RepositoryException {
        return this.value.getBinary();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        return this.value.getDecimal();
    }

    @Override
    public JCRNodeWrapper getNode() throws ValueFormatException, IllegalStateException, RepositoryException {
        String stringValue = this.value.getString();
        if (this.definition.getRequiredType() == 9 || this.definition.getRequiredType() == 10) {
            try {
                return this.session.getNodeByUUID(stringValue);
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        if (this.definition.getRequiredType() == 1) {
            try {
                if (StringUtils.startsWith((String)stringValue, (String)"/")) {
                    return this.session.getNode(stringValue);
                }
                return this.session.getNodeByUUID(stringValue);
            }
            catch (ItemNotFoundException | PathNotFoundException e) {
                return null;
            }
        }
        throw new ValueFormatException("property must be of type REFERENCE or STRING");
    }

    public int getType() {
        return this.value.getType();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.value.equals(((JCRValueWrapperImpl)obj).value);
        }
        return obj != null && obj instanceof Value && obj.equals(this.value);
    }

    public String toString() {
        try {
            return this.value.getString();
        }
        catch (RepositoryException e) {
            return super.toString();
        }
    }
}

