/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;

public class JCRDescendantsNodeIterator
implements JCRNodeIteratorWrapper {
    private Stack<JCRNodeIteratorWrapper> its = new Stack();
    private Predicate<JCRNodeWrapper> recursionPredicate;
    private JCRNodeWrapper next = null;
    private boolean preloaded = false;
    private int position = 0;

    public JCRDescendantsNodeIterator(JCRNodeWrapper node, Predicate<JCRNodeWrapper> recursionPredicate) throws RepositoryException {
        this.its.push(node.getNodes());
        this.recursionPredicate = recursionPredicate;
    }

    private JCRNodeWrapper getNext(boolean forward) {
        if (!this.preloaded) {
            this.preloaded = true;
            try {
                while (!this.its.isEmpty() && !this.its.peek().hasNext()) {
                    this.its.pop();
                }
                if (!this.its.isEmpty()) {
                    this.next = (JCRNodeWrapper)this.its.peek().nextNode();
                    if (this.recursionPredicate.test(this.next)) {
                        this.its.push(this.next.getNodes());
                    }
                } else {
                    this.next = null;
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (forward) {
            this.preloaded = false;
        }
        return this.next;
    }

    @Override
    public Iterator<JCRNodeWrapper> iterator() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.getNext(false) != null;
    }

    public JCRNodeWrapper next() {
        JCRNodeWrapper node = this.getNext(true);
        if (node == null) {
            throw new NoSuchElementException();
        }
        ++this.position;
        return node;
    }

    public Node nextNode() {
        return this.next();
    }

    public void skip(long skipNum) {
        int i = 0;
        while ((long)i < skipNum) {
            this.getNext(true);
            ++i;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
    }

    public long getSize() {
        return -1L;
    }

    public long getPosition() {
        return this.position;
    }
}

