/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.channels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelProvider;

public class ChannelService {
    List<ChannelProvider> channelProviders = new ArrayList<ChannelProvider>();
    private Map<String, Channel> channelMap = new HashMap<String, Channel>();
    private static volatile ChannelService instance = new ChannelService();

    public static ChannelService getInstance() {
        return instance;
    }

    public Channel getChannel(String identifier) {
        Channel result = this.channelMap.get(identifier);
        if (result != null) {
            return result;
        }
        result = new Channel();
        result.setIdentifier(identifier);
        for (ChannelProvider provider : this.channelProviders) {
            Map<String, String> channelCapabilities = provider.getChannelCapabilities(identifier);
            if (channelCapabilities != null) {
                result.getCapabilities().putAll(channelCapabilities);
            }
            if (provider.getFallBack(identifier) != null) {
                result.setFallBack(provider.getFallBack(identifier));
            }
            if (!provider.getAllChannels().contains(identifier)) continue;
            result.setVisible(provider.isVisible(identifier));
        }
        this.channelMap.put(identifier, result);
        return result;
    }

    public Channel resolveChannel(HttpServletRequest request) {
        String result = null;
        for (ChannelProvider provider : this.channelProviders) {
            result = provider.resolveChannel(request);
            if (result == null) continue;
            return this.getChannel(result);
        }
        return null;
    }

    public List<String> getAllChannels() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ChannelProvider provider : this.channelProviders) {
            result.addAll(provider.getAllChannels());
        }
        return new ArrayList<String>(result);
    }

    public void addProvider(ChannelProvider provider) {
        if (this.channelProviders.contains(provider)) {
            this.channelProviders.remove(provider);
        }
        this.channelProviders.add(provider);
        this.channelMap.clear();
        Collections.sort(this.channelProviders, new Comparator<ChannelProvider>(){

            @Override
            public int compare(ChannelProvider o1, ChannelProvider o2) {
                int i = o1.getPriority() - o2.getPriority();
                return i != 0 ? i : 1;
            }
        });
    }

    public boolean matchChannel(String channelId, Channel channel) {
        if (channel != null) {
            if (channelId.equals(channel.getIdentifier())) {
                return true;
            }
            if (channel.getFallBack() != null && !channel.getFallBack().equals("root")) {
                return this.matchChannel(channelId, this.getChannel(channel.getFallBack()));
            }
        }
        return false;
    }

    public void removeProvider(ChannelProvider provider) {
        this.channelProviders.remove(provider);
        this.channelMap.clear();
    }
}

