/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.categories.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryBean;
import org.jahia.services.categories.jcr.JCRCategory;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRCategoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(JCRCategoryProvider.class);
    private transient JCRSessionFactory sessionFactory;

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Node getCategoriesRoot() {
        Node rootNodeWrapper = null;
        try {
            rootNodeWrapper = this.getCategoriesRoot(this.sessionFactory.getCurrentUserSession());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rootNodeWrapper;
    }

    private Node getCategoriesRoot(JCRSessionWrapper jcrSessionWrapper) {
        JCRNodeWrapper rootNodeWrapper = null;
        try {
            rootNodeWrapper = jcrSessionWrapper.getNode(JCRContentUtils.getSystemSitePath() + "/categories");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rootNodeWrapper;
    }

    public List<Category> getRootCategories(JahiaUser user) {
        JCRNodeWrapper rootNodeWrapper = null;
        ArrayList<Category> rootCategories = new ArrayList<Category>();
        try {
            rootNodeWrapper = (JCRNodeWrapper)this.getCategoriesRoot();
            JCRNodeIteratorWrapper it = rootNodeWrapper.getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper rootCategoryNode = (JCRNodeWrapper)it.nextNode();
                if (!rootCategoryNode.isNodeType("jnt:category")) continue;
                rootCategories.add(new Category(this.createCategoryBeanFromNode(rootCategoryNode)));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rootCategories;
    }

    public Category createCategory(String key, Category parentCategory) throws JahiaException {
        Category newCategory = null;
        try {
            JCRSessionWrapper jcrSessionWrapper = this.sessionFactory.getCurrentUserSession();
            JCRNodeWrapper parentNodeWrapper = this.getParentNode(parentCategory, jcrSessionWrapper);
            if (!"default".equals(parentNodeWrapper.getSession().getWorkspace().getName())) {
                parentNodeWrapper = jcrSessionWrapper.getNodeByIdentifier(parentNodeWrapper.getIdentifier());
            }
            jcrSessionWrapper.checkout(parentNodeWrapper);
            JCRNodeWrapper wrapper = parentNodeWrapper.addNode(key, "jnt:category");
            jcrSessionWrapper.save();
            newCategory = new Category(this.createCategoryBeanFromNode(wrapper));
        }
        catch (ItemExistsException e) {
            throw new JahiaException("Category " + key + " already exists", "Category " + key + " already exists", 3, 2);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return newCategory;
    }

    public Category getCategoryByUUID(String categoryUUID) {
        Category categoryByUUID = null;
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live");
            JCRNodeWrapper categoryNode = session.getNodeByUUID(categoryUUID);
            categoryByUUID = new Category(this.createCategoryBeanFromNode(categoryNode));
        }
        catch (PathNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return categoryByUUID;
    }

    public Category getCategoryByPath(String categoryPath) {
        Category categoryByUUID = null;
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live");
            JCRNodeWrapper categoryNode = session.getNode(categoryPath);
            categoryByUUID = new Category(this.createCategoryBeanFromNode(categoryNode));
        }
        catch (PathNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return categoryByUUID;
    }

    public Category getCategoryByKey(String categoryKey, Category parentCategory) {
        Category newCategory = null;
        try {
            JCRSessionWrapper jcrSessionWrapper = this.sessionFactory.getCurrentUserSession("live");
            JCRNodeWrapper parentNodeWrapper = null;
            if (parentCategory != null) {
                parentNodeWrapper = (JCRNodeWrapper)((JCRCategory)parentCategory.getJahiaCategory()).getCategoryNode();
            }
            if (parentNodeWrapper == null) {
                parentNodeWrapper = (JCRNodeWrapper)this.getCategoriesRoot(jcrSessionWrapper);
            }
            JCRNodeWrapper wrapper = parentNodeWrapper.getNode(categoryKey);
            newCategory = new Category(this.createCategoryBeanFromNode(wrapper));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return newCategory;
    }

    public List<Category> findCategoryByKey(String categoryKey) {
        ArrayList<Category> result = new ArrayList<Category>();
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live");
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuilder query = new StringBuilder("SELECT * FROM [jnt:category] as cat WHERE localname(cat) = '");
                query.append(JCRContentUtils.sqlEncode(categoryKey));
                query.append("' ");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                Query q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    Node categoryNode = ni.nextNode();
                    result.add(new Category(this.createCategoryBeanFromNode(categoryNode)));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<Category> findCategoriesStartingByKey(String categoryKey) {
        ArrayList<Category> result = new ArrayList<Category>();
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live");
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuilder query = new StringBuilder("SELECT * FROM [jnt:category] as cat WHERE localname(cat) LIKE '");
                query.append(JCRContentUtils.sqlEncode(categoryKey));
                query.append("%' ");
                query.append(" ORDER BY localname(cat)");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                Query q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    Node categoryNode = ni.nextNode();
                    result.add(new Category(this.createCategoryBeanFromNode(categoryNode)));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<Category> findCategoriesStartingByTitle(String titlePrefix, String language) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Category> findCategoriesContainingTitleString(String title, String language) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Map<String, String> getTitlesForCategory(Category category) throws JahiaException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live");
            Node categoryNode = session.getNodeByIdentifier(category.getJahiaCategory().getId());
            NodeIterator it = categoryNode.getNodes("j:translation*");
            while (it.hasNext()) {
                Node subNode = (Node)it.next();
                String languageCode = subNode.getProperty("jcr:language").getString();
                String title = null;
                try {
                    title = subNode.getProperty("jcr:title").getString();
                }
                catch (PathNotFoundException ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                result.put(languageCode, title);
            }
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getTitleForCategory(Category category, Locale locale) throws JahiaException {
        String title = null;
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession("live", locale);
            Node categoryNode = session.getNodeByIdentifier(category.getJahiaCategory().getId());
            Property titleProperty = categoryNode.getProperty("jcr:title");
            if (titleProperty != null) {
                title = titleProperty.getString();
            }
        }
        catch (PathNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return title;
    }

    public void setTitleForCategory(Category category, Locale locale, String title) throws JahiaException {
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession(null, locale);
            JCRNodeWrapper categoryNode = session.getNodeByIdentifier(category.getJahiaCategory().getId());
            session.checkout(categoryNode);
            categoryNode.setProperty("jcr:title", title);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeTitleForCategory(Category category, Locale locale) throws JahiaException {
        try {
            JCRSessionWrapper session = this.sessionFactory.getCurrentUserSession(null, locale);
            JCRNodeWrapper categoryNode = session.getNodeByIdentifier(category.getJahiaCategory().getId());
            session.checkout(categoryNode);
            categoryNode.getProperty("jcr:title").remove();
            session.save();
        }
        catch (PathNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCategory(CategoryBean categoryBean) throws JahiaException {
        try {
            JCRNodeWrapper node;
            JCRSessionWrapper jcrSessionWrapper;
            block6: {
                jcrSessionWrapper = this.sessionFactory.getCurrentUserSession();
                node = null;
                if (categoryBean.getId() == null) {
                    List<Category> categories = this.findCategoryByKey(categoryBean.getKey());
                    if (categories.size() == 1) {
                        node = jcrSessionWrapper.getNodeByUUID(categories.get(0).getID());
                        break block6;
                    } else {
                        String msg = "Category " + categoryBean.getKey() + (categories.size() == 0 ? "not found" : " exists multiple times and could not be deleted");
                        throw new JahiaException(msg, msg, 3, 2);
                    }
                }
                node = jcrSessionWrapper.getNodeByUUID(categoryBean.getId());
            }
            if (node == null) return;
            if (!node.getParent().isCheckedOut()) {
                jcrSessionWrapper.checkout(node.getParent());
            }
            node.remove();
            jcrSessionWrapper.save();
            return;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private CategoryBean createCategoryBeanFromNode(Node categoryNode) {
        JCRCategory categoryBean = new JCRCategory(categoryNode);
        return categoryBean;
    }

    public List<Category> findCategoriesByPropNameAndValue(String propName, String propValue, JahiaUser user) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void removeProperties(String categoryId) {
        logger.error("method nor supported yet");
    }

    public Properties getProperties(String categoryId) {
        logger.error("method nor supported yet");
        return null;
    }

    public void setProperties(String categoryId, Properties properties) {
        logger.error("method nor supported yet");
    }

    public List<Category> getCategoryChildCategories(Category parentCategory, JahiaUser user) throws JahiaException {
        ArrayList<Category> rootCategories = new ArrayList<Category>();
        try {
            JCRSessionWrapper jcrSessionWrapper = this.sessionFactory.getCurrentUserSession("live");
            JCRNodeWrapper parentNodeWrapper = this.getParentNode(parentCategory, jcrSessionWrapper);
            JCRNodeIteratorWrapper iterator = parentNodeWrapper.getNodes();
            while (iterator.hasNext()) {
                JCRNodeWrapper rootCategoryNode = (JCRNodeWrapper)iterator.nextNode();
                if (!rootCategoryNode.isNodeType("jnt:category")) continue;
                rootCategories.add(new Category(this.createCategoryBeanFromNode(rootCategoryNode)));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rootCategories;
    }

    private JCRNodeWrapper getParentNode(Category parentCategory, JCRSessionWrapper jcrSessionWrapper) throws RepositoryException {
        JCRNodeWrapper parentNodeWrapper = null;
        if (parentCategory != null) {
            parentNodeWrapper = (JCRNodeWrapper)((JCRCategory)parentCategory.getJahiaCategory()).getCategoryNode();
        }
        if (parentNodeWrapper == null) {
            parentNodeWrapper = (JCRNodeWrapper)this.getCategoriesRoot(jcrSessionWrapper);
        }
        return parentNodeWrapper;
    }
}

