/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheProvider;
import org.jahia.services.cache.CacheService;
import org.jahia.services.cache.dummy.DummyCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory
extends CacheService {
    private static final Logger logger = LoggerFactory.getLogger(CacheFactory.class);
    private final Map<String, Cache<?, ?>> caches = new ConcurrentHashMap(53);
    private Map<String, CacheProvider> cacheProviders = new HashMap<String, CacheProvider>();
    private Map<String, String> cacheProviderForCache = new HashMap<String, String>();
    public static final String DEFAULT_CACHE = "default";

    private CacheFactory() {
    }

    @Override
    public void start() throws JahiaInitializationException {
        if (this.cacheProviders.isEmpty()) {
            logger.warn("No cache provider are configured. Using no-cache provider as a default one.");
            this.cacheProviders.put(DEFAULT_CACHE, new DummyCacheProvider());
        }
        for (CacheProvider cacheProvider : this.cacheProviders.values()) {
            cacheProvider.init(this.settingsBean, this);
        }
    }

    @Override
    public synchronized void stop() throws JahiaException {
        this.caches.clear();
        for (CacheProvider provider : this.cacheProviders.values()) {
            try {
                provider.shutdown();
            }
            catch (Exception exception) {}
        }
    }

    public static CacheFactory getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, boolean forceCreation) throws JahiaInitializationException {
        Cache cache = this.getCache(name);
        if (cache != null || !forceCreation) {
            return cache;
        }
        String provider = this.cacheProviderForCache.get(name);
        if (provider == null) {
            provider = DEFAULT_CACHE;
        }
        return this.createCacheInstance(name, provider);
    }

    protected synchronized <K, V> Cache<K, V> createCacheInstance(String name, String cacheProvider) throws JahiaInitializationException {
        if (name == null) {
            return null;
        }
        Cache cache = this.getCache(name);
        if (cache != null) {
            return cache;
        }
        cache = new Cache(name, this.cacheProviders.get(cacheProvider).newCacheImplementation(name));
        logger.info("Created cache instance [{}]", (Object)name);
        if (this.registerCache(cache)) {
            return cache;
        }
        cache = null;
        return null;
    }

    private boolean registerCache(Cache<?, ?> cache) {
        this.caches.put(cache.getName(), cache);
        return true;
    }

    public Cache getCache(String name) {
        if (name == null) {
            return null;
        }
        return this.caches.get(name);
    }

    @Override
    public Set<String> getNames() {
        return this.caches.keySet();
    }

    @Override
    public void flushAllCaches() {
        for (String curCacheName : this.getNames()) {
            Cache<?, ?> cache = this.caches.get(curCacheName);
            cache.flush();
        }
        logger.info("Flushed all caches.");
    }

    @Override
    public Map<String, CacheProvider> getCacheProviders() {
        return this.cacheProviders;
    }

    @Override
    public void setCacheProviders(Map<String, CacheProvider> cacheProviders) {
        if (cacheProviders != null) {
            this.cacheProviders.putAll(cacheProviders);
        }
    }

    public Map<String, String> getCacheProviderForCache() {
        return this.cacheProviderForCache;
    }

    public void setCacheProviderForCache(Map<String, String> cacheProviderForCache) {
        if (cacheProviderForCache != null) {
            this.cacheProviderForCache.putAll(cacheProviderForCache);
        }
    }

    private static class Holder {
        static final CacheFactory INSTANCE = new CacheFactory();

        private Holder() {
        }
    }
}

