/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.applications.ApplicationsManagerService;
import org.jahia.services.applications.DispatchingProvider;
import org.jahia.services.applications.DispatchingService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchingServiceImpl
extends DispatchingService {
    private static Logger logger = LoggerFactory.getLogger(DispatchingServiceImpl.class);
    private static DispatchingServiceImpl singletonInstance = null;
    private static final String ENTRYPOINT_ID_SEPARATOR = "_";
    private Map dispatchingProviders = new LinkedHashMap();
    private ApplicationsManagerService applicationsManager;

    protected DispatchingServiceImpl() {
    }

    public static synchronized DispatchingServiceImpl getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DispatchingServiceImpl();
        }
        return singletonInstance;
    }

    public void setApplicationsManager(ApplicationsManagerService applicationsManager) {
        this.applicationsManager = applicationsManager;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() {
    }

    @Override
    public String getAppOutput(int fieldID, String entryPointIDStr, JahiaUser jahiaUser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, String workspaceName) throws JahiaException {
        String fieldIDStr = Integer.toString(fieldID);
        String entryPointUniqueIDStr = fieldIDStr + ENTRYPOINT_ID_SEPARATOR + entryPointIDStr;
        EntryPointInstance entryPointInstance = ServicesRegistry.getInstance().getApplicationsManagerService().getEntryPointInstance(entryPointIDStr, workspaceName);
        if (entryPointInstance == null) {
            if (entryPointIDStr != null) {
                logger.error("Couldn't find application entry point with ID=" + entryPointIDStr);
            } else {
                logger.debug(" --> no selected application.");
            }
            return "";
        }
        ApplicationBean appBean = this.applicationsManager.getApplicationByContext(entryPointInstance.getContextName());
        if (appBean == null) {
            logger.error("Couldn't find application with appID=" + entryPointIDStr);
            return "";
        }
        DispatchingProvider dispatcher = (DispatchingProvider)this.dispatchingProviders.get(appBean.getType());
        if (dispatcher == null) {
            logger.error("Found no dispatching that corresponds to application type [" + appBean.getType() + "]");
            return "";
        }
        Object url = httpServletRequest.getAttribute("url");
        httpServletRequest.setAttribute("url", null);
        String renderResult = null;
        if (httpServletRequest != null) {
            if (httpServletRequest.getAttribute("org.jahia.applications.renderAlreadyProcessed." + entryPointUniqueIDStr) == null) {
                renderResult = dispatcher.render(entryPointInstance, entryPointInstance.getID(), jahiaUser, httpServletRequest, httpServletResponse, servletContext, workspaceName);
                httpServletRequest.setAttribute("org.jahia.applications.renderAlreadyProcessed." + entryPointUniqueIDStr, (Object)renderResult);
            } else {
                renderResult = (String)httpServletRequest.getAttribute("org.jahia.applications.renderAlreadyProcessed." + entryPointUniqueIDStr);
            }
        }
        httpServletRequest.setAttribute("url", url);
        return renderResult;
    }

    public Map getDispatchingProviders() {
        return this.dispatchingProviders;
    }

    public void setDispatchingProviders(Map dispatchingProviders) {
        this.dispatchingProviders = dispatchingProviders;
    }
}

