/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortletRegistryEvent;
import org.apache.pluto.container.driver.PortletRegistryListener;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.data.applications.WebAppContext;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.applications.ApplicationsManagerProvider;
import org.jahia.services.applications.ApplicationsManagerService;
import org.jahia.services.applications.CustomPortletMode;
import org.jahia.services.applications.CustomWindowState;
import org.jahia.services.applications.ServletContextManager;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRPortletNode;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ApplicationsManagerServiceImpl
extends ApplicationsManagerService
implements JahiaAfterInitializationService {
    private static Logger logger = LoggerFactory.getLogger(ApplicationsManagerServiceImpl.class);
    private static ApplicationsManagerServiceImpl instance;
    public static final String WEBAPPS_PERMISSION_PATH = "/permissions/webapps/";
    private ApplicationBean dummyComparator;
    private boolean isLoaded = false;
    private List<PortletMode> supportedPortletModes = new ArrayList<PortletMode>();
    private List<WindowState> supportedWindowStates = new ArrayList<WindowState>();
    private Map<String, ApplicationsManagerProvider> managerProviders = new LinkedHashMap<String, ApplicationsManagerProvider>();
    private JCRTemplate jcrTemplate;
    private CacheService cacheService;
    private JahiaGroupManagerService groupManagerService;
    private ServletContextManager servletContextManager;
    private Cache<String, ApplicationBean> applicationCache;
    private static final String APPLICATION_DEFINITION = "ApplicationDefinition";
    private static final String APPLICATION_DEFINITION_CONTEXT = "ApplicationDefinitionContext";
    private Cache<String, EntryPointInstance> entryPointCache;
    private static final String ENTRY_POINT_INSTANCE = "EntryPointInstance";
    private PlutoServices plutoServices;
    private Map<String, String> defaultPortletPermissionMappings;
    private Map<String, String> defaultWebAppRoleMappings;
    private Map<String, String> defaultPortletModeMappings;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setManagerProviders(Map<String, ApplicationsManagerProvider> managerProviders) {
        this.managerProviders = managerProviders;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public void setServletContextManager(ServletContextManager servletContextManager) {
        this.servletContextManager = servletContextManager;
    }

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void setPlutoServices(PlutoServices plutoServices) {
        this.plutoServices = plutoServices;
    }

    public void setDefaultPortletPermissionMappings(Map<String, String> defaultPortletPermissionMappings) {
        this.defaultPortletPermissionMappings = defaultPortletPermissionMappings;
    }

    public void setDefaultWebAppRoleMappings(Map<String, String> defaultWebAppRoleMappings) {
        this.defaultWebAppRoleMappings = defaultWebAppRoleMappings;
    }

    public void setDefaultPortletModeMappings(Map<String, String> defaultPortletModeMappings) {
        this.defaultPortletModeMappings = defaultPortletModeMappings;
    }

    protected ApplicationsManagerServiceImpl() {
        this.dummyComparator = new ApplicationBean("", "", "", true, "", "");
    }

    public static synchronized ApplicationsManagerServiceImpl getInstance() {
        if (instance == null) {
            instance = new ApplicationsManagerServiceImpl();
        }
        return instance;
    }

    @Override
    public void start() throws JahiaInitializationException {
        this.applicationCache = this.cacheService.getCache("ApplicationCache", true);
        this.entryPointCache = this.cacheService.getCache("ApplicationEntryPointCache", true);
        this.supportedPortletModes.add(PortletMode.VIEW);
        this.supportedPortletModes.add(PortletMode.EDIT);
        this.supportedPortletModes.add(PortletMode.HELP);
        this.supportedWindowStates.add(WindowState.NORMAL);
        this.supportedWindowStates.add(WindowState.MINIMIZED);
        this.supportedWindowStates.add(WindowState.MAXIMIZED);
        this.isLoaded = true;
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        try {
            this.loadAllApplications();
        }
        catch (Exception e) {
            throw new JahiaInitializationException("JahiaApplicationsManagerBaseService.init, exception occured : " + e.getMessage(), e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ApplicationBean getApplication(final String appID) throws JahiaException {
        this.checkIsLoaded();
        ApplicationBean app = this.applicationCache.get(APPLICATION_DEFINITION + appID);
        if (app == null) {
            try {
                app = this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<ApplicationBean>(){

                    @Override
                    public ApplicationBean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        return ApplicationsManagerServiceImpl.this.fromNodeToBean(session.getNodeByUUID(appID));
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (app != null) {
                this.applicationCache.put(APPLICATION_DEFINITION + appID, app);
                this.applicationCache.put(APPLICATION_DEFINITION_CONTEXT + app.getContext(), app);
            }
        }
        return app;
    }

    private ApplicationBean fromNodeToBean(JCRNodeWrapper wrapper) throws RepositoryException {
        return new ApplicationBean(wrapper.getIdentifier(), wrapper.getPropertyAsString("j:name"), wrapper.getPropertyAsString("j:context"), wrapper.getProperty("j:isVisible").getBoolean(), wrapper.getPropertyAsString("j:description"), wrapper.getPropertyAsString("j:type"));
    }

    @Override
    public ApplicationBean getApplicationByContext(String context) throws JahiaException {
        this.checkIsLoaded();
        this.syncPlutoWithDB();
        if (context == null) {
            return null;
        }
        ApplicationBean app = this.applicationCache.get(APPLICATION_DEFINITION_CONTEXT + context);
        if (app == null && (app = this.getApplicationByContextAndJCRCall(context)) != null) {
            this.putInApplicationCache(app);
        }
        return app;
    }

    private ApplicationBean getApplicationByContextAndJCRCall(final String context) {
        try {
            return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<ApplicationBean>(){

                @Override
                public ApplicationBean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    if (session.getWorkspace().getQueryManager() != null) {
                        String query = "SELECT * FROM [jnt:portletDefinition] as def where def.[j:context] = '" + context + "' ORDER BY def.[j:context]";
                        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                        QueryResult qr = q.execute();
                        NodeIterator nodes = qr.getNodes();
                        if (nodes.hasNext()) {
                            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodes.next();
                            return ApplicationsManagerServiceImpl.this.fromNodeToBean(nodeWrapper);
                        }
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving applicaion by context", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ApplicationBean> getApplications() throws JahiaException {
        this.checkIsLoaded();
        this.syncPlutoWithDB();
        try {
            return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<List<ApplicationBean>>(){

                @Override
                public List<ApplicationBean> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    ArrayList<ApplicationBean> apps = new ArrayList<ApplicationBean>();
                    if (session.getWorkspace().getQueryManager() != null) {
                        String query = "SELECT * FROM [jnt:portletDefinition] as def ORDER BY def.[j:context]";
                        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                        QueryResult qr = q.execute();
                        NodeIterator nodes = qr.getNodes();
                        while (nodes.hasNext()) {
                            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodes.next();
                            apps.add(ApplicationsManagerServiceImpl.this.fromNodeToBean(nodeWrapper));
                        }
                        Collections.sort(apps, ApplicationsManagerServiceImpl.this.dummyComparator);
                    }
                    return apps;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving the list of applications", (Throwable)e);
            return new ArrayList<ApplicationBean>();
        }
    }

    @Override
    public boolean setVisible(String appID, boolean visible) throws JahiaException {
        this.checkIsLoaded();
        ApplicationBean app = this.getApplication(appID);
        if (app != null) {
            app.setVisible(visible);
            return this.saveDefinition(app);
        }
        return false;
    }

    private static String getCompactName(String name) {
        String appName = name;
        appName = Patterns.DASH.matcher(appName).replaceAll("");
        appName = Patterns.UNDERSCORE.matcher(appName).replaceAll("");
        appName = Patterns.DOT.matcher(appName).replaceAll("");
        return appName;
    }

    public static String getWebAppNamespaceURI(String appName) {
        return "http://www.jahia.org/portlets/" + appName;
    }

    public static String getWebAppPrefix(String appName) {
        return JCRContentUtils.encodeJCRNamePrefix(ApplicationsManagerServiceImpl.getCompactName(appName));
    }

    public static String getEntryPointNamespaceURI(String appName, String entryPointDefinitionName) {
        return ApplicationsManagerServiceImpl.getWebAppNamespaceURI(appName) + "/" + entryPointDefinitionName;
    }

    public static String getEntryPointPrefix(String appName, String entryPointDefinitionName) {
        return JCRContentUtils.encodeJCRNamePrefix(ApplicationsManagerServiceImpl.getCompactName(appName + entryPointDefinitionName));
    }

    public static String getWebAppQualifiedNodeName(String appName, String localName) {
        return ApplicationsManagerServiceImpl.getWebAppPrefix(appName) + ":" + localName;
    }

    public static String getPortletQualifiedNodeName(String appName, String entryPointDefinitionName, String localName) {
        return ApplicationsManagerServiceImpl.getEntryPointPrefix(appName, entryPointDefinitionName) + ":" + localName;
    }

    @Override
    public boolean addDefinition(final ApplicationBean app) throws JahiaException {
        this.checkIsLoaded();
        if (app == null) {
            return false;
        }
        boolean ret = false;
        try {
            this.registerNamespace(ApplicationsManagerServiceImpl.getWebAppPrefix(app.getName()), ApplicationsManagerServiceImpl.getWebAppNamespaceURI(app.getName()));
            for (EntryPointDefinition entryPointDefinition : app.getEntryPointDefinitions()) {
                this.registerNamespace(ApplicationsManagerServiceImpl.getEntryPointPrefix(app.getName(), entryPointDefinition.getName()), ApplicationsManagerServiceImpl.getEntryPointNamespaceURI(app.getName(), entryPointDefinition.getName()));
            }
            ret = this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper parentNode = session.getNode("/portletdefinitions");
                    String name = Patterns.SLASH.matcher(app.getName()).replaceAll("___");
                    session.checkout(parentNode);
                    JCRNodeWrapper wrapper = parentNode.addNode(name, "jnt:portletDefinition");
                    wrapper.setProperty("j:context", app.getContext());
                    wrapper.setProperty("j:name", app.getName());
                    wrapper.setProperty("j:description", app.getDescription());
                    wrapper.setProperty("j:type", app.getType());
                    wrapper.setProperty("j:isVisible", app.isVisible());
                    session.save();
                    app.setID(wrapper.getIdentifier());
                    String webappPath = ApplicationsManagerServiceImpl.WEBAPPS_PERMISSION_PATH + app.getName();
                    String webappRolesPath = webappPath + "/" + ApplicationsManagerServiceImpl.getWebAppQualifiedNodeName(app.getName(), "roles");
                    ApplicationsManagerServiceImpl.this.getOrCreatePermissionNode(webappRolesPath, session);
                    session.save();
                    try {
                        WebAppContext appContext = ApplicationsManagerServiceImpl.this.servletContextManager.getApplicationContext(app);
                        for (String webAppRoleName : appContext.getRoles()) {
                            String jahiaRolePath;
                            JCRNodeWrapper permission = ApplicationsManagerServiceImpl.this.getOrCreatePermissionNode(webappRolesPath + "/" + ApplicationsManagerServiceImpl.getWebAppQualifiedNodeName(app.getName(), webAppRoleName), session);
                            session.save();
                            if (ApplicationsManagerServiceImpl.this.defaultWebAppRoleMappings == null || (jahiaRolePath = (String)ApplicationsManagerServiceImpl.this.defaultWebAppRoleMappings.get(webAppRoleName)) == null) continue;
                            ApplicationsManagerServiceImpl.this.grantPermissionToRole(permission, jahiaRolePath, session);
                        }
                    }
                    catch (JahiaException e) {
                        logger.error("Error while retrieving web application roles", (Throwable)e);
                    }
                    for (EntryPointDefinition entryPointDefinition : app.getEntryPointDefinitions()) {
                        String portletsPath = webappPath + "/" + ApplicationsManagerServiceImpl.getWebAppQualifiedNodeName(app.getName(), "portlets");
                        String createInstancesPermPath = portletsPath + "/" + ApplicationsManagerServiceImpl.getPortletQualifiedNodeName(app.getName(), entryPointDefinition.getName(), "createInstance");
                        JCRNodeWrapper createInstancesPermNode = ApplicationsManagerServiceImpl.this.getOrCreatePermissionNode(createInstancesPermPath, session);
                        session.save();
                        if (ApplicationsManagerServiceImpl.this.defaultPortletPermissionMappings != null) {
                            String jahiaRolePath = (String)ApplicationsManagerServiceImpl.this.defaultPortletPermissionMappings.get("createInstance");
                            ApplicationsManagerServiceImpl.this.grantPermissionToRole(createInstancesPermNode, jahiaRolePath, session);
                        }
                        String portletModePath = webappPath + "/" + ApplicationsManagerServiceImpl.getWebAppQualifiedNodeName(app.getName(), "portlets") + "/" + ApplicationsManagerServiceImpl.getPortletQualifiedNodeName(app.getName(), entryPointDefinition.getName(), "modes");
                        ApplicationsManagerServiceImpl.this.getOrCreatePermissionNode(portletModePath, session);
                        session.save();
                        for (PortletMode portletMode : entryPointDefinition.getPortletModes()) {
                            String jahiaRolePath;
                            JCRNodeWrapper permission = ApplicationsManagerServiceImpl.this.getOrCreatePermissionNode(portletModePath + "/" + ApplicationsManagerServiceImpl.getPortletQualifiedNodeName(app.getName(), entryPointDefinition.getName(), portletMode.toString()), session);
                            session.save();
                            if (ApplicationsManagerServiceImpl.this.defaultPortletModeMappings == null || (jahiaRolePath = (String)ApplicationsManagerServiceImpl.this.defaultPortletModeMappings.get(portletMode.toString())) == null) continue;
                            ApplicationsManagerServiceImpl.this.grantPermissionToRole(permission, jahiaRolePath, session);
                        }
                    }
                    session.save();
                    JahiaPrivilegeRegistry.init(session);
                    return true;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.putInApplicationCache(app);
        return ret;
    }

    private void grantPermissionToRole(JCRNodeWrapper permission, String jahiaRolePath, JCRSessionWrapper session) throws RepositoryException {
        try {
            JCRNodeWrapper n = session.getNode(jahiaRolePath);
            session.checkout(n);
            Value newValue = session.getValueFactory().createValue(permission.getName());
            if (n.hasProperty("j:permissionNames")) {
                ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(n.getProperty("j:permissionNames").getValues()));
                values.add(newValue);
                n.setProperty("j:permissionNames", values.toArray(new Value[values.size()]));
            } else {
                n.setProperty("j:permissionNames", new Value[]{newValue});
            }
            session.save();
        }
        catch (PathNotFoundException e) {
            logger.warn("Couldn't find Jahia role " + jahiaRolePath + " to map permission " + permission.getName() + ", will not map the role");
        }
    }

    private JCRNodeWrapper getOrCreatePermissionNode(String path, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper parentNode = session.getRootNode();
        return JCRContentUtils.getOrAddPath(session, parentNode, path, "jnt:permission");
    }

    @Override
    public boolean saveDefinition(final ApplicationBean app) throws JahiaException {
        this.checkIsLoaded();
        if (app == null) {
            return false;
        }
        boolean ret = false;
        try {
            ret = this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper wrapper = session.getNodeByUUID(app.getID());
                    wrapper.setProperty("j:context", app.getContext());
                    wrapper.setProperty("j:name", app.getName());
                    wrapper.setProperty("j:description", app.getDescription());
                    wrapper.setProperty("j:type", app.getType());
                    wrapper.setProperty("j:isVisible", app.isVisible());
                    session.save();
                    app.setID(wrapper.getIdentifier());
                    return true;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.putInApplicationCache(app);
        return ret;
    }

    @Override
    public void removeApplication(final String appID) throws JahiaException {
        this.checkIsLoaded();
        try {
            this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    session.getNodeByUUID(appID).remove();
                    session.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.applicationCache.flush();
    }

    @Override
    public WebAppContext getApplicationContext(String id) throws JahiaException {
        return this.servletContextManager.getApplicationContext(id);
    }

    @Override
    public WebAppContext getApplicationContext(ApplicationBean appBean) throws JahiaException {
        return this.servletContextManager.getApplicationContext(appBean);
    }

    @Override
    public EntryPointInstance createEntryPointInstance(EntryPointDefinition entryPointDefinition, String path) throws JahiaException {
        if (entryPointDefinition == null) {
            return null;
        }
        ApplicationBean appBean = this.getApplication(entryPointDefinition.getApplicationID());
        ApplicationsManagerProvider appProvider = this.getProvider(appBean);
        EntryPointInstance epInstance = null;
        try {
            epInstance = appProvider.createEntryPointInstance(entryPointDefinition);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to retrieve entry point definitions for application " + appBean.getID(), (Throwable)je);
        }
        if (epInstance != null) {
            try {
                EntryPointInstance epInstance1 = epInstance;
                JCRSessionWrapper session = this.jcrTemplate.getSessionFactory().getCurrentUserSession();
                JCRNodeWrapper parentNode = session.getNode(path);
                session.checkout(parentNode);
                String name = epInstance1.getResKeyName() != null ? epInstance1.getResKeyName() : Patterns.SLASH.matcher(appBean.getName()).replaceAll("___") + Math.round(Math.random() * 1000000.0);
                JCRPortletNode wrapper = (JCRPortletNode)parentNode.addNode(name, "jnt:portlet");
                String scope = epInstance1.getCacheScope();
                if (scope != null) {
                    wrapper.setProperty("j:cacheScope", scope);
                }
                wrapper.setApplication(appBean.getID(), epInstance1.getDefName());
                wrapper.setProperty("j:expirationTime", epInstance1.getExpirationTime());
                session.save();
                epInstance1.setID(wrapper.getUUID());
                return epInstance1;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.entryPointCache.put(ENTRY_POINT_INSTANCE + epInstance.getID(), epInstance);
            }
        }
        return null;
    }

    @Override
    public PortletWindow getPortletWindow(EntryPointInstance entryPointInstance, String windowID, JahiaUser jahiaUser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, String workspaceName) throws JahiaException {
        ApplicationBean appBean = this.getApplicationByContext(entryPointInstance.getContextName());
        ApplicationsManagerProvider appProvider = this.getProvider(appBean);
        return appProvider.getPortletWindow(entryPointInstance, windowID, jahiaUser, httpServletRequest, httpServletResponse, servletContext, workspaceName);
    }

    @Override
    public List<EntryPointDefinition> getAppEntryPointDefinitions(ApplicationBean appBean) {
        ApplicationsManagerProvider appProvider = this.getProvider(appBean);
        try {
            return appProvider.getAppEntryPointDefinitions(appBean);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to retrieve entry point definitions for application " + appBean.getID(), (Throwable)je);
            return Collections.emptyList();
        }
    }

    @Override
    public EntryPointInstance getEntryPointInstance(String epInstanceID, String workspaceName) throws JahiaException {
        EntryPointInstance[] entryPointInstanceByID = new EntryPointInstance[]{this.entryPointCache.get(ENTRY_POINT_INSTANCE + epInstanceID)};
        if (entryPointInstanceByID[0] == null && epInstanceID != null && !"".equals(epInstanceID) && !"<empty>".equals(epInstanceID)) {
            try {
                JCRSessionWrapper session = this.jcrTemplate.getSessionFactory().getCurrentUserSession(workspaceName);
                JCRPortletNode node = (JCRPortletNode)session.getNodeByUUID(epInstanceID);
                entryPointInstanceByID[0] = this.getEntryPointInstance(node);
                this.entryPointCache.put(ENTRY_POINT_INSTANCE + epInstanceID, entryPointInstanceByID[0]);
                return entryPointInstanceByID[0];
            }
            catch (ItemNotFoundException e) {
                logger.debug("User " + JCRSessionFactory.getInstance().getCurrentUser().getName() + " could not load the portlet instance :" + epInstanceID);
                return null;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return entryPointInstanceByID[0];
    }

    @Override
    public EntryPointInstance getEntryPointInstance(JCRPortletNode node) throws RepositoryException {
        String contextName = node.getContextName();
        if (contextName == null) {
            return null;
        }
        EntryPointInstance entryPointInstance = new EntryPointInstance(node.getUUID(), contextName, node.getDefinitionName(), node.getName());
        if (node.hasProperty("j:cacheScope")) {
            entryPointInstance.setCacheScope(node.getCacheScope());
        }
        if (node.hasProperty("j:expirationTime")) {
            entryPointInstance.setExpirationTime(node.getExpirationTime());
        }
        return entryPointInstance;
    }

    @Override
    public void removeEntryPointInstance(String epInstanceID) throws JahiaException {
        try {
            if (epInstanceID != null) {
                JCRSessionWrapper session = this.jcrTemplate.getSessionFactory().getCurrentUserSession();
                JCRNodeWrapper node = session.getNodeByUUID(epInstanceID);
                node.remove();
                session.save();
                this.entryPointCache.remove(ENTRY_POINT_INSTANCE + epInstanceID);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadAllApplications() {
        List<ApplicationBean> apps = null;
        try {
            apps = this.getApplications();
            this.loadApplicationPrivileges(apps);
        }
        catch (JahiaException e) {
            logger.error("Error while loading all the applications", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error registering JCR namespaces and loading privileges for portlets", (Throwable)e);
        }
        if (apps != null) {
            Iterator<ApplicationBean> iterator = apps.iterator();
            while (iterator.hasNext()) {
                ApplicationBean app1;
                ApplicationBean app = app1 = iterator.next();
                this.putInApplicationCache(app);
            }
        }
    }

    private void checkIsLoaded() throws JahiaException {
        if (!this.isLoaded) {
            throw new JahiaException("Error accessing a service that was not initialized successfully", "Error accessing a service that was not initialized successfully", 12, 3);
        }
    }

    private void syncPlutoWithDB() throws JahiaException {
        PortletRegistryService portletRegistryService = this.plutoServices.getPortletRegistryService();
        Iterator portletApplicationNames = portletRegistryService.getRegisteredPortletApplicationNames();
        while (portletApplicationNames.hasNext()) {
            String currentPortletApplicationName = (String)portletApplicationNames.next();
            String currentContext = !currentPortletApplicationName.startsWith("/") ? "/" + currentPortletApplicationName : currentPortletApplicationName;
            ApplicationBean app = this.applicationCache.get(APPLICATION_DEFINITION_CONTEXT + currentContext);
            if (app == null && (app = this.getApplicationByContextAndJCRCall(currentContext)) != null) {
                this.putInApplicationCache(app);
            }
            if (app != null) continue;
            logger.info("Registering portlet context " + currentPortletApplicationName + " in Jahia.");
            this.registerWebApps(currentContext);
        }
    }

    private void registerWebApps(String context) throws JahiaException {
        this.addDefinition(new ApplicationBean("", !context.startsWith("/") ? context : context.substring(1), context, true, "", "portlet"));
    }

    private void putInApplicationCache(ApplicationBean app) {
        this.applicationCache.put(APPLICATION_DEFINITION + app.getID(), app);
        this.applicationCache.put(APPLICATION_DEFINITION_CONTEXT + app.getContext(), app);
    }

    private ApplicationsManagerProvider getProvider(ApplicationBean appBean) {
        return this.managerProviders.get(appBean.getType());
    }

    public void loadCustomPortletModes(String supportedPortletModesConfigFileName) {
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setLogger(LogFactory.getLog(Digester.class));
        digester.addObjectCreate("portlet-modes/portlet-mode", CustomPortletMode.class);
        digester.addBeanPropertySetter("portlet-modes/portlet-mode/name", "name");
        digester.addSetNext("portlet-modes/portlet-mode", "addCustomPortletMode", CustomPortletMode.class.getName());
        File supportedPortletModesConfigFile = new File(supportedPortletModesConfigFileName);
        try {
            digester.parse(supportedPortletModesConfigFile);
        }
        catch (IOException ioe) {
            logger.error("Error while trying to load support portlet modes from file " + supportedPortletModesConfigFile, (Throwable)ioe);
        }
        catch (SAXException saxe) {
            logger.error("Error while trying to load support portlet modes from file " + supportedPortletModesConfigFile, (Throwable)saxe);
        }
    }

    public void addCustomPortletModeBean(CustomPortletMode customPortletMode) {
        this.supportedPortletModes.add(new PortletMode(customPortletMode.getName()));
    }

    @Override
    public List<PortletMode> getSupportedPortletModes() {
        return this.supportedPortletModes;
    }

    public void loadCustomWindowStates(String supportedWindowStatesConfigFileName) {
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setLogger(LogFactory.getLog(Digester.class));
        digester.addObjectCreate("window-states/window-state", CustomWindowState.class);
        digester.addBeanPropertySetter("window-states/window-state/name", "name");
        digester.addSetNext("window-states/window-state", "addCustomWindowState", CustomWindowState.class.getName());
        File supportedWindowStatesConfigFile = new File(supportedWindowStatesConfigFileName);
        try {
            digester.parse(supportedWindowStatesConfigFile);
        }
        catch (IOException ioe) {
            logger.error("Error while trying to load support portlet modes from file " + supportedWindowStatesConfigFile, (Throwable)ioe);
        }
        catch (SAXException saxe) {
            logger.error("Error while trying to load support portlet modes from file " + supportedWindowStatesConfigFile, (Throwable)saxe);
        }
    }

    public void addCustomWindowState(CustomWindowState customWindowState) {
        this.supportedWindowStates.add(new WindowState(customWindowState.getName()));
    }

    @Override
    public List<WindowState> getSupportedWindowStates() {
        return this.supportedWindowStates;
    }

    public void registerListeners() {
        this.plutoServices.getPortletRegistryService().addPortletRegistryListener(new PortletRegistryListener(){

            public void portletApplicationRegistered(PortletRegistryEvent evt) {
                ApplicationsManagerServiceImpl.this.servletContextManager.removeContextFromCache(evt.getApplicationName());
                try {
                    ApplicationsManagerServiceImpl.this.loadApplicationPrivileges(evt);
                    ApplicationsManagerServiceImpl.this.syncPlutoWithDB();
                }
                catch (Exception e) {
                    logger.error("Error registering application '" + evt.getApplicationName() + "'. Cause: " + e.getMessage(), (Throwable)e);
                }
            }

            public void portletApplicationRemoved(PortletRegistryEvent evt) {
            }
        });
        try {
            this.syncPlutoWithDB();
        }
        catch (Exception e) {
            logger.error("Error synchronizing deployed portlets state with the internal registry. Cause: " + e.getMessage(), (Throwable)e);
        }
    }

    private void loadApplicationPrivileges(PortletRegistryEvent evt) throws RepositoryException {
        PortletApplicationDefinition portletApplication = evt.getPortletApplication();
        String applicationName = portletApplication.getName();
        if (applicationName.charAt(0) == '/') {
            applicationName = applicationName.substring(1);
        }
        String appName = applicationName;
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        namespaces.put(ApplicationsManagerServiceImpl.getWebAppPrefix(appName), ApplicationsManagerServiceImpl.getWebAppNamespaceURI(appName));
        List portlets = portletApplication.getPortlets();
        for (PortletDefinition portlet : portlets) {
            namespaces.put(ApplicationsManagerServiceImpl.getEntryPointPrefix(appName, portlet.getPortletName()), ApplicationsManagerServiceImpl.getEntryPointNamespaceURI(appName, portlet.getPortletName()));
        }
        this.registerNamespacesAndLoadPrivileges(namespaces);
    }

    private void loadApplicationPrivileges(List<ApplicationBean> apps) throws RepositoryException {
        if (apps == null || apps.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        for (ApplicationBean app : apps) {
            namespaces.put(ApplicationsManagerServiceImpl.getWebAppPrefix(app.getName()), ApplicationsManagerServiceImpl.getWebAppNamespaceURI(app.getName()));
            for (EntryPointDefinition entryPointDefinition : app.getEntryPointDefinitions()) {
                namespaces.put(ApplicationsManagerServiceImpl.getEntryPointPrefix(app.getName(), entryPointDefinition.getName()), ApplicationsManagerServiceImpl.getEntryPointNamespaceURI(app.getName(), entryPointDefinition.getName()));
            }
        }
        this.registerNamespacesAndLoadPrivileges(namespaces);
    }

    private void registerNamespacesAndLoadPrivileges(Map<String, String> namespaces) throws RepositoryException {
        if (namespaces == null || namespaces.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> ns : namespaces.entrySet()) {
            this.registerNamespace(ns.getKey(), ns.getValue());
        }
        JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaPrivilegeRegistry.init(session);
                return null;
            }
        });
    }

    private void registerNamespace(String key, String value) throws RepositoryException {
        try {
            JCRSessionFactory.getInstance().getNamespaceRegistry().getURI(key);
        }
        catch (RepositoryException e) {
            JCRSessionFactory.getInstance().getNamespaceRegistry().registerNamespace(key, value);
            NodeTypeRegistry.getInstance().getNamespaces().put(key, value);
            JCRSessionFactory.getInstance().getProvider("/").registerNamespaces();
        }
    }
}

