/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.security.spi;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jahia.osgi.BundleUtils;
import org.jahia.security.spi.LicenseCheckerService;

public class LicenseCheckUtil {
    private static volatile boolean initialized = false;
    private static AtomicReference<LicenseCheckerService> instance = new AtomicReference();

    private LicenseCheckUtil() {
    }

    public static boolean isAllowed(String featureId) {
        LicenseCheckerService service = LicenseCheckUtil.getInstance();
        return service != null && service.checkFeature(featureId);
    }

    public static boolean isLimitReached(String componentName, String limitName) {
        LicenseCheckerService service = LicenseCheckUtil.getInstance();
        return service != null && service.isLimitReached(componentName, limitName);
    }

    public static boolean isLoggedInUsersLimitReached() {
        LicenseCheckerService service = LicenseCheckUtil.getInstance();
        return service != null && service.isLoggedInUsersLimitReached();
    }

    public static Optional<Long> getSiteLimit() {
        LicenseCheckerService service = LicenseCheckUtil.getInstance();
        if (service != null) {
            return service.getSiteLimit();
        }
        return Optional.empty();
    }

    private static LicenseCheckerService getInstance() {
        if (instance.get() == null && !initialized) {
            instance.compareAndSet(null, BundleUtils.getOsgiService(LicenseCheckerService.class, null));
            initialized = true;
        }
        return instance.get();
    }
}

