/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogBridge {
    private LogBridge() {
        throw new IllegalStateException("Utility class");
    }

    public static void log(String loggerName, int level, Object message, Throwable t) {
        String msg;
        if (level == Level.OFF.intLevel()) {
            return;
        }
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        String string = msg = message != null ? message.toString() : null;
        if (level <= Level.ERROR.intLevel()) {
            logger.error(msg, t);
        } else if (level <= Level.WARN.intLevel()) {
            logger.warn(msg, t);
        } else if (level <= Level.INFO.intLevel()) {
            logger.info(msg, t);
        } else if (level <= Level.DEBUG.intLevel()) {
            logger.debug(msg, t);
        } else {
            logger.trace(msg, t);
        }
    }

    public static void putMDC(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public static String getMDC(String key) {
        return MDC.get((String)key);
    }

    public static void removeMDC(String key) {
        MDC.remove((String)key);
    }

    public static void clearMDC() {
        MDC.clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> contextMap) {
        MDC.setContextMap(contextMap);
    }
}

