/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.modulemanager.models.JahiaDepends;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;

class JahiaBundleTemplatesPackageHandler {
    JahiaBundleTemplatesPackageHandler() {
    }

    static JahiaTemplatesPackage build(Bundle bundle) {
        String downloadSourcesHeader;
        boolean isSourcesDownloadable;
        if (bundle == null) {
            throw new IllegalArgumentException("Provided bundle is null");
        }
        String moduleType = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Module-Type");
        if (StringUtils.isEmpty((String)moduleType)) {
            return null;
        }
        JahiaTemplatesPackage pkg = new JahiaTemplatesPackage(bundle);
        pkg.setModuleType(moduleType);
        pkg.setModulePriority(Integer.parseInt(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Module-Priority"), (String)"0")));
        pkg.setEditModeBlocked(Boolean.parseBoolean(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Block-Edit-Mode"), (String)"false")));
        pkg.setAutoDeployOnSite(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Deploy-On-Site")));
        pkg.setName(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Title", "Bundle-Name"), (String)bundle.getSymbolicName()));
        pkg.setVersion(new ModuleVersion(StringUtils.defaultIfBlank((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Version"), (String)bundle.getVersion().toString())));
        pkg.setId(bundle.getSymbolicName());
        pkg.setDescription(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Bundle-Description"));
        JahiaBundleTemplatesPackageHandler.detectResourceBundle(bundle, pkg);
        JahiaBundleTemplatesPackageHandler.setSourcesFolderInPackageIfPossible(bundle, pkg);
        if (pkg.getScmURI() == null) {
            String scmUri = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Source-Control-Connection");
            pkg.setScmURI(scmUri);
        }
        if (pkg.getScmTag() == null) {
            String scmTag = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Source-Control-Tag");
            pkg.setScmTag(scmTag);
        }
        if ((isSourcesDownloadable = SettingsBean.getInstance().isMavenExecutableSet()) && (downloadSourcesHeader = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Download-Sources-Available")) != null && ("false".equalsIgnoreCase(downloadSourcesHeader) || "no".equalsIgnoreCase(downloadSourcesHeader))) {
            isSourcesDownloadable = false;
        }
        pkg.setSourcesDownloadable(isSourcesDownloadable);
        URL rootEntry = bundle.getEntry("/");
        if (rootEntry != null) {
            pkg.setFilePath(rootEntry.getPath());
        }
        String depends = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Depends");
        JahiaBundleTemplatesPackageHandler.setPackageDepends(pkg, depends);
        pkg.setProvider(StringUtils.defaultString((String)JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Implementation-Vendor"), (String)"Jahia Solutions Group SA"));
        pkg.setForgeUrl(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Private-App-Store"));
        pkg.setGroupId(JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-GroupId"));
        return pkg;
    }

    private static void setSourcesFolderInPackageIfPossible(Bundle bundle, JahiaTemplatesPackage pkg) {
        String srcFolder = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Source-Folders");
        if (srcFolder != null) {
            File sources = new File(srcFolder);
            if (sources.exists()) {
                ServicesRegistry.getInstance().getJahiaTemplateManagerService().setSourcesFolderInPackage(pkg, sources);
            } else {
                File containerSources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath() + File.separator + sources.getName());
                if (Files.exists(containerSources.toPath(), new LinkOption[0])) {
                    ServicesRegistry.getInstance().getJahiaTemplateManagerService().setSourcesFolderInPackage(pkg, containerSources);
                }
            }
        }
    }

    private static void setPackageDepends(JahiaTemplatesPackage pkg, String depends) {
        if (StringUtils.isNotBlank((String)depends)) {
            String[] dependencies;
            for (String dependency : dependencies = ModuleUtils.toDependsArray(depends)) {
                JahiaDepends dep = new JahiaDepends(dependency);
                if (!dep.isOptional()) {
                    pkg.setDepends(dep.getModuleName());
                }
                pkg.setVersionDepends(dep);
            }
        }
    }

    private static void detectResourceBundle(Bundle bundle, JahiaTemplatesPackage pkg) {
        String resourceBundle = JahiaBundleTemplatesPackageHandler.getHeader(bundle, "Jahia-Resource-Bundle");
        if (StringUtils.isNotBlank((String)resourceBundle)) {
            pkg.setResourceBundleName(resourceBundle.trim());
            return;
        }
        String rbName = pkg.getId();
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
            return;
        }
        rbName = StringUtils.replace((String)pkg.getName(), (String)" ", (String)"");
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
            return;
        }
        rbName = StringUtils.replace((String)pkg.getName(), (String)" ", (String)"_");
        if (JahiaBundleTemplatesPackageHandler.hasResourceBundle(bundle, rbName)) {
            pkg.setResourceBundleName("resources." + rbName);
        }
    }

    private static boolean hasResourceBundle(Bundle bundle, String resourceBundleName) {
        Enumeration paths = bundle.getEntryPaths("/resources/");
        while (paths != null && paths.hasMoreElements()) {
            String path = (String)paths.nextElement();
            if (!StringUtils.startsWith((String)path, (String)("resources/" + resourceBundleName)) || !StringUtils.endsWith((String)path, (String)".properties")) continue;
            return true;
        }
        return false;
    }

    private static String getHeader(Bundle bundle, String ... headerNamesToLookup) {
        String val = null;
        for (String headerName : headerNamesToLookup) {
            val = (String)bundle.getHeaders().get(headerName);
            if (val != null) break;
        }
        return val;
    }
}

