/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters.jcr;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.filters.CompositeFilter;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.PipelineException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.i18n.JahiaLocaleContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrSessionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(JcrSessionFilter.class);
    private Pipeline authPipeline;
    private List<String> bypassForPatterns;
    private JCRSessionFactory sessionFactory;
    private JahiaUserManagerService userManagerService;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.bypass(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean initialized = SpringContextSingleton.getInstance().isInitialized();
        try {
            AuthValveContext authValveContext = null;
            if (initialized) {
                try {
                    this.sessionFactory.setCurrentUser(null);
                    authValveContext = new AuthValveContext((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.sessionFactory);
                    this.authPipeline.invoke(authValveContext);
                }
                catch (PipelineException pe) {
                    logger.error("Error while authorizing user", (Throwable)pe);
                }
            }
            if (this.sessionFactory.getCurrentUser() == null) {
                this.sessionFactory.setCurrentUser(this.userManagerService.lookupUserByPath("/users/guest").getJahiaUser());
            } else {
                boolean storeInSession;
                HttpSession httpSession;
                JCRUserNode userNode = this.userManagerService.lookupUserByPath(this.sessionFactory.getCurrentUser().getLocalPath());
                if (userNode == null || userNode.isAccountLocked()) {
                    this.sessionFactory.setCurrentUser(null);
                }
                if (!((httpSession = ((HttpServletRequest)servletRequest).getSession(storeInSession = authValveContext != null && authValveContext.isShouldStoreAuthInSession())) == null || httpSession.isNew() && authValveContext.isAuthRetrievedFromSession())) {
                    httpSession.setAttribute("org.jahia.usermanager.jahiauser", (Object)this.sessionFactory.getCurrentUser());
                    JahiaLocaleContextHolder.setLocale(UserPreferencesHelper.getPreferredLocale(userNode));
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (initialized) {
                JcrSessionFilter.endRequest();
            }
        }
    }

    private boolean bypass(ServletRequest servletRequest) {
        if (this.bypassForPatterns == null || this.bypassForPatterns.isEmpty() || !(servletRequest instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String path = req.getRequestURI();
        if (req.getContextPath().length() > 0) {
            path = StringUtils.substringAfter((String)path, (String)req.getContextPath());
        }
        for (String pattern : this.bypassForPatterns) {
            if (!CompositeFilter.matchFiltersURL(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public static void endRequest() {
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        sessionFactory.setCurrentUser(null);
        sessionFactory.setCurrentLocale(null);
        sessionFactory.setFallbackLocale(null);
        sessionFactory.setCurrentAliasedUser(null);
        sessionFactory.setCurrentServletPath(null);
        sessionFactory.setCurrentPreviewDate(null);
        sessionFactory.setReadOnlyCacheEnabled(null);
        sessionFactory.closeAllSessions();
        ServicesRegistry.getInstance().getSchedulerService().triggerEndOfRequest();
        JahiaLocaleContextHolder.resetLocale();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAuthPipeline(Pipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setBypassForPatterns(List<String> bypassForPatterns) {
        this.bypassForPatterns = bypassForPatterns;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

