/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;

public class MaintenanceFilter
implements Filter {
    private Set<Pattern> allowedResources = new HashSet<Pattern>();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean block = Jahia.isMaintenance();
        if (block) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String uri = StringUtils.substringAfter((String)httpRequest.getRequestURI(), (String)httpRequest.getContextPath());
            for (Pattern resourcePattern : this.allowedResources) {
                if (!resourcePattern.matcher(uri).matches()) continue;
                block = false;
                break;
            }
        }
        if (block) {
            ((HttpServletResponse)response).sendError(503, "Jahia in under maintenance");
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAllowedResources(Set<String> allowedResources) {
        for (String regex : allowedResources) {
            this.allowedResources.add(Pattern.compile(regex));
        }
    }
}

