/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class GraphqlProxyServlet
extends HttpServlet {
    private ServiceTracker<HttpServlet, HttpServlet> tracker;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            BundleContext bundleContext = this.getBundleContext();
            String str = "(&(objectClass=" + HttpServlet.class.getName() + ")(http.felix.dispatcher=*))";
            this.tracker = new ServiceTracker(bundleContext, bundleContext.createFilter(str), null);
            this.tracker.open();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpServlet dispatcher = (HttpServlet)this.tracker.getService();
        PathTranslationWrapper wrapper = new PathTranslationWrapper(req);
        if (dispatcher != null) {
            dispatcher.service((ServletRequest)wrapper, (ServletResponse)res);
        } else {
            res.sendError(503);
        }
    }

    public void destroy() {
        this.tracker.close();
        super.destroy();
    }

    private BundleContext getBundleContext() throws ServletException {
        Object context = this.getServletContext().getAttribute(BundleContext.class.getName());
        if (context instanceof BundleContext) {
            return (BundleContext)context;
        }
        throw new ServletException("Bundle context attribute [" + BundleContext.class.getName() + "] not set in servlet context");
    }

    private static class PathTranslationWrapper
    extends HttpServletRequestWrapper {
        public PathTranslationWrapper(HttpServletRequest req) {
            super(req);
        }

        public String getServletPath() {
            return "/modules";
        }

        public String getPathInfo() {
            return super.getServletPath().substring("/modules".length()) + Optional.ofNullable(super.getPathInfo()).orElse("");
        }
    }
}

