/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.FindUser;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUsersAndGroups
extends FindUser {
    private static final Logger logger = LoggerFactory.getLogger(FindUsersAndGroups.class);
    protected Set<String> groupDisplayProperties = Collections.emptySet();
    protected Set<String> groupSearchProperties = new HashSet<String>(Arrays.asList("groupname"));
    private JahiaGroupManagerService groupService;

    public static String getFindUsersAndGroupsServletPath() {
        return "/cms/findUsersAndGroups";
    }

    protected String getSiteKey(HttpServletRequest request) {
        String siteKey = FindUsersAndGroups.getParameter(request, "siteKey", null);
        if (siteKey == null) {
            throw new JahiaBadRequestException("siteKey parameter must be present");
        }
        return siteKey;
    }

    @Override
    protected Set<JCRNodeWrapper> search(String queryTerm, HttpServletRequest request) {
        int limit = Math.min(FindUsersAndGroups.getIntParameter(request, "limit", this.defaultLimit), this.hardLimit);
        if (!queryTerm.contains("*")) {
            queryTerm = queryTerm + "*";
        }
        Set<JCRUserNode> users = this.searchUsers(queryTerm);
        Set<JCRGroupNode> groups = this.searchGroups(queryTerm, request);
        HashSet<JCRNodeWrapper> result = new HashSet<JCRNodeWrapper>();
        if (users.size() + groups.size() <= limit) {
            result.addAll(users);
            result.addAll(groups);
        } else {
            if (users.size() <= limit / 2) {
                result.addAll(users);
            } else {
                result.addAll(new LinkedList<JCRUserNode>(users).subList(0, Math.max(limit / 2, limit - groups.size())));
            }
            for (JCRGroupNode g : groups) {
                if (result.size() >= limit) break;
                result.add(g);
            }
        }
        return result;
    }

    protected Set<JCRGroupNode> searchGroups(String queryTerm, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String siteKey = this.getSiteKey(request);
        Properties searchCriterias = new Properties();
        for (String key : this.groupSearchProperties) {
            searchCriterias.put(key, queryTerm);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Performing group search using criteria: {}", (Object)searchCriterias);
        }
        Set<JCRGroupNode> result = this.groupService.searchGroups(siteKey, searchCriterias);
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} matching groups in {} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - startTime));
        }
        return result;
    }

    public void setGroupDisplayProperties(Set<String> groupDisplayProperties) {
        this.groupDisplayProperties = groupDisplayProperties;
    }

    public void setGroupSearchProperties(Set<String> groupSearchProperties) {
        this.groupSearchProperties = groupSearchProperties;
    }

    public void setJahiaGroupManagerService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    protected JSONObject toJSON(JCRGroupNode group) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("key", (Object)("g:" + group.getPath()));
        json.put("groupKey", (Object)group.getPath());
        json.put("groupname", (Object)group.getName());
        json.put("displayName", (Object)PrincipalViewHelper.getFullName(group));
        json.put("type", (Object)"g");
        for (String key : this.groupDisplayProperties) {
            try {
                String value;
                if (!group.hasProperty(key) || (value = group.getProperty(key).getString()) == null) continue;
                json.put(key, (Object)value);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return json;
    }

    @Override
    protected JSONObject toJSON(JCRUserNode user) throws JSONException {
        JSONObject json = super.toJSON(user);
        json.put("key", (Object)("u:" + user.getName()));
        String fullName = PrincipalViewHelper.getFullName(user);
        if (!fullName.equals(user.getName())) {
            fullName = fullName + " (" + user.getName() + ")";
        }
        json.put("displayName", (Object)fullName);
        json.put("type", (Object)"u");
        return json;
    }

    @Override
    protected JSONObject toJSON(JCRNodeWrapper principal) throws JSONException {
        return principal instanceof JCRGroupNode ? this.toJSON((JCRGroupNode)principal) : this.toJSON((JCRUserNode)principal);
    }
}

