/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.tika.io.IOUtils;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.content.server.UploadedPendingFile;
import org.jahia.bin.SessionNamedDataStorage;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.files.FileCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningHelper {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy_MM_dd_HH_mm_ss");
    private static final Logger logger = LoggerFactory.getLogger(VersioningHelper.class);
    private CacheService cacheService;
    private JCRVersionService versionService;
    private FileCacheManager cacheManager;
    private SessionNamedDataStorage<UploadedPendingFile> fileStorage;

    public static String formatForLabel(long timestamp) {
        return DF.format(timestamp);
    }

    public static String getVersionLabel(long timestamp) {
        return "uploaded_at_" + VersioningHelper.formatForLabel(timestamp);
    }

    public static String getVersionLabelCurrent() {
        return VersioningHelper.getVersionLabel(System.currentTimeMillis());
    }

    public static String getRestoreVersionLabel(long timestamp) {
        return "restored_at_" + VersioningHelper.formatForLabel(timestamp);
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setVersionService(JCRVersionService versionService) {
        this.versionService = versionService;
    }

    public void setCacheManager(FileCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setFileStorage(SessionNamedDataStorage<UploadedPendingFile> fileStorage) {
        this.fileStorage = fileStorage;
    }

    public void activateVersioning(List<String> pathes, JCRSessionWrapper currentUserSession) {
        for (String path : pathes) {
            try {
                JCRNodeWrapper node = currentUserSession.getNode(path);
                if (node.isVersioned()) continue;
                node.versionFile();
                currentUserSession.save();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewVersionFile(JCRNodeWrapper node, String tmpName, String httpSessionID) throws GWTJahiaServiceException {
        block15: {
            try {
                if (node != null) {
                    boolean supportVersioning = node.getProvider().getRepository().getDescriptorValue("option.versioning.supported").getBoolean();
                    JCRSessionWrapper session = node.getSession();
                    if (supportVersioning) {
                        VersionIterator allVersions;
                        VersionManager versionManager = session.getWorkspace().getVersionManager();
                        if (!node.isVersioned()) {
                            node.versionFile();
                            session.save();
                        }
                        if ((allVersions = versionManager.getVersionHistory(node.getPath()).getAllVersions()).getSize() == 1L) {
                            versionManager.checkpoint(node.getPath());
                            this.versionService.addVersionLabel(node, VersioningHelper.getVersionLabel(node.getProperty("jcr:created").getDate().getTime().getTime()));
                        }
                        versionManager.checkout(node.getPath());
                    }
                    UploadedPendingFile item = this.fileStorage.getRequired(httpSessionID, tmpName);
                    try {
                        InputStream is = null;
                        try {
                            is = item.getContentStream();
                            node.getFileContent().uploadFile(is, JCRContentUtils.getMimeType(StringUtils.isNotEmpty((String)tmpName) ? tmpName : node.getName(), item.getContentType()));
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)is);
                        }
                    }
                    finally {
                        item.close();
                        this.fileStorage.remove(httpSessionID, tmpName);
                    }
                    session.save();
                    if (supportVersioning && JCRContentUtils.needVersion(node, this.versionService.getVersionedTypes())) {
                        session.getWorkspace().getVersionManager().checkpoint(node.getPath());
                        this.versionService.addVersionLabel(node, VersioningHelper.getVersionLabelCurrent());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Number of version: " + node.getVersions().size());
                        }
                    }
                    this.cacheManager.invalidate(session.getWorkspace().getName(), node.getPath());
                    break block15;
                }
                logger.error("Could not add version to a null file.");
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void restoreVersionLabel(String nodeUuid, Date versionDate, String versionLabel, boolean allSubTree, JCRSessionWrapper currentUserSession) {
        try {
            JCRNodeWrapper node = currentUserSession.getNodeByUUID(nodeUuid);
            this.versionService.restoreVersionLabel(node, versionDate, versionLabel, allSubTree);
            currentUserSession.save();
            this.versionService.addVersionLabel(node, VersioningHelper.getRestoreVersionLabel(System.currentTimeMillis()));
            this.cacheService.flushAllCaches();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

