/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.content.server;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcMap;
import java.net.MalformedURLException;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.SourceFormatter;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.taglibs.standard.util.UrlUtil;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.GWTJahiaContentHistoryEntry;
import org.jahia.ajax.gwt.client.data.GWTJahiaCreateEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaCreatePortletInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaPortletOutputBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaSearchQuery;
import org.jahia.ajax.gwt.client.data.GWTJahiaSite;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.GWTModuleReleaseInfo;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.GWTResourceBundle;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.job.GWTJahiaJobDetail;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNewPortletInstance;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeUsage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeVersion;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaPortletDefinition;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.seo.GWTJahiaUrlMapping;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbar;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.data.wcag.WCAGValidationResult;
import org.jahia.ajax.gwt.client.data.wcag.WCAGViolation;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowComment;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowOutcome;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowTask;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowType;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryItem;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.SessionValidationResult;
import org.jahia.ajax.gwt.commons.server.JahiaRemoteService;
import org.jahia.ajax.gwt.helper.ACLHelper;
import org.jahia.ajax.gwt.helper.CacheHelper;
import org.jahia.ajax.gwt.helper.ChannelHelper;
import org.jahia.ajax.gwt.helper.ContentDefinitionHelper;
import org.jahia.ajax.gwt.helper.ContentHubHelper;
import org.jahia.ajax.gwt.helper.ContentManagerHelper;
import org.jahia.ajax.gwt.helper.DiffHelper;
import org.jahia.ajax.gwt.helper.GWTResourceBundleUtils;
import org.jahia.ajax.gwt.helper.ImageHelper;
import org.jahia.ajax.gwt.helper.LanguageHelper;
import org.jahia.ajax.gwt.helper.ModuleHelper;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.ajax.gwt.helper.PortletHelper;
import org.jahia.ajax.gwt.helper.PropertiesHelper;
import org.jahia.ajax.gwt.helper.PublicationHelper;
import org.jahia.ajax.gwt.helper.SchedulerHelper;
import org.jahia.ajax.gwt.helper.SearchHelper;
import org.jahia.ajax.gwt.helper.SeoHelper;
import org.jahia.ajax.gwt.helper.StubHelper;
import org.jahia.ajax.gwt.helper.TemplateHelper;
import org.jahia.ajax.gwt.helper.TranslationHelper;
import org.jahia.ajax.gwt.helper.UIConfigHelper;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.ajax.gwt.helper.WorkflowHelper;
import org.jahia.ajax.gwt.helper.ZipHelper;
import org.jahia.bin.Export;
import org.jahia.bin.Jahia;
import org.jahia.bin.Login;
import org.jahia.exceptions.JahiaException;
import org.jahia.params.valves.LoginConfig;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.NodeConstraintViolationException;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.htmlvalidator.Result;
import org.jahia.services.htmlvalidator.ValidatorResults;
import org.jahia.services.htmlvalidator.WAIValidator;
import org.jahia.services.notification.ToolbarWarningsService;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.seo.jcr.NonUniqueUrlMappingException;
import org.jahia.services.tags.TaggingService;
import org.jahia.services.translation.TranslationException;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.visibility.VisibilityConditionRule;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.services.wip.WIPInfo;
import org.jahia.services.wip.WIPService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.NodeTypesUtils;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaContentManagementServiceImpl
extends JahiaRemoteService
implements JahiaContentManagementService {
    private static final transient Logger logger = LoggerFactory.getLogger(JahiaContentManagementServiceImpl.class);
    private static final Pattern VERSION_AT_PATTERN = Pattern.compile("_at_");
    private NavigationHelper navigation;
    private ContentManagerHelper contentManager;
    private SearchHelper search;
    private PublicationHelper publication;
    private WorkflowHelper workflow;
    private VersioningHelper versioning;
    private PortletHelper portlet;
    private ContentDefinitionHelper contentDefinition;
    private ContentHubHelper contentHub;
    private PropertiesHelper properties;
    private LanguageHelper languages;
    private TemplateHelper template;
    private ImageHelper image;
    private ZipHelper zip;
    private ACLHelper aclHelper;
    private DiffHelper diff;
    private SeoHelper seo;
    private int sessionPollingFrequency;
    private CacheHelper cacheHelper;
    private SchedulerHelper schedulerHelper;
    private UIConfigHelper uiConfigHelper;
    private JCRContentUtils jcrContentUtils;
    private ChannelHelper channelHelper;
    private TranslationHelper translationHelper;
    private StubHelper stubHelper;
    private ModuleHelper moduleHelper;
    private TaggingService taggingService;
    private ToolbarWarningsService toolbarWarningsService;
    private WIPService wipService;

    public void setAcl(ACLHelper acl) {
        this.aclHelper = acl;
    }

    public void setContentDefinition(ContentDefinitionHelper contentDefinition) {
        this.contentDefinition = contentDefinition;
    }

    public void setContentHub(ContentHubHelper contentHub) {
        this.contentHub = contentHub;
    }

    public void setContentManager(ContentManagerHelper contentManager) {
        this.contentManager = contentManager;
    }

    public void setPortlet(PortletHelper portlet) {
        this.portlet = portlet;
    }

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setProperties(PropertiesHelper properties) {
        this.properties = properties;
    }

    public void setPublication(PublicationHelper publication) {
        this.publication = publication;
    }

    public void setWorkflow(WorkflowHelper workflow) {
        this.workflow = workflow;
    }

    public void setSearch(SearchHelper search) {
        this.search = search;
    }

    public void setLanguages(LanguageHelper languages) {
        this.languages = languages;
    }

    public void setDiff(DiffHelper diff) {
        this.diff = diff;
    }

    public void setTemplate(TemplateHelper template) {
        this.template = template;
    }

    public void setImage(ImageHelper image) {
        this.image = image;
    }

    public void setVersioning(VersioningHelper versioning) {
        this.versioning = versioning;
    }

    public void setZip(ZipHelper zip) {
        this.zip = zip;
    }

    public void setSessionPollingFrequency(int sessionPollingFrequency) {
        this.sessionPollingFrequency = sessionPollingFrequency;
    }

    public void setCacheHelper(CacheHelper cacheHelper) {
        this.cacheHelper = cacheHelper;
    }

    public void setSchedulerHelper(SchedulerHelper schedulerHelper) {
        this.schedulerHelper = schedulerHelper;
    }

    public void setUiConfigHelper(UIConfigHelper uiConfigHelper) {
        this.uiConfigHelper = uiConfigHelper;
    }

    public void setJCRContentUtils(JCRContentUtils jcrContentUtils) {
        this.jcrContentUtils = jcrContentUtils;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setTranslationHelper(TranslationHelper translationHelper) {
        this.translationHelper = translationHelper;
    }

    public void setStubHelper(StubHelper stubHelper) {
        this.stubHelper = stubHelper;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setToolbarWarningsService(ToolbarWarningsService toolbarWarningsService) {
        this.toolbarWarningsService = toolbarWarningsService;
    }

    public void setWipService(WIPService wipService) {
        this.wipService = wipService;
    }

    public GWTManagerConfiguration getManagerConfiguration(String name, String path) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        GWTManagerConfiguration config = null;
        try {
            HashMap locks;
            JCRNodeWrapper context = this.getSite();
            if (!StringUtils.isEmpty((String)path)) {
                context = this.retrieveCurrentSession().getNode(path);
            }
            if ((locks = (HashMap)this.getRequest().getSession().getAttribute("engineLocks")) == null) {
                locks = new HashMap();
                this.getRequest().getSession().setAttribute("engineLocks", locks);
            }
            config = this.uiConfigHelper.getGWTManagerConfiguration(context, this.getSite(), this.getRemoteJahiaUser(), this.getLocale(), this.getUILocale(), this.getRequest(), name);
        }
        catch (RepositoryException e) {
            logger.error("Cannot get node", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
        return config;
    }

    public GWTEditConfiguration getEditConfiguration(String path, String name, String enforcedWorkspace) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        GWTEditConfiguration config = null;
        try {
            HashMap locks;
            JCRSessionWrapper session = this.retrieveCurrentSession();
            if (!session.getWorkspace().getName().equals(enforcedWorkspace)) {
                session = this.retrieveCurrentSession(enforcedWorkspace, session.getLocale(), true);
            }
            if ((locks = (HashMap)this.getRequest().getSession().getAttribute("engineLocks")) == null) {
                locks = new HashMap();
                this.getRequest().getSession().setAttribute("engineLocks", locks);
            }
            config = this.uiConfigHelper.getGWTEditConfiguration(name, path, this.getRemoteJahiaUser(), this.getLocale(), this.getUILocale(), this.getRequest(), session);
        }
        catch (Exception e) {
            logger.error("Cannot retrieve edit configuration " + name + " for path " + path, (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.edit.configuration", this.getUILocale(), name, path, e.getLocalizedMessage()));
        }
        return config;
    }

    public BasePagingLoadResult<GWTJahiaNode> lsLoad(String parentPath, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, boolean checkSubChild, int limit, int offset, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex, boolean showOnlyNodesWithTemplates, boolean useUILocale) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        Locale locale = useUILocale ? this.getUILocale() : this.getLocale();
        ArrayList<Object> filteredList = new ArrayList<GWTJahiaNode>();
        for (GWTJahiaNode n : this.navigation.ls(parentPath, nodeTypes, mimeTypes, filters, fields, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex, this.retrieveCurrentSession(this.getWorkspace(), locale, true), showOnlyNodesWithTemplates, this.getUILocale())) {
            if (!n.isMatchFilters()) continue;
            filteredList.add(n);
        }
        int length = filteredList.size();
        if (offset > -1 && limit > 0) {
            filteredList = offset >= length ? new ArrayList() : new ArrayList(filteredList.subList(offset, Math.min(length - 1, offset + limit)));
        }
        return new BasePagingLoadResult(filteredList, offset, length);
    }

    public List<GWTJahiaNode> getRoot(List<String> paths, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, List<String> selectedNodes, List<String> openPaths, boolean checkSubChild, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex, boolean useUILocale) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        if (openPaths == null || openPaths.isEmpty()) {
            openPaths = this.getOpenPathsForRepository(paths.toString());
        }
        logger.debug("retrieving open paths for {} : {}", paths, openPaths);
        Locale locale = useUILocale ? this.getUILocale() : this.getLocale();
        return this.navigation.retrieveRoot(paths, nodeTypes, mimeTypes, filters, fields, selectedNodes, openPaths, this.getSite(), this.retrieveCurrentSession(this.getWorkspace(), locale, true), locale, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex);
    }

    public List<GWTJahiaNode> getNodes(List<String> paths, List<String> fields) {
        this.enableJcrSessionReadOnlyCache();
        long timer = System.currentTimeMillis();
        List<GWTJahiaNode> list = this.getNodesInternal(paths, fields);
        if (logger.isDebugEnabled()) {
            if (paths.size() > 3) {
                logger.debug("getNodes took {} ms for {} paths: {},...", new Object[]{System.currentTimeMillis() - timer, paths.size(), StringUtils.join(paths.subList(0, 3), (String)", ")});
            } else {
                logger.debug("getNodes took {} ms for paths: {}", (Object)(System.currentTimeMillis() - timer), (Object)StringUtils.join(paths, (String)", "));
            }
        }
        return list;
    }

    private List<GWTJahiaNode> getNodesInternal(List<String> paths, List<String> fields) {
        ArrayList<GWTJahiaNode> list = new ArrayList<GWTJahiaNode>();
        for (String path : paths) {
            try {
                JCRNodeWrapper node = this.retrieveCurrentSession(this.getWorkspace(), this.getLocale(), true).getNode(path);
                GWTJahiaNode gwtJahiaNode = this.navigation.getGWTJahiaNode(node, fields, this.getUILocale());
                list.add(gwtJahiaNode);
            }
            catch (GWTJahiaServiceException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (PathNotFoundException e) {
                logger.debug("Missing area {}. Skipping.", (Object)path);
            }
            catch (RepositoryException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public Map<String, List<? extends ModelData>> getNodesAndTypes(List<ModelData> getNodesParams, List<String> types) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        long timer = System.currentTimeMillis();
        HashMap<String, List<? extends ModelData>> m = new HashMap<String, List<? extends ModelData>>();
        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
        ArrayList paths = new ArrayList();
        for (ModelData params : getNodesParams) {
            if (logger.isDebugEnabled()) {
                paths.addAll((List)params.get("paths"));
            }
            nodes.addAll(this.getNodesInternal((List)params.get("paths"), (List)params.get("fields")));
        }
        m.put("nodes", nodes);
        for (GWTJahiaNode node : nodes) {
            if (types.contains(node.getNodeTypes().get(0))) continue;
            types.add((String)node.getNodeTypes().get(0));
        }
        m.put("types", this.getNodeTypes(types));
        if (logger.isDebugEnabled()) {
            if (paths.size() > 3) {
                logger.debug("getNodesAndTypes took {} ms for {} paths: {},...", new Object[]{System.currentTimeMillis() - timer, paths.size(), StringUtils.join(paths.subList(0, 3), (String)", ")});
            } else {
                logger.debug("getNodesAndTypes took {} ms for paths: {}", (Object)(System.currentTimeMillis() - timer), (Object)StringUtils.join(paths, (String)", "));
            }
        }
        return m;
    }

    public GWTJahiaNode getNode(String path) throws GWTJahiaServiceException {
        return this.navigation.getNode(path, null, this.retrieveCurrentSession(), this.getUILocale());
    }

    public void saveOpenPathsForRepository(String repositoryType, List<String> paths) throws GWTJahiaServiceException {
        this.getSession().setAttribute("org.jahia.contentmanager.savedopenpaths." + repositoryType, paths);
    }

    public BasePagingLoadResult<GWTJahiaNode> search(GWTJahiaSearchQuery searchQuery, int limit, int offset, boolean showOnlyNodesWithTemplates) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        List<GWTJahiaNode> result = this.search.search(searchQuery, 0, 0, showOnlyNodesWithTemplates, this.getSite().getSiteKey().equals("systemsite") ? null : this.getSite(), this.retrieveCurrentSession());
        int size = result.size();
        result = new ArrayList<GWTJahiaNode>(result.subList(offset, Math.min(size, offset + limit)));
        return new BasePagingLoadResult(result, offset, size);
    }

    public List<GWTJahiaNode> search(String searchString, int limit, List<String> nodeTypes, List<String> mimeTypes, List<String> filters) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.search.search(searchString, limit, nodeTypes, mimeTypes, filters, this.getSite().getSiteKey().equals("systemsite") ? null : this.getSite(), this.retrieveCurrentSession());
    }

    public PagingLoadResult<GWTJahiaNode> searchSQL(String searchString, int limit, int offset, List<String> nodeTypes, List<String> fields, boolean sortOnDisplayName) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        List<GWTJahiaNode> gwtJahiaNodes = this.search.searchSQL(searchString, limit, offset, nodeTypes, null, null, fields, this.retrieveCurrentSession());
        int total = gwtJahiaNodes.size();
        if (limit >= 0) {
            try {
                QueryWrapper q = this.retrieveCurrentSession().getWorkspace().getQueryManager().createQuery(searchString, "JCR-SQL2");
                total = (int)q.execute().getNodes().getSize();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (sortOnDisplayName) {
            final Collator collator = Collator.getInstance(this.retrieveCurrentSession().getLocale());
            Collections.sort(gwtJahiaNodes, new Comparator<GWTJahiaNode>(){

                @Override
                public int compare(GWTJahiaNode o1, GWTJahiaNode o2) {
                    return collator.compare(o1.getDisplayName(), o2.getDisplayName());
                }
            });
        }
        return new BasePagingLoadResult(gwtJahiaNodes, offset, total);
    }

    public List<GWTJahiaPortletDefinition> searchPortlets(String match) throws GWTJahiaServiceException {
        try {
            return this.portlet.searchPortlets(match, this.getLocale(), this.retrieveCurrentSession(), this.getUILocale());
        }
        catch (Exception e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.search.portlets", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public List<GWTJahiaNode> getSavedSearch() throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.search.getSavedSearch(this.getSite().getSiteKey().equals("systemsite") ? null : this.getSite(), this.retrieveCurrentSession());
    }

    public void saveSearch(GWTJahiaSearchQuery searchQuery, String path, String name, boolean onTopOf) throws GWTJahiaServiceException {
        if (onTopOf) {
            GWTJahiaNode parentNode = this.navigation.getParentNode(path, this.retrieveCurrentSession());
            GWTJahiaNode jahiaNode = this.search.saveSearch(searchQuery, parentNode.getPath(), name, this.retrieveCurrentSession(), this.getUILocale());
            try {
                this.contentManager.moveOnTopOf(jahiaNode.getPath(), path, this.retrieveCurrentSession());
            }
            catch (RepositoryException e) {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.store.query", this.getUILocale(), this.getLocalizedMessage(e)));
            }
        } else {
            this.search.saveSearch(searchQuery, path, name, this.retrieveCurrentSession(), this.getUILocale());
        }
    }

    public void storePasswordForProvider(String providerKey, String username, String password) throws GWTJahiaServiceException {
        try {
            JCRSessionWrapper session = this.retrieveCurrentSession();
            this.contentHub.storePasswordForProvider(ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(this.getUser().getLocalPath(), session), providerKey, username, password);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error("Cannot save user properties", (Throwable)e);
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    public Map<String, String> getStoredPasswordsProviders() {
        return this.contentHub.getStoredPasswordsProviders(this.getUser());
    }

    public void setLock(List<String> paths, boolean locked) throws GWTJahiaServiceException {
        this.contentManager.setLock(paths, locked, this.retrieveCurrentSession());
    }

    public void clearAllLocks(String path, boolean processChildNodes) throws GWTJahiaServiceException {
        this.contentManager.clearAllLocks(path, processChildNodes, this.retrieveCurrentSession(), this.getUILocale());
    }

    public void markForDeletion(List<String> paths, String comment) throws GWTJahiaServiceException {
        this.contentManager.deletePaths(paths, false, comment, this.getUser(), this.retrieveCurrentSession(), this.getUILocale());
    }

    public GWTJahiaNode deletePaths(List<String> paths) throws GWTJahiaServiceException {
        return this.contentManager.deletePaths(paths, true, null, this.getUser(), this.retrieveCurrentSession(), this.getUILocale());
    }

    public void undeletePaths(List<String> paths) throws GWTJahiaServiceException {
        this.contentManager.undeletePaths(paths, this.getUser(), this.retrieveCurrentSession(), this.getUILocale());
    }

    public String getAbsolutePath(String path) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.navigation.getAbsolutePath(path, this.retrieveCurrentSession(), this.getRequest(), this.getUILocale());
    }

    public void checkWriteable(List<String> paths) throws GWTJahiaServiceException {
        this.contentManager.checkWriteable(paths, this.getUser(), this.retrieveCurrentSession(), this.getUILocale());
    }

    public void paste(List<String> pathsToCopy, String destinationPath, String newName, boolean cut, List<String> childNodeTypesToSkip) throws GWTJahiaServiceException {
        this.contentManager.copy(pathsToCopy, destinationPath, newName, false, cut, false, childNodeTypesToSkip, true, this.retrieveCurrentSession(this.getLocale()), this.getUILocale());
    }

    public void pasteReferences(List<String> pathsToCopy, String destinationPath, String newName) throws GWTJahiaServiceException {
        this.contentManager.copy(pathsToCopy, destinationPath, newName, false, false, true, null, false, this.retrieveCurrentSession(this.getLocale()), this.getUILocale());
    }

    public GWTJahiaGetPropertiesResult getProperties(String path, String langCode) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        if (langCode == null) {
            return this.getProperties(path, this.getLocale());
        }
        return this.getProperties(path, LanguageCodeConverters.getLocaleFromCode(langCode));
    }

    private GWTJahiaGetPropertiesResult getProperties(String path, Locale locale) throws GWTJahiaServiceException {
        GWTJahiaNode node = this.navigation.getNode(path, GWTJahiaNode.DEFAULT_FIELDS, this.retrieveCurrentSession(locale != null ? locale : this.retrieveCurrentSession().getLocale()), this.getUILocale());
        List<GWTJahiaNodeType> nodeTypes = this.contentDefinition.getNodeTypes(node.getNodeTypes(), this.getUILocale());
        Map<String, GWTJahiaNodeProperty> props = this.properties.getProperties(path, this.retrieveCurrentSession(locale), this.getUILocale());
        GWTJahiaGetPropertiesResult result = new GWTJahiaGetPropertiesResult(nodeTypes, props);
        result.setNode(node);
        result.setAvailabledLanguages(this.languages.getLanguages(this.getSite(), this.getLocale()));
        result.setCurrentLocale(this.languages.getCurrentLang(this.getLocale()));
        return result;
    }

    public void saveProperties(List<GWTJahiaNode> nodes, List<GWTJahiaNodeProperty> newProps, Set<String> removedTypes) throws GWTJahiaServiceException {
        JCRSessionWrapper s = this.retrieveCurrentSession();
        try {
            this.properties.saveProperties(nodes, newProps, removedTypes, s, this.getLocale(), this.getSession().getId());
            this.retrieveCurrentSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void savePropertiesAndACL(List<GWTJahiaNode> nodes, GWTJahiaNodeACL acl, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties, List<GWTJahiaNodeProperty> sharedProperties, Set<String> removedTypes) throws GWTJahiaServiceException {
        try {
            ArrayList<JCRSessionWrapper> sessions = new ArrayList<JCRSessionWrapper>();
            JCRSessionWrapper session = this.retrieveCurrentSession(null);
            sessions.add(session);
            this.properties.saveProperties(nodes, sharedProperties, removedTypes, session, this.getUILocale(), this.getSession().getId());
            for (String currentLangCode : langCodeProperties.keySet()) {
                List<GWTJahiaNodeProperty> props = langCodeProperties.get(currentLangCode);
                Locale locale = LanguageCodeConverters.languageCodeToLocale(currentLangCode);
                session = this.retrieveCurrentSession(locale);
                sessions.add(session);
                this.properties.saveProperties(nodes, props, removedTypes, session, this.getUILocale(), this.getSession().getId());
            }
            for (JCRSessionWrapper sessionWrapper : sessions) {
                sessionWrapper.validate();
            }
            if (acl != null) {
                for (GWTJahiaNode node : nodes) {
                    this.contentManager.setACL(node.getUUID(), acl, this.retrieveCurrentSession());
                }
            }
            for (JCRSessionWrapper sessionWrapper : sessions) {
                sessionWrapper.save();
            }
        }
        catch (ConstraintViolationException e) {
            if (e instanceof CompositeConstraintViolationException) {
                this.properties.convertException((CompositeConstraintViolationException)e);
            }
            if (e instanceof NodeConstraintViolationException) {
                this.properties.convertException((NodeConstraintViolationException)e);
            }
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (LockException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public RpcMap saveNode(GWTJahiaNode node, GWTJahiaNodeACL acl, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties, List<GWTJahiaNodeProperty> sharedProperties, Set<String> removedTypes) throws GWTJahiaServiceException {
        RpcMap result;
        block26: {
            result = new RpcMap();
            JCRSessionWrapper jcrSessionWrapper = this.retrieveCurrentSession();
            try {
                JCRNodeWrapper nodeWrapper = jcrSessionWrapper.getNodeByUUID(node.getUUID());
                this.wipService.saveWipPropertiesIfNeeded(nodeWrapper, this.getWipInfo(sharedProperties));
                sharedProperties.removeIf(property -> "j:workInProgressStatus".equals(property.getName()) || "j:workInProgressLanguages".equals(property.getName()));
                if (!nodeWrapper.getName().equals(JCRContentUtils.escapeLocalNodeName(node.getName()))) {
                    String name = this.contentManager.findAvailableName(nodeWrapper.getParent(), JCRContentUtils.escapeLocalNodeName(node.getName()));
                    nodeWrapper.rename(name);
                    jcrSessionWrapper.save();
                }
                node.setName(nodeWrapper.getName());
                node.setPath(nodeWrapper.getPath());
                this.saveProperties(node, langCodeProperties, sharedProperties, removedTypes);
                if (node.get("includeChildren") != null) {
                    List removedChildrenPaths = node.getRemovedChildrenPaths();
                    if (!removedChildrenPaths.isEmpty()) {
                        this.deletePaths(removedChildrenPaths);
                        node.clearRemovedChildrenPaths();
                    }
                    ArrayList newNames = new ArrayList();
                    for (ModelData modelData : node.getChildren()) {
                        GWTJahiaNode subNode = (GWTJahiaNode)modelData;
                        subNode.setPath(node.getPath() + "/" + subNode.getName());
                        String renamedFrom = (String)subNode.get("renamedFrom");
                        if (renamedFrom != null && nodeWrapper.hasNode(renamedFrom)) {
                            nodeWrapper.getNode(renamedFrom).rename(subNode.getName());
                        }
                        newNames.add(JCRContentUtils.escapeLocalNodeName(subNode.getName()));
                        if (subNode.get("nodeLangCodeProperties") == null || subNode.get("nodeProperties") == null) continue;
                        if (nodeWrapper.hasNode(JCRContentUtils.escapeLocalNodeName(subNode.getName()))) {
                            this.saveNode(subNode, null, (Map)subNode.get("nodeLangCodeProperties"), (List)subNode.get("nodeProperties"), new HashSet<String>());
                            continue;
                        }
                        this.createNode(node.getPath(), subNode);
                    }
                    if (nodeWrapper.getPrimaryNodeType().hasOrderableChildNodes()) {
                        ArrayList<String> oldNames = new ArrayList<String>();
                        JCRNodeIteratorWrapper oldChildrenNodes = nodeWrapper.getNodes();
                        while (oldChildrenNodes.hasNext()) {
                            JCRNodeWrapper next = (JCRNodeWrapper)oldChildrenNodes.next();
                            if (!newNames.contains(next.getName())) continue;
                            oldNames.add(next.getName());
                        }
                        if (!oldNames.equals(newNames)) {
                            Iterator iterator = newNames.iterator();
                            while (iterator.hasNext()) {
                                String newName = (String)iterator.next();
                                nodeWrapper.orderBefore(newName, null);
                            }
                        }
                    }
                }
                if (acl != null) {
                    this.contentManager.setACL(node.getUUID(), acl, jcrSessionWrapper);
                }
                if (node.get("vanityMappings") != null) {
                    this.saveUrlMappings(node, (Map)node.get("vanityMappings"));
                }
                if (node.get("visibilityConditions") != null) {
                    List visibilityConditions = (List)node.get("visibilityConditions");
                    this.contentManager.saveVisibilityConditions(node, visibilityConditions, jcrSessionWrapper, this.getUILocale(), this.getSession().getId());
                    try {
                        for (GWTJahiaNode condition : visibilityConditions) {
                            if (!Boolean.TRUE.equals(condition.get("node-published") != null)) continue;
                            String uuid = jcrSessionWrapper.itemExists(condition.getPath()) ? jcrSessionWrapper.getNode(condition.getPath()).getIdentifier() : condition.getUUID();
                            this.publication.publish(Collections.singletonList(uuid));
                        }
                        if (Boolean.TRUE.equals(node.get("conditions-published"))) {
                            this.publication.publish(Arrays.asList(jcrSessionWrapper.getNode(node.getPath() + "/" + "j:conditionalVisibility").getIdentifier()));
                        }
                    }
                    catch (RepositoryException e) {
                        logger.error("Error while saving visibility conditions for node " + node.getPath(), (Throwable)e);
                        throw new GWTJahiaServiceException((Throwable)e);
                    }
                }
                if (node.get("activeWorkflows") != null) {
                    this.workflow.updateWorkflowRules(node, (Set)node.get("activeWorkflows"), jcrSessionWrapper);
                }
                GWTResourceBundle rb = (GWTResourceBundle)node.get("resourceBundle");
                boolean needPermissionReload = false;
                if (rb != null) {
                    needPermissionReload = GWTResourceBundleUtils.store(node, rb, jcrSessionWrapper);
                }
                jcrSessionWrapper.save();
                if (rb == null) break block26;
                try {
                    result.put("siteLanguages", this.languages.getLanguages((JCRSiteNode)jcrSessionWrapper.getNodeByIdentifier(node.getSiteUUID()), this.getLocale()));
                    if (needPermissionReload) {
                        result.put("permissions", this.getAvailablePermissions());
                    }
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (LockException e) {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("could.not.be.accessed", this.getUILocale(), node.getDisplayName(), this.getLocalizedMessage((RepositoryException)((Object)e))));
            }
            catch (ConstraintViolationException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage(e)));
            }
        }
        this.closeEditEngine(node.getPath());
        return result;
    }

    public WIPInfo getWipInfo(List<GWTJahiaNodeProperty> sharedProperties) {
        String status = "DISABLED";
        Set<String> languages = new HashSet<String>();
        for (GWTJahiaNodeProperty property : sharedProperties) {
            if (property.getName().equals("j:workInProgressStatus")) {
                status = ((GWTJahiaNodePropertyValue)property.getValues().get(0)).getString();
            }
            if (!property.getName().equals("j:workInProgressLanguages")) continue;
            languages = property.getValues() != null ? property.getValues().stream().map(GWTJahiaNodePropertyValue::getString).collect(Collectors.toSet()) : Collections.emptySet();
        }
        return new WIPInfo(status, languages);
    }

    private void saveProperties(GWTJahiaNode node, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties, List<GWTJahiaNodeProperty> sharedProperties, Set<String> removedTypes) throws GWTJahiaServiceException {
        Iterator<String> langCode = langCodeProperties.keySet().iterator();
        try {
            ArrayList<JCRSessionWrapper> sessions = new ArrayList<JCRSessionWrapper>();
            JCRSessionWrapper session = this.retrieveCurrentSession(null);
            sessions.add(session);
            this.properties.saveProperties(Arrays.asList(node), sharedProperties, removedTypes, session, this.getUILocale(), this.getSession().getId());
            if (removedTypes != null && !removedTypes.isEmpty()) {
                for (ExtendedNodeType mixin : this.retrieveCurrentSession().getNodeByUUID(node.getUUID()).getMixinNodeTypes()) {
                    removedTypes.remove(mixin.getName());
                }
            }
            while (langCode.hasNext()) {
                String currentLangCode = langCode.next();
                List<GWTJahiaNodeProperty> props = langCodeProperties.get(currentLangCode);
                session = this.retrieveCurrentSession(LanguageCodeConverters.languageCodeToLocale(currentLangCode));
                sessions.add(session);
                this.properties.saveProperties(Arrays.asList(node), props, removedTypes, session, this.getUILocale(), this.getSession().getId());
            }
            for (JCRSessionWrapper sessionWrapper : sessions) {
                sessionWrapper.validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (e instanceof CompositeConstraintViolationException) {
                this.properties.convertException((CompositeConstraintViolationException)e);
            }
            if (e instanceof NodeConstraintViolationException) {
                this.properties.convertException((NodeConstraintViolationException)e);
            }
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (LockException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.save.properties", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public GWTJahiaNode createNode(String parentPath, GWTJahiaNode newNode) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
        for (ModelData modelData : newNode.getChildren()) {
            nodes.add((GWTJahiaNode)modelData);
        }
        return this.createNode(parentPath, newNode.getName(), (String)newNode.getNodeTypes().get(0), newNode.getNodeTypes().subList(1, newNode.getNodeTypes().size()), (GWTJahiaNodeACL)newNode.get("newAcl"), (List)newNode.get("nodeProperties"), (Map)newNode.get("nodeLangCodeProperties"), nodes, null, true);
    }

    public GWTJahiaNode createNode(String parentPath, String name, String nodeType, List<String> mixin, GWTJahiaNodeACL acl, List<GWTJahiaNodeProperty> props, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties, List<GWTJahiaNode> subNodes, Map<String, String> parentNodesType, boolean forceCreation) throws GWTJahiaServiceException {
        GWTJahiaNode node;
        if (name == null && langCodeProperties != null) {
            List<GWTJahiaNodeProperty> l;
            String defaultLanguage = this.getLocale().toString();
            if (this.getSite() != null) {
                defaultLanguage = this.getSite().getDefaultLanguage();
            }
            if ((l = langCodeProperties.get(defaultLanguage)) == null && langCodeProperties.size() > 0) {
                l = langCodeProperties.values().iterator().next();
            }
            if (l != null) {
                name = this.contentManager.generateNameFromTitle(l);
            }
        }
        JCRSessionWrapper session = this.retrieveCurrentSession();
        GWTJahiaNode res = this.contentManager.createNode(parentPath, name, nodeType, mixin, props, session, this.getUILocale(), parentNodesType, forceCreation, this.getSession().getId());
        List<String> fields = Arrays.asList("icon", "tags", "childrenInfo", "j:view", "j:width", "j:height", "locksInfo", "subnodesConstraintsInfo");
        try {
            JCRNodeWrapper nodeWrapper = session.getNodeByUUID(res.getUUID());
            node = this.navigation.getGWTJahiaNode(nodeWrapper, fields);
            if (acl != null && (!acl.getAce().isEmpty() || acl.isBreakAllInheritance())) {
                this.contentManager.setACL(res.getUUID(), acl, session);
            }
            if (langCodeProperties != null && !langCodeProperties.isEmpty()) {
                ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
                nodes.add(node);
                ArrayList<String> locales = new ArrayList<String>(langCodeProperties.keySet());
                locales.remove(session.getLocale().toString());
                locales.add(0, session.getLocale().toString());
                for (String currentLangCode : locales) {
                    List<GWTJahiaNodeProperty> properties = langCodeProperties.get(currentLangCode);
                    JCRSessionWrapper langSession = this.retrieveCurrentSession(LanguageCodeConverters.languageCodeToLocale(currentLangCode));
                    if (properties == null) continue;
                    this.properties.saveProperties(nodes, properties, null, langSession, this.getUILocale(), this.getSession().getId());
                    langSession.validate();
                }
            }
            session.save();
        }
        catch (ConstraintViolationException e) {
            if (e instanceof CompositeConstraintViolationException) {
                this.properties.convertException((CompositeConstraintViolationException)e);
            }
            if (e instanceof NodeConstraintViolationException) {
                this.properties.convertException((NodeConstraintViolationException)e);
            }
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (NamespaceException e) {
            throw new GWTJahiaServiceException(e.getMessage() != null ? Messages.getInternal("label.gwt.error.jcr.namespace", this.getUILocale()) + "\n" + Messages.getInternal("label.cause", this.getUILocale()) + ": " + e.getMessage() : Messages.getInternal("label.gwt.error.jcr.namespace", this.getUILocale()));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage(e)));
        }
        if (subNodes != null) {
            for (GWTJahiaNode subNode : subNodes) {
                this.createNode(node.getPath(), subNode);
            }
        }
        return node;
    }

    public GWTJahiaNode createNodeAndMoveBefore(String path, String name, String nodeType, List<String> mixin, GWTJahiaNodeACL acl, List<GWTJahiaNodeProperty> properties, Map<String, List<GWTJahiaNodeProperty>> langCodeProperties) throws GWTJahiaServiceException {
        GWTJahiaNode parentNode = this.navigation.getParentNode(path, this.retrieveCurrentSession());
        GWTJahiaNode jahiaNode = this.createNode(parentNode.getPath(), name, nodeType, mixin, acl, properties, langCodeProperties, null, null, true);
        try {
            this.contentManager.moveOnTopOf(jahiaNode.getPath(), path, this.retrieveCurrentSession());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.move.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
        try {
            this.retrieveCurrentSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage((RepositoryException)((Object)e))));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.creation.failed.cause", this.getUILocale(), this.getLocalizedMessage(e)));
        }
        return jahiaNode;
    }

    public GWTJahiaNode createFolder(String parentPath, String name) throws GWTJahiaServiceException {
        return this.contentManager.createFolder(parentPath, name, this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
    }

    public GWTJahiaNode createPortletInstance(String path, GWTJahiaNewPortletInstance wiz) throws GWTJahiaServiceException {
        return this.portlet.createPortletInstance(path, wiz, this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
    }

    public GWTJahiaNode createRSSPortletInstance(String path, String name, String url) throws GWTJahiaServiceException {
        return this.portlet.createRSSPortletInstance(path, name, url, this.getSite(), this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
    }

    public GWTJahiaNode createGoogleGadgetPortletInstance(String path, String name, String script) throws GWTJahiaServiceException {
        return this.portlet.createGoogleGadgetPortletInstance(path, name, script, this.getSite(), this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
    }

    public void checkExistence(String path) throws GWTJahiaServiceException {
        if (this.contentManager.checkExistence(path, this.retrieveCurrentSession(), this.getUILocale())) {
            throw new ExistingFileException(path);
        }
    }

    public GWTJahiaNode rename(String path, String newName) throws GWTJahiaServiceException {
        return this.contentManager.rename(path, newName, this.retrieveCurrentSession(), this.getUILocale());
    }

    public void move(List<String> sourcePaths, String targetPath) throws GWTJahiaServiceException {
        try {
            for (String sourcePath : sourcePaths) {
                this.contentManager.move(sourcePath, targetPath, this.retrieveCurrentSession());
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.move.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void moveAtEnd(List<String> sourcePaths, String targetPath) throws GWTJahiaServiceException {
        try {
            for (String sourcePath : sourcePaths) {
                this.contentManager.moveAtEnd(sourcePath, targetPath, this.retrieveCurrentSession());
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.move.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void moveOnTopOf(List<String> sourcePaths, String targetPath) throws GWTJahiaServiceException {
        try {
            for (String sourcePath : sourcePaths) {
                this.contentManager.moveOnTopOf(sourcePath, targetPath, this.retrieveCurrentSession());
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.move.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public GWTJahiaNodeACE createDefaultUsersGroupACE(List<String> permissions, boolean grand) throws GWTJahiaServiceException {
        return this.aclHelper.createUsersGroupACE(permissions, grand, this.getSite());
    }

    public List<GWTJahiaNodeUsage> getUsages(List<String> paths) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.navigation.getUsages(paths, this.retrieveCurrentSession(), this.getUILocale());
    }

    public List<GWTJahiaNode> getNodesByCategory(GWTJahiaNode category) throws GWTJahiaServiceException {
        return this.navigation.getNodesByCategory(category.getPath(), this.retrieveCurrentSession());
    }

    public BasePagingLoadResult<GWTJahiaNode> getNodesByCategory(GWTJahiaNode category, int limit, int offset) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        List<GWTJahiaNode> result = this.getNodesByCategory(category);
        return new BasePagingLoadResult(result, offset, result.size());
    }

    public void zip(List<String> paths, String archiveName) throws GWTJahiaServiceException {
        this.zip.zip(paths, archiveName, this.retrieveCurrentSession(), this.getUILocale());
    }

    public List<GWTJahiaNodeProperty> translate(List<GWTJahiaNodeProperty> properties, List<GWTJahiaItemDefinition> definitions, String srcLanguage, String destLanguage, String siteUUID) throws GWTJahiaServiceException {
        try {
            return this.translationHelper.translate(properties, definitions, srcLanguage, destLanguage, (JCRSiteNode)this.retrieveCurrentSession().getNodeByIdentifier(siteUUID), this.getUILocale());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.translate", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public GWTJahiaNodeProperty translate(GWTJahiaNodeProperty property, GWTJahiaItemDefinition definition, String srcLanguage, String destLanguage, String siteUUID) throws GWTJahiaServiceException {
        try {
            return this.translationHelper.translate(property, definition, srcLanguage, destLanguage, (JCRSiteNode)this.retrieveCurrentSession().getNodeByIdentifier(siteUUID), this.getUILocale());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.warn(e.getMessage(), (Throwable)e);
            } else if (e instanceof TranslationException && ((TranslationException)e).getDetails() != null) {
                logger.warn("{}: {}", (Object)e.getMessage(), (Object)((TranslationException)e).getDetails());
            } else {
                logger.warn(e.getMessage());
            }
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.translate", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public void unzip(List<String> paths) throws GWTJahiaServiceException {
        this.zip.unzip(paths, false, this.retrieveCurrentSession(), this.getUILocale());
    }

    public String getExportUrl(String path) throws GWTJahiaServiceException {
        try {
            JCRSessionWrapper jcrSessionWrapper = JCRSessionFactory.getInstance().getCurrentUserSession();
            return Jahia.getContextPath() + Export.getExportServletPath() + "/" + jcrSessionWrapper.getWorkspace().getName() + path;
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.exportURL", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void cropImage(String path, String target, int top, int left, int width, int height, boolean forceReplace) throws GWTJahiaServiceException {
        JCRSessionWrapper session = this.retrieveCurrentSession();
        this.image.crop(path, target, top, left, width, height, forceReplace, session, this.getUILocale());
    }

    public void resizeImage(String path, String target, int width, int height, boolean forceReplace) throws GWTJahiaServiceException {
        JCRSessionWrapper session = this.retrieveCurrentSession();
        this.image.resizeImage(path, target, width, height, forceReplace, session, this.getUILocale());
    }

    public void rotateImage(String path, String target, boolean clockwise, boolean forceReplace) throws GWTJahiaServiceException {
        JCRSessionWrapper session = this.retrieveCurrentSession();
        this.image.rotateImage(path, target, clockwise, forceReplace, session, this.getUILocale());
    }

    public void activateVersioning(List<String> path) throws GWTJahiaServiceException {
        this.versioning.activateVersioning(path, this.retrieveCurrentSession());
    }

    public List<GWTJahiaNodeVersion> getVersions(String path) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRNodeWrapper node = this.retrieveCurrentSession(this.getLocale()).getNode(path);
            List<GWTJahiaNodeVersion> versions = this.navigation.getVersions(node, !node.isNodeType("nt:file"));
            this.sortVersions(versions);
            return versions;
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.versions", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    private void sortVersions(List<GWTJahiaNodeVersion> versions) {
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        Collections.sort(versions, new Comparator<GWTJahiaNodeVersion>(){

            @Override
            public int compare(GWTJahiaNodeVersion o1, GWTJahiaNodeVersion o2) {
                String[] strings1 = VERSION_AT_PATTERN.split(o1.getLabel());
                String[] strings2 = VERSION_AT_PATTERN.split(o2.getLabel());
                if (strings1.length == 2 && strings2.length == 2) {
                    try {
                        Date dateV2 = simpleDateFormat.parse(strings2[1]);
                        o2.setDate(dateV2);
                        Date dateV1 = simpleDateFormat.parse(strings1[1]);
                        o1.setDate(dateV1);
                        return dateV2.compareTo(dateV1);
                    }
                    catch (ParseException e) {
                        return o1.getLabel().compareTo(o2.getLabel());
                    }
                }
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
    }

    public BasePagingLoadResult<GWTJahiaNodeVersion> getVersions(GWTJahiaNode node, int limit, int offset) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRNodeWrapper nodeWrapper = JCRSessionFactory.getInstance().getCurrentUserSession(this.getWorkspace(), this.getLocale()).getNode(node.getPath());
            List<GWTJahiaNodeVersion> result = this.navigation.getVersions(nodeWrapper, true);
            this.sortVersions(result);
            GWTJahiaNodeVersion liveVersion = new GWTJahiaNodeVersion("live", node);
            result.add(0, liveVersion);
            liveVersion.setUrl(this.navigation.getNodeURL(null, nodeWrapper, null, null, "live", this.getLocale(), false));
            GWTJahiaNodeVersion defaultVersion = new GWTJahiaNodeVersion("default", node);
            result.add(0, defaultVersion);
            defaultVersion.setUrl(this.navigation.getNodeURL(null, nodeWrapper, null, null, "default", this.getLocale(), false));
            int size = result.size();
            result = new ArrayList<GWTJahiaNodeVersion>(result.subList(offset, Math.min(size, offset + limit)));
            return new BasePagingLoadResult(result, offset, size);
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.versions", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void restoreNode(GWTJahiaNodeVersion gwtJahiaNodeVersion, boolean allSubTree) throws GWTJahiaServiceException {
        String nodeUuid = gwtJahiaNodeVersion.getNode().getUUID();
        this.versioning.restoreVersionLabel(nodeUuid, gwtJahiaNodeVersion.getDate(), gwtJahiaNodeVersion.getLabel(), allSubTree, this.retrieveCurrentSession());
    }

    public void restoreNodeByIdentifierAndDate(String identifier, Date versionDate, String versionLabel, boolean allSubTree) throws GWTJahiaServiceException {
        this.versioning.restoreVersionLabel(identifier, versionDate, versionLabel, allSubTree, this.retrieveCurrentSession());
    }

    public void uploadedFile(List<String[]> uploadeds) throws GWTJahiaServiceException {
        for (String[] uploaded : uploadeds) {
            this.contentManager.uploadedFile(uploaded[0], uploaded[1], Integer.parseInt(uploaded[2]), uploaded[3], this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
        }
    }

    public GWTRenderResult getRenderedContent(String path, String workspace, String locale, String template, String configuration, Map<String, List<String>> contextParams, boolean editMode, String configName, String channelIdentifier, String channelVariant) throws GWTJahiaServiceException {
        Locale localValue = this.getLocale();
        if (locale != null) {
            localValue = LanguageCodeConverters.languageCodeToLocale(locale);
            if (!this.getLocale().equals(localValue)) {
                this.getSession().setAttribute("org.jahia.services.multilang.currentlocale", (Object)localValue);
            }
        }
        return this.template.getRenderedContent(path, template, configuration, contextParams, editMode, configName, this.getRequest(), this.getResponse(), this.retrieveCurrentSession(workspace, localValue, true), this.getUILocale(), channelIdentifier, channelVariant);
    }

    public String getNodeURL(String servlet, String path, Date versionDate, String versionLabel, String workspace, String locale, boolean findDisplayable) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        JCRSessionWrapper session = this.retrieveCurrentSession(workspace != null ? workspace : this.getWorkspace(), locale != null ? LanguageCodeConverters.languageCodeToLocale(locale) : this.getLocale(), false);
        try {
            String nodeIdentifier = this.retrieveCurrentSession().nodeExists(path) ? this.retrieveCurrentSession().getNode(path).getIdentifier() : session.getNode(path).getIdentifier();
            JCRNodeWrapper node = session.getNodeByIdentifier(nodeIdentifier);
            String nodeURL = this.navigation.getNodeURL(servlet, node, versionDate, versionLabel, session.getWorkspace().getName(), session.getLocale(), findDisplayable);
            if ("live".equals(workspace) && !SettingsBean.getInstance().isUrlRewriteSeoRulesEnabled()) {
                nodeURL = Url.appendServerNameIfNeeded(node, nodeURL, this.getRequest());
            }
            return this.getResponse().encodeURL(nodeURL);
        }
        catch (MalformedURLException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    public List<GWTJahiaJobDetail> importContent(String parentPath, String fileKey, Boolean replaceContent) throws GWTJahiaServiceException {
        List<GWTJahiaJobDetail> details = this.schedulerHelper.getActiveJobs(this.getUILocale());
        this.contentManager.importContent(parentPath, fileKey, replaceContent, this.retrieveCurrentSession(), this.getUILocale(), this.getSession().getId());
        return details;
    }

    public List<GWTJahiaChannel> getChannels() throws GWTJahiaServiceException {
        return this.channelHelper.getChannels();
    }

    public Map<String, GWTJahiaWorkflowDefinition> getWorkflowDefinitions(List<String> workflowDefinitionIds) throws GWTJahiaServiceException {
        HashMap<String, GWTJahiaWorkflowDefinition> l = new HashMap<String, GWTJahiaWorkflowDefinition>();
        for (String wf : workflowDefinitionIds) {
            l.put(wf, this.workflow.getGWTJahiaWorkflowDefinition(wf, this.getUILocale()));
        }
        return l;
    }

    public void startWorkflow(String path, GWTJahiaWorkflowDefinition workflowDefinition, List<GWTJahiaNodeProperty> properties, List<String> comments) throws GWTJahiaServiceException {
        this.workflow.startWorkflow(path, workflowDefinition, this.retrieveCurrentSession(), properties, comments);
    }

    public void startWorkflow(List<String> uuids, GWTJahiaWorkflowDefinition def, List<GWTJahiaNodeProperty> properties, List<String> comments, Map<String, Object> args, String locale) throws GWTJahiaServiceException {
        this.workflow.startWorkflow(uuids, def, this.retrieveCurrentSession(locale != null ? LanguageCodeConverters.languageCodeToLocale(locale) : this.getLocale()), properties, comments, args);
    }

    public void abortWorkflow(String processId, String provider) throws GWTJahiaServiceException {
        this.workflow.abortWorkflow(processId, provider);
    }

    public void assignAndCompleteTask(GWTJahiaWorkflowTask task, GWTJahiaWorkflowOutcome outcome, List<GWTJahiaNodeProperty> properties) throws GWTJahiaServiceException {
        this.workflow.assignAndCompleteTask(task, outcome, this.retrieveCurrentSession(), properties);
    }

    public List<GWTJahiaWorkflowComment> addCommentToWorkflow(GWTJahiaWorkflow wf, String comment) {
        this.workflow.addCommentToWorkflow(wf, this.getUser(), comment, this.getLocale());
        return this.getWorkflowComments(wf);
    }

    public List<GWTJahiaWorkflowComment> getWorkflowComments(GWTJahiaWorkflow workflow) {
        this.enableJcrSessionReadOnlyCache();
        return this.workflow.getWorkflowComments(workflow, this.getLocale());
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryForUser() throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        List<GWTJahiaWorkflowHistoryItem> res = this.workflow.getWorkflowHistoryForUser(this.getUser(), this.getLocale(), this.getUILocale());
        return res;
    }

    public void publish(List<String> uuids, List<GWTJahiaNodeProperty> properties, List<String> comments) throws GWTJahiaServiceException {
        this.publication.publish(uuids, this.retrieveCurrentSession(), this.getSite(), properties, comments);
    }

    public void unpublish(List<String> uuids) throws GWTJahiaServiceException {
        long l = System.currentTimeMillis();
        JCRSessionWrapper session = this.retrieveCurrentSession();
        this.publication.unpublish(uuids, Collections.singleton(session.getLocale().toString()), session.getUser());
        logger.debug("-->{}", (Object)(System.currentTimeMillis() - l));
    }

    public List<GWTJahiaPublicationInfo> getPublicationInfo(List<String> uuids, boolean allSubTree, boolean checkForUnpublication) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        JCRSessionWrapper session = this.retrieveCurrentSession();
        return this.publication.getFullPublicationInfos(uuids, Collections.singleton(this.retrieveCurrentSession().getLocale().toString()), session, allSubTree, true, checkForUnpublication);
    }

    public List<GWTJahiaPublicationInfo> getPublicationInfo(List<String> uuids, boolean allSubTree, boolean checkForUnpublication, Set<String> languages) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        JCRSessionWrapper session = this.retrieveCurrentSession();
        return this.publication.getFullPublicationInfos(uuids, languages, session, allSubTree, true, checkForUnpublication);
    }

    public GWTJahiaWorkflowInfo getWorkflowInfo(String path) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.workflow.getWorkflowInfo(path, true, this.retrieveCurrentSession(), this.getLocale(), this.getUILocale());
    }

    public String getHighlighted(String original, String amendment) {
        return this.diff.getHighlighted(original, amendment);
    }

    private List<String> getOpenPathsForRepository(String repositoryType) throws GWTJahiaServiceException {
        return (List)this.getSession().getAttribute("org.jahia.contentmanager.savedopenpaths." + repositoryType);
    }

    private JahiaUser getUser() {
        return this.getRemoteJahiaUser();
    }

    public List<GWTJahiaUrlMapping> getUrlMappings(GWTJahiaNode node, String locale) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            return this.seo.getUrlMappings(node, locale, this.retrieveCurrentSession());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.urlMappings", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void saveUrlMappings(GWTJahiaNode node, Map<String, List<GWTJahiaUrlMapping>> mappings) throws GWTJahiaServiceException {
        try {
            this.seo.saveUrlMappings(node, mappings, this.retrieveCurrentSession());
        }
        catch (NonUniqueUrlMappingException e) {
            Locale uiLocale = this.getUILocale();
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("failure.duplicateVanityUrlMapping", uiLocale, e.getUrlMapping(), e.getNodePath(), e.getExistingNodePath(), Messages.getInternal("label." + e.getWorkspace(), uiLocale)), Messages.getInternalWithArguments("failure.duplicateVanityUrlMapping_display", uiLocale, e.getUrlMapping(), e.getExistingNodePath()));
        }
        catch (javax.validation.ConstraintViolationException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.save.urlMappings", this.getUILocale(), e.getLocalizedMessage()));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.save.urlMappings", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void deployTemplates(String templatesPath, String sitePath) throws GWTJahiaServiceException {
        logger.info("Deploying templates {} to the target {}", (Object)templatesPath, (Object)sitePath);
        this.moduleHelper.deployModule(templatesPath, sitePath, this.retrieveCurrentSession());
        logger.info("...template deployment done.");
    }

    public GWTJahiaNode createModule(String moduleName, String artifactId, String groupId, String siteType, String sources) throws GWTJahiaServiceException {
        try {
            return this.moduleHelper.createModule(moduleName, artifactId, groupId, siteType, sources, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot create module", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.create.module", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public GWTJahiaNode checkoutModule(String moduleId, String scmURI, String scmType, String branchOrTag, String sources) throws GWTJahiaServiceException {
        try {
            return this.moduleHelper.checkoutModule(moduleId, scmURI, scmType, branchOrTag, sources, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot checkout module", (Throwable)e);
            String message = e.getLocalizedMessage();
            if (StringUtils.isEmpty((String)message)) {
                message = Messages.getInternal("label.gwt.error.nomessage", this.getUILocale());
            }
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.checkout.module", this.getUILocale(), message));
        }
    }

    public GWTJahiaNode sendToSourceControl(String moduleId, String scmURI, String scmType) throws GWTJahiaServiceException {
        try {
            return this.contentManager.sendToSourceControl(moduleId, scmURI, scmType, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot init remote repository", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.init.remote.repo", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public void saveModule(String moduleId, String message) throws GWTJahiaServiceException {
        boolean noChanges;
        try {
            noChanges = !this.moduleHelper.saveAndCommitModule(moduleId, message, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.synchronize.sources", this.getUILocale(), "\n" + e.getLocalizedMessage()));
        }
        if (noChanges) {
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.nothing.to.commit", this.getUILocale()));
        }
    }

    public String updateModule(String moduleId) throws GWTJahiaServiceException {
        try {
            return this.moduleHelper.updateModule(moduleId, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot update module", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.update.module", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public void addToSourceControl(String moduleId, GWTJahiaNode node) throws GWTJahiaServiceException {
        try {
            this.moduleHelper.addToSourceControl(moduleId, node, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot add to source control", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.add.to.source.control", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public void markConflictAsResolved(String moduleId, GWTJahiaNode node) throws GWTJahiaServiceException {
        try {
            this.contentManager.markConflictAsResolved(moduleId, node, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot mark conflict as resolved", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.mark.conflict.resolved", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public void compileAndDeploy(String moduleId) throws GWTJahiaServiceException {
        try {
            this.moduleHelper.compileAndDeploy(moduleId, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Cannot compile module", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.compile.module", this.getUILocale(), e.getLocalizedMessage()));
        }
    }

    public GWTJahiaNode generateWar(String moduleId) throws GWTJahiaServiceException {
        try {
            return this.moduleHelper.releaseModule(moduleId, null, this.retrieveCurrentSession(null));
        }
        catch (Exception e) {
            logger.error("Error during generation of a package for module " + moduleId, (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.generate.war", this.getUILocale(), moduleId, e.getLocalizedMessage()));
        }
    }

    public RpcMap releaseModule(String moduleId, GWTModuleReleaseInfo releaseInfo) throws GWTJahiaServiceException {
        try {
            GWTJahiaNode node = this.moduleHelper.releaseModule(moduleId, releaseInfo, this.retrieveCurrentSession(null));
            RpcMap r = new RpcMap();
            r.put("newModule", (Object)this.navigation.getNode("/modules/" + moduleId, GWTJahiaNode.DEFAULT_SITE_FIELDS, this.retrieveCurrentSession(), this.getUILocale()));
            r.put("artifactUrl", (Object)releaseInfo.getArtifactUrl());
            r.put("catalogModulePageUrl", (Object)releaseInfo.getForgeModulePageUrl());
            if (node != null) {
                r.put("filename", (Object)node.getName());
                r.put("downloadUrl", (Object)node.getUrl());
            }
            return r;
        }
        catch (Exception e) {
            String nextVersion = releaseInfo.getNextVersion();
            logger.error("Error during releasing version " + nextVersion + " of module " + moduleId, (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.release.module", this.getUILocale(), nextVersion, moduleId, "\n" + e.getLocalizedMessage()));
        }
    }

    public void setSeo(SeoHelper seoHelper) {
        this.seo = seoHelper;
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryProcesses(String nodeId, String lang) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        Locale locale = LanguageCodeConverters.languageCodeToLocale(lang);
        return this.workflow.getWorkflowHistoryProcesses(nodeId, this.retrieveCurrentSession(locale), this.getUILocale());
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryTasks(String provider, String processId) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.workflow.getWorkflowHistoryTasks(provider, processId, this.getUILocale());
    }

    public SessionValidationResult isValidSession() throws GWTJahiaServiceException {
        String loginUrl = this.getLogingUrl();
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            Long date = (Long)session.getAttribute("lastPoll");
            long lastAccessed = session.getLastAccessedTime();
            long now = System.currentTimeMillis();
            boolean invalidated = false;
            if (date != null && date / 1000L == lastAccessed / 1000L) {
                long first = (Long)session.getAttribute("firstPoll");
                logger.debug("Inactive since : {}", (Object)(now - first));
                if (now - first < (long)(session.getMaxInactiveInterval() * 1000)) {
                    session.setMaxInactiveInterval(session.getMaxInactiveInterval() - (int)((now - first) / 1000L));
                } else {
                    session.invalidate();
                    invalidated = true;
                }
            } else {
                session.setAttribute("firstPoll", (Object)now);
            }
            if (!invalidated) {
                session.setAttribute("lastPoll", (Object)now);
            }
            return new SessionValidationResult(loginUrl, this.sessionPollingFrequency);
        }
        return new SessionValidationResult(loginUrl, 0);
    }

    private String getLogingUrl() {
        HttpServletRequest request = this.getRequest();
        String loginUrl = StringUtils.defaultIfEmpty((String)LoginConfig.getInstance().getCustomLoginUrl(request), (String)Login.getServletPath());
        boolean isAbsolute = UrlUtil.isAbsoluteUrl((String)loginUrl);
        if (!isAbsolute) {
            if (request.getContextPath().length() > 0) {
                loginUrl = request.getContextPath() + loginUrl;
            }
            loginUrl = this.getResponse().encodeURL(loginUrl);
        }
        return loginUrl;
    }

    public GWTJahiaCreateEngineInitBean initializeCreateEngine(String typename, String parentpath, String targetName) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
            JCRNodeWrapper parent = sessionWrapper.getNode(parentpath);
            GWTJahiaCreateEngineInitBean result = new GWTJahiaCreateEngineInitBean();
            result.setLanguages(this.languages.getLanguages(this.getSite(), this.getLocale()));
            String defaultLanguage = parent.getResolveSite().getDefaultLanguage();
            if (defaultLanguage == null) {
                defaultLanguage = sessionWrapper.getRootNode().getResolveSite().getDefaultLanguage();
            }
            result.setDefaultLanguageCode(defaultLanguage);
            result.setCurrentLocale(this.languages.getCurrentLang(this.getLocale()));
            List<ExtendedNodeType> availableMixins = this.contentDefinition.getAvailableMixin(typename, parent.getResolveSite());
            List<GWTJahiaNodeType> gwtMixin = this.contentDefinition.getGWTNodeTypes(availableMixins, this.getUILocale());
            this.addInheritedMixin(gwtMixin);
            result.setMixin(gwtMixin);
            ArrayList<ExtendedNodeType> allTypes = new ArrayList<ExtendedNodeType>();
            ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(typename);
            allTypes.add(nodeType);
            allTypes.addAll(availableMixins);
            result.setChoiceListInitializersValues(this.contentDefinition.getAllChoiceListInitializersValues(allTypes, nodeType, null, parent, this.getUILocale()));
            result.setDefaultValues(this.contentDefinition.getAllDefaultValues(allTypes, sessionWrapper.getRootNode().getResolveSite().getLanguagesAsLocales()));
            result.setAcl(this.contentManager.getACL(parentpath, true, sessionWrapper, this.getUILocale()));
            result.setDefaultName(this.jcrContentUtils.generateNodeName(parent, defaultLanguage, nodeType, targetName));
            return result;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get node", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public GWTJahiaCreatePortletInitBean initializeCreatePortletEngine(String typename, String parentpath) throws GWTJahiaServiceException {
        GWTJahiaCreateEngineInitBean result = this.initializeCreateEngine(typename, parentpath, null);
        GWTJahiaCreatePortletInitBean portletInitBean = new GWTJahiaCreatePortletInitBean();
        portletInitBean.setChoiceListInitializersValues(result.getChoiceListInitializersValues());
        portletInitBean.setLanguages(result.getLanguages());
        portletInitBean.setMixin(result.getMixin());
        portletInitBean.setNodeType(this.contentDefinition.getNodeType(typename, this.getUILocale()));
        return portletInitBean;
    }

    public GWTJahiaEditEngineInitBean initializeEditEngine(String nodepath, boolean tryToLockNode) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
            if (!sessionWrapper.nodeExists(nodepath)) {
                logger.warn("Cannot initialize edit engine because the node [" + nodepath + "] doesnt exist");
                return null;
            }
            JCRNodeWrapper nodeWrapper = sessionWrapper.getNode(nodepath);
            GWTJahiaNode node = this.navigation.getGWTJahiaNode(nodeWrapper);
            this.addEngineLock(tryToLockNode && node.isLocked() == false, nodeWrapper);
            List<GWTJahiaNodeType> nodeTypes = this.contentDefinition.getNodeTypes(nodeWrapper.getNodeTypes(), this.getUILocale());
            Map<String, GWTJahiaNodeProperty> props = this.properties.getProperties(nodepath, this.retrieveCurrentSession(), this.getUILocale());
            GWTJahiaEditEngineInitBean result = new GWTJahiaEditEngineInitBean(nodeTypes, props);
            result.setNode(node);
            result.hasOrderableChildNodes(nodeWrapper.getPrimaryNodeType().hasOrderableChildNodes());
            result.setAvailabledLanguages(this.languages.getLanguages(this.getSite(), this.getLocale()));
            result.setCurrentLocale(this.languages.getCurrentLang(this.getLocale()));
            String defaultLanguage = nodeWrapper.getResolveSite().getDefaultLanguage();
            if (defaultLanguage == null) {
                defaultLanguage = sessionWrapper.getRootNode().getResolveSite().getDefaultLanguage();
            }
            result.setDefaultLanguageCode(defaultLanguage);
            List<ExtendedNodeType> availableMixins = this.contentDefinition.getAvailableMixin(nodeWrapper.getPrimaryNodeTypeName(), nodeWrapper.getResolveSite());
            List<GWTJahiaNodeType> gwtMixin = this.contentDefinition.getGWTNodeTypes(availableMixins, this.getUILocale());
            this.addInheritedMixin(gwtMixin);
            result.setMixin(gwtMixin);
            ArrayList<ExtendedNodeType> allTypes = new ArrayList<ExtendedNodeType>();
            allTypes.add(nodeWrapper.getPrimaryNodeType());
            allTypes.addAll(Arrays.asList(nodeWrapper.getMixinNodeTypes()));
            allTypes.addAll(availableMixins);
            JCRNodeWrapper parent = null;
            try {
                nodeWrapper.getParent();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            result.setInitializersValues(this.contentDefinition.getAllChoiceListInitializersValues(allTypes, nodeWrapper.getPrimaryNodeType(), nodeWrapper, parent, this.getUILocale()));
            result.setDefaultValues(this.contentDefinition.getAllDefaultValues(allTypes, sessionWrapper.getRootNode().getResolveSite().getLanguagesAsLocales()));
            GWTJahiaNodeACL gwtJahiaNodeACL = this.contentManager.getACL(nodepath, false, sessionWrapper, this.getUILocale());
            result.setAcl(gwtJahiaNodeACL);
            HashMap<String, Set<String>> referencesWarnings = new HashMap<String, Set<String>>();
            for (GWTJahiaNodeProperty property : props.values()) {
                Set<String> allDeniedUsers;
                try {
                    if (property.getName().equals("*") || nodeWrapper.getProperty(property.getName()).getDefinition().isProtected()) {
                        continue;
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                ArrayList<GWTJahiaNode> refs = new ArrayList<GWTJahiaNode>();
                for (GWTJahiaNodePropertyValue value : property.getValues()) {
                    if (value.getType() != 9 && value.getType() != 10 || value.getNode() == null) continue;
                    refs.add(value.getNode());
                }
                if (refs.isEmpty() || (allDeniedUsers = this.compareAcl(gwtJahiaNodeACL, refs)).isEmpty()) continue;
                referencesWarnings.put(property.getName(), allDeniedUsers);
            }
            result.setReferencesWarnings(referencesWarnings);
            result.setTranslationEnabled(this.translationHelper.isTranslationEnabled(nodeWrapper.getResolveSite()));
            return result;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get node", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    private void addInheritedMixin(List<GWTJahiaNodeType> gwtMixin) throws NoSuchNodeTypeException, GWTJahiaServiceException {
        if (gwtMixin != null) {
            ArrayList<GWTJahiaNodeType> gwtMixinCopy = new ArrayList<GWTJahiaNodeType>(gwtMixin);
            for (GWTJahiaNodeType type : gwtMixinCopy) {
                if (!type.getSuperTypes().contains("jmix:templateMixin")) continue;
                for (String superType : type.getSuperTypes()) {
                    GWTJahiaNodeType nodeType = this.contentDefinition.getGWTJahiaNodeType(NodeTypeRegistry.getInstance().getNodeType(superType), this.getUILocale());
                    if (gwtMixin.contains(nodeType)) continue;
                    gwtMixin.add(nodeType);
                }
            }
        }
    }

    public void closeEditEngine(String nodepath) throws GWTJahiaServiceException {
        JCRSessionWrapper jcrSessionWrapper = this.retrieveCurrentSession();
        try {
            JCRNodeWrapper n = jcrSessionWrapper.getNode(nodepath);
            if (n.getProvider().isLockingAvailable() && n.isLocked() && n.getLockOwner().equals(JCRSessionFactory.getInstance().getCurrentUser().getUsername())) {
                Map locks = (Map)this.getRequest().getSession().getAttribute("engineLocks");
                String windowId = this.getRequest().getParameter("windowId");
                if (windowId != null && locks != null) {
                    if (locks.get(windowId) != null) {
                        n.unlock("engine");
                        GWTResourceBundleUtils.unlock(n);
                        ((List)locks.get(windowId)).remove(n.getSession().getLocale() + "/" + n.getIdentifier());
                    }
                } else if (windowId == null) {
                    logger.error("Missing windowId : " + this.getRequest().getRequestURI() + "?" + this.getRequest().getQueryString());
                    throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.unlock.node", this.getUILocale(), new Object[0]));
                }
            }
            this.dumpLocks(n, "closeEditEngine");
        }
        catch (UnsupportedRepositoryOperationException n) {
        }
        catch (RepositoryException e) {
            logger.warn("Unable to unlock node " + nodepath, (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.unlock.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public Set<String> compareAcl(GWTJahiaNodeACL nodeAcl, List<GWTJahiaNode> references) throws GWTJahiaServiceException {
        JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
        HashSet<String> result = new HashSet<String>();
        for (GWTJahiaNode reference : references) {
            GWTJahiaNodeACL referenceAcl = this.contentManager.getACL(reference.getPath(), false, sessionWrapper, this.getUILocale());
            HashSet<String> allReadUsers = new HashSet<String>();
            for (GWTJahiaNodeACE ace : nodeAcl.getAce()) {
                if ((!ace.getRoles().containsKey("jcr:read_live") || Boolean.FALSE.equals(ace.getRoles().get("jcr:read_live"))) && (!ace.getInheritedRoles().containsKey("jcr:read_live") || Boolean.FALSE.equals(ace.getInheritedRoles().get("jcr:read_live")))) continue;
                allReadUsers.add(ace.getPrincipalType() + ":" + ace.getPrincipal());
            }
            HashSet<String> allDeniedUsers = new HashSet<String>();
            for (GWTJahiaNodeACE ace : referenceAcl.getAce()) {
                if ((!ace.getRoles().containsKey("jcr:read_live") || Boolean.TRUE.equals(ace.getRoles().get("jcr:read_live"))) && (!ace.getInheritedRoles().containsKey("jcr:read_live") || Boolean.TRUE.equals(ace.getInheritedRoles().get("jcr:read_live")))) continue;
                allDeniedUsers.add(ace.getPrincipalType() + ":" + ace.getPrincipal());
            }
            allDeniedUsers.retainAll(allReadUsers);
            result.addAll(allDeniedUsers);
        }
        return result;
    }

    public GWTJahiaEditEngineInitBean initializeEditEngine(List<String> paths, boolean tryToLockNode) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
            List<GWTJahiaNodeType> nodeTypes = null;
            List<GWTJahiaNodeType> gwtMixin = null;
            ArrayList<ExtendedNodeType> allTypes = new ArrayList<ExtendedNodeType>();
            JCRNodeWrapper nodeWrapper = null;
            for (String path : paths) {
                if (!sessionWrapper.nodeExists(path)) {
                    logger.warn("Cannot initialize edit engine because the node [" + path + "] doesnt exist");
                    return null;
                }
                nodeWrapper = sessionWrapper.getNode(path);
                this.addEngineLock(tryToLockNode && !JCRContentUtils.isLockedAndCannotBeEdited(nodeWrapper), nodeWrapper);
                if (nodeTypes == null) {
                    List<GWTJahiaNodeType> theseTypes;
                    nodeTypes = theseTypes = this.contentDefinition.getNodeTypes(nodeWrapper.getNodeTypes(), this.getUILocale());
                } else {
                    ArrayList previousTypes = new ArrayList(nodeTypes);
                    nodeTypes.clear();
                    block3: for (GWTJahiaNodeType p : previousTypes) {
                        if (!nodeWrapper.isNodeType(p.getName())) {
                            List superTypes = p.getSuperTypes();
                            for (String s : superTypes) {
                                if (!nodeWrapper.isNodeType(s)) continue;
                                nodeTypes.add(0, this.contentDefinition.getNodeType(s, this.getUILocale()));
                                continue block3;
                            }
                            continue;
                        }
                        nodeTypes.add(p);
                    }
                }
                List<ExtendedNodeType> availableMixins = this.contentDefinition.getAvailableMixin(nodeWrapper.getPrimaryNodeTypeName(), nodeWrapper.getResolveSite());
                List<GWTJahiaNodeType> theseMixin = this.contentDefinition.getGWTNodeTypes(availableMixins, this.getUILocale());
                if (gwtMixin == null) {
                    gwtMixin = theseMixin;
                } else {
                    gwtMixin.retainAll(theseMixin);
                }
                allTypes.add(nodeWrapper.getPrimaryNodeType());
                allTypes.addAll(Arrays.asList(nodeWrapper.getMixinNodeTypes()));
                allTypes.addAll(availableMixins);
            }
            this.addInheritedMixin(gwtMixin);
            GWTJahiaEditEngineInitBean result = new GWTJahiaEditEngineInitBean(nodeTypes, new HashMap());
            result.setAvailabledLanguages(this.languages.getLanguages(this.getSite(), this.getLocale()));
            result.setCurrentLocale(this.languages.getCurrentLang(this.getLocale()));
            result.setMixin(gwtMixin);
            result.setInitializersValues(this.contentDefinition.getAllChoiceListInitializersValues(allTypes, NodeTypeRegistry.getInstance().getNodeType("nt:base"), nodeWrapper, nodeWrapper.getParent(), this.getUILocale()));
            result.setDefaultValues(new HashMap());
            return result;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get node", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    private void addEngineLock(boolean tryToLockNode, JCRNodeWrapper nodeWrapper) throws RepositoryException, GWTJahiaServiceException {
        try {
            if (tryToLockNode && nodeWrapper.getProvider().isLockingAvailable() && nodeWrapper.hasPermission("{http://www.jcp.org/jcr/1.0}lockManagement")) {
                nodeWrapper.lockAndStoreToken("engine");
                GWTResourceBundleUtils.lock(nodeWrapper);
                String windowId = this.getRequest().getParameter("windowId");
                if (windowId != null) {
                    ArrayList<String> l;
                    HashMap<String, ArrayList<String>> locks = (HashMap<String, ArrayList<String>>)this.getRequest().getSession().getAttribute("engineLocks");
                    if (locks == null) {
                        locks = new HashMap<String, ArrayList<String>>();
                    }
                    if ((l = (ArrayList<String>)locks.get(windowId)) == null) {
                        l = new ArrayList<String>();
                        locks.put(windowId, l);
                    }
                    l.add(nodeWrapper.getSession().getLocale() + "/" + nodeWrapper.getIdentifier());
                    this.getRequest().getSession().setAttribute("engineLocks", locks);
                } else {
                    logger.error("Missing windowId : " + this.getRequest().getRequestURI() + "?" + this.getRequest().getQueryString());
                    throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.unlock.node", this.getUILocale(), new Object[0]));
                }
            }
            this.dumpLocks(nodeWrapper, "initializeEditEngine");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    private void dumpLocks(JCRNodeWrapper nodeWrapper, String message) throws RepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug(message + " - Locks for " + nodeWrapper.getPath() + " - " + nodeWrapper.isLocked());
            if (nodeWrapper.hasProperty("j:lockTypes")) {
                for (JCRValueWrapper value : nodeWrapper.getProperty("j:lockTypes").getValues()) {
                    logger.debug(value.getString());
                }
            }
            JCRNodeIteratorWrapper ni = nodeWrapper.getNodes("j:translation*");
            while (ni.hasNext()) {
                JCRNodeWrapper jcrNodeWrapper = (JCRNodeWrapper)ni.next();
                logger.debug(message + " Locks for " + jcrNodeWrapper.getPath() + " - " + jcrNodeWrapper.isLocked());
                if (!jcrNodeWrapper.hasProperty("j:lockTypes")) continue;
                for (JCRValueWrapper value : jcrNodeWrapper.getProperty("j:lockTypes").getValues()) {
                    logger.debug(value.getString());
                }
            }
        }
    }

    public Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>> getWorkflowRules(String path) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.workflow.getWorkflowRules(path, this.retrieveCurrentSession(), this.getUILocale());
    }

    public GWTJahiaNode getSource(String referenceIdentifier) throws GWTJahiaServiceException {
        GWTJahiaNode gwtSourceNode = null;
        try {
            JCRNodeWrapper source;
            JCRSessionWrapper session = this.retrieveCurrentSession();
            JCRNodeWrapper node = session.getNodeByIdentifier(referenceIdentifier);
            if (node.hasProperty("j:node") && (source = (JCRNodeWrapper)node.getProperty("j:node").getNode()) != null) {
                gwtSourceNode = this.navigation.getGWTJahiaNode(source);
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.source", this.getUILocale(), this.getLocalizedMessage(e)));
        }
        return gwtSourceNode;
    }

    public void flush(String path) throws GWTJahiaServiceException {
        try {
            if (this.retrieveCurrentSession().getNode(path).hasPermission("adminCache")) {
                this.cacheHelper.flush(path, true);
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.flush", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void flushAll() throws GWTJahiaServiceException {
        try {
            if (this.retrieveCurrentSession().getRootNode().hasPermission("adminCache")) {
                this.cacheHelper.flushAll();
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.flush", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void flushSite(String siteUUID) throws GWTJahiaServiceException {
        JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
        try {
            JCRNodeWrapper nodeWrapper = sessionWrapper.getNodeByIdentifier(siteUUID);
            if (nodeWrapper.hasPermission("adminCache")) {
                this.cacheHelper.flush(nodeWrapper.getPath(), true);
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.flush", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public Map<String, Object> getPollData(Set<String> keys) throws GWTJahiaServiceException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Locale locale = this.getLocale();
        if (keys.contains("activeJobs")) {
            result.put("activeJobs", this.schedulerHelper.getActiveJobs(locale));
        }
        if (keys.contains("numberOfTasks")) {
            result.put("numberOfTasks", this.workflow.getNumberOfTasksForUser(this.getUser()));
        }
        return result;
    }

    public BasePagingLoadResult<GWTJahiaJobDetail> getJobs(int offset, int limit, String sortField, String sortDir, String groupBy, List<String> groupNames) throws GWTJahiaServiceException {
        List<GWTJahiaJobDetail> jobList = this.schedulerHelper.getAllJobs(new HashSet<String>(groupNames), sortField, sortDir, groupBy);
        int size = jobList.size();
        jobList = new ArrayList<GWTJahiaJobDetail>(jobList.subList(offset, Math.min(size, offset + limit)));
        return new BasePagingLoadResult(jobList, offset, size);
    }

    public Boolean deleteJob(String jobName, String groupName) throws GWTJahiaServiceException {
        return this.schedulerHelper.deleteJob(jobName, groupName);
    }

    public List<String> getAllJobGroupNames() throws GWTJahiaServiceException {
        return this.schedulerHelper.getAllJobGroupNames();
    }

    public BasePagingLoadResult<GWTJahiaContentHistoryEntry> getContentHistory(String nodeIdentifier, int offset, int limit) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
        try {
            List<GWTJahiaContentHistoryEntry> historyListJahia = this.contentManager.getContentHistory(sessionWrapper, nodeIdentifier, offset, limit);
            int size = historyListJahia.size();
            historyListJahia = offset > size ? new ArrayList<GWTJahiaContentHistoryEntry>(0) : new ArrayList<GWTJahiaContentHistoryEntry>(historyListJahia.subList(offset, Math.min(size, offset + limit)));
            BasePagingLoadResult pagingLoadResult = new BasePagingLoadResult(historyListJahia, offset, size);
            return pagingLoadResult;
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.content.history", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public void cleanReferences(String path) throws GWTJahiaServiceException {
        this.contentManager.deleteReferences(path, this.getUser(), this.retrieveCurrentSession(), this.getUILocale());
    }

    public GWTChoiceListInitializer getFieldInitializerValues(String typeName, String propertyName, String parentPath, Map<String, List<GWTJahiaNodePropertyValue>> dependentValues) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRSessionWrapper sessionWrapper = this.retrieveCurrentSession();
            JCRNodeWrapper parent = sessionWrapper.getNode(parentPath);
            ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(typeName);
            GWTChoiceListInitializer initializer = this.contentDefinition.getInitializerValues(nodeType.getPropertyDefinition(propertyName), nodeType, null, parent, dependentValues, this.getUILocale());
            return initializer;
        }
        catch (RepositoryException e) {
            logger.error("Cannot get node", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", this.getUILocale(), this.getLocalizedMessage(e)));
        }
    }

    public List<String> getNamespaces() {
        return new ArrayList<String>(NodeTypeRegistry.getInstance().getNamespaces().keySet());
    }

    public List<GWTJahiaNode> getPortalNodes(String targetAreaName) {
        this.enableJcrSessionReadOnlyCache();
        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
        try {
            QueryWrapper q = this.retrieveCurrentSession().getWorkspace().getQueryManager().createQuery("select * from [jnt:contentFolder] as l where localname()='" + JCRContentUtils.sqlEncode(targetAreaName) + "' and isdescendantnode(l,['/sites'])", "JCR-SQL2");
            QueryResult queryResult = q.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodeIterator.nextNode();
                nodes.add(this.navigation.getGWTJahiaNode(nodeWrapper));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return nodes;
    }

    public Map<String, WCAGValidationResult> validateWCAG(Map<String, String> richTexts) {
        Locale locale;
        HashMap<String, WCAGValidationResult> result = new HashMap<String, WCAGValidationResult>(richTexts.size());
        try {
            locale = this.getUILocale();
        }
        catch (GWTJahiaServiceException e) {
            logger.warn("Unable to get UI locale", (Throwable)e);
            locale = this.getRequest().getLocale();
        }
        for (Map.Entry<String, String> richText : richTexts.entrySet()) {
            ValidatorResults validatorResults = new WAIValidator(locale).validate(richText.getValue());
            result.put(richText.getKey(), this.toWCAGResult(validatorResults));
        }
        return result;
    }

    public int getNumberOfTasksForUser() throws GWTJahiaServiceException {
        return this.workflow.getNumberOfTasksForUser(this.getUser());
    }

    private WCAGValidationResult toWCAGResult(ValidatorResults validatorResults) {
        if (validatorResults.isEmpty()) {
            return WCAGValidationResult.OK;
        }
        WCAGValidationResult wcagResult = new WCAGValidationResult();
        for (Result result : validatorResults.getErrors()) {
            wcagResult.getErrors().add(new WCAGViolation(result.getType().toString(), StringEscapeUtils.escapeHtml((String)result.getMessage()), result.getContext(), StringEscapeUtils.escapeXml((String)result.getCode()), result.getExample(), Integer.valueOf(result.getLine()), Integer.valueOf(result.getColumn())));
        }
        for (Result result : validatorResults.getWarnings()) {
            wcagResult.getWarnings().add(new WCAGViolation(result.getType().toString(), StringEscapeUtils.escapeHtml((String)result.getMessage()), result.getContext(), StringEscapeUtils.escapeXml((String)result.getCode()), result.getExample(), Integer.valueOf(result.getLine()), Integer.valueOf(result.getColumn())));
        }
        for (Result result : validatorResults.getInfos()) {
            wcagResult.getInfos().add(new WCAGViolation(result.getType().toString(), StringEscapeUtils.escapeHtml((String)result.getMessage()), result.getContext(), StringEscapeUtils.escapeXml((String)result.getCode()), result.getExample(), Integer.valueOf(result.getLine()), Integer.valueOf(result.getColumn())));
        }
        return wcagResult;
    }

    public GWTJahiaToolbar getGWTToolbars(String toolbarGroup) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.uiConfigHelper.getGWTToolbarSet(this.getSite(), this.getSite(), this.getRemoteJahiaUser(), this.getLocale(), this.getUILocale(), this.getRequest(), toolbarGroup);
    }

    public GWTJahiaPortletOutputBean drawPortletInstanceOutput(String windowID, String entryPointIDStr, String pathInfo, String queryString) {
        GWTJahiaPortletOutputBean result = new GWTJahiaPortletOutputBean();
        try {
            int fieldId = Integer.parseInt(windowID);
            String portletOutput = ServicesRegistry.getInstance().getApplicationsDispatchService().getAppOutput(fieldId, entryPointIDStr, this.getRemoteJahiaUser(), this.getRequest(), this.getResponse(), this.getServletContext(), this.getWorkspace());
            try {
                JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentUserSession().getNodeByUUID(entryPointIDStr);
                String nodeTypeName = node.getPrimaryNodeTypeName();
                if ("jnt:htmlPortlet".equals(nodeTypeName)) {
                    result.setInIFrame(false);
                }
                if ("jnt:contentPortlet".equals(nodeTypeName) || "jnt:rssPortlet".equals(nodeTypeName)) {
                    result.setInContentPortlet(true);
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            result.setHtmlOutput(portletOutput);
            Source source = new Source((CharSequence)portletOutput);
            source = new Source((CharSequence)new SourceFormatter((Segment)source).toString());
            List scriptTags = source.getAllStartTags("script");
            for (StartTag curScriptTag : scriptTags) {
                if (curScriptTag.getAttributeValue("src") != null && !curScriptTag.getAttributeValue("src").equals("")) {
                    result.getScriptsWithSrc().add(curScriptTag.getAttributeValue("src"));
                    continue;
                }
                result.getScriptsWithCode().add(curScriptTag.getElement().getContent().toString());
            }
        }
        catch (JahiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<GWTJahiaSite> getAvailableSites() {
        ArrayList<GWTJahiaSite> returnedSites = new ArrayList<GWTJahiaSite>();
        try {
            List<JCRSiteNode> sites = ServicesRegistry.getInstance().getJahiaSitesService().getSitesNodeList();
            for (JCRSiteNode jahiaSite : sites) {
                GWTJahiaSite gwtJahiaSite = new GWTJahiaSite();
                gwtJahiaSite.setSiteName(jahiaSite.getTitle());
                gwtJahiaSite.setSiteKey(jahiaSite.getSiteKey());
                gwtJahiaSite.setTemplateFolder(jahiaSite.getTemplateFolder());
                gwtJahiaSite.setTemplatePackageName(jahiaSite.getTemplatePackageName());
                gwtJahiaSite.setInstalledModules(jahiaSite.getInstalledModules());
                returnedSites.add(gwtJahiaSite);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return returnedSites;
    }

    public Integer deleteAllCompletedJobs() throws GWTJahiaServiceException {
        return this.schedulerHelper.deleteAllCompletedJobs();
    }

    public String getNodeURLByIdentifier(String servlet, String identifier, Date versionDate, String versionLabel, String workspace, String locale) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        JCRSessionWrapper session = this.retrieveCurrentSession(workspace != null ? workspace : this.getWorkspace(), locale != null ? LanguageCodeConverters.languageCodeToLocale(locale) : this.getLocale(), false);
        try {
            JCRNodeWrapper nodeByIdentifier = session.getNodeByIdentifier(identifier);
            if (nodeByIdentifier.isFile()) {
                String url = nodeByIdentifier.getUrl();
                if (versionDate != null) {
                    url = url + "?v=" + versionDate.getTime();
                    if (versionLabel != null) {
                        url = url + "&l=" + versionLabel;
                    }
                }
                return url;
            }
            return this.getResponse().encodeURL(this.navigation.getNodeURL(servlet, nodeByIdentifier, versionDate, versionLabel, session.getWorkspace().getName(), session.getLocale(), false));
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    public GWTJahiaNodeType getNodeType(String name) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        GWTJahiaNodeType type = this.contentDefinition.getNodeType(name, this.getUILocale());
        if (type != null) {
            this.checkComponentPermissions(Collections.singletonList(type));
        }
        return type;
    }

    public List<GWTJahiaNodeType> getNodeTypes(List<String> names) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.checkComponentPermissions(this.contentDefinition.getNodeTypes(names, this.getUILocale()));
    }

    private List<GWTJahiaNodeType> checkComponentPermissions(List<GWTJahiaNodeType> types) {
        JCRSiteNode site;
        if (types != null && types.size() > 0 && (site = this.getSite()).getPath().startsWith("/sites")) {
            for (GWTJahiaNodeType type : types) {
                try {
                    boolean perm = NodeTypesUtils.checkPermissionForType(type.getName(), (JCRNodeWrapper)site);
                    type.set("canUseComponentForCreate", (Object)perm);
                    type.set("canUseComponentForEdit", (Object)perm);
                }
                catch (RepositoryException e) {
                    logger.error("Cannot check component permissions for type " + type, (Throwable)e);
                }
            }
        }
        return types;
    }

    public List<GWTJahiaNodeType> getSubNodeTypes(List<String> names) throws GWTJahiaServiceException {
        return this.contentDefinition.getSubNodeTypes(names, this.getUILocale());
    }

    public List<GWTJahiaNodeType> getContentTypes(List<String> baseTypes, boolean includeSubTypes, boolean displayStudioElement) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.contentDefinition.getContentTypesAsList(baseTypes, new HashMap<String, Object>(), this.getUILocale(), includeSubTypes, displayStudioElement);
    }

    public List<GWTJahiaNodeType> getContentTypesAsTree(List<String> nodeTypes, List<String> excludedNodeTypes, boolean includeSubTypes) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.contentDefinition.getContentTypesAsTree(nodeTypes, excludedNodeTypes, includeSubTypes, this.getSite(), this.getUILocale(), this.retrieveCurrentSession());
    }

    public GWTJahiaNodeType getWFFormForNodeAndNodeType(String formResourceName) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.contentDefinition.getNodeType(formResourceName, this.getUILocale());
    }

    public ModelData getVisibilityInformation(String path) throws GWTJahiaServiceException {
        BaseModelData result = new BaseModelData();
        try {
            VisibilityService visibilityService = VisibilityService.getInstance();
            Map<String, VisibilityConditionRule> conditionsClasses = visibilityService.getConditions();
            ArrayList<GWTJahiaNodeType> types = new ArrayList<GWTJahiaNodeType>();
            HashMap<String, List<String>> requiredFields = new HashMap<String, List<String>>();
            for (Map.Entry<String, VisibilityConditionRule> entry : conditionsClasses.entrySet()) {
                GWTJahiaNodeType type = this.getNodeType(entry.getKey());
                type.set("xtemplate", (Object)entry.getValue().getGWTDisplayTemplate(this.getUILocale()));
                requiredFields.put(entry.getKey(), entry.getValue().getRequiredFieldNamesForTemplate());
                types.add(type);
            }
            result.set("types", types);
            JCRNodeWrapper node = this.retrieveCurrentSession().getNode(path);
            Map<JCRNodeWrapper, Boolean> conditionMatchesDetails = visibilityService.getConditionMatchesDetails(node);
            ArrayList<GWTJahiaNode> conditions = new ArrayList<GWTJahiaNode>();
            for (Map.Entry<JCRNodeWrapper, Boolean> entry : conditionMatchesDetails.entrySet()) {
                ArrayList<String> fields = new ArrayList<String>(Arrays.asList("publicationInfo"));
                fields.addAll((Collection)requiredFields.get(entry.getKey().getPrimaryNodeTypeName()));
                GWTJahiaNode jahiaNode = this.navigation.getGWTJahiaNode(entry.getKey(), fields);
                jahiaNode.set("conditionMatch", (Object)entry.getValue());
                ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(entry.getKey().getPrimaryNodeTypeName());
                ResourceBundle rb = ResourceBundles.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(nt.getSystemId()), this.getUILocale());
                for (String prop : (List)requiredFields.get(entry.getKey().getPrimaryNodeTypeName())) {
                    Object val = jahiaNode.get(prop);
                    if (val instanceof List) {
                        ArrayList<String> nl = new ArrayList<String>();
                        for (Object v : (List)val) {
                            if (v instanceof String) {
                                nl.add(Messages.get(rb, nt.getPropertyDefinition(prop).getResourceBundleKey() + "." + JCRContentUtils.replaceColon((String)v), (String)v));
                                continue;
                            }
                            nl.add((String)v);
                        }
                        jahiaNode.set(prop, nl);
                        continue;
                    }
                    if (val instanceof String) {
                        jahiaNode.set(prop, (Object)Messages.get(rb, nt.getPropertyDefinition(prop).getResourceBundleKey() + "." + JCRContentUtils.replaceColon((String)val), (String)val));
                        continue;
                    }
                    if (!(val instanceof Date)) continue;
                    jahiaNode.set(prop, (Object)ContentDefinitionHelper.dateTimeFormat.format((Date)val));
                }
                conditions.add(jahiaNode);
            }
            result.set("conditions", conditions);
            if (node.hasNode("j:conditionalVisibility")) {
                JCRNodeWrapper conditionalVisibilityNode = node.getNode("j:conditionalVisibility");
                result.set("j:forceMatchAllConditions", (Object)conditionalVisibilityNode.getProperty("j:forceMatchAllConditions").getValue().getBoolean());
                String locale = node.getSession().getLocale().toString();
                result.set("publicationInfo", (Object)this.publication.getAggregatedPublicationInfosByLanguage(conditionalVisibilityNode, Collections.singleton(locale), this.retrieveCurrentSession(), true, true).get(locale));
            } else {
                result.set("j:forceMatchAllConditions", (Object)false);
            }
            result.set("currentStatus", (Object)visibilityService.matchesConditions(node));
            try {
                JCRNodeWrapper liveNode = this.retrieveCurrentSession("live", null, false).getNodeByUUID(node.getIdentifier());
                result.set("liveStatus", (Object)visibilityService.matchesConditions(liveNode));
            }
            catch (RepositoryException repositoryException) {}
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
        return result;
    }

    public RpcMap initializeCodeEditor(String path, boolean isNew, String nodeTypeName, String fileType) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        return this.stubHelper.initializeCodeEditor(path, isNew, nodeTypeName, fileType, this.getSite().getName(), this.getUILocale(), this.retrieveCurrentSession());
    }

    public List<GWTJahiaValueDisplayBean> getTags(String prefix, String startPath, Long minCount, Long limit, Long offset, boolean sortByCount) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaValueDisplayBean> tags = new ArrayList<GWTJahiaValueDisplayBean>();
        try {
            Map<String, Long> tagsMap = this.taggingService.getTagsSuggester().suggest(prefix, startPath, minCount, limit, offset, sortByCount, this.retrieveCurrentSession());
            for (String tagEntry : tagsMap.keySet()) {
                tags.add(new GWTJahiaValueDisplayBean(tagEntry, tagEntry));
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException("Cannot get tags", (Throwable)e);
        }
        return tags;
    }

    public String convertTag(String tag) {
        return this.taggingService.getTagHandler().execute(tag);
    }

    public String getToolbarWarnings() throws GWTJahiaServiceException {
        return this.toolbarWarningsService.getMessagesValueAsString(this.getUILocale());
    }

    public GWTModuleReleaseInfo getInfoForModuleRelease(String moduleId) throws GWTJahiaServiceException {
        GWTModuleReleaseInfo result = null;
        try {
            result = this.moduleHelper.getModuleDistributionInfo(moduleId, this.retrieveCurrentSession());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }

    public void setModuleHelper(ModuleHelper moduleHelper) {
        this.moduleHelper = moduleHelper;
    }

    public GWTModuleReleaseInfo setDistributionServerForModule(String module, GWTModuleReleaseInfo info) throws GWTJahiaServiceException {
        GWTModuleReleaseInfo result = null;
        try {
            JCRSessionWrapper session = this.retrieveCurrentSession();
            if (info.getForgeUrl() != null) {
                this.moduleHelper.updateForgeUrlForModule(module, info.getForgeUrl(), session, info.getUsername(), info.getPassword());
            } else {
                this.moduleHelper.updateDistributionServerForModule(module, info.getRepositoryId(), info.getRepositoryUrl(), session);
            }
            result = this.moduleHelper.getModuleDistributionInfo(module, this.retrieveCurrentSession());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException((Throwable)e);
        }
        return result;
    }

    private String getLocalizedMessage(RepositoryException e) throws GWTJahiaServiceException {
        if (e.getLocalizedMessage() != null) {
            return e.getLocalizedMessage();
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return Messages.getInternal("label.gwt.error." + ((Object)((Object)e)).getClass().getName(), this.getUILocale(), StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)((Object)((Object)e)).getClass().getName()), (String)" "));
    }

    public List<String> getAvailablePermissions() throws GWTJahiaServiceException {
        return JahiaPrivilegeRegistry.getRegisteredPrivilegeNames();
    }

    public String getDisplayableNodePath(String nodePath, boolean fallbackToHomePage) throws GWTJahiaServiceException {
        this.enableJcrSessionReadOnlyCache();
        try {
            JCRSessionWrapper session = this.retrieveCurrentSession();
            JCRNodeWrapper node = session.getNode(nodePath);
            RenderContext renderContext = new RenderContext(null, null, session.getUser());
            JCRNodeWrapper displayableNode = JCRContentUtils.findDisplayableNode(node, renderContext);
            if (displayableNode == null && fallbackToHomePage) {
                displayableNode = node.getResolveSite().getHome();
            }
            return displayableNode != null ? displayableNode.getPath() : null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    private void enableJcrSessionReadOnlyCache() {
        JCRSessionFactory.getInstance().setReadOnlyCacheEnabled(true);
    }
}

