/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.apache.jackrabbit.server.BasicCredentialsProvider;
import org.jahia.services.usermanager.JahiaUser;

public class JahiaSessionCredentials
extends BasicCredentialsProvider {
    public JahiaSessionCredentials() {
        this("");
    }

    public JahiaSessionCredentials(String defaultHeaderValue) {
        super(defaultHeaderValue);
    }

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        JahiaUser jahiaUser = (JahiaUser)request.getSession(true).getAttribute("org.jahia.usermanager.jahiauser");
        if (jahiaUser != null) {
            request.setAttribute("isGuest", (Object)Boolean.FALSE);
            return JahiaLoginModule.getCredentials(jahiaUser.getName(), jahiaUser.getRealm());
        }
        SimpleCredentials c = (SimpleCredentials)super.getCredentials(request);
        if (c != null) {
            return c;
        }
        request.setAttribute("isGuest", (Object)Boolean.TRUE);
        return JahiaLoginModule.getGuestCredentials();
    }
}

