/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.JahiaRootCollection;
import org.apache.jackrabbit.webdav.jcr.JahiaServerRootCollection;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.jackrabbit.webdav.simple.ResourceFactoryImpl;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.OptionsResponse;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaResourceFactoryImpl
extends ResourceFactoryImpl {
    private static final Logger logger = LoggerFactory.getLogger(JahiaResourceFactoryImpl.class);
    private static Set<String> allowedNodeTypes;
    private final LockManager lockMgr;

    public JahiaResourceFactoryImpl(LockManager lockMgr, ResourceConfig resourceConfig) {
        super(lockMgr, resourceConfig);
        this.lockMgr = lockMgr;
        JahiaResourceFactoryImpl.getAllowedNodeTypes();
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        try {
            if (locator.isRootLocation()) {
                JcrDavSession davSession = (JcrDavSession)request.getDavSession();
                JahiaRootCollection jahiaRootCollection = new JahiaRootCollection(locator, davSession, (DavResourceFactory)this);
                jahiaRootCollection.addLockManager(this.lockMgr);
                return jahiaRootCollection;
            }
            if ("default".equals(locator.getWorkspaceName()) && "/repository".equals(locator.getRepositoryPath())) {
                JcrDavSession davSession = (JcrDavSession)request.getDavSession();
                JahiaServerRootCollection jahiaServerRootCollection = new JahiaServerRootCollection(locator, davSession, (DavResourceFactory)this);
                jahiaServerRootCollection.addLockManager(this.lockMgr);
                return jahiaServerRootCollection;
            }
            Node node = this.getNode(request.getDavSession(), locator);
            return this.createResource(super.createResource(locator, request, response), node);
        }
        catch (AccessDeniedException e) {
            throw new DavException(404);
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        try {
            if (locator.isRootLocation()) {
                JahiaRootCollection jahiaRootCollection = new JahiaRootCollection(locator, (JcrDavSession)session, (DavResourceFactory)this);
                jahiaRootCollection.addLockManager(this.lockMgr);
                return jahiaRootCollection;
            }
            if ("default".equals(locator.getWorkspaceName()) && "/repository".equals(locator.getRepositoryPath())) {
                JahiaServerRootCollection jahiaServerRootCollection = new JahiaServerRootCollection(locator, (JcrDavSession)session, (DavResourceFactory)this);
                jahiaServerRootCollection.addLockManager(this.lockMgr);
                return jahiaServerRootCollection;
            }
            Node node = this.getNode(session, locator);
            return this.createResource(super.createResource(locator, session), node);
        }
        catch (AccessDeniedException e) {
            throw new DavException(404);
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    private DavResource createResource(DavResource resource, Node node) {
        if (resource instanceof VersionHistoryResource) {
            return new VersionHistoryResourceImpl(this, (VersionHistoryResource)resource, node);
        }
        if (resource instanceof VersionResource) {
            return new VersionResourceImpl(this, (VersionResource)resource, node);
        }
        if (resource instanceof VersionControlledResource) {
            return new VersionControlledResourceImpl(this, (VersionControlledResource)resource, node);
        }
        if (resource instanceof DeltaVResource) {
            return new DeltaVResourceImpl(this, (DeltaVResource)resource, node);
        }
        return new DavResourceImpl(this, resource, node);
    }

    private Node getNode(DavSession sessionImpl, DavResourceLocator locator) throws RepositoryException {
        return this.getNode(sessionImpl, locator.getRepositoryPath());
    }

    private Node getNode(DavSession sessionImpl, String repoPath) throws RepositoryException {
        Node node = null;
        try {
            Session session;
            Item item;
            if (repoPath != null && (item = (session = ((JcrDavSession)sessionImpl).getRepositorySession()).getItem(repoPath)) instanceof Node && !JahiaResourceFactoryImpl.isAllowed((node = (Node)item).getPrimaryNodeType())) {
                throw new AccessDeniedException("Access denied.");
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return node;
    }

    public static boolean isAllowed(NodeType nodetype) {
        return JahiaResourceFactoryImpl.getAllowedNodeTypes().stream().anyMatch(arg_0 -> ((NodeType)nodetype).isNodeType(arg_0));
    }

    private static Set<String> getAllowedNodeTypes() {
        if (allowedNodeTypes == null) {
            String configuredTypes = SettingsBean.getInstance().getPropertiesFile().getProperty("repositoryAllowedNodeTypes", "rep:root,jnt:virtualsitesFolder,jnt:virtualsite,jnt:folder,jnt:file");
            allowedNodeTypes = Arrays.stream(StringUtils.split((String)configuredTypes, (String)", ")).map(nodeType -> {
                try {
                    NodeTypeRegistry.getInstance().getNodeType((String)nodeType);
                    return nodeType;
                }
                catch (NoSuchNodeTypeException e) {
                    throw new JahiaRuntimeException("unable to resolve type [" + nodeType + "]", e);
                }
            }).collect(Collectors.toSet());
        }
        return allowedNodeTypes;
    }

    static class VersionControlledResourceImpl<R extends VersionControlledResource>
    extends DeltaVResourceImpl<R>
    implements VersionControlledResource {
        final /* synthetic */ JahiaResourceFactoryImpl this$0;

        VersionControlledResourceImpl(R resource, Node node) {
            this.this$0 = this$0;
            super((JahiaResourceFactoryImpl)this$0, resource, node);
        }

        public String checkin() throws DavException {
            return ((VersionControlledResource)this.resource).checkin();
        }

        public void checkout() throws DavException {
            ((VersionControlledResource)this.resource).checkout();
        }

        public void uncheckout() throws DavException {
            ((VersionControlledResource)this.resource).uncheckout();
        }

        public MultiStatus update(UpdateInfo updateInfo) throws DavException {
            return ((VersionControlledResource)this.resource).update(updateInfo);
        }

        public MultiStatus merge(MergeInfo mergeInfo) throws DavException {
            return ((VersionControlledResource)this.resource).merge(mergeInfo);
        }

        public void label(LabelInfo labelInfo) throws DavException {
            ((VersionControlledResource)this.resource).label(labelInfo);
        }

        public VersionHistoryResource getVersionHistory() throws DavException {
            return ((VersionControlledResource)this.resource).getVersionHistory();
        }

        public void addVersionControl() throws DavException {
            ((VersionControlledResource)this.resource).addVersionControl();
        }
    }

    static class VersionHistoryResourceImpl<R extends VersionHistoryResource>
    extends DeltaVResourceImpl<R>
    implements VersionHistoryResource {
        final /* synthetic */ JahiaResourceFactoryImpl this$0;

        VersionHistoryResourceImpl(R resource, Node node) {
            this.this$0 = this$0;
            super((JahiaResourceFactoryImpl)this$0, resource, node);
        }

        public VersionResource[] getVersions() throws DavException {
            return ((VersionHistoryResource)this.resource).getVersions();
        }
    }

    static class VersionResourceImpl<R extends VersionResource>
    extends DeltaVResourceImpl<R>
    implements VersionResource {
        final /* synthetic */ JahiaResourceFactoryImpl this$0;

        VersionResourceImpl(R resource, Node node) {
            this.this$0 = this$0;
            super((JahiaResourceFactoryImpl)this$0, resource, node);
        }

        public void label(LabelInfo labelInfo) throws DavException {
            ((VersionResource)this.resource).label(labelInfo);
        }

        public VersionHistoryResource getVersionHistory() throws DavException {
            return ((VersionResource)this.resource).getVersionHistory();
        }
    }

    static class DeltaVResourceImpl<R extends DeltaVResource>
    extends DavResourceImpl<R>
    implements DeltaVResource {
        final /* synthetic */ JahiaResourceFactoryImpl this$0;

        DeltaVResourceImpl(R resource, Node node) {
            this.this$0 = this$0;
            super((JahiaResourceFactoryImpl)this$0, resource, node);
        }

        public OptionsResponse getOptionResponse(OptionsInfo optionsInfo) {
            return ((DeltaVResource)this.resource).getOptionResponse(optionsInfo);
        }

        public Report getReport(ReportInfo reportInfo) throws DavException {
            return ((DeltaVResource)this.resource).getReport(reportInfo);
        }

        public void addWorkspace(DavResource workspace) throws DavException {
            ((DeltaVResource)this.resource).addWorkspace(workspace);
        }

        public DavResource[] getReferenceResources(DavPropertyName hrefPropertyName) throws DavException {
            return ((DeltaVResource)this.resource).getReferenceResources(hrefPropertyName);
        }
    }

    static class DavResourceImpl<R extends DavResource>
    implements DavResource {
        protected final R resource;
        protected final Node node;
        final /* synthetic */ JahiaResourceFactoryImpl this$0;

        DavResourceImpl(R resource, Node node) {
            this.this$0 = this$0;
            this.resource = resource;
            this.node = node;
        }

        public String getComplianceClass() {
            return this.resource.getComplianceClass();
        }

        public String getSupportedMethods() {
            return this.resource.getSupportedMethods();
        }

        public boolean exists() {
            return this.resource.exists();
        }

        public boolean isCollection() {
            return this.resource.isCollection();
        }

        public String getDisplayName() {
            return this.resource.getDisplayName();
        }

        public DavResourceLocator getLocator() {
            return this.resource.getLocator();
        }

        public String getResourcePath() {
            return this.resource.getResourcePath();
        }

        public String getHref() {
            return this.resource.getHref();
        }

        public long getModificationTime() {
            return this.resource.getModificationTime();
        }

        public void spool(OutputContext outputContext) throws IOException {
            this.resource.spool(outputContext);
        }

        public DavPropertyName[] getPropertyNames() {
            return this.resource.getPropertyNames();
        }

        public DavProperty<?> getProperty(DavPropertyName name) {
            return this.resource.getProperty(name);
        }

        public DavPropertySet getProperties() {
            return this.resource.getProperties();
        }

        public void setProperty(DavProperty<?> property) throws DavException {
            this.resource.setProperty(property);
        }

        public void removeProperty(DavPropertyName propertyName) throws DavException {
            this.resource.removeProperty(propertyName);
        }

        public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
            return this.resource.alterProperties(changeList);
        }

        public DavResource getCollection() {
            return this.resource.getCollection();
        }

        public void addMember(DavResource resource, InputContext inputContext) throws DavException {
            this.resource.addMember(resource, inputContext);
        }

        public DavResourceIterator getMembers() {
            return this.resource.getMembers();
        }

        public void removeMember(DavResource member) throws DavException {
            this.resource.removeMember(member);
        }

        public void move(DavResource destination) throws DavException {
            try {
                if (this.node != null) {
                    this.node.checkout();
                    this.node.getParent().checkout();
                }
                String p = destination.getLocator().getRepositoryPath();
                p = p.substring(0, p.lastIndexOf(47));
                Node destNode = this.this$0.getNode(destination.getSession(), p);
                if (destNode != null) {
                    destNode.checkout();
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.resource.move(destination);
        }

        public void copy(DavResource destination, boolean shallow) throws DavException {
            this.resource.copy(destination, shallow);
        }

        public boolean isLockable(Type type, Scope scope) {
            return this.resource.isLockable(type, scope);
        }

        public boolean hasLock(Type type, Scope scope) {
            return this.resource.hasLock(type, scope);
        }

        public ActiveLock getLock(Type type, Scope scope) {
            return this.resource.getLock(type, scope);
        }

        public ActiveLock[] getLocks() {
            return this.resource.getLocks();
        }

        public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
            return this.resource.lock(reqLockInfo);
        }

        public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
            return this.resource.refreshLock(reqLockInfo, lockToken);
        }

        public void unlock(String lockToken) throws DavException {
            block2: {
                try {
                    this.resource.unlock(lockToken);
                }
                catch (DavException e) {
                    if (e.getErrorCode() == 412) break block2;
                    throw e;
                }
            }
        }

        public void addLockManager(LockManager lockmgr) {
            this.resource.addLockManager(lockmgr);
        }

        public DavResourceFactory getFactory() {
            return this.resource.getFactory();
        }

        public DavSession getSession() {
            return this.resource.getSession();
        }
    }
}

