/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.HashSet;
import java.util.concurrent.Executor;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.parser.Parser;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.utils.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaTranslationNodeIndexer
extends JahiaNodeIndexer {
    private static final Logger logger = LoggerFactory.getLogger(JahiaTranslationNodeIndexer.class);
    private static final Name MIXIN_TYPES = NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "mixinTypes");
    private static final Name PRIMARY_TYPE = NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "primaryType");
    private String language;
    private NodeState parentNode;
    private ExtendedNodeType parentNodeType;

    protected JahiaTranslationNodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, Executor executor, Parser parser, QueryHandlerContext context) {
        super(node, stateProvider, mappings, executor, parser, context);
        try {
            for (Name propName : node.getPropertyNames()) {
                if (!"language".equals(propName.getLocalName()) || !"http://www.jcp.org/jcr/1.0".equals(propName.getNamespaceURI())) continue;
                PropertyId id = new PropertyId(node.getNodeId(), propName);
                PropertyState propState = (PropertyState)stateProvider.getItemState((ItemId)id);
                this.language = propState.getValues()[0].getString();
                break;
            }
        }
        catch (Exception e) {
            logger.debug("Error finding language property", (Throwable)e);
        }
    }

    @Override
    protected ExtendedPropertyDefinition getPropertyDefinition(String fieldName) throws RepositoryException, ItemStateException {
        ExtendedPropertyDefinition propDef;
        int endIndex = fieldName.lastIndexOf("_" + this.language);
        if (endIndex >= 0) {
            fieldName = fieldName.substring(0, endIndex);
        }
        return (propDef = this.getPropertyDefinitionFor(fieldName, this.getParentNodeType(), this.parentNode)) != null ? propDef : this.getPropertyDefinitionFor(fieldName, this.getNodeType(), this.node);
    }

    private ExtendedNodeType getParentNodeType() throws RepositoryException, ItemStateException {
        if (this.parentNodeType == null) {
            Name parenteNodeTypeName = this.getParentNodeState().getNodeTypeName();
            this.parentNodeType = this.nodeTypeRegistry.getNodeType(JahiaTranslationNodeIndexer.getTypeNameAsString(parenteNodeTypeName, this.namespaceRegistry));
        }
        return this.parentNodeType;
    }

    private NodeState getParentNodeState() throws ItemStateException {
        if (this.parentNode == null) {
            this.parentNode = (NodeState)this.stateProvider.getItemState((ItemId)this.node.getParentId());
        }
        return this.parentNode;
    }

    @Override
    protected String getFullTextFieldName(String site) {
        return LuceneUtils.getFullTextFieldName(site, this.language);
    }

    @Override
    public Document createDoc() throws RepositoryException {
        Document doc = super.createDoc();
        this.doNotUseInExcerpt.clear();
        try {
            NodeState parentNodeState = this.getParentNodeState();
            this.cleanupNodeProperties(parentNodeState);
            NodeId parentId = parentNodeState.getParentId();
            if (parentId == null) {
                logger.warn("The node {} is in 'free floating' state. You should run a consistency check/fix on the repository.", (Object)parentNodeState.getId());
            } else {
                doc.add((Fieldable)new Field(TRANSLATED_NODE_PARENT, false, parentId.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            if (this.language == null) {
                logger.warn("The node {} is of type {} but doesn't contain a valid value for the jcr:language property!", (Object)this.node.getId(), (Object)"jnt:translation");
            } else {
                doc.add((Fieldable)new Field(TRANSLATION_LANGUAGE, this.language, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            this.addProperties(doc, parentNodeState);
            if (this.isIndexed(J_VISIBILITY) && parentNodeState.hasChildNodeEntry(J_VISIBILITY)) {
                doc.add((Fieldable)new Field(CHECK_VISIBILITY, false, "1", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            for (Fieldable field : this.doNotUseInExcerpt) {
                doc.add(field);
            }
        }
        catch (ItemStateException e) {
            logger.warn("Error while indexing translation node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
        }
        return doc;
    }

    private void addProperties(Document doc, NodeState parentNodeState) throws RepositoryException {
        HashSet parentNodePropertyNames = new HashSet(parentNodeState.getPropertyNames());
        HashSet localNames = new HashSet(this.node.getPropertyNames());
        localNames.remove(PRIMARY_TYPE);
        localNames.remove(MIXIN_TYPES);
        parentNodePropertyNames.removeAll(localNames);
        parentNodePropertyNames.removeAll(this.getIndexingConfig().getExcludesFromI18NCopy());
        for (Name propName : parentNodePropertyNames) {
            try {
                InternalValue[] values;
                PropertyId id = new PropertyId(parentNodeState.getNodeId(), propName);
                PropertyState propState = (PropertyState)this.stateProvider.getItemState((ItemId)id);
                if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                    this.addPropertyName(doc, propState.getName());
                }
                for (InternalValue value : values = propState.getValues()) {
                    this.addValue(doc, value, propState.getName());
                }
                if (values.length <= 1) continue;
                this.addMVPName(doc, propState.getName());
            }
            catch (ItemStateException e) {
                this.throwRepositoryException((Exception)((Object)e));
            }
        }
    }
}

