/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.JahiaIndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaTranslationNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NodeIndexer;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.schema.DateField;
import org.apache.solr.util.NumberUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.textextraction.TextExtractionService;
import org.jahia.utils.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaNodeIndexer
extends NodeIndexer {
    private static final Logger logger = LoggerFactory.getLogger(JahiaNodeIndexer.class);
    public static final String FACET_PREFIX = "FACET:";
    public static final String TRANSLATED_NODE_PARENT = "_:TRANSLATED_PARENT".intern();
    public static final String TRANSLATION_LANGUAGE = "_:TRANSLATION_LANGUAGE".intern();
    public static final String ACL_UUID = "_:ACL_UUID".intern();
    public static final Name J_ACL = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "acl");
    public static final Name J_ACL_INHERITED = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "inherit");
    public static final Name J_ACE_PRINCIPAL = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "principal");
    public static final Name J_ACE_GRANT = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "aceType");
    public static final Name J_ACE_ROLES = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "roles");
    private static final String USER_PRINCIPAL_PREFIX = "u:";
    public static final String CHECK_VISIBILITY = "_:CHECK_VISIBILITY".intern();
    private static final Name J_EXTRACTED_TEXT = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "extractedText");
    public static final Name J_VISIBILITY = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "conditionalVisibility");
    public static final String PUBLISHED = "_:PUBLISHED".intern();
    public static final Name J_PUBLISHED = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "published");
    public static final String FACET_HIERARCHY = "_:FACET_HIERARCHY".intern();
    public static final Name J_INVALID_LANGUAGES = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/1.0", "invalidLanguages");
    public static final String INVALID_LANGUAGES = "_:INVALID_LANGUAGES".intern();
    private static final int INITIAL_COLLECTION_SIZE = 17;
    protected final NodeTypeRegistry nodeTypeRegistry;
    protected final NamespaceRegistry namespaceRegistry;
    protected final HierarchyManager hierarchyMgr;
    private ExtendedNodeType nodeType;
    private final Name nodeTypeName;
    protected boolean supportSpellchecking;
    private Name siteTypeName;
    private Name siteFolderTypeName;
    private static final DateField dateType = new DateField();
    private boolean addAclUuidInIndex;
    private boolean useOptimizedACEIndexation;
    private String site;
    private Map<String, ExtendedPropertyDefinition> fieldNameToPropDef;

    protected JahiaNodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, Executor executor, Parser parser, QueryHandlerContext context) {
        block3: {
            super(node, stateProvider, mappings, executor, parser);
            this.supportSpellchecking = false;
            this.siteTypeName = null;
            this.siteFolderTypeName = null;
            this.addAclUuidInIndex = true;
            this.useOptimizedACEIndexation = false;
            this.fieldNameToPropDef = new HashMap<String, ExtendedPropertyDefinition>(17);
            this.nodeTypeRegistry = NodeTypeRegistry.getInstance();
            this.namespaceRegistry = context.getNamespaceRegistry();
            this.hierarchyMgr = context.getHierarchyManager();
            this.nodeTypeName = node.getNodeTypeName();
            try {
                ExtendedNodeType siteNodeType;
                if (this.siteTypeName == null && this.nodeTypeRegistry != null && (siteNodeType = this.nodeTypeRegistry.getNodeType("jnt:virtualsite")) != null) {
                    this.siteTypeName = NameFactoryImpl.getInstance().create(siteNodeType.getNameObject().getUri(), siteNodeType.getLocalName());
                    siteNodeType = this.nodeTypeRegistry.getNodeType("jnt:virtualsitesFolder");
                    this.siteFolderTypeName = NameFactoryImpl.getInstance().create(siteNodeType.getNameObject().getUri(), siteNodeType.getLocalName());
                }
            }
            catch (NoSuchNodeTypeException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getTypeNameAsString() throws RepositoryException {
        return JahiaNodeIndexer.getTypeNameAsString(this.nodeTypeName, this.namespaceRegistry);
    }

    protected static String getTypeNameAsString(Name nodeTypeName, NamespaceRegistry namespaceRegistry) throws RepositoryException {
        return namespaceRegistry.getPrefix(nodeTypeName.getNamespaceURI()) + ":" + nodeTypeName.getLocalName();
    }

    protected boolean useInExcerpt(Name propertyName) {
        boolean useInExcerpt = super.useInExcerpt(propertyName);
        if (useInExcerpt) {
            ExtendedPropertyDefinition propDef = this.getExtendedPropertyDefinition(this.getPropertyName(propertyName));
            useInExcerpt = propDef == null || propDef.isFullTextSearchable();
        }
        return useInExcerpt;
    }

    protected String getPropertyName(Name name) {
        StringBuilder propertyNameBuilder;
        block3: {
            propertyNameBuilder = new StringBuilder();
            try {
                propertyNameBuilder.append(this.namespaceRegistry.getPrefix(name.getNamespaceURI()));
            }
            catch (RepositoryException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Cannot get namespace prefix for: {}", (Object)name.getNamespaceURI(), (Object)e);
            }
        }
        if (propertyNameBuilder.length() > 0) {
            propertyNameBuilder.append(":");
        }
        propertyNameBuilder.append(name.getLocalName());
        return propertyNameBuilder.toString();
    }

    protected String resolveSite() {
        if (this.site != null) {
            return this.site;
        }
        try {
            NodeId id;
            Object current = this.node;
            do {
                NodeState siteParent;
                if (!this.isNodeType((NodeState)current, this.siteTypeName) || !this.isNodeType(siteParent = (NodeState)this.stateProvider.getItemState((ItemId)current.getParentId()), this.siteFolderTypeName)) continue;
                this.site = siteParent.getChildNodeEntry(current.getNodeId()).getName().getLocalName();
                break;
            } while ((current = (id = current.getParentId()) != null ? (NodeState)this.stateProvider.getItemState((ItemId)id) : null) != null);
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return this.site;
    }

    private boolean isNodeType(NodeState nodeState, Name typeName) {
        if (typeName != null) {
            Name primary = nodeState.getNodeTypeName();
            if (primary.equals(typeName)) {
                return true;
            }
            Set mixins = nodeState.getMixinTypeNames();
            if (mixins.contains(typeName)) {
                return true;
            }
        }
        return false;
    }

    protected ExtendedNodeType getNodeType() {
        if (this.nodeType == null) {
            try {
                this.nodeType = this.nodeTypeRegistry.getNodeType(this.getTypeNameAsString());
            }
            catch (RepositoryException e) {
                logger.error("Couldn't resolve type: {}:{}", (Object)this.nodeTypeName.getNamespaceURI(), (Object)this.nodeTypeName.getLocalName());
            }
        }
        return this.nodeType;
    }

    protected ExtendedPropertyDefinition getExtendedPropertyDefinition(String fieldName) {
        ExtendedPropertyDefinition propDef = this.fieldNameToPropDef.get(fieldName);
        if (propDef == null) {
            block4: {
                try {
                    propDef = this.getPropertyDefinition(fieldName);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Error finding property associated with field named {}", (Object)fieldName, (Object)e);
                }
            }
            if (propDef != null) {
                this.fieldNameToPropDef.put(fieldName, propDef);
            }
        }
        return propDef;
    }

    protected ExtendedPropertyDefinition getPropertyDefinition(String fieldName) throws RepositoryException, ItemStateException {
        return this.getPropertyDefinitionFor(fieldName, this.getNodeType(), this.node);
    }

    protected ExtendedPropertyDefinition getPropertyDefinitionFor(String fieldName, ExtendedNodeType nodeType, NodeState node) throws RepositoryException {
        ExtendedPropertyDefinition propDef;
        block1: {
            Name mixinTypeName;
            ExtendedNodeType mixinType;
            propDef = nodeType.getPropertyDefinitionsAsMap().get(fieldName);
            if (propDef != null) break block1;
            Iterator iterator = node.getMixinTypeNames().iterator();
            while (iterator.hasNext() && (propDef = (mixinType = this.nodeTypeRegistry.getNodeType(JahiaNodeIndexer.getTypeNameAsString(mixinTypeName = (Name)iterator.next(), this.namespaceRegistry))).getPropertyDefinitionsAsMap().get(fieldName)) == null) {
            }
        }
        return propDef;
    }

    protected float getPropertyBoost(Name propertyName) {
        ExtendedPropertyDefinition propDef;
        float scoreBoost = super.getPropertyBoost(propertyName);
        if (Float.compare(scoreBoost, 1.0f) == 0 && (propDef = this.getExtendedPropertyDefinition(this.getPropertyName(propertyName))) != null) {
            scoreBoost = (float)propDef.getScoreboost();
        }
        return scoreBoost;
    }

    protected boolean isIncludedInNodeIndex(Name propertyName) {
        boolean isIncludedInNodeIndex = super.isIncludedInNodeIndex(propertyName);
        if (isIncludedInNodeIndex) {
            ExtendedPropertyDefinition propDef = this.getExtendedPropertyDefinition(this.getPropertyName(propertyName));
            isIncludedInNodeIndex = propDef == null || propDef.isFullTextSearchable();
        }
        return isIncludedInNodeIndex;
    }

    protected boolean isIndexed(Name propertyName) {
        boolean isIndexed = super.isIndexed(propertyName);
        if (isIndexed) {
            ExtendedPropertyDefinition propDef = this.getExtendedPropertyDefinition(this.getPropertyName(propertyName));
            isIndexed = propDef == null || propDef.getIndex() != 0;
        }
        return isIndexed;
    }

    protected void addStringValue(Document doc, String fieldName, String internalValue, boolean tokenized, boolean includeInNodeIndex, float boost, boolean useInExcerpt) {
        String propertyName = this.getPropertyNameFromFieldname(fieldName);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(propertyName);
        if (definition != null && 2 == definition.getSelector()) {
            internalValue = this.extractTextFromHtml(internalValue);
        }
        if (internalValue != null) {
            super.addStringValue(doc, fieldName, internalValue, tokenized, includeInNodeIndex, boost, useInExcerpt);
        }
        if (StringUtils.isNotEmpty((String)internalValue)) {
            if (tokenized && includeInNodeIndex && this.isSupportSpellchecking()) {
                this.addFieldForSpellchecking(doc, propertyName, internalValue);
            }
            if (definition != null && definition.isFacetable()) {
                this.addFacetValue(doc, fieldName, internalValue);
            }
        }
    }

    private String extractTextFromHtml(String internalValue) {
        try {
            Metadata metadata = new Metadata();
            metadata.set("Content-Type", "text/html");
            metadata.set("Content-Encoding", "UTF-8");
            TextExtractionService textExtractor = (TextExtractionService)SpringContextSingleton.getBean("org.jahia.services.textextraction.TextExtractionService");
            return textExtractor.parse((InputStream)new ByteArrayInputStream(("<!DOCTYPE html>" + internalValue).getBytes(StandardCharsets.UTF_8)), metadata);
        }
        catch (Exception e) {
            return StringEscapeUtils.unescapeHtml((String)internalValue);
        }
    }

    private void addFieldForSpellchecking(Document doc, String propertyName, String internalValue) {
        if (this.getIndexingConfig().shouldPropertyBeSpellchecked(propertyName) && this.resolveSite() != null) {
            doc.add((Fieldable)this.createFulltextField(this.getFullTextFieldName(this.site), internalValue, false));
        }
    }

    protected String getFullTextFieldName(String site) {
        return LuceneUtils.getFullTextFieldName(site, null);
    }

    private String getPropertyNameFromFieldname(String fieldName) {
        String propertyName;
        block3: {
            propertyName = fieldName;
            int pos = fieldName.indexOf(58);
            if (pos > -1) {
                try {
                    String prefix = this.namespaceRegistry.getPrefix(this.mappings.getURI(fieldName.substring(0, pos)));
                    propertyName = !StringUtils.isEmpty((String)prefix) ? prefix + fieldName.substring(pos) : fieldName.substring(pos + 1);
                }
                catch (RepositoryException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Cannot convert Lucene fieldName '{}' to property name", (Object)fieldName, (Object)e);
                }
            }
        }
        return propertyName;
    }

    protected void addFacetValue(Document doc, String fieldName, Object internalValue) {
        String stringValue = internalValue.toString();
        if (stringValue.length() == 0) {
            return;
        }
        int idx = fieldName.indexOf(58);
        fieldName = fieldName.substring(0, idx + 1) + FACET_PREFIX + fieldName.substring(idx + 1);
        Field f = new Field(fieldName, true, stringValue, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        doc.add((Fieldable)f);
    }

    protected void addHierarchicalFacetValue(Document doc, String fieldName, Object internalValue) {
        String stringValue = internalValue.toString();
        if (stringValue.length() == 0) {
            return;
        }
        ItemId itemId = (ItemId)internalValue;
        int idx = fieldName.indexOf(58);
        fieldName = fieldName.substring(0, idx + 1) + FACET_PREFIX + fieldName.substring(idx + 1);
        ArrayList<String> hierarchyPaths = new ArrayList<String>();
        ArrayList<String> parentIds = new ArrayList<String>();
        try {
            NodeState node = (NodeState)this.stateProvider.getItemState(itemId);
            Name typeName = node.getNodeTypeName();
            boolean isCategoryType = typeName.toString().equals("{http://www.jahia.org/jahia/nt/1.0}category");
            NodeState parent = (NodeState)this.stateProvider.getItemState((ItemId)node.getParentId());
            while (typeName.equals(parent.getNodeTypeName())) {
                hierarchyPaths.add(StringUtils.remove((String)this.resolver.getJCRPath(this.hierarchyMgr.getPath((ItemId)node.getNodeId())), (String)"0:"));
                parentIds.add(node.getNodeId().toString());
                node = parent;
                parent = (NodeState)this.stateProvider.getItemState((ItemId)node.getParentId());
            }
            String jcrPath = this.resolver.getJCRPath(this.hierarchyMgr.getPath((ItemId)node.getNodeId()));
            while (!("/".equals(jcrPath) || isCategoryType && "0:/0:sites/0:systemsite".equals(jcrPath))) {
                parentIds.add(node.getNodeId().toString());
                node = (NodeState)this.stateProvider.getItemState((ItemId)node.getParentId());
                jcrPath = this.resolver.getJCRPath(this.hierarchyMgr.getPath((ItemId)node.getNodeId()));
            }
        }
        catch (NoSuchItemStateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException | ItemStateException e) {
            logger.warn("Error while indexing hierarchical facet value for node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
        }
        int hierarchyIndex = hierarchyPaths.size();
        for (String path : hierarchyPaths) {
            doc.add((Fieldable)new Field(fieldName, true, hierarchyIndex + path, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO));
            --hierarchyIndex;
        }
        for (String id : parentIds) {
            doc.add((Fieldable)new Field(FACET_HIERARCHY, false, id, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
    }

    protected Field createFulltextField(String fieldName, String value, boolean store) {
        if (store) {
            return new Field(fieldName, true, value, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        }
        return new Field(fieldName, true, value, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
    }

    public boolean isSupportSpellchecking() {
        return this.supportSpellchecking;
    }

    public void setSupportSpellchecking(boolean supportSpellchecking) {
        this.supportSpellchecking = supportSpellchecking;
    }

    protected void addCalendarValue(Document doc, String fieldName, Calendar internalValue) {
        super.addCalendarValue(doc, fieldName, internalValue);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            this.addFacetValue(doc, fieldName, dateType.toInternal(new Date(internalValue.getTimeInMillis())));
        }
    }

    protected void addBinaryValue(Document doc, String fieldName, InternalValue internalValue) {
        try {
            String propName = this.mappings.getPrefix("http://www.jahia.org/jahia/1.0") + ":extractedText";
            if (!propName.equals(fieldName)) {
                return;
            }
            long timer = System.currentTimeMillis();
            String value = internalValue.getString();
            this.addStringValue(doc, fieldName, value, true, this.isIncludedInNodeIndex(J_EXTRACTED_TEXT), this.getPropertyBoost(J_EXTRACTED_TEXT), this.useInExcerpt(J_EXTRACTED_TEXT));
            if (logger.isDebugEnabled()) {
                logger.debug("Indexed j:extractedText of length {} in {} ms", (Object)value.length(), (Object)(System.currentTimeMillis() - timer));
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error indexing content of the j:extractedText property", (Throwable)e);
            }
            logger.warn("Error indexing content of the j:extractedText property. Cause: {}", (Object)e.getMessage());
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        super.addBooleanValue(doc, fieldName, internalValue);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            this.addFacetValue(doc, fieldName, internalValue.toString());
        }
    }

    protected void addDoubleValue(Document doc, String fieldName, double internalValue) {
        super.addDoubleValue(doc, fieldName, internalValue);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            this.addFacetValue(doc, fieldName, NumberUtils.double2sortableStr((String)Double.toString(internalValue)));
        }
    }

    protected void addLongValue(Document doc, String fieldName, long internalValue) {
        super.addLongValue(doc, fieldName, internalValue);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            this.addFacetValue(doc, fieldName, NumberUtils.long2sortableStr((String)Long.toString(internalValue)));
        }
    }

    protected void addReferenceValue(Document doc, String fieldName, NodeId internalValue, boolean weak) {
        super.addReferenceValue(doc, fieldName, internalValue, weak);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            if (definition.isHierarchical()) {
                this.addHierarchicalFacetValue(doc, fieldName, internalValue);
            } else {
                this.addFacetValue(doc, fieldName, internalValue);
            }
        }
    }

    protected void addNameValue(Document doc, String fieldName, Name internalValue) {
        super.addNameValue(doc, fieldName, internalValue);
        ExtendedPropertyDefinition definition = this.getExtendedPropertyDefinition(this.getPropertyNameFromFieldname(fieldName));
        if (definition != null && definition.isFacetable()) {
            this.addFacetValue(doc, fieldName, internalValue.getNamespaceURI());
        }
    }

    public Document createDoc() throws RepositoryException {
        PropertyState propState;
        PropertyId id;
        Document doc = this.createDocIgnoringMissingProperties();
        if (this.isAddAclUuidInIndex() && this.isIndexed(J_ACL)) {
            this.addAclUuid(doc);
        }
        if (this.isIndexed(J_VISIBILITY) && this.node.hasChildNodeEntry(J_VISIBILITY)) {
            doc.add((Fieldable)new Field(CHECK_VISIBILITY, false, "1", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
        if (this.isIndexed(J_PUBLISHED) && this.node.getPropertyNames().contains(J_PUBLISHED)) {
            id = new PropertyId(this.node.getNodeId(), J_PUBLISHED);
            try {
                propState = (PropertyState)this.stateProvider.getItemState((ItemId)id);
                doc.add((Fieldable)new Field(PUBLISHED, false, propState.getValues()[0].getString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            catch (ItemStateException e) {
                logger.warn("Error while indexing j:published property for node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
            }
        }
        if (this.isIndexed(J_INVALID_LANGUAGES) && this.node.getPropertyNames().contains(J_INVALID_LANGUAGES)) {
            id = new PropertyId(this.node.getNodeId(), J_INVALID_LANGUAGES);
            try {
                InternalValue[] values;
                propState = (PropertyState)this.stateProvider.getItemState((ItemId)id);
                for (InternalValue value : values = propState.getValues()) {
                    doc.add((Fieldable)new Field(INVALID_LANGUAGES, false, value.getString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
                }
            }
            catch (ItemStateException e) {
                logger.warn("Error while indexing j:invalidLanguages for node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
            }
        }
        return doc;
    }

    protected void addParentChildRelation(Document doc, NodeId parentId) throws ItemStateException {
        try {
            super.addParentChildRelation(doc, parentId);
        }
        catch (RepositoryException | NoSuchItemStateException e) {
            logger.warn("Error while indexing parent child relation for node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
        }
    }

    private Document createDocIgnoringMissingProperties() throws RepositoryException {
        try {
            return super.createDoc();
        }
        catch (RepositoryException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof NoSuchItemStateException) {
                this.cleanupNodeProperties(this.node);
                return super.createDoc();
            }
            throw e;
        }
    }

    protected void cleanupNodeProperties(NodeState node) {
        Set props = node.getPropertyNames();
        HashSet<Name> toRemove = null;
        NodeId nodeId = node.getNodeId();
        for (Name propName : props) {
            try {
                if (this.stateProvider.hasItemState((ItemId)new PropertyId(nodeId, propName))) continue;
                if (toRemove == null) {
                    toRemove = new HashSet<Name>();
                }
                toRemove.add(propName);
            }
            catch (Exception exception) {}
        }
        if (toRemove != null) {
            for (Name name : toRemove) {
                logger.debug("Removed non-existing property {} from {}", (Object)name, (Object)nodeId);
                node.removePropertyName(name);
            }
        }
    }

    protected JahiaIndexingConfigurationImpl getIndexingConfig() {
        return (JahiaIndexingConfigurationImpl)this.indexingConfig;
    }

    protected void addAclUuid(Document doc) throws RepositoryException {
        ArrayList<String> acls = new ArrayList<String>();
        NodeState currentNode = this.node;
        try {
            while (currentNode != null) {
                ChildNodeEntry aclChildNode;
                if (currentNode.hasChildNodeEntry(J_ACL) && (aclChildNode = currentNode.getChildNodeEntry(J_ACL, 1)) != null) {
                    acls.add(0, this.getAce(currentNode, aclChildNode));
                    if (this.isAclNotInherited(aclChildNode)) break;
                }
                currentNode = currentNode.getParentId() != null ? (NodeState)this.stateProvider.getItemState((ItemId)currentNode.getParentId()) : null;
            }
        }
        catch (ItemStateException e) {
            logger.warn("Error while indexing ACL for node {}: {}", (Object)this.node.getNodeId(), (Object)e.getMessage());
        }
        doc.add((Fieldable)new Field(ACL_UUID, false, StringUtils.join(acls, (String)" "), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
    }

    private boolean isAclNotInherited(ChildNodeEntry aclChildNode) throws RepositoryException, ItemStateException {
        boolean aclNotInherited = false;
        PropertyId propId = new PropertyId(aclChildNode.getId(), J_ACL_INHERITED);
        if (this.stateProvider.hasItemState((ItemId)propId)) {
            PropertyState ps = (PropertyState)this.stateProvider.getItemState((ItemId)propId);
            aclNotInherited = ps.getValues().length == 1 && !ps.getValues()[0].getBoolean();
        }
        return aclNotInherited;
    }

    private String getAce(NodeState node, ChildNodeEntry aclChildNode) throws RepositoryException, ItemStateException {
        ChildNodeEntry childNodeEntry;
        PropertyId principalPropId;
        PropertyState principal;
        InternalValue internalValue;
        String principalValue;
        StringBuilder ace = new StringBuilder(node.getId().toString());
        NodeState ns = (NodeState)this.stateProvider.getItemState((ItemId)aclChildNode.getId());
        if (ns.getChildNodeEntries().size() == 1 && this.useOptimizedACEIndexation && (principalValue = (internalValue = (principal = (PropertyState)this.stateProvider.getItemState((ItemId)(principalPropId = new PropertyId((childNodeEntry = (ChildNodeEntry)ns.getChildNodeEntries().get(0)).getId(), J_ACE_PRINCIPAL)))).getValues()[0]).getString()).startsWith(USER_PRINCIPAL_PREFIX)) {
            PropertyId grantPropId = new PropertyId(childNodeEntry.getId(), J_ACE_GRANT);
            PropertyState grant = (PropertyState)this.stateProvider.getItemState((ItemId)grantPropId);
            PropertyId rolesPropId = new PropertyId(childNodeEntry.getId(), J_ACE_ROLES);
            PropertyState roles = (PropertyState)this.stateProvider.getItemState((ItemId)rolesPropId);
            ace.append("/");
            if (grant.getValues()[0].getString().equals("GRANT")) {
                for (InternalValue value : roles.getValues()) {
                    ace.append(value.getName().getLocalName()).append("/");
                }
            }
            ace.append(principalValue.substring(USER_PRINCIPAL_PREFIX.length()));
        }
        return ace.toString();
    }

    public boolean isAddAclUuidInIndex() {
        return this.addAclUuidInIndex;
    }

    public void setAddAclUuidInIndex(boolean addAclUuidInIndex) {
        this.addAclUuidInIndex = addAclUuidInIndex;
    }

    public boolean isUseOptimizedACEIndexation() {
        return this.useOptimizedACEIndexation;
    }

    public void setUseOptimizedACEIndexation(boolean useOptimizedACEIndexation) {
        this.useOptimizedACEIndexation = useOptimizedACEIndexation;
    }

    public static JahiaNodeIndexer createNodeIndexer(NodeState node, ItemStateManager itemStateManager, NamespaceMappings nsMappings, Executor executor, Parser parser, QueryHandlerContext context) throws RepositoryException {
        if ("jnt:translation".equals(JahiaNodeIndexer.getTypeNameAsString(node.getNodeTypeName(), (NamespaceRegistry)context.getNamespaceRegistry()))) {
            return new JahiaTranslationNodeIndexer(node, itemStateManager, nsMappings, executor, parser, context);
        }
        return new JahiaNodeIndexer(node, itemStateManager, nsMappings, executor, parser, context);
    }
}

