/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.LinkedList;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.JahiaSearchManager;
import org.apache.jackrabbit.core.JahiaSessionImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.JahiaClusterNode;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.query.lucene.JahiaSearchIndex;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaRepositoryImpl
extends RepositoryImpl
implements ReadOnlyModeCapable {
    private static final Logger log = LoggerFactory.getLogger(JahiaRepositoryImpl.class);

    public JahiaRepositoryImpl(RepositoryConfig repConfig) throws RepositoryException {
        super(repConfig);
    }

    public static RepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        return new JahiaRepositoryImpl(config);
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new JahiaSessionImpl(this.context, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new JahiaSessionImpl(this.context, subject, wspConfig);
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    protected ClusterNode createClusterNode() throws RepositoryException {
        try {
            JahiaClusterNode clusterNode = new JahiaClusterNode();
            clusterNode.init((ClusterContext)new RepositoryImpl.ExternalEventListener((RepositoryImpl)this));
            return clusterNode;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void scheduleReindexing() throws RepositoryException {
        LinkedList<JahiaSearchIndex> indexes = new LinkedList<JahiaSearchIndex>();
        JahiaSearchIndex index = (JahiaSearchIndex)this.getSystemSearchManager("default").getQueryHandler();
        if (index.prepareReindexing()) {
            indexes.add(index);
        }
        if ((index = (JahiaSearchIndex)this.getWorkspaceInfo("default").getSearchManager().getQueryHandler()).prepareReindexing()) {
            indexes.add(index);
        }
        if ((index = (JahiaSearchIndex)this.getWorkspaceInfo("live").getSearchManager().getQueryHandler()).prepareReindexing()) {
            indexes.add(index);
        }
        if (!indexes.isEmpty()) {
            JobDetail jobDetail = BackgroundJob.createJahiaJob("Re-indexing of the repository content", JahiaSearchIndex.ReindexJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put((Object)"indexes", indexes);
            try {
                ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail, true);
            }
            catch (SchedulerException e) {
                log.error("Unable to schedule background job for re-indexing", (Throwable)e);
            }
        }
    }

    public void scheduleReindexing(String workspaceName) throws RepositoryException {
        JahiaSearchIndex index = (JahiaSearchIndex)(workspaceName == null ? this.getSystemSearchManager("default") : this.getWorkspaceInfo(workspaceName).getSearchManager()).getQueryHandler();
        index.scheduleReindexing();
    }

    protected RepositoryImpl.WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new JahiaWorkspaceInfo(wspConfig);
    }

    protected NodeId getSystemExcludedNodeId() {
        return JahiaSearchIndex.SKIP_VERSION_INDEX ? RepositoryImpl.VERSION_STORAGE_NODE_ID : null;
    }

    public void reindexTree(String startNodeId, String workspaceName) throws RepositoryException, NoSuchItemStateException, IllegalArgumentException, ItemStateException, IOException {
        ((JahiaSearchIndex)this.getWorkspaceInfo(workspaceName).getSearchManager().getQueryHandler()).reindexTree(startNodeId);
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        try {
            ((JahiaSearchIndex)this.getSystemSearchManager("default").getQueryHandler()).switchReadOnlyMode(enable);
            ((JahiaSearchIndex)this.getWorkspaceInfo("default").getSearchManager().getQueryHandler()).switchReadOnlyMode(enable);
            ((JahiaSearchIndex)this.getWorkspaceInfo("live").getSearchManager().getQueryHandler()).switchReadOnlyMode(enable);
        }
        catch (RepositoryException e) {
            log.error("Failed to switch read-only mode to " + enable, (Throwable)e);
        }
    }

    @Override
    public int getReadOnlyModePriority() {
        return 0;
    }

    protected class JahiaWorkspaceInfo
    extends RepositoryImpl.WorkspaceInfo {
        private SearchManager searchMgr;

        public JahiaWorkspaceInfo(WorkspaceConfig config) {
            super((RepositoryImpl)JahiaRepositoryImpl.this, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SearchManager getSearchManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            JahiaWorkspaceInfo jahiaWorkspaceInfo = this;
            synchronized (jahiaWorkspaceInfo) {
                if (this.searchMgr == null && this.getConfig().isSearchEnabled()) {
                    this.searchMgr = new JahiaSearchManager(this.getName(), JahiaRepositoryImpl.this.context, (QueryHandlerFactory)this.getConfig(), this.getItemStateProvider(), this.getPersistenceManager(), JahiaRepositoryImpl.this.context.getRootNodeId(), JahiaRepositoryImpl.this.getSystemSearchManager(this.getName()), RepositoryImpl.SYSTEM_ROOT_NODE_ID);
                }
                return this.searchMgr;
            }
        }
    }
}

