/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.JahiaPersistenceCopier;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaRepositoryCopier {
    private static final Logger logger = LoggerFactory.getLogger(JahiaRepositoryCopier.class);
    private int batchSize;
    private RepositoryContext source;
    private RepositoryContext target;

    public JahiaRepositoryCopier(RepositoryImpl source, RepositoryImpl target, int batchSize) {
        this.source = source.getRepositoryContext();
        this.target = target.getRepositoryContext();
        this.batchSize = batchSize;
    }

    public void copy() throws RepositoryException {
        try {
            this.copyNamespaces();
            this.copyNodeTypes();
            this.copyVersionStore();
            this.copyWorkspaces();
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", (Throwable)e);
        }
    }

    private void copyNamespaces() throws RepositoryException {
        NamespaceRegistryImpl sourceRegistry = this.source.getNamespaceRegistry();
        NamespaceRegistryImpl targetRegistry = this.target.getNamespaceRegistry();
        logger.info("Copying registered namespaces");
        List<String> existing = Arrays.asList(targetRegistry.getURIs());
        for (String uri : sourceRegistry.getURIs()) {
            if (existing.contains(uri)) continue;
            targetRegistry.registerNamespace(sourceRegistry.getPrefix(uri), uri);
        }
    }

    private void copyNodeTypes() throws RepositoryException {
        NodeTypeRegistry sourceRegistry = this.source.getNodeTypeRegistry();
        NodeTypeRegistry targetRegistry = this.target.getNodeTypeRegistry();
        logger.info("Copying registered node types");
        List<Name> existing = Arrays.asList(targetRegistry.getRegisteredNodeTypes());
        ArrayList<QNodeTypeDefinition> register = new ArrayList<QNodeTypeDefinition>();
        for (Name name : sourceRegistry.getRegisteredNodeTypes()) {
            if (existing.contains(name)) continue;
            register.add(sourceRegistry.getNodeTypeDef(name));
        }
        try {
            targetRegistry.registerNodeTypes(register);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Unable to copy node types", (Throwable)e);
        }
    }

    private void copyVersionStore() throws RepositoryException {
        logger.info("Copying version histories");
        JahiaPersistenceCopier copier = new JahiaPersistenceCopier(this.source.getInternalVersionManager().getPersistenceManager(), this.target.getInternalVersionManager().getPersistenceManager(), this.target.getDataStore(), this.batchSize);
        copier.copy(RepositoryImpl.VERSION_STORAGE_NODE_ID);
        copier.copy(RepositoryImpl.ACTIVITIES_NODE_ID);
        copier.flush();
    }

    private void copyWorkspaces() throws RepositoryException {
        List<String> existing = Arrays.asList(this.target.getRepository().getWorkspaceNames());
        for (String name : this.source.getRepository().getWorkspaceNames()) {
            logger.info("Copying workspace {}", (Object)name);
            if (!existing.contains(name)) {
                logger.info("Creating workspace {}", (Object)name);
                this.target.getRepository().createWorkspace(name);
            }
            logger.info("Copy all the workspace content for workspace {}", (Object)name);
            JahiaPersistenceCopier copier = new JahiaPersistenceCopier(this.source.getRepository().getWorkspaceInfo(name).getPersistenceManager(), this.target.getRepository().getWorkspaceInfo(name).getPersistenceManager(), this.target.getDataStore(), this.batchSize);
            copier.excludeNode(RepositoryImpl.SYSTEM_ROOT_NODE_ID);
            copier.copy(RepositoryImpl.ROOT_NODE_ID);
            copier.flush();
            logger.info("Copy all the active open-scoped locks");
            LockManagerImpl sourceLockManager = this.source.getRepository().getLockManager(name);
            LockManagerImpl targetLockManager = this.target.getRepository().getLockManager(name);
            targetLockManager.copyOpenScopedLocksFrom(sourceLockManager);
        }
    }
}

