/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.core.util.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.templates.JahiaModuleAware;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class ModuleMessageSource
implements MessageSource,
JahiaModuleAware {
    private ConcurrentMap<Locale, ResourceBundle> bundles = null;
    private JahiaTemplatesPackage module;
    private boolean useCodeAsDefaultMessage;

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle;
        if (null == this.bundles) {
            this.bundles = new ConcurrentHashMap<Locale, ResourceBundle>(2);
        }
        if (null == (bundle = (ResourceBundle)this.bundles.get(locale))) {
            bundle = ResourceBundles.get(this.module, locale);
            this.bundles.put(locale, bundle);
        }
        return bundle;
    }

    private String getDefaultMessage(String code) {
        if (this.useCodeAsDefaultMessage) {
            return code;
        }
        return null;
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String fallback;
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            codes = StringUtils.EMPTY_STRING_ARRAY;
        }
        for (String code : codes) {
            String msg = Messages.get(this.getBundle(locale), code, null);
            if (msg == null) continue;
            return Messages.format(msg, locale, this.resolveArguments(locale, resolvable.getArguments()));
        }
        String defaultMessage = resolvable.getDefaultMessage();
        if (defaultMessage != null) {
            return Messages.format(defaultMessage, locale, this.resolveArguments(locale, resolvable.getArguments()));
        }
        if (codes.length > 0 && (fallback = this.getDefaultMessage(codes[0])) != null) {
            return fallback;
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        try {
            return Messages.format(this.getBundle(locale).getString(code), locale, this.resolveArguments(locale, args));
        }
        catch (MissingResourceException e) {
            throw new NoSuchMessageException(code, locale);
        }
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return Messages.getWithArgs(this.getBundle(locale), code, defaultMessage, args);
    }

    private Object[] resolveArguments(Locale locale, Object ... args) {
        if (args == null || args.length == 0 || !(args[0] instanceof MessageSourceResolvable)) {
            return args;
        }
        LinkedList<String> msgs = new LinkedList<String>();
        for (Object arg : args) {
            if (arg instanceof MessageSourceResolvable) {
                msgs.add(this.getMessage((MessageSourceResolvable)arg, locale));
                continue;
            }
            msgs.add(arg != null ? arg.toString() : null);
        }
        return msgs.toArray();
    }

    @Override
    public void setJahiaModule(JahiaTemplatesPackage module) {
        this.module = module;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }
}

