/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jahia.utils.i18n.JahiaPropertyResourceBundle;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;

public class HierarchicalResourceBundle
extends ResourceBundle {
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    private ResourceBundle bundle;
    private List<String> lookupChain;
    private Locale sourceLocale;

    HierarchicalResourceBundle(List<String> lookupChain, Locale sourceLocale) {
        this.lookupChain = lookupChain;
        this.sourceLocale = sourceLocale;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = this.lookupChain.get(0) != null ? ResourceBundles.get(this.lookupChain.get(0), this.sourceLocale) : NONEXISTENT_BUNDLE;
            }
            catch (MissingResourceException e) {
                this.bundle = NONEXISTENT_BUNDLE;
            }
        }
        return this.bundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.getBundle().getKeys();
    }

    @Override
    public Object handleGetObject(String key) {
        String value = null;
        MissingResourceException mre = null;
        ResourceBundle rb = this.getBundle();
        if (rb != NONEXISTENT_BUNDLE) {
            if (rb instanceof JahiaPropertyResourceBundle) {
                value = ((JahiaPropertyResourceBundle)rb).getStringInternal(key);
            } else {
                try {
                    value = rb.getString(key);
                }
                catch (MissingResourceException e) {
                    mre = e;
                }
            }
        }
        if (value != null) {
            return value;
        }
        if (this.lookupChain.size() > 1) {
            for (String nextBundleName : this.lookupChain.subList(1, this.lookupChain.size())) {
                ResourceBundle nextBundle = null;
                try {
                    nextBundle = ResourceBundles.get(nextBundleName, this.sourceLocale);
                }
                catch (MissingResourceException e) {
                    continue;
                }
                if (nextBundle instanceof JahiaPropertyResourceBundle) {
                    value = ((JahiaPropertyResourceBundle)nextBundle).getStringInternal(key);
                } else {
                    try {
                        value = nextBundle.getString(key);
                    }
                    catch (MissingResourceException e) {
                        mre = e;
                    }
                }
                if (value == null) continue;
                break;
            }
        }
        if (value == null) {
            throw mre != null ? mre : new MissingResourceException("Cannot find resource " + key + " for bundle " + this.lookupChain.get(0), this.lookupChain.get(0), key);
        }
        return value;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(null);
    }

    public String getFormatted(String key, String defaultValue, Object ... arguments) {
        return Messages.format(this.getString(key, defaultValue), arguments);
    }

    public String getString(String key, String defaultValue) {
        String message;
        try {
            message = this.getString(key);
        }
        catch (MissingResourceException e) {
            message = defaultValue;
        }
        return message;
    }
}

