/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.settings.SettingsBean;
import org.springframework.core.io.Resource;

public final class WebUtils {
    public static String escapePath(String path) {
        return path != null ? Text.escapePath((String)path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String path) throws IOException {
        path = path.length() > 0 && path.charAt(0) != '/' ? "/" + path : path;
        InputStream is = null;
        if (path.startsWith("/modules/")) {
            Resource r;
            String module = StringUtils.substringAfter((String)path, (String)"/modules/");
            String remainingPath = StringUtils.substringAfter((String)module, (String)"/");
            module = StringUtils.substringBefore((String)module, (String)"/");
            JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module);
            if (pack != null && (r = pack.getResource(remainingPath)) != null) {
                is = r.getInputStream();
            }
        } else {
            is = JahiaContextLoaderListener.getServletContext().getResourceAsStream(path);
        }
        String content = null;
        if (is != null) {
            try {
                content = IOUtils.toString((InputStream)is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return content;
    }

    public static String lookupResourceAsString(String ... lookupPaths) throws IOException {
        String path;
        String text = null;
        String[] arr$ = lookupPaths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (text = WebUtils.getResourceAsString(path = arr$[i$])) == null; ++i$) {
        }
        return text;
    }

    public static void setCacheHeaders(long expiresSeconds, HttpServletResponse response) {
        response.setHeader("Cache-Control", "public, max-age=" + expiresSeconds);
        response.setDateHeader("Expires", System.currentTimeMillis() + expiresSeconds * 1000L);
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, proxy-revalidate, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 295075800000L);
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, SettingsBean.getInstance().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private WebUtils() {
    }
}

