/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StringResponseWrapper
extends HttpServletResponseWrapper {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private boolean isStreamUsed;
    private boolean isWriterUsed;
    private String redirect;
    private ServletOutputStream sos = new ServletOutputStream(){

        public void write(byte[] b) throws IOException {
            StringResponseWrapper.this.bos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            StringResponseWrapper.this.bos.write(b, off, len);
        }

        public void write(int b) throws IOException {
            StringResponseWrapper.this.bos.write(b);
        }
    };
    private int status = 200;
    private StringWriter sw = new StringWriter();

    public StringResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() {
        if (this.isWriterUsed) {
            throw new IllegalStateException("The getWriter() was already called before on this object");
        }
        this.isStreamUsed = true;
        return this.sos;
    }

    public int getStatus() {
        return this.status;
    }

    public String getString() throws UnsupportedEncodingException {
        if (this.isWriterUsed) {
            return this.sw.toString();
        }
        if (this.isStreamUsed) {
            return this.bos.toString(DEFAULT_ENCODING);
        }
        return "";
    }

    public PrintWriter getWriter() {
        if (this.isStreamUsed) {
            throw new IllegalStateException("The getOutputStream() was already called before on this object");
        }
        this.isWriterUsed = true;
        return new PrintWriter(this.sw);
    }

    public void setContentType(String x) {
    }

    public void setLocale(Locale x) {
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void sendRedirect(String location) throws IOException {
        this.redirect = location;
    }

    public void flushBuffer() throws IOException {
        this.sos.flush();
        this.sw.flush();
    }
}

