/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom.email;

import java.util.Collection;
import javax.mail.Message;
import javax.mail.internet.MimeMultipart;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mail.MailEndpoint;
import org.jahia.services.mail.MailServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class JBPMMailSession
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JBPMMailSession.class);
    private MailServiceImpl mailService;
    private ProducerTemplate template;

    public boolean isEnabled() {
        return this.mailService.isEnabled();
    }

    public void setMailService(MailServiceImpl mailService) {
        this.mailService = mailService;
        this.template = mailService.getCamelContext().createProducerTemplate();
    }

    public void send(Collection<Message> emails) {
        if (this.mailService.isEnabled()) {
            for (Message email : emails) {
                try {
                    CamelContext context = this.mailService.getCamelContext();
                    MailEndpoint endpoint = (MailEndpoint)context.getEndpoint(this.mailService.getEndpointUri());
                    Exchange exchange = endpoint.createExchange(email);
                    if (email.getContent() instanceof MimeMultipart) {
                        int i;
                        MimeMultipart multipart = (MimeMultipart)email.getContent();
                        for (i = 0; i < multipart.getCount(); ++i) {
                            MimeMultipart alt;
                            Object content = multipart.getBodyPart(i).getContent();
                            if (!(content instanceof MimeMultipart) || !(alt = (MimeMultipart)content).getContentType().startsWith("multipart/alternative")) continue;
                            exchange.getIn().setBody(alt.getBodyPart(0).getDataHandler().getContent());
                            exchange.getIn().setHeader("contentType", (Object)alt.getBodyPart(0).getDataHandler().getContentType());
                            if (alt.getCount() != 2) continue;
                            exchange.getIn().setHeader("CamelMailAlternativeBody", alt.getBodyPart(1).getDataHandler().getContent());
                        }
                        for (i = 1; i < multipart.getCount(); ++i) {
                            exchange.getIn().addAttachment("part" + i, multipart.getBodyPart(i).getDataHandler());
                        }
                    }
                    this.template.send("seda:mailUsers?multipleConsumers=true", exchange);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void destroy() throws Exception {
        if (this.template != null) {
            this.template.stop();
        }
    }
}

