/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.List;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    private static transient Logger logger = LoggerFactory.getLogger(PublishWorkItemHandler.class);

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        List uuids = (List)workItem.getParameter("nodeIds");
        String workspace = (String)workItem.getParameter("workspace");
        String userKey = (String)workItem.getParameter("user");
        if (workItem.getParameter("currentUser") != null) {
            userKey = (String)workItem.getParameter("currentUser");
        }
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Publication", PublicationJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("userkey", userKey);
        jobDataMap.put((Object)"publicationInfos", (Object)uuids);
        jobDataMap.put("source", workspace);
        jobDataMap.put("destination", "live");
        jobDataMap.put("lock", "publication-process-" + workItem.getProcessInstanceId());
        jobDataMap.put("checkPermissions", false);
        try {
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobAtEndOfRequest(jobDetail);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

