/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;

public class GetTasksForUserCommand
extends BaseCommand<List<WorkflowTask>> {
    private final JahiaUser user;
    private final Locale uiLocale;

    public GetTasksForUserCommand(JahiaUser user, Locale uiLocale) {
        this.user = user;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<WorkflowTask> execute() {
        List tasksOwned = this.getTaskService().getTasksOwnedByStatus(this.user.getUserKey(), JBPM6WorkflowProvider.RESERVED_STATUS_LIST, "en");
        List potentialOwnerTasks = this.getTaskService().getTasksAssignedAsPotentialOwnerByStatus(this.user.getUserKey(), JBPM6WorkflowProvider.OPEN_STATUS_LIST_NON_RESERVED, "en");
        List businessAdministratorTasks = this.getTaskService().getTasksAssignedAsBusinessAdministrator(this.user.getUserKey(), "en");
        ArrayList<WorkflowTask> availableTasks = new ArrayList<WorkflowTask>();
        if (tasksOwned != null && tasksOwned.size() > 0) {
            availableTasks.addAll(this.convertToWorkflowTasks(this.uiLocale, tasksOwned, this.getKieSession(), this.getTaskService()));
        }
        if (potentialOwnerTasks != null && potentialOwnerTasks.size() > 0) {
            availableTasks.addAll(this.convertToWorkflowTasks(this.uiLocale, potentialOwnerTasks, this.getKieSession(), this.getTaskService()));
        }
        if (businessAdministratorTasks != null && businessAdministratorTasks.size() > 0) {
            availableTasks.addAll(this.convertToWorkflowTasks(this.uiLocale, businessAdministratorTasks, this.getKieSession(), this.getTaskService()));
        }
        return availableTasks;
    }
}

