/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jbpm.process.audit.VariableInstanceLog;

public class GetHistoryWorkflowsForPathCommand
extends BaseCommand<List<HistoryWorkflow>> {
    private final String path;
    private final Locale uiLocale;

    public GetHistoryWorkflowsForPathCommand(String path, Locale uiLocale) {
        this.path = path;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<HistoryWorkflow> execute() {
        List result = this.getEm().createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value like :variableValue").setParameter("variableId", (Object)"nodePath").setParameter("variableValue", (Object)this.path).getResultList();
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (VariableInstanceLog log : result) {
            l.add(Long.toString(log.getProcessInstanceId()));
        }
        return this.getHistoryWorkflows(l, this.uiLocale);
    }
}

