/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.query.QueryWrapper;

public class UserCacheHelper {
    private EhCacheProvider ehCacheProvider;
    private SelfPopulatingCache userPathByUserNameCache;
    private int timeToLiveForNonExistingUsers = 600;

    public String getUserPath(String name, String site) {
        String value = (String)this.getUserPathByUserNameCache().get((Serializable)new UserPathCacheKey(name, StringUtils.isEmpty((String)site) ? null : site)).getObjectValue();
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelfPopulatingCache getUserPathByUserNameCache() {
        if (this.userPathByUserNameCache == null) {
            UserCacheHelper userCacheHelper = this;
            synchronized (userCacheHelper) {
                if (this.userPathByUserNameCache == null) {
                    this.userPathByUserNameCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaUserManagerService.userPathByUserNameCache", new UserPathByUserNameCacheEntryFactory());
                }
            }
        }
        return this.userPathByUserNameCache;
    }

    private String internalGetUserPath(String name, String siteName) throws RepositoryException {
        StringBuilder q = new StringBuilder();
        q.append("SELECT [j:nodename] from [jnt:user] where localname()='").append(JCRContentUtils.sqlEncode(name)).append("' and isdescendantnode('");
        if (siteName != null) {
            q.append("/sites/").append(JCRContentUtils.sqlEncode(siteName));
        }
        q.append("/users/')");
        String p = this.queryUserPathInWorkspace(q, "live");
        if (p == null) {
            p = this.queryUserPathInWorkspace(q, null);
        }
        return p;
    }

    private String queryUserPathInWorkspace(StringBuilder q, String workspace) throws RepositoryException {
        QueryWrapper query = JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null).getWorkspace().getQueryManager().createQuery(q.toString(), "JCR-SQL2");
        query.setLimit(1L);
        RowIterator it = query.execute().getRows();
        if (!it.hasNext()) {
            return null;
        }
        return it.nextRow().getPath();
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public void setTimeToLiveForNonExistingUsers(int timeToLiveForNonExistingUsers) {
        this.timeToLiveForNonExistingUsers = timeToLiveForNonExistingUsers;
    }

    public void updateAdded(String userPath) {
        this.getUserPathByUserNameCache().put(new Element((Serializable)new UserPathCacheKey(StringUtils.substringAfterLast((String)userPath, (String)"/"), this.getSiteKey(userPath)), (Serializable)((Object)userPath)));
    }

    public void updateRemoved(String userPath) {
        this.getUserPathByUserNameCache().remove((Serializable)new UserPathCacheKey(StringUtils.substringAfterLast((String)userPath, (String)"/"), this.getSiteKey(userPath)));
    }

    private String getSiteKey(String userPath) {
        return userPath.startsWith("/sites/") ? StringUtils.substringBetween((String)userPath, (String)"/sites/", (String)"/") : null;
    }

    private static class UserPathCacheKey
    implements Serializable {
        private static final long serialVersionUID = -727853070149556455L;
        private final int hash;
        private final String site;
        private final String user;

        private UserPathCacheKey(String user, String site) {
            this.user = user;
            this.site = site;
            this.hash = this.getHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (null == other || other.getClass() != this.getClass()) {
                return false;
            }
            UserPathCacheKey otherKey = (UserPathCacheKey)other;
            return StringUtils.equals((String)this.user, (String)otherKey.user) && StringUtils.equals((String)this.site, (String)otherKey.site);
        }

        private final int getHashCode() {
            int iTotal = 17;
            iTotal = 37 * iTotal + (this.user != null ? this.user.hashCode() : 0);
            iTotal = 37 * iTotal + (this.site != null ? this.site.hashCode() : 0);
            return iTotal;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class UserPathByUserNameCacheEntryFactory
    implements CacheEntryFactory {
        private UserPathByUserNameCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            UserPathCacheKey k = (UserPathCacheKey)key;
            String path = UserCacheHelper.this.internalGetUserPath(k.user, k.site);
            if (path != null) {
                return new Element(key, (Object)path);
            }
            return new Element(key, (Object)"", 0, UserCacheHelper.this.timeToLiveForNonExistingUsers);
        }
    }
}

