/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.editmode;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.editmode.Engine;
import org.jahia.services.uicomponents.bean.editmode.EngineConfiguration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EngineTab
implements Serializable,
Comparable<EngineTab>,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = -5995531303789738603L;
    private String id;
    private String title;
    private String titleKey;
    private Visibility visibility;
    private EditEngineTabItem tabItem;
    private int order;
    private String requiredPermission;
    private Object parent;
    private Object parentEditConfiguration;
    private Object parentManagerConfiguration;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    public EngineTab() {
    }

    public EngineTab(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public EditEngineTabItem getTabItem() {
        return this.tabItem;
    }

    public void setTabItem(EditEngineTabItem item) {
        this.tabItem = item;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setParentEditConfiguration(EditConfiguration config) {
        this.parentEditConfiguration = config;
    }

    public void setParentManagerConfiguration(ManagerConfiguration config) {
        this.parentManagerConfiguration = config;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    @Override
    public int compareTo(EngineTab o) {
        return this.getOrder() - o.getOrder();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.addTab(o);
            }
        } else {
            this.addTab(this.parent);
        }
        this.addTab(this.parentManagerConfiguration);
        this.addTab(this.parentEditConfiguration);
    }

    public void destroy() throws Exception {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                EngineTab.removeTab(this.getEngineTabs(o), this.getId());
            }
        } else {
            EngineTab.removeTab(this.getEngineTabs(this.parent), this.getId());
        }
        EngineTab.removeTab(this.getEngineTabs(this.parent), this.getId());
        EngineTab.removeTab(this.getEngineTabs(this.parentEditConfiguration), this.getId());
        EngineTab.removeTab(this.getEngineTabs(this.parentManagerConfiguration), this.getId());
    }

    private void addTab(Object parent) {
        List<EngineTab> tabs = this.getEngineTabs(parent);
        if (tabs != null) {
            EngineTab.removeTab(tabs, this.getId());
            int index = -1;
            if (this.position >= 0) {
                index = this.position;
            } else if (this.positionBefore != null) {
                index = tabs.indexOf(new EngineTab(this.positionBefore));
            } else if (this.positionAfter != null) {
                index = tabs.indexOf(new EngineTab(this.positionAfter));
                if (index != -1) {
                    ++index;
                }
                if (index >= tabs.size()) {
                    index = -1;
                }
            }
            if (index != -1) {
                tabs.add(index, this);
            } else {
                tabs.add(this);
            }
        } else if (this.parent != null) {
            throw new IllegalArgumentException("Unknown parent type '" + this.parent.getClass().getName() + "'. Can accept EditConfiguration, ManagerConfiguration, Engine or" + " a String value with a beanId of the those beans");
        }
    }

    protected static void removeTab(List<EngineTab> tabs, String tabId) {
        if (tabs != null && tabId != null && tabId.length() > 0) {
            Iterator<EngineTab> iterator = tabs.iterator();
            while (iterator.hasNext()) {
                EngineTab tab = iterator.next();
                if (tab.getId() == null || !tab.getId().equals(tabId)) continue;
                iterator.remove();
            }
        }
    }

    private List<EngineTab> getEngineTabs(Object parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof String) {
            parent = SpringContextSingleton.getBean((String)parent);
        }
        List<EngineTab> tabs = null;
        if (parent instanceof EditConfiguration) {
            tabs = ((EditConfiguration)parent).getDefaultEditConfiguration().getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((EditConfiguration)parent).getDefaultEditConfiguration().setEngineTabs(tabs);
            }
        } else if (parent instanceof ManagerConfiguration) {
            tabs = ((ManagerConfiguration)parent).getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((ManagerConfiguration)parent).setEngineTabs(tabs);
            }
        } else if (parent instanceof EngineConfiguration) {
            tabs = ((EngineConfiguration)parent).getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((EngineConfiguration)parent).setEngineTabs(tabs);
            }
        } else if (parent instanceof Engine && (tabs = ((Engine)parent).getTabs()) == null) {
            tabs = new LinkedList<EngineTab>();
            ((Engine)parent).setTabs(tabs);
        }
        return tabs;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            EngineTab other = (EngineTab)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

