/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.ajax.gwt.helper.ModuleGWTResources;
import org.jahia.ajax.gwt.utils.GWTResourceConfig;
import org.jahia.bin.Action;
import org.jahia.bin.errors.ErrorHandler;
import org.jahia.bin.filters.AbstractServletFilter;
import org.jahia.bin.filters.CompositeFilter;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRWorkspaceWrapper;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRNodeDecoratorDefinition;
import org.jahia.services.content.decorator.validation.JCRNodeValidator;
import org.jahia.services.content.decorator.validation.JCRNodeValidatorDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializerService;
import org.jahia.services.content.nodetypes.initializers.ModuleChoiceListInitializer;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRendererService;
import org.jahia.services.content.nodetypes.renderer.ModuleChoiceListRenderer;
import org.jahia.services.content.rules.BackgroundAction;
import org.jahia.services.content.rules.ModuleGlobalObject;
import org.jahia.services.content.rules.RulesListener;
import org.jahia.services.pwd.PasswordDigester;
import org.jahia.services.pwd.PasswordService;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.StaticAssetMapping;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.RenderServiceAware;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.DefaultCacheKeyGenerator;
import org.jahia.services.render.webflow.BundleFlowRegistry;
import org.jahia.services.search.SearchProvider;
import org.jahia.services.search.SearchServiceImpl;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.visibility.VisibilityConditionRule;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorklowTypeRegistration;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;

public class TemplatePackageRegistry {
    private static Logger logger = LoggerFactory.getLogger(TemplatePackageRegistry.class);
    private static boolean hasEncounteredIssuesWithDefinitions = false;
    static final String TEMPLATES_SET = "templatesSet";
    public static final Comparator<JahiaTemplatesPackage> TEMPLATE_PACKAGE_COMPARATOR = new Comparator<JahiaTemplatesPackage>(){

        @Override
        public int compare(JahiaTemplatesPackage o1, JahiaTemplatesPackage o2) {
            if (o2.getModulePriority() != o1.getModulePriority()) {
                return o2.getModulePriority() - o1.getModulePriority();
            }
            if (!o1.getModuleType().equals(o2.getModuleType())) {
                if (o1.getModuleType().equals(TemplatePackageRegistry.TEMPLATES_SET)) {
                    return -99;
                }
                if (o2.getModuleType().equals(TemplatePackageRegistry.TEMPLATES_SET)) {
                    return 99;
                }
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    private Map<String, JahiaTemplatesPackage> packagesByName = new TreeMap<String, JahiaTemplatesPackage>();
    private Map<String, JahiaTemplatesPackage> packagesById = new TreeMap<String, JahiaTemplatesPackage>();
    private List<JahiaTemplatesPackage> templatePackages;
    private Map<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>> packagesWithVersionByName = new TreeMap<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>>();
    private Map<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>> packagesWithVersionById = new TreeMap<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>>();
    private Map<String, Set<JahiaTemplatesPackage>> modulesWithViewsPerComponents = new HashMap<String, Set<JahiaTemplatesPackage>>();
    private List<RenderFilter> filters = new LinkedList<RenderFilter>();
    private List<ErrorHandler> errorHandlers = new LinkedList<ErrorHandler>();
    private Map<String, Action> actions;
    private Map<String, BackgroundAction> backgroundActions;
    private List<HandlerMapping> springHandlerMappings = new ArrayList<HandlerMapping>();
    private Map<String, JahiaTemplatesPackage> packagesForResourceBundles = new HashMap<String, JahiaTemplatesPackage>();
    private boolean afterInitializeDone = false;

    public TemplatePackageRegistry() {
        this.actions = new CaseInsensitiveMap();
        this.backgroundActions = new CaseInsensitiveMap();
    }

    public Map<String, Action> getActions() {
        return this.actions;
    }

    public Map<String, BackgroundAction> getBackgroundActions() {
        return this.backgroundActions;
    }

    public List<HandlerMapping> getSpringHandlerMappings() {
        return this.springHandlerMappings;
    }

    public List<ErrorHandler> getErrorHandlers() {
        return this.errorHandlers;
    }

    public Map<String, Set<JahiaTemplatesPackage>> getModulesWithViewsPerComponents() {
        return this.modulesWithViewsPerComponents;
    }

    public void addModuleWithViewsForComponent(String component, JahiaTemplatesPackage module) {
        Set<JahiaTemplatesPackage> jahiaTemplatesPackages;
        if (this.modulesWithViewsPerComponents.containsKey(component)) {
            jahiaTemplatesPackages = this.modulesWithViewsPerComponents.get(component);
        } else {
            jahiaTemplatesPackages = new TreeSet<JahiaTemplatesPackage>(TEMPLATE_PACKAGE_COMPARATOR);
            this.modulesWithViewsPerComponents.put(component, jahiaTemplatesPackages);
        }
        jahiaTemplatesPackages.add(module);
    }

    public void removeModuleWithViewsForComponent(String component, JahiaTemplatesPackage module) {
        if (this.modulesWithViewsPerComponents.containsKey(component)) {
            Set<JahiaTemplatesPackage> jahiaTemplatesPackages = this.modulesWithViewsPerComponents.get(component);
            jahiaTemplatesPackages.remove(module);
            if (jahiaTemplatesPackages.isEmpty()) {
                this.modulesWithViewsPerComponents.remove(component);
            }
        }
    }

    private boolean computeDependencies(JahiaTemplatesPackage pack, JahiaTemplatesPackage currentPack) {
        for (String depends : currentPack.getDepends()) {
            JahiaTemplatesPackage dependentPack = this.packagesById.get(depends);
            if (dependentPack == null) {
                dependentPack = this.packagesByName.get(depends);
            }
            if (dependentPack == null) {
                return false;
            }
            if (pack.getDependencies().contains(dependentPack)) continue;
            if (!this.computeDependencies(pack, dependentPack)) {
                return false;
            }
            pack.addDependency(dependentPack);
        }
        return true;
    }

    public void afterInitializationForModules() {
        for (JahiaTemplatesPackage pack : this.packagesByName.values()) {
            this.afterInitializationForModule(pack);
        }
        this.afterInitializeDone = true;
    }

    public boolean isAfterInitializeDone() {
        return this.afterInitializeDone;
    }

    public synchronized void afterInitializationForModule(JahiaTemplatesPackage pack) {
        if (pack.getContext() != null && !pack.isServiceInitialized()) {
            int count = 0;
            Map map = pack.getContext().getBeansOfType(JahiaAfterInitializationService.class);
            for (JahiaAfterInitializationService initializationService : map.values()) {
                try {
                    initializationService.initAfterAllServicesAreStarted();
                    ++count;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (count > 0) {
                logger.info("Post-initialized {} beans implementing JahiaAfterInitializationService for module {}", (Object)count, (Object)pack.getId());
            }
            pack.setServiceInitialized(true);
        }
    }

    public boolean contains(String moduleName) {
        return this.packagesByName.containsKey(moduleName);
    }

    public boolean containsAll(List<String> moduleNames) {
        return this.packagesByName.keySet().containsAll(moduleNames);
    }

    public boolean containsId(String moduleId) {
        return this.packagesById.containsKey(moduleId);
    }

    public List<JahiaTemplatesPackage> getAvailablePackages() {
        if (null == this.templatePackages) {
            this.templatePackages = Collections.unmodifiableList(new LinkedList<JahiaTemplatesPackage>(this.packagesByName.values()));
        }
        return this.templatePackages;
    }

    public int getAvailablePackagesCount() {
        return this.packagesByName.size();
    }

    public Set<ModuleVersion> getAvailableVersionsForModule(String moduleNameOrId) {
        if (this.packagesWithVersionById.containsKey(moduleNameOrId)) {
            Set<ModuleVersion> moduleVersions = this.packagesWithVersionById.get(moduleNameOrId).keySet();
            if (moduleVersions instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)moduleVersions);
            }
            return Collections.unmodifiableSortedSet(new TreeSet<ModuleVersion>(moduleVersions));
        }
        if (this.packagesWithVersionByName.containsKey(moduleNameOrId)) {
            Set<ModuleVersion> moduleVersions = this.packagesWithVersionByName.get(moduleNameOrId).keySet();
            if (moduleVersions instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)moduleVersions);
            }
            return Collections.unmodifiableSortedSet(new TreeSet<ModuleVersion>(moduleVersions));
        }
        return Collections.emptySet();
    }

    public boolean areVersionsForModuleAvailable(String moduleNameOrId) {
        SortedMap<ModuleVersion, JahiaTemplatesPackage> m = this.packagesWithVersionById.get(moduleNameOrId);
        if (m == null) {
            m = this.packagesWithVersionByName.get(moduleNameOrId);
        }
        return m != null && !m.isEmpty();
    }

    public Map<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>> getAllModuleVersions() {
        return this.packagesWithVersionById;
    }

    public String getModuleId(String moduleNameOrId) {
        Iterator<JahiaTemplatesPackage> i$;
        if (this.packagesWithVersionById.containsKey(moduleNameOrId)) {
            return moduleNameOrId;
        }
        if (this.packagesWithVersionByName.containsKey(moduleNameOrId) && (i$ = this.packagesWithVersionByName.get(moduleNameOrId).values().iterator()).hasNext()) {
            JahiaTemplatesPackage aPackage = i$.next();
            return aPackage.getId();
        }
        return null;
    }

    public Set<String> getModuleIds() {
        return this.packagesById.keySet();
    }

    public Set<String> getModuleNames() {
        return this.packagesByName.keySet();
    }

    public Map<String, JahiaTemplatesPackage> getRegisteredModules() {
        return this.packagesById;
    }

    public List<RenderFilter> getRenderFilters() {
        return this.filters;
    }

    public final boolean hasEncounteredIssuesWithDefinitions() {
        return hasEncounteredIssuesWithDefinitions;
    }

    public JahiaTemplatesPackage lookup(String packageName) {
        if (packageName == null || this.packagesByName == null) {
            return null;
        }
        return this.packagesByName.get(packageName);
    }

    public JahiaTemplatesPackage lookupByBundle(Bundle osgiBundle) {
        if (this.packagesByName == null) {
            return null;
        }
        if (osgiBundle == null) {
            throw new IllegalArgumentException("OSGi bundle is null");
        }
        String moduleId = osgiBundle.getSymbolicName();
        String version = StringUtils.defaultIfEmpty((String)((String)osgiBundle.getHeaders().get("Implementation-Version")), (String)osgiBundle.getVersion().toString());
        return this.lookupByIdAndVersion(moduleId, new ModuleVersion(version));
    }

    public JahiaTemplatesPackage lookupByFileName(String fileName) {
        return this.lookupById(fileName);
    }

    public JahiaTemplatesPackage lookupById(String moduleId) {
        if (moduleId == null || this.packagesById == null) {
            return null;
        }
        return this.packagesById.containsKey(moduleId) ? this.packagesById.get(moduleId) : null;
    }

    public JahiaTemplatesPackage lookupByNameAndVersion(String moduleName, ModuleVersion moduleVersion) {
        if (moduleName == null || this.packagesByName == null) {
            return null;
        }
        Map packageVersions = this.packagesWithVersionByName.get(moduleName);
        if (packageVersions != null) {
            return (JahiaTemplatesPackage)packageVersions.get(moduleVersion);
        }
        return null;
    }

    public JahiaTemplatesPackage lookupByFileNameAndVersion(String fileName, ModuleVersion moduleVersion) {
        return this.lookupByIdAndVersion(fileName, moduleVersion);
    }

    public JahiaTemplatesPackage lookupByIdAndVersion(String moduleId, ModuleVersion moduleVersion) {
        if (moduleId == null || this.packagesWithVersionById == null) {
            return null;
        }
        Map packageVersions = this.packagesWithVersionById.get(moduleId);
        if (packageVersions != null) {
            return (JahiaTemplatesPackage)packageVersions.get(moduleVersion);
        }
        return null;
    }

    public void registerPackageVersion(JahiaTemplatesPackage pack) {
        JahiaTemplatesPackage jahiaTemplatesPackage;
        if (!this.packagesWithVersionById.containsKey(pack.getId())) {
            this.packagesWithVersionById.put(pack.getId(), new TreeMap());
        }
        SortedMap<ModuleVersion, JahiaTemplatesPackage> map = this.packagesWithVersionById.get(pack.getId());
        if (!this.packagesWithVersionByName.containsKey(pack.getName())) {
            this.packagesWithVersionByName.put(pack.getName(), map);
        }
        if ((jahiaTemplatesPackage = (JahiaTemplatesPackage)map.get(pack.getVersion())) == null || jahiaTemplatesPackage.getClass().equals(pack.getClass()) || !pack.getClass().equals(JahiaTemplatesPackage.class)) {
            map.put(pack.getVersion(), pack);
        }
    }

    public void unregisterPackageVersion(JahiaTemplatesPackage pack) {
        Map map = this.packagesWithVersionById.get(pack.getId());
        map.remove(pack.getVersion());
        if (map.isEmpty()) {
            this.packagesWithVersionById.remove(pack.getId());
            this.packagesWithVersionByName.remove(pack.getName());
        }
    }

    public void register(final JahiaTemplatesPackage templatePackage) {
        Resource[] rootResources;
        this.templatePackages = null;
        if (this.packagesByName.get(templatePackage.getName()) != null) {
            JahiaTemplatesPackage previousPack = this.packagesByName.get(templatePackage.getName());
            previousPack.setActiveVersion(false);
        }
        this.packagesByName.put(templatePackage.getName(), templatePackage);
        this.packagesById.put(templatePackage.getId(), templatePackage);
        this.computeDependencies(templatePackage);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    if (session.itemExists("/modules/" + templatePackage.getIdWithVersion() + "/permissions")) {
                        JahiaPrivilegeRegistry.addModulePrivileges(session, "/modules/" + templatePackage.getIdWithVersion());
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Cannot get permissions in module", (Throwable)e);
        }
        for (Resource rootResource : rootResources = templatePackage.getResources("")) {
            if (templatePackage.getResources(rootResource.getFilename()).length <= 0 || !rootResource.getFilename().contains("_")) continue;
            String key = rootResource.getFilename();
            if (!this.modulesWithViewsPerComponents.containsKey(key)) {
                this.modulesWithViewsPerComponents.put(key, new TreeSet<JahiaTemplatesPackage>(TEMPLATE_PACKAGE_COMPARATOR));
            }
            this.modulesWithViewsPerComponents.get(key).remove(templatePackage);
            this.modulesWithViewsPerComponents.get(key).add(templatePackage);
        }
        logger.info("Registered '{}' [{}] version {}", new Object[]{templatePackage.getName(), templatePackage.getId(), templatePackage.getVersion()});
    }

    public JahiaTemplatesPackage getPackageForResourceBundle(String resourceBundle) {
        return this.packagesForResourceBundles.get(resourceBundle);
    }

    public void addPackageForResourceBundle(String bundle, JahiaTemplatesPackage module) {
        this.packagesForResourceBundles.put(bundle, module);
    }

    private void computeResourceBundleHierarchy(JahiaTemplatesPackage templatePackage) {
        templatePackage.getResourceBundleHierarchy().clear();
        if (templatePackage.getResourceBundleName() != null) {
            templatePackage.getResourceBundleHierarchy().add(templatePackage.getResourceBundleName());
        }
        for (JahiaTemplatesPackage dependency : templatePackage.getDependencies()) {
            if (dependency.isDefault() || dependency.getResourceBundleName() == null) continue;
            templatePackage.getResourceBundleHierarchy().add(dependency.getResourceBundleName());
        }
        if (!templatePackage.isDefault() && this.packagesById.containsKey("default")) {
            templatePackage.getResourceBundleHierarchy().add(this.packagesById.get("default").getResourceBundleName());
            templatePackage.getResourceBundleHierarchy().add("JahiaTypesResources");
            templatePackage.getResourceBundleHierarchy().add("JahiaInternalResources");
        } else {
            templatePackage.getResourceBundleHierarchy().add("JahiaTypesResources");
            templatePackage.getResourceBundleHierarchy().add("JahiaInternalResources");
        }
        if (templatePackage.getResourceBundleName() != null) {
            this.addPackageForResourceBundle(templatePackage.getResourceBundleName(), templatePackage);
        }
    }

    public boolean computeDependencies(JahiaTemplatesPackage pack) {
        pack.resetDependencies();
        if (this.computeDependencies(pack, pack)) {
            this.computeResourceBundleHierarchy(pack);
            return true;
        }
        return false;
    }

    public List<JahiaTemplatesPackage> getDependantModules(JahiaTemplatesPackage module) {
        return this.getDependantModules(module, false);
    }

    public List<JahiaTemplatesPackage> getDependantModules(JahiaTemplatesPackage module, boolean includeNonStarted) {
        Collection<JahiaTemplatesPackage> modulesToExamine;
        ArrayList<JahiaTemplatesPackage> modules = new ArrayList<JahiaTemplatesPackage>();
        if (includeNonStarted) {
            modulesToExamine = new HashSet<JahiaTemplatesPackage>(this.packagesById.values());
            HashSet<String> nonStartedKeys = new HashSet<String>(this.packagesWithVersionById.keySet());
            nonStartedKeys.removeAll(this.packagesById.keySet());
            for (String nonStartedKey : nonStartedKeys) {
                modulesToExamine.addAll(this.packagesWithVersionById.get(nonStartedKey).values());
            }
        } else {
            modulesToExamine = this.packagesById.values();
        }
        for (JahiaTemplatesPackage aPackage : modulesToExamine) {
            if (!aPackage.getDepends().contains(module.getId()) && !aPackage.getDepends().contains(module.getName())) continue;
            modules.add(aPackage);
        }
        return modules;
    }

    public void reset() {
        for (JahiaTemplatesPackage pkg : new HashSet<JahiaTemplatesPackage>(this.packagesByName.values())) {
            this.unregister(pkg);
        }
        this.templatePackages = null;
    }

    public void unregister(JahiaTemplatesPackage templatePackage) {
        if (templatePackage.isActiveVersion()) {
            this.packagesByName.remove(templatePackage.getName());
            this.packagesById.remove(templatePackage.getId());
            this.templatePackages = null;
        }
        for (Set<JahiaTemplatesPackage> packages : this.modulesWithViewsPerComponents.values()) {
            packages.remove(templatePackage);
        }
    }

    public void resetBeanModules() {
        this.filters.clear();
        this.errorHandlers.clear();
        this.actions.clear();
        this.backgroundActions.clear();
    }

    public void handleJCREventListener(Object bean, final boolean register) {
        final DefaultEventListener eventListener = (DefaultEventListener)bean;
        if (eventListener.getEventTypes() > 0) {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, eventListener.getWorkspace(), null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRWorkspaceWrapper workspace = session.getWorkspace();
                        ObservationManager observationManager = workspace.getObservationManager();
                        EventListenerIterator registeredEventListeners = observationManager.getRegisteredEventListeners();
                        while (registeredEventListeners.hasNext()) {
                            EventListener next = registeredEventListeners.nextEventListener();
                            if (!next.getClass().equals(eventListener.getClass()) || next instanceof DefaultEventListener && !StringUtils.equals((String)((DefaultEventListener)next).getWorkspace(), (String)eventListener.getWorkspace())) continue;
                            observationManager.removeEventListener(next);
                            break;
                        }
                        if (register) {
                            observationManager.addEventListener((EventListener)eventListener, eventListener.getEventTypes(), eventListener.getPath(), eventListener.isDeep(), eventListener.getUuids(), eventListener.getNodeTypes(), false);
                        }
                        return null;
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug((register ? "Registering" : "Unregistering") + " event listener" + eventListener.getClass().getName() + " for workspace '" + eventListener.getWorkspace() + "'");
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.info("Skipping listener {} as it has no event types configured.", (Object)eventListener.getClass().getName());
        }
    }

    static class ModuleRegistry
    implements DestructionAwareBeanPostProcessor,
    ApplicationListener<ApplicationContextEvent> {
        private TemplatePackageRegistry templatePackageRegistry;
        private ChoiceListInitializerService choiceListInitializers;
        private ChoiceListRendererService choiceListRendererService;
        private RenderService renderService;
        private WorkflowService workflowService;
        private VisibilityService visibilityService;
        private Map<String, String> staticAssetMapping;
        private JCRStoreService jcrStoreService;
        private CompositeFilter compositeFilter;
        private SearchServiceImpl searchService;
        private GWTResourceConfig gwtResourceConfig;
        private boolean flushCaches;
        private PasswordService passwordService;

        ModuleRegistry() {
        }

        public void onApplicationEvent(ApplicationContextEvent event) {
            if ((event instanceof ContextClosedEvent || event instanceof ContextRefreshedEvent) && this.flushCaches) {
                CacheHelper.flushOutputCaches();
            }
        }

        public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
            JCRNodeValidatorDefinition jcrNodeValidatorDefinition;
            Map<String, Class> validators;
            JCRNodeDecoratorDefinition jcrNodeDecoratorDefinition;
            Map<String, Class> decorators;
            if (!JahiaContextLoaderListener.isRunning()) {
                return;
            }
            if (bean instanceof RenderFilter) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering RenderFilter '" + beanName + "'");
                }
                this.templatePackageRegistry.filters.remove((RenderFilter)bean);
            }
            if (bean instanceof ErrorHandler) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering ErrorHandler '" + beanName + "'");
                }
                this.templatePackageRegistry.errorHandlers.remove((ErrorHandler)bean);
            }
            if (bean instanceof Action) {
                Action action = (Action)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering Action '" + action.getName() + "' (" + beanName + ")");
                }
                this.templatePackageRegistry.actions.remove(action.getName());
            }
            if (bean instanceof ModuleChoiceListInitializer) {
                ModuleChoiceListInitializer moduleChoiceListInitializer = (ModuleChoiceListInitializer)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering ModuleChoiceListInitializer '" + moduleChoiceListInitializer.getKey() + "' (" + beanName + ")");
                }
                this.choiceListInitializers.getInitializers().remove(moduleChoiceListInitializer.getKey());
            }
            if (bean instanceof ModuleChoiceListRenderer) {
                ModuleChoiceListRenderer choiceListRenderer = (ModuleChoiceListRenderer)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering ChoiceListRenderer '" + choiceListRenderer.getKey() + "' (" + beanName + ")");
                }
                this.choiceListRendererService.getRenderers().remove(choiceListRenderer.getKey());
            }
            if (bean instanceof ModuleGlobalObject) {
                ModuleGlobalObject moduleGlobalObject = (ModuleGlobalObject)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering ModuleGlobalObject '" + beanName + "'");
                }
                if (moduleGlobalObject.getGlobalRulesObject() != null) {
                    for (RulesListener listener : RulesListener.getInstances()) {
                        for (Map.Entry<String, Object> entry : moduleGlobalObject.getGlobalRulesObject().entrySet()) {
                            listener.removeGlobalObject(entry.getKey());
                        }
                    }
                }
            }
            if (bean instanceof StaticAssetMapping) {
                StaticAssetMapping mappings = (StaticAssetMapping)bean;
                this.staticAssetMapping.keySet().removeAll(mappings.getMapping().keySet());
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering static asset mappings '" + mappings.getMapping() + "'");
                }
            }
            if (bean instanceof DefaultEventListener) {
                this.templatePackageRegistry.handleJCREventListener(bean, false);
            }
            if (bean instanceof BackgroundAction) {
                BackgroundAction backgroundAction = (BackgroundAction)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering Background Action '" + backgroundAction.getName() + "' (" + beanName + ")");
                }
                this.templatePackageRegistry.backgroundActions.remove(backgroundAction.getName());
            }
            if (bean instanceof WorklowTypeRegistration) {
                WorklowTypeRegistration registration = (WorklowTypeRegistration)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering workflow type {}", (Object)registration.getType());
                }
                this.workflowService.unregisterWorkflowType(registration);
            }
            if (bean instanceof VisibilityConditionRule) {
                VisibilityConditionRule conditionRule = (VisibilityConditionRule)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering Visibility Condition Rule '" + conditionRule.getClass().getName() + "' (" + beanName + ")");
                }
                this.visibilityService.removeCondition(conditionRule.getAssociatedNodeType());
            }
            if (bean instanceof JCRNodeDecoratorDefinition && (decorators = (jcrNodeDecoratorDefinition = (JCRNodeDecoratorDefinition)bean).getDecorators()) != null) {
                for (Map.Entry<String, Class> decorator : decorators.entrySet()) {
                    this.jcrStoreService.removeDecorator(decorator.getKey());
                }
            }
            if (bean instanceof JCRNodeValidatorDefinition && (validators = (jcrNodeValidatorDefinition = (JCRNodeValidatorDefinition)bean).getValidators()) != null) {
                for (Map.Entry<String, Class> validatorEntry : validators.entrySet()) {
                    this.jcrStoreService.removeValidator(validatorEntry.getKey());
                }
            }
            if (bean instanceof CacheKeyPartGenerator) {
                DefaultCacheKeyGenerator cacheKeyGenerator = (DefaultCacheKeyGenerator)SpringContextSingleton.getBean("cacheKeyGenerator");
                ArrayList<CacheKeyPartGenerator> l = new ArrayList<CacheKeyPartGenerator>(cacheKeyGenerator.getPartGenerators());
                l.remove(bean);
                cacheKeyGenerator.setPartGenerators(l);
                this.flushCaches = true;
            }
            if (bean instanceof HandlerMapping) {
                this.templatePackageRegistry.springHandlerMappings.remove((HandlerMapping)bean);
            }
            if (bean instanceof ProviderFactory) {
                this.jcrStoreService.removeProviderFactory(((ProviderFactory)bean).getNodeTypeName(), (ProviderFactory)bean);
            }
            if (bean instanceof FactoryBean && bean.getClass().getName().equals("org.springframework.webflow.config.FlowRegistryFactoryBean")) {
                try {
                    FlowDefinitionRegistry flowDefinitionRegistry = (FlowDefinitionRegistry)((FactoryBean)bean).getObject();
                    ((BundleFlowRegistry)((Object)SpringContextSingleton.getBean("jahiaBundleFlowRegistry"))).removeFlowRegistry(flowDefinitionRegistry);
                }
                catch (Exception e) {
                    logger.error("Cannot register webflow registry", (Throwable)e);
                }
            }
            if (bean instanceof AbstractServletFilter) {
                try {
                    this.compositeFilter.unregisterFilter((AbstractServletFilter)bean);
                }
                catch (Exception e) {
                    logger.error("Cannot register servlet filter", (Throwable)e);
                }
            }
            if (bean instanceof SearchProvider) {
                try {
                    this.searchService.unregisterSearchProvider((SearchProvider)bean);
                }
                catch (Exception e) {
                    logger.error("Cannot unregistered search provider", (Throwable)e);
                }
            }
            if (bean instanceof ModuleGWTResources) {
                try {
                    ModuleGWTResources moduleGWTResources = (ModuleGWTResources)bean;
                    if (moduleGWTResources.getCSSResources() != null) {
                        this.gwtResourceConfig.getCssStyles().removeAll(moduleGWTResources.getCSSResources());
                    }
                    if (moduleGWTResources.getJavascriptResources() != null) {
                        this.gwtResourceConfig.getJavaScripts().removeAll(moduleGWTResources.getJavascriptResources());
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot unregistered search provider", (Throwable)e);
                }
            }
            if (bean instanceof PasswordDigester) {
                this.passwordService.unregisterDigester(((PasswordDigester)bean).getId());
            }
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            JCRNodeValidatorDefinition jcrNodeValidatorDefinition;
            Map<String, Class> validators;
            JCRNodeDecoratorDefinition jcrNodeDecoratorDefinition;
            Map<String, Class> decorators;
            if (bean instanceof RenderServiceAware) {
                ((RenderServiceAware)bean).setRenderService(this.renderService);
            }
            if (bean instanceof RenderFilter) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering RenderFilter '" + beanName + "'");
                }
                if (this.templatePackageRegistry.filters.contains((RenderFilter)bean)) {
                    this.templatePackageRegistry.filters.remove((RenderFilter)bean);
                }
                this.templatePackageRegistry.filters.add((RenderFilter)bean);
            }
            if (bean instanceof ErrorHandler) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering ErrorHandler '" + beanName + "'");
                }
                if (this.templatePackageRegistry.errorHandlers.contains((ErrorHandler)bean)) {
                    this.templatePackageRegistry.errorHandlers.remove((ErrorHandler)bean);
                }
                this.templatePackageRegistry.errorHandlers.add((ErrorHandler)bean);
            }
            if (bean instanceof Action) {
                Action action = (Action)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering Action '" + action.getName() + "' (" + beanName + ")");
                }
                this.templatePackageRegistry.actions.put(action.getName(), action);
            }
            if (bean instanceof ModuleChoiceListInitializer) {
                ModuleChoiceListInitializer moduleChoiceListInitializer = (ModuleChoiceListInitializer)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering ModuleChoiceListInitializer '" + moduleChoiceListInitializer.getKey() + "' (" + beanName + ")");
                }
                this.choiceListInitializers.getInitializers().put(moduleChoiceListInitializer.getKey(), moduleChoiceListInitializer);
            }
            if (bean instanceof ModuleChoiceListRenderer) {
                ModuleChoiceListRenderer choiceListRenderer = (ModuleChoiceListRenderer)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering ChoiceListRenderer '" + choiceListRenderer.getKey() + "' (" + beanName + ")");
                }
                this.choiceListRendererService.getRenderers().put(choiceListRenderer.getKey(), choiceListRenderer);
            }
            if (bean instanceof ModuleGlobalObject) {
                ModuleGlobalObject moduleGlobalObject = (ModuleGlobalObject)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering ModuleGlobalObject '" + beanName + "'");
                }
                if (moduleGlobalObject.getGlobalRulesObject() != null) {
                    for (RulesListener listener : RulesListener.getInstances()) {
                        for (Map.Entry<String, Object> entry : moduleGlobalObject.getGlobalRulesObject().entrySet()) {
                            listener.addGlobalObject(entry.getKey(), entry.getValue());
                        }
                    }
                }
            }
            if (bean instanceof StaticAssetMapping) {
                StaticAssetMapping mappings = (StaticAssetMapping)bean;
                this.staticAssetMapping.putAll(mappings.getMapping());
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering static asset mappings '" + mappings.getMapping() + "'");
                }
            }
            if (bean instanceof DefaultEventListener) {
                this.templatePackageRegistry.handleJCREventListener(bean, true);
            }
            if (bean instanceof BackgroundAction) {
                BackgroundAction backgroundAction = (BackgroundAction)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering Background Action '" + backgroundAction.getName() + "' (" + beanName + ")");
                }
                this.templatePackageRegistry.backgroundActions.put(backgroundAction.getName(), backgroundAction);
            }
            if (bean instanceof WorklowTypeRegistration) {
                WorklowTypeRegistration registration = (WorklowTypeRegistration)bean;
                this.workflowService.registerWorkflowType(registration);
            }
            if (bean instanceof VisibilityConditionRule) {
                VisibilityConditionRule conditionRule = (VisibilityConditionRule)bean;
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering Visibility Condition Rule '" + conditionRule.getClass().getName() + "' (" + beanName + ")");
                }
                this.visibilityService.addCondition(conditionRule.getAssociatedNodeType(), conditionRule);
            }
            if (bean instanceof JCRNodeDecoratorDefinition && (decorators = (jcrNodeDecoratorDefinition = (JCRNodeDecoratorDefinition)bean).getDecorators()) != null) {
                for (Map.Entry<String, Class> decorator : decorators.entrySet()) {
                    try {
                        if (!NodeTypeRegistry.getInstance().getNodeType(decorator.getKey()).isMixin()) {
                            this.jcrStoreService.addDecorator(decorator.getKey(), decorator.getValue());
                            continue;
                        }
                        logger.error("It is impossible to decorate a mixin, only primary node type can be decorated");
                    }
                    catch (NoSuchNodeTypeException e) {
                        logger.error("Cannot register decorator for nodetype " + decorator.getKey() + " has it does not exist in the registry.", (Throwable)e);
                    }
                }
            }
            if (bean instanceof JCRNodeValidatorDefinition && (validators = (jcrNodeValidatorDefinition = (JCRNodeValidatorDefinition)bean).getValidators()) != null) {
                for (Map.Entry<String, Class> validatorEntry : validators.entrySet()) {
                    Class validatorEntryValue = validatorEntry.getValue();
                    try {
                        if (validatorEntryValue.getConstructor(JCRNodeWrapper.class) == null || !JCRNodeValidator.class.isAssignableFrom(validatorEntryValue)) continue;
                        this.jcrStoreService.addValidator(validatorEntry.getKey(), validatorEntryValue);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error("Validator must have a constructor taking only a JCRNodeWrapper has a parameter. Please add " + validatorEntryValue.getSimpleName() + "(JCRNodeWrapper node) has a constructor", (Throwable)e);
                    }
                }
            }
            if (bean instanceof CacheKeyPartGenerator) {
                DefaultCacheKeyGenerator cacheKeyGenerator = (DefaultCacheKeyGenerator)SpringContextSingleton.getBean("cacheKeyGenerator");
                ArrayList<CacheKeyPartGenerator> l = new ArrayList<CacheKeyPartGenerator>(cacheKeyGenerator.getPartGenerators());
                for (CacheKeyPartGenerator generator : cacheKeyGenerator.getPartGenerators()) {
                    if (!generator.getKey().equals(((CacheKeyPartGenerator)bean).getKey())) continue;
                    l.remove(generator);
                }
                l.add((CacheKeyPartGenerator)bean);
                cacheKeyGenerator.setPartGenerators(l);
                this.flushCaches = true;
            }
            if (bean instanceof HandlerMapping) {
                if (this.templatePackageRegistry.springHandlerMappings.contains((HandlerMapping)bean)) {
                    this.templatePackageRegistry.springHandlerMappings.remove((HandlerMapping)bean);
                }
                this.templatePackageRegistry.springHandlerMappings.add((HandlerMapping)bean);
                try {
                    logger.info("Map {}", (Object)((SimpleUrlHandlerMapping)bean).getUrlMap());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (bean instanceof ProviderFactory) {
                this.jcrStoreService.addProviderFactory(((ProviderFactory)bean).getNodeTypeName(), (ProviderFactory)bean);
            }
            if (bean instanceof FactoryBean && bean.getClass().getName().equals("org.springframework.webflow.config.FlowRegistryFactoryBean")) {
                try {
                    FlowDefinitionRegistry flowDefinitionRegistry = (FlowDefinitionRegistry)((FactoryBean)bean).getObject();
                    BundleFlowRegistry bundleFlowRegistry = (BundleFlowRegistry)((Object)SpringContextSingleton.getBean("jahiaBundleFlowRegistry"));
                    if (bundleFlowRegistry.containsFlowRegistry(flowDefinitionRegistry)) {
                        bundleFlowRegistry.removeFlowRegistry(flowDefinitionRegistry);
                    }
                    bundleFlowRegistry.addFlowRegistry(flowDefinitionRegistry);
                }
                catch (Exception e) {
                    logger.error("Cannot register webflow registry", (Throwable)e);
                }
            }
            if (bean instanceof AbstractServletFilter) {
                try {
                    if (this.compositeFilter.containsFilter((AbstractServletFilter)bean)) {
                        this.compositeFilter.unregisterFilter((AbstractServletFilter)bean);
                    }
                    this.compositeFilter.registerFilter((AbstractServletFilter)bean);
                }
                catch (Exception e) {
                    logger.error("Cannot register servlet filter", (Throwable)e);
                }
            }
            if (bean instanceof SearchProvider) {
                try {
                    SearchProvider provider = (SearchProvider)bean;
                    if (provider.isEnabled()) {
                        this.searchService.registerSearchProvider(provider);
                    } else {
                        logger.warn("Provider {} is not enabled, possibly due to licensing issues and was thus not registered.", (Object)provider.getName());
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot register search provider", (Throwable)e);
                }
            }
            if (bean instanceof ModuleGWTResources) {
                try {
                    ModuleGWTResources moduleGWTResources = (ModuleGWTResources)bean;
                    if (moduleGWTResources.getCSSResources() != null) {
                        this.gwtResourceConfig.getCssStyles().addAll(moduleGWTResources.getCSSResources());
                    }
                    if (moduleGWTResources.getJavascriptResources() != null) {
                        this.gwtResourceConfig.getJavaScripts().addAll(moduleGWTResources.getJavascriptResources());
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot register module GWT resources", (Throwable)e);
                }
            }
            if (bean instanceof PasswordDigester) {
                this.passwordService.registerDigester((PasswordDigester)bean);
            }
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public void setTemplatePackageRegistry(TemplatePackageRegistry templatePackageRegistry) {
            this.templatePackageRegistry = templatePackageRegistry;
        }

        public void setChoiceListInitializers(ChoiceListInitializerService choiceListInitializers) {
            this.choiceListInitializers = choiceListInitializers;
        }

        public void setChoiceListRendererService(ChoiceListRendererService choiceListRendererService) {
            this.choiceListRendererService = choiceListRendererService;
        }

        public void setStaticAssetMapping(Map<String, String> staticAssetMapping) {
            this.staticAssetMapping = staticAssetMapping;
        }

        public void setWorkflowService(WorkflowService workflowService) {
            this.workflowService = workflowService;
        }

        public void setVisibilityService(VisibilityService visibilityService) {
            this.visibilityService = visibilityService;
        }

        public void setRenderService(RenderService renderService) {
            this.renderService = renderService;
        }

        public void setJcrStoreService(JCRStoreService jcrStoreService) {
            this.jcrStoreService = jcrStoreService;
        }

        public void setCompositeFilter(CompositeFilter compositeFilter) {
            this.compositeFilter = compositeFilter;
        }

        public void setSearchService(SearchServiceImpl searchService) {
            this.searchService = searchService;
        }

        public void setGwtResourceConfig(GWTResourceConfig gwtResourceConfig) {
            this.gwtResourceConfig = gwtResourceConfig;
        }

        public void setPasswordService(PasswordService passwordService) {
            this.passwordService = passwordService;
        }
    }
}

