/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.ProcessHelper;

public abstract class SourceControlManagement {
    protected String executable;
    protected File rootFolder;
    private volatile Map<String, Status> statusMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> readLines(String source) throws IOException {
        List list;
        StringReader input = null;
        try {
            input = new StringReader(source);
            list = IOUtils.readLines((Reader)input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
        return list;
    }

    protected SourceControlManagement(String executable) {
        this.executable = executable;
    }

    public final void add(File file) throws IOException {
        this.add((List<File>)ImmutableList.of((Object)file));
    }

    public abstract void add(List<File> var1) throws IOException;

    protected void checkExecutionResult(ExecutionResult result) throws IOException {
        if (result.exitValue != 0 || result.out.contains("conflicts")) {
            String message = result.err;
            if (StringUtils.isBlank((String)message)) {
                message = result.out;
            }
            message = message.replace("hint:", "");
            throw new IOException(message);
        }
    }

    public boolean checkCommit() throws IOException {
        Map<String, Status> statusMap = this.createStatusMap();
        if (statusMap.values().contains((Object)Status.UNMERGED)) {
            throw new IOException("Commit : remaining conflicts need to be resolved");
        }
        return statusMap.values().contains((Object)Status.MODIFIED) || statusMap.values().contains((Object)Status.ADDED) || statusMap.values().contains((Object)Status.DELETED) || statusMap.values().contains((Object)Status.RENAMED) || statusMap.values().contains((Object)Status.COPIED) || statusMap.values().contains((Object)Status.UNMERGED);
    }

    public abstract boolean commit(String var1) throws IOException;

    protected abstract Map<String, Status> createStatusMap() throws IOException;

    protected ExecutionResult executeCommand(String command, String[] arguments) throws IOException {
        try {
            StringBuilder resultOut = new StringBuilder();
            StringBuilder resultErr = new StringBuilder();
            int res = ProcessHelper.execute(command, arguments, null, this.rootFolder, resultOut, resultErr, false);
            return new ExecutionResult(res, resultOut.toString(), resultErr.toString());
        }
        catch (Exception e) {
            throw new IOException("Failed to execute command " + command + (arguments != null ? " " + Arrays.toString(arguments) : ""), e);
        }
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Status getStatus(String path) throws IOException {
        Map<String, Status> statuses = this.getStatusMap();
        Status s = statuses.get(path);
        if (s != null) {
            return s;
        }
        if (path.indexOf(47) != -1 && statuses.values().contains((Object)Status.UNTRACKED)) {
            StringBuilder subPath = new StringBuilder(32);
            for (String segment : StringUtils.split((String)path, (char)'/')) {
                if (subPath.length() > 0) {
                    if (statuses.get(subPath.toString()) == Status.UNTRACKED) {
                        return Status.UNTRACKED;
                    }
                    subPath.append('/');
                }
                subPath.append(segment);
            }
        }
        return Status.UNMODIFIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, Status> getStatusMap() throws IOException {
        if (this.statusMap == null) {
            SourceControlManagement sourceControlManagement = this;
            synchronized (sourceControlManagement) {
                if (this.statusMap == null) {
                    this.statusMap = this.createStatusMap();
                }
            }
        }
        return this.statusMap;
    }

    public abstract String getURI() throws IOException;

    protected abstract void getFromSCM(File var1, String var2, String var3) throws IOException;

    protected abstract void sendToSCM(File var1, String var2) throws IOException;

    protected abstract void initWithWorkingDirectory(File var1) throws IOException;

    public synchronized void invalidateStatusCache() {
        this.statusMap = null;
    }

    public abstract void markConflictAsResolved(File var1) throws IOException;

    public abstract void move(File var1, File var2) throws IOException;

    public abstract void remove(File var1) throws IOException;

    public abstract String update() throws IOException;

    public abstract Map<String, String> getTagInfos(String var1) throws IOException;

    public abstract Map<String, String> getBranchInfos(String var1) throws IOException;

    public static enum Status {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        RENAMED,
        UNMERGED,
        UNMODIFIED,
        UNTRACKED;

    }

    protected static class ExecutionResult {
        protected String err;
        protected int exitValue;
        protected String out;

        protected ExecutionResult(int exitValue, String out, String err) {
            this.exitValue = exitValue;
            this.out = out;
            this.err = err;
        }
    }
}

