/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.DocumentException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.templates.ScmUnavailableModuleIdException;
import org.jahia.services.templates.ScmWrongVersionException;
import org.jahia.services.templates.SourceControlFactory;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PomUtils;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class SourceControlHelper {
    private static final Logger logger = LoggerFactory.getLogger(SourceControlHelper.class);
    private static final NameFileFilter POM_XML_FILE_FILTER = new NameFileFilter("pom.xml");
    private SourceControlFactory sourceControlFactory;
    private TemplatePackageRegistry templatePackageRegistry;

    public JCRNodeWrapper checkoutModule(File moduleSources, String scmURI, String branchOrTag, String moduleId, String version, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        boolean newModule = moduleSources == null;
        File sources = this.ensureModuleSourceFolder(moduleSources);
        try {
            JahiaTemplatesPackage pack;
            SourceControlManagement scm = this.sourceControlFactory.checkoutRepository(sources, scmURI, branchOrTag, false);
            ModuleInfo moduleInfo = this.getModuleInfo(sources, scmURI, moduleId, version, branchOrTag);
            if (this.templatePackageRegistry.containsId(moduleInfo.id) && !moduleInfo.groupId.equals(this.templatePackageRegistry.lookupById(moduleInfo.id).getGroupId())) {
                FileUtils.deleteDirectory((File)sources);
                throw new ScmUnavailableModuleIdException("Cannot checkout module " + moduleInfo.id + " because another module with the same artifactId exists", moduleInfo.id);
            }
            if (version != null && !version.equals(moduleInfo.version)) {
                FileUtils.deleteDirectory((File)sources);
                throw new ScmWrongVersionException("Sources don't match module version");
            }
            if (newModule) {
                File newPath = new File(sources.getParentFile(), moduleInfo.id + "_" + moduleInfo.version);
                int i = 0;
                while (newPath.exists()) {
                    newPath = new File(sources.getParentFile(), moduleInfo.id + "_" + moduleInfo.version + "_" + ++i);
                }
                FileUtils.moveDirectory((File)sources, (File)newPath);
                moduleInfo.path = new File(moduleInfo.path.getPath().replace(sources.getPath(), newPath.getPath()));
                sources = newPath;
                scm = this.sourceControlFactory.getSourceControlManagement(moduleInfo.path);
            }
            if (sources.equals(moduleInfo.path)) {
                this.setSCMConfigInPom(sources, scmURI);
            }
            if ((pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().compileAndDeploy(moduleInfo.id, moduleInfo.path, session)) != null) {
                JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
                pack.setSourceControl(scm);
                this.setSourcesFolderInPackageAndNode(pack, moduleInfo.path, node);
                session.save();
                ResourceBundles.flushCache();
                NodeTypeRegistry.getInstance().flushLabels();
                return node;
            }
            FileUtils.deleteDirectory((File)sources);
        }
        catch (BundleException e) {
            FileUtils.deleteQuietly((File)sources);
            throw e;
        }
        catch (RepositoryException e) {
            FileUtils.deleteQuietly((File)sources);
            throw e;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)sources);
            throw e;
        }
        catch (DocumentException e) {
            FileUtils.deleteQuietly((File)sources);
            throw new IOException(e);
        }
        catch (XmlPullParserException e) {
            FileUtils.deleteQuietly((File)sources);
            throw new IOException(e);
        }
        return null;
    }

    public File checkoutTmpModule(String moduleId, String version, String scmURI, String branchOrTag) throws IOException, XmlPullParserException, DocumentException, RepositoryException {
        File sources = this.ensureModuleSourceFolder(null);
        this.sourceControlFactory.checkoutRepository(sources, scmURI, branchOrTag, false);
        ModuleInfo moduleInfo = this.getModuleInfo(sources, scmURI, moduleId, version, branchOrTag);
        if (version != null && !version.equals(moduleInfo.version)) {
            FileUtils.deleteDirectory((File)sources);
            throw new ScmWrongVersionException("Sources don't match module version");
        }
        return moduleInfo.path;
    }

    public boolean checkValidSources(JahiaTemplatesPackage pack, File sources) {
        if (!SettingsBean.getInstance().isDevelopmentMode()) {
            return false;
        }
        if (!new File(sources, "src/main/resources").exists() && !new File(sources, "src/main/webapp").exists()) {
            return false;
        }
        File pom = new File(sources, "pom.xml");
        if (pom.exists()) {
            try {
                String sourceVersion = PomUtils.getVersion(pom);
                if (sourceVersion != null && sourceVersion.equals(pack.getVersion().toString())) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.error("Cannot parse pom.xml file at " + pom, (Throwable)e);
            }
        }
        return false;
    }

    private File ensureModuleSourceFolder(File moduleSources) throws IOException {
        File sources = moduleSources;
        if (sources == null) {
            sources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath(), UUID.randomUUID().toString());
        }
        if (sources.exists()) {
            throw new IOException("Sources folder " + sources + " already exist");
        }
        if (!sources.getParentFile().exists() && !sources.getParentFile().mkdirs()) {
            throw new IOException("Unable to create sources folder at: " + sources);
        }
        return sources;
    }

    private ModuleInfo getModuleInfo(File sources, String scmURI, String moduleId, String version, String branchOrTag) throws IOException, DocumentException, XmlPullParserException {
        ModuleInfo info = new ModuleInfo();
        info.id = moduleId;
        info.path = sources;
        info.version = version;
        Model pom = null;
        if (!StringUtils.isEmpty((String)moduleId)) {
            Collection files = FileUtils.listFiles((File)sources, (IOFileFilter)POM_XML_FILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : files) {
                Model modulePom = PomUtils.read(file);
                if (!moduleId.equals(modulePom.getArtifactId())) continue;
                pom = modulePom;
                info.path = file.getParentFile();
                break;
            }
        } else {
            pom = PomUtils.read(new File(sources, "pom.xml"));
        }
        if (pom != null) {
            info.id = pom.getArtifactId();
            info.groupId = pom.getGroupId();
            info.version = pom.getVersion();
            Parent parent = pom.getParent();
            if (parent != null) {
                String v = parent.getVersion();
                if (info.version == null) {
                    info.version = v;
                }
                if (info.groupId == null) {
                    info.groupId = parent.getGroupId();
                }
            }
        } else {
            FileUtils.deleteQuietly((File)sources);
            String msg = Messages.getInternalWithArguments("source.not.found.with.uri", LocaleContextHolder.getLocale(), moduleId, StringUtils.defaultIfEmpty((String)version, (String)""), scmURI, StringUtils.defaultIfEmpty((String)branchOrTag, (String)""));
            logger.error(msg);
            throw new IOException(msg);
        }
        return info;
    }

    public SourceControlFactory getSourceControlFactory() {
        return this.sourceControlFactory;
    }

    public File getSources(JahiaTemplatesPackage pack, JCRSessionWrapper session) throws RepositoryException {
        File sources;
        JCRNodeWrapper vi;
        if (pack.getSourcesFolder() != null) {
            return pack.getSourcesFolder();
        }
        JCRNodeWrapper n = session.getNode("/modules/" + pack.getIdWithVersion());
        if (n.hasNode("j:versionInfo") && (vi = n.getNode("j:versionInfo")).hasProperty("j:sourcesFolder") && this.checkValidSources(pack, sources = new File(vi.getProperty("j:sourcesFolder").getString()))) {
            pack.setSourcesFolder(sources);
            return sources;
        }
        return null;
    }

    public void sendToSourceControl(String moduleId, String scmURI, String scmType, JCRSessionWrapper session) throws RepositoryException, IOException {
        JahiaTemplatesPackage pack = this.templatePackageRegistry.lookupById(moduleId);
        String fullUri = "scm:" + scmType + ":" + scmURI;
        File sources = this.getSources(pack, session);
        SourceControlManagement scm = this.sourceControlFactory.checkoutRepository(sources, fullUri, null, true);
        pack.setSourceControl(scm);
        this.setSCMConfigInPom(sources, fullUri);
        JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
        this.setSourcesFolderInPackageAndNode(pack, sources, node);
        session.save();
        scm.add(new File(sources, "pom.xml"));
        scm.commit("Initial commit");
    }

    public Map<String, String> listTags(String scmURI) throws IOException {
        return this.sourceControlFactory.listTags(scmURI);
    }

    public Map<String, String> listBranches(String scmURI) throws IOException {
        return this.sourceControlFactory.listBranches(scmURI);
    }

    public String guessBranchOrTag(String moduleVersion, String scm, Set<String> branchOrTags) {
        Object[] splitVersion = StringUtils.split((String)StringUtils.removeEnd((String)moduleVersion, (String)"-SNAPSHOT"), (String)".");
        if (moduleVersion.endsWith("-SNAPSHOT")) {
            String branch;
            if (splitVersion.length >= 3 && branchOrTags.contains(branch = String.format("JAHIA-%s-%s-%s-X-BRANCH", splitVersion))) {
                return branch;
            }
            if (splitVersion.length >= 2 && branchOrTags.contains(branch = String.format("JAHIA-%s-%s-X-X-BRANCH", splitVersion))) {
                return branch;
            }
            if (splitVersion.length >= 1 && branchOrTags.contains(branch = (String)splitVersion[0] + "_x")) {
                return branch;
            }
            if ("svn".equals(scm) ? branchOrTags.contains(branch = "trunk") : "git".equals(scm) && branchOrTags.contains(branch = "master")) {
                return branch;
            }
        } else {
            String tag = StringUtils.join((Object[])splitVersion, (char)'_');
            if (branchOrTags.contains(tag)) {
                return tag;
            }
            tag = "JAHIA_" + tag;
            if (branchOrTags.contains(tag)) {
                return tag;
            }
        }
        return null;
    }

    private void setSCMConfigInPom(File sources, String uri) {
        try {
            PomUtils.updateScm(new File(sources, "pom.xml"), uri);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setSourceControlFactory(SourceControlFactory sourceControlFactory) {
        this.sourceControlFactory = sourceControlFactory;
    }

    public void setSourcesFolderInPackage(JahiaTemplatesPackage pack, File sources) {
        if (this.checkValidSources(pack, sources)) {
            pack.setSourcesFolder(sources);
            try {
                SourceControlManagement sourceControlManagement = this.sourceControlFactory.getSourceControlManagement(sources);
                if (sourceControlManagement != null) {
                    pack.setSourceControl(sourceControlManagement);
                }
            }
            catch (Exception e) {
                logger.error("Cannot get source control", (Throwable)e);
            }
        }
    }

    public void setSourcesFolderInPackageAndNode(JahiaTemplatesPackage pack, File sources, JCRNodeWrapper node) throws RepositoryException {
        this.setSourcesFolderInPackage(pack, sources);
        if (pack.getSourcesFolder() != null) {
            node.getNode("j:versionInfo").setProperty("j:sourcesFolder", pack.getSourcesFolder().getPath());
            if (pack.getSourceControl() != null) {
                try {
                    node.getNode("j:versionInfo").setProperty("j:scmURI", pack.getSourceControl().getURI());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry registry) {
        this.templatePackageRegistry = registry;
    }

    private static class ModuleInfo {
        String id;
        String groupId;
        File path;
        String version;

        private ModuleInfo() {
        }
    }
}

