/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.sites;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JahiaSitesService
extends JahiaService {
    private static final String AUTHORIZED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789.-";
    private static Logger logger = LoggerFactory.getLogger(JahiaSitesService.class);
    private static final String[] TRANSLATOR_NODES_PATTERN = new String[]{"translator-*"};
    public static final String SYSTEM_SITE_KEY = "systemsite";
    public static final String SITES_JCR_PATH = "/sites";
    protected JahiaGroupManagerService groupService;
    protected JCRSessionFactory sessionFactory;
    protected EhCacheProvider ehCacheProvider;
    private SelfPopulatingCache siteKeyByServerNameCache;
    private SelfPopulatingCache siteDefaultLanguageBySiteKey;
    private SelfPopulatingCache sitesListCache;

    public synchronized void setGroupService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private JahiaSitesService() {
    }

    public static JahiaSitesService getInstance() {
        return Holder.INSTANCE;
    }

    public List<String> getSitesNames() {
        return (List)this.getSitesListCache().get((Serializable)((Object)"/")).getObjectValue();
    }

    private SelfPopulatingCache getSitesListCache() {
        if (this.sitesListCache == null) {
            this.sitesListCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.sitesListCache", new CacheEntryFactory(){

                public Object createEntry(Object o) throws Exception {
                    ArrayList<String> sites = new ArrayList<String>();
                    for (JCRSiteNode jcrSiteNode : JahiaSitesService.this.getSitesNodeList(JahiaSitesService.this.sessionFactory.getCurrentSystemSession("live", null, null))) {
                        sites.add(jcrSiteNode.getName());
                    }
                    return sites;
                }
            });
        }
        return this.sitesListCache;
    }

    public List<JCRSiteNode> getSitesNodeList() throws RepositoryException {
        return this.getSitesNodeList(this.getUserSession());
    }

    public List<JCRSiteNode> getSitesNodeList(JCRSessionWrapper session) throws RepositoryException {
        ArrayList<JCRSiteNode> list = new ArrayList<JCRSiteNode>();
        JCRNodeIteratorWrapper ni = session.getNode(SITES_JCR_PATH).getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)ni.next();
            if (!nodeWrapper.isNodeType("jnt:virtualsite")) continue;
            JCRSiteNode siteNode = (JCRSiteNode)nodeWrapper;
            list.add(siteNode);
        }
        return list;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() {
    }

    public JahiaSite getSiteByKey(String siteKey) throws JahiaException {
        if (StringUtils.isEmpty((String)siteKey)) {
            return null;
        }
        JCRSiteNode site = null;
        try {
            site = this.getSiteByKey(siteKey, this.getUserSession());
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    private JCRSessionWrapper getUserSession() throws RepositoryException {
        return this.sessionFactory.getCurrentUserSession("live");
    }

    public JCRSiteNode getSiteByKey(String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return (JCRSiteNode)session.getNode("/sites/" + siteKey);
    }

    public boolean siteExists(String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return StringUtils.isNotEmpty((String)siteKey) && session.nodeExists("/sites/" + siteKey);
    }

    public JahiaSite getSiteByServerName(String serverName) throws JahiaException {
        if (serverName == null) {
            return null;
        }
        JCRSiteNode site = null;
        try {
            site = this.getSiteByServerName(serverName, this.getUserSession());
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    public JCRSiteNode getSiteByServerName(String serverName, JCRSessionWrapper session) throws RepositoryException {
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:virtualsite] as s where lower(s.[j:serverName])='" + JCRContentUtils.sqlEncode(StringUtils.lowerCase((String)serverName)) + "' and ischildnode(s, '/sites/')", "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        if (ni.hasNext()) {
            return (JCRSiteNode)ni.next();
        }
        return null;
    }

    public String getSitenameByServerName(String serverName) throws JahiaException {
        if (serverName == null) {
            return null;
        }
        String siteName = this.getSiteKeyByServerNameCache().get((Serializable)((Object)serverName)).getObjectValue().toString();
        return "".equals(siteName) ? null : siteName;
    }

    private SelfPopulatingCache getSiteKeyByServerNameCache() {
        if (this.siteKeyByServerNameCache == null) {
            this.siteKeyByServerNameCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.siteKeyByServerNameCache", new SiteKeyByServerNameCacheEntryFactory());
        }
        return this.siteKeyByServerNameCache;
    }

    public JahiaSite getSite(String name) throws JahiaException {
        return this.getSiteByServerName(name);
    }

    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease) throws JahiaException, IOException {
        return this.addSite(currentUser, title, serverName, siteKey, descr, selectedLocale, selectTmplSet, null, firstImport, fileImport, fileImportName, asAJob, doImportServerPermissions, originatingJahiaRelease, null, null);
    }

    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String[] modulesToDeploy, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease) throws JahiaException, IOException {
        return this.addSite(currentUser, title, serverName, siteKey, descr, selectedLocale, selectTmplSet, modulesToDeploy, firstImport, fileImport, fileImportName, asAJob, doImportServerPermissions, originatingJahiaRelease, null, null);
    }

    public JahiaSite addSite(final JahiaUser currentUser, final String title, final String serverName, final String siteKey, final String descr, final Locale selectedLocale, final String selectTmplSet, final String[] modulesToDeploy, final String firstImport, final Resource fileImport, final String fileImportName, final Boolean asAJob, final Boolean doImportServerPermissions, final String originatingJahiaRelease, final Resource legacyMappingFilePath, final Resource legacyDefinitionsFilePath) throws JahiaException, IOException {
        JahiaSite site = null;
        final ArrayList errors = new ArrayList(1);
        try {
            site = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<JahiaSite>(){

                @Override
                public JahiaSite doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        session.getPathMapping().putAll(JCRSessionFactory.getInstance().getCurrentUserSession().getPathMapping());
                        return JahiaSitesService.this.addSite(currentUser, title, serverName, siteKey, descr, selectedLocale, selectTmplSet, modulesToDeploy, firstImport, fileImport, fileImportName, asAJob, doImportServerPermissions, originatingJahiaRelease, legacyMappingFilePath, legacyDefinitionsFilePath, session);
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                    catch (JahiaException e) {
                        errors.add(e);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new JahiaException("", "", 0, 0, e);
        }
        if (!errors.isEmpty()) {
            Exception e = (Exception)errors.get(0);
            if (e instanceof JahiaException) {
                throw (JahiaException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new JahiaException("", "", 0, 0, e);
        }
        return site;
    }

    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String[] modulesToDeploy, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session) throws JahiaException, IOException {
        boolean importingSystemSite = false;
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        JCRSiteNode site = null;
        try {
            if (!this.siteExists(siteKey, session)) {
                JahiaTemplatesPackage templateSet = templateService.getAnyDeployedTemplatePackage(selectTmplSet);
                String templatePackage = templateSet.getId();
                JCRNodeWrapper sitesFolder = session.getNode(SITES_JCR_PATH);
                try {
                    sitesFolder.getNode(siteKey);
                    throw new IOException("site already exists");
                }
                catch (PathNotFoundException e) {
                    JCRNodeWrapper siteNode = sitesFolder.addNode(siteKey, "jnt:virtualsite");
                    if (sitesFolder.hasProperty("j:virtualsitesFolderSkeleton")) {
                        String skeletons = sitesFolder.getProperty("j:virtualsitesFolderSkeleton").getString();
                        try {
                            JCRContentUtils.importSkeletons(skeletons, sitesFolder.getPath() + "/" + siteKey, session);
                        }
                        catch (Exception importEx) {
                            logger.error("Unable to import data using site skeleton " + skeletons, (Throwable)importEx);
                        }
                    }
                    siteNode.setProperty("j:title", title);
                    siteNode.setProperty("j:description", descr);
                    siteNode.setProperty("j:serverName", serverName);
                    siteNode.setProperty("j:defaultLanguage", selectedLocale.toString());
                    siteNode.setProperty("j:mixLanguage", false);
                    siteNode.setProperty("j:languages", new String[]{selectedLocale.toString()});
                    siteNode.setProperty("j:inactiveLiveLanguages", new String[0]);
                    siteNode.setProperty("j:inactiveLanguages", new String[0]);
                    siteNode.setProperty("j:mandatoryLanguages", new String[0]);
                    siteNode.setProperty("j:templatesSet", templatePackage);
                    siteNode.setProperty("j:installedModules", new Value[]{session.getValueFactory().createValue(templatePackage)});
                    String target = this.getTargetString(siteKey);
                    this.deployModules(target, modulesToDeploy, templateSet, session, templateService);
                    List<JahiaTemplatesPackage> availableTemplatePackages = templateService.getAvailableTemplatePackages();
                    for (JahiaTemplatesPackage availableTemplatePackage : availableTemplatePackages) {
                        String autoDeployOnSite = availableTemplatePackage.getAutoDeployOnSite();
                        if (autoDeployOnSite == null || !"all".equals(autoDeployOnSite) && !siteKey.equals(autoDeployOnSite)) continue;
                        String source = "/modules/" + availableTemplatePackage.getId();
                        try {
                            logger.info("Deploying module {} to {}", (Object)source, (Object)target);
                            templateService.installModule(availableTemplatePackage, target, session);
                        }
                        catch (RepositoryException re) {
                            logger.error("Unable to deploy module " + source + " to " + target + ". Cause: " + re.getMessage(), (Throwable)re);
                        }
                    }
                    site = (JCRSiteNode)siteNode;
                    session.save();
                }
            } else if (siteKey.equals(SYSTEM_SITE_KEY)) {
                site = (JCRSiteNode)this.getSiteByKey(SYSTEM_SITE_KEY);
                importingSystemSite = true;
            } else {
                throw new IOException("site already exists");
            }
            JCRSiteNode siteNode = (JCRSiteNode)session.getNode(site.getPath());
            if (!site.isDefault() && !site.getSiteKey().equals(SYSTEM_SITE_KEY) && this.getNbSites() == 2) {
                this.setDefaultSite(site, session);
            }
            if (!importingSystemSite) {
                JCRGroupNode sitePrivGroup;
                JCRGroupNode adminGroup;
                JahiaGroupManagerService jgms = ServicesRegistry.getInstance().getJahiaGroupManagerService();
                siteNode.setMixLanguagesActive(false);
                session.save();
                JCRGroupNode privGroup = jgms.lookupGroup(null, "privileged", session);
                if (privGroup == null) {
                    privGroup = jgms.createGroup(null, "privileged", null, true, session);
                }
                if ((adminGroup = jgms.lookupGroup(site.getSiteKey(), "site-administrators", session)) == null) {
                    adminGroup = jgms.createGroup(site.getSiteKey(), "site-administrators", null, false, session);
                }
                if (currentUser != null) {
                    adminGroup.addMember(session.getNode(currentUser.getLocalPath()));
                }
                if ((sitePrivGroup = jgms.lookupGroup(site.getSiteKey(), "site-privileged", session)) == null) {
                    sitePrivGroup = jgms.createGroup(site.getSiteKey(), "site-privileged", null, false, session);
                }
                privGroup.addMember(sitePrivGroup);
                if (!siteKey.equals(SYSTEM_SITE_KEY)) {
                    siteNode.grantRoles("g:site-privileged", Collections.singleton("privileged"));
                    siteNode.denyRoles("g:privileged", Collections.singleton("privileged"));
                }
                siteNode.grantRoles("g:site-administrators", Collections.singleton("site-administrator"));
                session.save();
            }
            Resource initialZip = null;
            if ("fileImport".equals(firstImport)) {
                initialZip = fileImport;
            }
            if ("importRepositoryFile".equals(firstImport) || initialZip != null && initialZip.exists() && !"noImport".equals(firstImport)) {
                try {
                    HashMap<Object, Object> importInfos = new HashMap<Object, Object>();
                    importInfos.put("originatingJahiaRelease", originatingJahiaRelease);
                    ServicesRegistry.getInstance().getImportExportService().importSiteZip(initialZip, site, importInfos, legacyMappingFilePath, legacyDefinitionsFilePath, session);
                }
                catch (RepositoryException e) {
                    logger.warn("Error importing site ZIP", (Throwable)e);
                }
            }
            logger.debug("Site updated with Home Page");
        }
        catch (RepositoryException e) {
            logger.warn("Error adding home node", (Throwable)e);
        }
        return site;
    }

    private String getTargetString(String siteKey) {
        return "/sites/" + siteKey;
    }

    public void deployModules(JahiaSite site, String[] modulesToDeploy, JCRSessionWrapper session) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        this.deployModules(this.getTargetString(site.getSiteKey()), modulesToDeploy, templateService.getAnyDeployedTemplatePackage(site.getTemplatePackageName()), session, templateService);
    }

    public void updateModules(JahiaSite site, List<String> newModuleIds, JCRSessionWrapper session) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        List<String> installedModules = site.getInstalledModules();
        LinkedList<String> modulesToUninstall = new LinkedList<String>(installedModules);
        modulesToUninstall.removeAll(newModuleIds);
        modulesToUninstall.remove("default");
        modulesToUninstall.remove(((JCRSiteNode)site).getTemplatePackage().getId());
        String siteKey = site.getSiteKey();
        for (JahiaTemplatesPackage availableTemplatePackage : templateService.getAvailableTemplatePackages()) {
            String autoDeployOnSite = availableTemplatePackage.getAutoDeployOnSite();
            if (autoDeployOnSite == null || !"all".equals(autoDeployOnSite) && !siteKey.equals(autoDeployOnSite)) continue;
            modulesToUninstall.remove(availableTemplatePackage.getId());
        }
        if (!modulesToUninstall.isEmpty()) {
            List<JahiaTemplatesPackage> uninstalledModules = this.moduleIdsToTemplatesPackage(modulesToUninstall, templateService);
            try {
                logger.info("Uninstalling modules " + uninstalledModules + " from " + siteKey);
                templateService.uninstallModules(uninstalledModules, site.getJCRLocalPath(), session);
            }
            catch (RepositoryException re) {
                logger.error("Unable to uninstall modules " + uninstalledModules + " from " + siteKey + ". Cause: " + re.getMessage(), (Throwable)re);
            }
        }
        LinkedList<String> modulesToInstall = new LinkedList<String>(newModuleIds);
        modulesToInstall.removeAll(installedModules);
        if (!modulesToInstall.isEmpty()) {
            List<JahiaTemplatesPackage> toInstallModules = this.moduleIdsToTemplatesPackage(modulesToInstall, templateService);
            try {
                logger.info("Installing modules " + toInstallModules + " to " + siteKey);
                templateService.installModules(toInstallModules, site.getJCRLocalPath(), session);
            }
            catch (RepositoryException re) {
                logger.error("Unable to install modules " + toInstallModules + " to " + siteKey + ". Cause: " + re.getMessage(), (Throwable)re);
            }
        }
    }

    private void deployModules(String target, String[] modulesToDeploy, JahiaTemplatesPackage templateSet, JCRSessionWrapper session, JahiaTemplateManagerService templateService) {
        List<JahiaTemplatesPackage> modules = this.moduleIdsToTemplatesPackage(modulesToDeploy != null ? Arrays.asList(modulesToDeploy) : Collections.emptyList(), templateService);
        modules.add(templateService.getAnyDeployedTemplatePackage("default"));
        modules.add(templateSet);
        try {
            logger.info("Deploying modules {} to {}", (Object)modules.toString(), (Object)target);
            templateService.installModules(modules, target, session);
        }
        catch (RepositoryException re) {
            logger.error("Unable to deploy modules " + modules.toString() + " to " + target + ". Cause: " + re.getMessage(), (Throwable)re);
        }
    }

    private List<JahiaTemplatesPackage> moduleIdsToTemplatesPackage(List<String> modules, JahiaTemplateManagerService templateService) {
        if (modules != null) {
            ArrayList<JahiaTemplatesPackage> packages = new ArrayList<JahiaTemplatesPackage>(2 + modules.size());
            for (String s : modules) {
                JahiaTemplatesPackage packageByFileName = templateService.getAnyDeployedTemplatePackage(s);
                if (packages.contains(packageByFileName)) continue;
                packages.add(packageByFileName);
            }
            return packages;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSite(final JahiaSite site) throws JahiaException {
        String siteKey = null;
        String serverName = null;
        try {
            siteKey = site.getSiteKey();
            serverName = site.getServerName();
            final String key = siteKey;
            JCRCallback<Boolean> deleteCallback = new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRPropertyWrapper defaultSite;
                    JCRNodeWrapper sites = session.getNode(JahiaSitesService.SITES_JCR_PATH);
                    if (!sites.isCheckedOut()) {
                        session.checkout(sites);
                    }
                    JCRNodeWrapper site1 = sites.getNode(key);
                    if (sites.hasProperty("j:defaultSite") && (defaultSite = sites.getProperty("j:defaultSite")).getValue().getString().equals(site1.getIdentifier())) {
                        defaultSite.remove();
                    }
                    site1.remove();
                    session.save();
                    return true;
                }
            };
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (String groupPath : JahiaSitesService.this.groupService.getGroupList(key)) {
                        if (!StringUtils.startsWith((String)groupPath, (String)(site.getJCRLocalPath() + "/groups/")) || StringUtils.startsWith((String)groupPath, (String)(site.getJCRLocalPath() + "/groups/providers/"))) continue;
                        JahiaSitesService.this.groupService.deleteGroup(groupPath, session);
                    }
                    session.save();
                    return true;
                }
            });
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, deleteCallback);
            JCRTemplate.getInstance().doExecuteWithSystemSession(deleteCallback);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.invalidateCache(siteKey, serverName);
        }
    }

    public synchronized void updateSystemSitePermissions(final JahiaSite site) throws JahiaException {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JahiaSitesService.this.updateSystemSitePermissions(site, session);
                    session.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSystemSitePermissions(JahiaSite site, JCRSessionWrapper session) throws RepositoryException {
        JCRSiteNode siteNode;
        JCRNodeWrapper sites = session.getNode(SITES_JCR_PATH);
        if (!sites.isCheckedOut()) {
            session.checkout(sites);
        }
        if (!(siteNode = (JCRSiteNode)site).isCheckedOut()) {
            session.checkout(siteNode);
        }
        if (siteNode.getName().equals(SYSTEM_SITE_KEY)) {
            boolean update = this.updateWorkspacePermissions(session, "default", site);
            if (update |= this.updateWorkspacePermissions(session, "live", site)) {
                JahiaPrivilegeRegistry.init(session);
            }
            this.updateTranslatorRoles(session, site);
        }
    }

    public int getNbSites() throws JahiaException {
        try {
            return this.getSitesNodeList().size();
        }
        catch (RepositoryException e) {
            return 0;
        }
    }

    public JahiaSite getDefaultSite() {
        JahiaSite site = null;
        try {
            site = this.getDefaultSite(this.getUserSession());
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    public JahiaSite getDefaultSite(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = session.getNode(SITES_JCR_PATH);
        if (node.hasProperty("j:defaultSite")) {
            try {
                return (JCRSiteNode)node.getProperty("j:defaultSite").getNode();
            }
            catch (RepositoryException e) {
                List<JCRSiteNode> sitesNodeList = this.getSitesNodeList(session);
                for (JCRSiteNode jcrSiteNode : sitesNodeList) {
                    if (SYSTEM_SITE_KEY.equals(jcrSiteNode.getSiteKey())) continue;
                    return jcrSiteNode;
                }
            }
        }
        return null;
    }

    public void setDefaultSite(final JahiaSite site) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JahiaSitesService.this.setDefaultSite(site, session);
                    session.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("cannot set default site", (Throwable)e);
        }
    }

    public void setDefaultSite(JahiaSite site, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = session.getNode(SITES_JCR_PATH);
        if (!node.isCheckedOut()) {
            session.checkout(node);
        }
        if (site != null) {
            JCRNodeWrapper s = node.getNode(site.getSiteKey());
            node.setProperty("j:defaultSite", s);
        } else if (node.hasProperty("j:defaultSite")) {
            node.getProperty("j:defaultSite").remove();
        }
    }

    public void invalidateCache(JahiaSite site) throws JahiaException {
        if (site == null) {
            return;
        }
        this.invalidateCache(site.getSiteKey(), site.getServerName());
    }

    public void invalidateCache(String siteKey, String serverName) {
        if (this.siteDefaultLanguageBySiteKey != null && siteKey != null) {
            this.siteDefaultLanguageBySiteKey.remove((Serializable)((Object)siteKey));
        }
        if (this.siteKeyByServerNameCache != null && serverName != null) {
            this.siteKeyByServerNameCache.remove((Serializable)((Object)serverName));
        }
    }

    private boolean updateWorkspacePermissions(JCRSessionWrapper session, String ws, JahiaSite site) throws RepositoryException {
        JCRNodeWrapper n = session.getNode("/permissions/repository-permissions/jcr:all_" + ws + "/jcr:write_" + ws + "/jcr:modifyProperties_" + ws);
        HashSet<String> languages = new HashSet<String>();
        NodeIterator ni = n.getNodes(new String[]{"jcr:modifyProperties_" + ws + "_*"});
        while (ni.hasNext()) {
            Node next = (Node)ni.next();
            languages.add(StringUtils.substringAfter((String)next.getName(), (String)("jcr:modifyProperties_" + ws + "_")));
        }
        boolean updated = false;
        for (String s : site.getLanguages()) {
            if (languages.contains(s)) continue;
            n.addNode("jcr:modifyProperties_" + ws + "_" + s, "jnt:permission");
            updated = true;
        }
        return updated;
    }

    private void updateTranslatorRoles(JCRSessionWrapper session, JahiaSite site) throws RepositoryException {
        if (!session.itemExists("/roles/translator")) {
            return;
        }
        JCRNodeWrapper n = session.getNode("/roles/translator");
        HashSet<String> languages = new HashSet<String>();
        NodeIterator ni = n.getNodes(TRANSLATOR_NODES_PATTERN);
        while (ni.hasNext()) {
            Node next = (Node)ni.next();
            languages.add(StringUtils.substringAfter((String)next.getName(), (String)"translator-"));
        }
        for (String s : site.getLanguages()) {
            if (languages.contains(s)) continue;
            session.checkout(n);
            Node translator = n.addNode("translator-" + s, "jnt:role");
            LinkedList<Value> perms = new LinkedList<Value>();
            perms.add(session.getValueFactory().createValue("jcr:modifyProperties_default_" + s));
            Value[] values = perms.toArray(new Value[perms.size()]);
            translator.setProperty("j:permissionNames", values);
            translator.setProperty("j:roleGroup", "edit-role");
            translator.setProperty("j:privilegedAccess", true);
        }
    }

    public boolean isSiteKeyValid(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (SYSTEM_SITE_KEY.equals(name)) {
            return false;
        }
        boolean valid = true;
        for (char toBeTested : name.toCharArray()) {
            if (AUTHORIZED_CHARS.indexOf(toBeTested) != -1) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public boolean isServerNameValid(String serverName) {
        return StringUtils.isNotEmpty((String)serverName) && !serverName.contains(" ") && !serverName.contains(":");
    }

    public boolean updateSystemSiteLanguages(JahiaSite site, JCRSessionWrapper session) {
        if (!site.getSiteKey().equals(SYSTEM_SITE_KEY)) {
            try {
                JCRSiteNode jahiaSite = this.getSiteByKey(SYSTEM_SITE_KEY, session);
                HashSet<String> jahiaSiteLanguages = new HashSet<String>(jahiaSite.getLanguages());
                if (!jahiaSiteLanguages.containsAll(site.getLanguages())) {
                    jahiaSiteLanguages.addAll(site.getLanguages());
                    jahiaSite.setLanguages(jahiaSiteLanguages);
                    return true;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public String getSiteDefaultLanguage(String siteKey) throws JahiaException {
        if (siteKey == null) {
            return null;
        }
        return (String)this.getSiteDefaultLanguageBySiteKeyCache().get((Serializable)((Object)siteKey)).getObjectValue();
    }

    private SelfPopulatingCache getSiteDefaultLanguageBySiteKeyCache() {
        if (this.siteDefaultLanguageBySiteKey == null) {
            this.siteDefaultLanguageBySiteKey = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.siteDefaultLanguageBySiteKey", new SiteDefaultLanguageBySiteKeyCacheEntryFactory());
        }
        return this.siteDefaultLanguageBySiteKey;
    }

    public static void flushSitesInternalCaches() {
        JahiaSitesService.getInstance().flushCaches();
    }

    private void flushCaches() {
        if (this.siteKeyByServerNameCache != null) {
            this.siteKeyByServerNameCache.removeAll(false);
        }
        if (this.siteDefaultLanguageBySiteKey != null) {
            this.siteDefaultLanguageBySiteKey.removeAll(false);
        }
        if (this.sitesListCache != null) {
            this.sitesListCache.removeAll();
        }
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public class SiteDefaultLanguageBySiteKeyCacheEntryFactory
    implements CacheEntryFactory {
        public Object createEntry(Object key) throws Exception {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            try {
                JCRSiteNode s;
                JCRSiteNode jCRSiteNode = s = StringUtils.isEmpty((String)((String)key)) ? null : JahiaSitesService.this.getSiteByKey((String)key, session);
                if (s != null) {
                    return s.getDefaultLanguage();
                }
            }
            catch (PathNotFoundException e) {
            }
            catch (RepositoryException e) {
                logger.error("cannot get site", (Throwable)e);
            }
            return "";
        }
    }

    public class SiteKeyByServerNameCacheEntryFactory
    implements CacheEntryFactory {
        public Object createEntry(Object key) throws Exception {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRSiteNode s = JahiaSitesService.this.getSiteByServerName((String)key, session);
            if (s != null) {
                return s.getSiteKey();
            }
            return "";
        }
    }

    private static class Holder {
        static final JahiaSitesService INSTANCE = new JahiaSitesService();

        private Holder() {
        }
    }
}

