/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.AbstractHit;
import org.jahia.services.search.PageHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeHit
extends AbstractHit<JCRNodeWrapper> {
    private static final Pattern SITES_CONTENTS_FILES = Pattern.compile("/sites/([^/]+)/(contents|files)/.*");
    private static Logger logger = LoggerFactory.getLogger(JCRNodeHit.class);
    private String link = null;
    private Map<String, JCRPropertyWrapper> propertiesFacade;
    private List<AbstractHit<?>> usages;
    private JCRNodeWrapper displayableNode = null;
    private Set<String> usageFilterSites;

    public JCRNodeHit(JCRNodeWrapper node, RenderContext context) {
        super(node, context);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public Date getCreated() {
        return ((JCRNodeWrapper)this.resource).getCreationDateAsDate();
    }

    @Override
    public String getCreatedBy() {
        return ((JCRNodeWrapper)this.resource).getCreationUser();
    }

    @Override
    public Date getLastModified() {
        return ((JCRNodeWrapper)this.resource).getLastModifiedAsDate();
    }

    @Override
    public String getLastModifiedBy() {
        return ((JCRNodeWrapper)this.resource).getModificationUser();
    }

    @Override
    public String getLink() {
        if (this.link == null) {
            this.link = this.context.getURLGenerator().getContext() + this.resolveURL(this.getLinkTemplateType()) + this.getQueryParameter();
        }
        return this.link;
    }

    public String getPath() {
        return ((JCRNodeWrapper)this.resource).getPath();
    }

    public Map<String, JCRPropertyWrapper> getProperties() {
        if (this.propertiesFacade == null) {
            this.propertiesFacade = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){
                private Map<Object, JCRPropertyWrapper> accessedProperties = new HashMap<Object, JCRPropertyWrapper>();

                public Object transform(Object input) {
                    JCRPropertyWrapper property = null;
                    if (this.accessedProperties.containsKey(input)) {
                        property = this.accessedProperties.get(input);
                    } else {
                        try {
                            property = ((JCRNodeWrapper)JCRNodeHit.this.resource).getProperty(String.valueOf(input));
                        }
                        catch (RepositoryException e) {
                            logger.warn("Error accessing property '" + input + "'.", (Throwable)e);
                        }
                        this.accessedProperties.put(input, property);
                    }
                    return property;
                }
            });
        }
        return this.propertiesFacade;
    }

    @Override
    public String getTitle() {
        return this.getDisplayableNode().getDisplayableName();
    }

    public String getName() {
        return ((JCRNodeWrapper)this.resource).getName();
    }

    @Override
    public String getType() {
        String type = null;
        try {
            type = ((JCRNodeWrapper)this.resource).getPrimaryNodeTypeName();
        }
        catch (RepositoryException e) {
            logger.warn("Unable to retrieve primary node type for the resource " + this.getPath(), (Throwable)e);
        }
        return type;
    }

    public String getIconType() {
        return "";
    }

    @Override
    public List<AbstractHit<?>> getUsages() {
        if (this.usages == null) {
            this.usages = Collections.emptyList();
            if (this.shouldRetrieveUsages((JCRNodeWrapper)this.resource)) {
                this.usages = new ArrayList();
                HashSet<String> addedLinks = new HashSet<String>();
                try {
                    PropertyIterator it = ((JCRNodeWrapper)this.resource).getWeakReferences();
                    while (it.hasNext()) {
                        try {
                            JCRNodeHit hit;
                            JCRNodeWrapper refNode = (JCRNodeWrapper)it.nextProperty().getParent().getParent();
                            if (this.usageFilterSites != null && !this.usageFilterSites.contains(refNode.getResolveSite().getName())) continue;
                            JCRNodeWrapper node = JCRContentUtils.findDisplayableNode(refNode, this.context, refNode.getResolveSite());
                            if (node == null) {
                                node = refNode;
                            }
                            JCRNodeHit jCRNodeHit = hit = node.isNodeType("jnt:page") ? new PageHit(node, this.context) : new JCRNodeHit(node, this.context);
                            if (node.equals(this.resource) || !addedLinks.add(hit.getLink())) continue;
                            this.usages.add(hit);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        return this.usages;
    }

    private boolean shouldRetrieveUsages(JCRNodeWrapper node) {
        boolean shouldRetrieveUsages = false;
        if (SITES_CONTENTS_FILES.matcher(node.getPath()).matches()) {
            shouldRetrieveUsages = true;
        }
        return shouldRetrieveUsages;
    }

    public JCRNodeWrapper getDisplayableNode() {
        if (this.displayableNode == null) {
            JCRSiteNode site;
            try {
                site = ((JCRNodeWrapper)this.resource).getResolveSite();
            }
            catch (RepositoryException e) {
                site = null;
            }
            this.displayableNode = JCRContentUtils.findDisplayableNode((JCRNodeWrapper)this.resource, this.context, site);
            if (this.displayableNode == null) {
                this.displayableNode = (JCRNodeWrapper)this.resource;
            }
        }
        return this.displayableNode;
    }

    private String resolveURL(String templateType) {
        return this.context.getURLGenerator().buildURL(this.getDisplayableNode(), this.getDisplayableNode().getLanguage(), null, templateType);
    }

    public void setUsageFilterSites(Set<String> usageFilterSites) {
        this.usageFilterSites = usageFilterSites;
    }
}

