/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.Hit;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHit<T>
implements Hit<T> {
    private static Logger logger = LoggerFactory.getLogger(AbstractHit.class);
    private String excerpt;
    protected T resource;
    private float score;
    protected RenderContext context;
    private String queryParameter = "";
    private String linkTemplateType = "html";
    private List<Row> rows = null;

    public AbstractHit(T resource, RenderContext context) {
        this.resource = resource;
        this.context = context;
    }

    @Override
    public String getExcerpt() {
        if (this.excerpt == null && this.rows != null) {
            try {
                for (Row row : this.rows) {
                    Value excerptValue = row.getValue("rep:excerpt(.)");
                    if (excerptValue == null) continue;
                    if (excerptValue.getString().contains("###tags#") || excerptValue.getString().contains("###defaultCategory#")) {
                        StringBuilder r = new StringBuilder();
                        String separator = "";
                        String type = "";
                        for (String s : Patterns.COMMA.split(excerptValue.getString())) {
                            String s2 = Messages.getInternal(s.contains("tags") ? "label.tags" : "label.category", this.context.getRequest().getLocale());
                            String s1 = s.substring(s.indexOf("###"), s.lastIndexOf("###"));
                            String identifier = s1.substring(s1.lastIndexOf("#") + 1);
                            String v = "";
                            if (identifier.startsWith("<span")) {
                                identifier = identifier.substring(identifier.indexOf(">") + 1, identifier.lastIndexOf("</span>"));
                                v = "<span class=\" searchHighlightedText\">" + this.getTitle() + "</span>";
                            } else {
                                v = this.getTitle();
                            }
                            if (!type.equals(s2)) {
                                r.append(s2).append(":");
                                type = s2;
                                separator = "";
                            }
                            r.append(separator).append(v);
                            separator = ", ";
                        }
                        this.setExcerpt(r.toString());
                    } else {
                        if (StringUtils.isEmpty((String)excerptValue.getString())) continue;
                        this.setExcerpt(excerptValue.getString());
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Search details cannot be retrieved", (Throwable)e);
            }
        }
        return this.excerpt;
    }

    @Override
    public T getRawHit() {
        return this.resource;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    public RenderContext getContext() {
        return this.context;
    }

    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("type", (Object)this.getType()).append("title", (Object)this.getTitle()).append("link", (Object)this.getLink()).append("score", this.getScore()).append("contentType", (Object)this.getContentType()).append("created", (Object)this.getCreated()).append("createdBy", (Object)this.getCreatedBy()).append("lastModified", (Object)this.getLastModified()).append("lastModifiedBy", (Object)this.getLastModifiedBy()).append("lastModifiedBy", (Object)this.getLastModifiedBy()).toString();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        return this.resource.equals(obj);
    }

    public String getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(String queryParameter) {
        this.queryParameter = queryParameter;
    }

    public String getLinkTemplateType() {
        return this.linkTemplateType;
    }

    public void setLinkTemplateType(String linkTemplateType) {
        this.linkTemplateType = linkTemplateType;
    }

    public void addRow(Row row) {
        if (this.rows == null) {
            this.rows = new ArrayList<Row>();
        }
        this.rows.add(row);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public abstract List<AbstractHit<?>> getUsages();
}

