/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaService;
import org.jahia.services.scheduler.JahiaJobListener;
import org.jahia.services.scheduler.JahiaSchedulerListener;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class SchedulerService
extends JahiaService {
    public static final String INSTANT_TRIGGER_GROUP = "instant";
    static Logger logger = LoggerFactory.getLogger(SchedulerService.class);
    private static final Map<Pattern, Long> PURGE_ALL_STRATEGY = Collections.singletonMap(Pattern.compile(".*"), 0L);
    public static final String SYSTEM_JOB_GROUP = "system";
    private Scheduler ramScheduler = null;
    private Scheduler scheduler = null;
    private ThreadLocal<List<JobDetail>> scheduledAtEndOfRequest = new ThreadLocal();
    private ThreadLocal<List<JobDetail>> ramScheduledAtEndOfRequest = new ThreadLocal();

    public Integer deleteAllCompletedJobs() throws SchedulerException {
        return this.deleteAllCompletedJobs(PURGE_ALL_STRATEGY, true);
    }

    public Integer deleteAllCompletedRAMJobs() throws SchedulerException {
        return this.deleteAllCompletedJobs(PURGE_ALL_STRATEGY, true, true);
    }

    public Integer deleteAllCompletedJobs(Map<Pattern, Long> purgeStrategy, boolean purgeWithNoEndDate) throws SchedulerException {
        return this.deleteAllCompletedJobs(purgeStrategy, purgeWithNoEndDate, false);
    }

    public Integer deleteAllCompletedJobs(Map<Pattern, Long> purgeStrategy, boolean purgeWithNoEndDate, boolean isRAMScheduler) throws SchedulerException {
        logger.info("Start looking for completed jobs in {} scheduler", (Object)(isRAMScheduler ? "RAM" : "persistent"));
        int deletedCount = 0;
        Scheduler schedulerInstance = isRAMScheduler ? this.getRAMScheduler() : this.getScheduler();
        for (String jobGroup : schedulerInstance.getJobGroupNames()) {
            String[] jobNames = schedulerInstance.getJobNames(jobGroup);
            logger.info("Processing job group {} with {} jobs", (Object)jobGroup, (Object)jobNames.length);
            for (String jobName : jobNames) {
                Long ended;
                Long age;
                logger.debug("Checking job {}.{}", (Object)jobGroup, (Object)jobName);
                if (!ArrayUtils.isEmpty((Object[])schedulerInstance.getTriggersOfJob(jobName, jobGroup)) || (age = this.getAge(jobName, jobGroup, purgeStrategy)) == null || age < 0L) continue;
                JobDetail job = schedulerInstance.getJobDetail(jobName, jobGroup);
                if (job == null) {
                    logger.warn("Unable to find job {}.{}", (Object)jobGroup, (Object)jobName);
                    continue;
                }
                String status = job.getJobDataMap().getString("status");
                if (!"successful".equals(status) && !"failed".equals(status) && !"canceled".equals(status)) continue;
                Long l = ended = job.getJobDataMap().containsKey((Object)"end") ? job.getJobDataMap().getLongFromString("end") : null;
                if ((ended == null || System.currentTimeMillis() - ended <= age) && (ended != null || !purgeWithNoEndDate)) continue;
                logger.debug("Job {} matches purge policy. Deleting it.", (Object)job.getFullName());
                try {
                    schedulerInstance.deleteJob(jobName, jobGroup);
                    ++deletedCount;
                }
                catch (SchedulerException e) {
                    logger.warn("Error deleting job " + jobGroup + "." + jobName, (Throwable)e);
                }
            }
        }
        logger.info("Removed {} completed jobs", (Object)deletedCount);
        return deletedCount;
    }

    protected Long getAge(String jobName, String jobGroup, Map<Pattern, Long> purgeStrategy) {
        Long expiration = null;
        String key = jobGroup + "." + jobName;
        for (Map.Entry<Pattern, Long> purgeEntry : purgeStrategy.entrySet()) {
            if (!purgeEntry.getKey().matcher(key).matches()) continue;
            expiration = purgeEntry.getValue();
            break;
        }
        return expiration;
    }

    public List<JobDetail> getAllActiveJobs() throws SchedulerException {
        LinkedList<JobDetail> l = new LinkedList<JobDetail>();
        for (String group : this.scheduler.getTriggerGroupNames()) {
            l.addAll(this.getAllActiveJobs(group));
        }
        return l;
    }

    public List<JobDetail> getAllActiveJobs(String triggerGroup) throws SchedulerException {
        String group = StringUtils.isNotEmpty((String)triggerGroup) ? triggerGroup : "DEFAULT";
        String[] trigs = this.scheduler.getTriggerNames(group);
        if (trigs == null || trigs.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<JobDetail> all = new LinkedList<JobDetail>();
        for (String name : trigs) {
            JobDetail jd;
            Trigger t = this.scheduler.getTrigger(name, group);
            if (t == null || SYSTEM_JOB_GROUP.equals(t.getJobGroup()) || (jd = this.scheduler.getJobDetail(t.getJobName(), t.getJobGroup())) == null || !"executing".equals(jd.getJobDataMap().getString("status"))) continue;
            all.add(jd);
        }
        return all;
    }

    public List<JobDetail> getAllJobs() throws SchedulerException {
        LinkedList<JobDetail> l = new LinkedList<JobDetail>();
        for (String group : this.scheduler.getJobGroupNames()) {
            l.addAll(this.getAllJobs(group));
        }
        return l;
    }

    public List<JobDetail> getAllRAMJobs() throws SchedulerException {
        LinkedList<JobDetail> l = new LinkedList<JobDetail>();
        for (String group : this.getRAMScheduler().getJobGroupNames()) {
            l.addAll(this.getAllJobs(group, true));
        }
        return l;
    }

    public List<JobDetail> getAllJobs(String groupname) throws SchedulerException {
        return this.getAllJobs(groupname, false);
    }

    public List<JobDetail> getAllJobs(String groupname, boolean useRamScheduler) throws SchedulerException {
        String group = StringUtils.isNotEmpty((String)groupname) ? groupname : "DEFAULT";
        LinkedList<JobDetail> all = new LinkedList<JobDetail>();
        for (String process : this.getScheduler(useRamScheduler).getJobNames(group)) {
            all.add(this.getScheduler(useRamScheduler).getJobDetail(process, group));
        }
        return all;
    }

    public Scheduler getRAMScheduler() {
        return this.ramScheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    protected Scheduler getScheduler(boolean isRamScheduler) {
        return isRamScheduler ? this.ramScheduler : this.scheduler;
    }

    public void startSchedulers() throws JahiaInitializationException {
        try {
            this.ramScheduler.start();
            if (this.settingsBean.isProcessingServer()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting scheduler...\n instanceId:" + this.scheduler.getMetaData().getSchedulerInstanceId() + " instanceName:" + this.scheduler.getMetaData().getSchedulerName() + "\n" + this.scheduler.getMetaData().getSummary());
                }
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaInitializationException(e.getMessage(), e);
        }
    }

    public void scheduleJobNow(JobDetail jobDetail) throws SchedulerException {
        this.scheduleJobNow(jobDetail, false);
    }

    public void scheduleJobNow(JobDetail jobDetail, boolean useRamScheduler) throws SchedulerException {
        JobDataMap data = jobDetail.getJobDataMap();
        SimpleTrigger trigger = new SimpleTrigger(jobDetail.getName() + "_Trigger", INSTANT_TRIGGER_GROUP);
        trigger.setVolatility(jobDetail.isVolatile());
        data.put("status", "added");
        if (logger.isDebugEnabled()) {
            logger.debug("schedule job " + jobDetail.getName() + " volatile(" + jobDetail.isVolatile() + ") @ " + new Date(System.currentTimeMillis()));
        }
        if (useRamScheduler) {
            this.ramScheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
    }

    public void scheduleJobAtEndOfRequest(JobDetail jobDetail) throws SchedulerException {
        this.scheduleJobAtEndOfRequest(jobDetail, false);
    }

    public void scheduleJobAtEndOfRequest(JobDetail jobDetail, boolean useRamScheduler) throws SchedulerException {
        List<JobDetail> jobList;
        List<JobDetail> list = jobList = useRamScheduler ? this.ramScheduledAtEndOfRequest.get() : this.scheduledAtEndOfRequest.get();
        if (jobList == null) {
            jobList = new ArrayList<JobDetail>();
            if (useRamScheduler) {
                this.ramScheduledAtEndOfRequest.set(jobList);
            } else {
                this.scheduledAtEndOfRequest.set(jobList);
            }
        }
        jobList.add(jobDetail);
    }

    public void triggerEndOfRequest() {
        if (this.ramScheduledAtEndOfRequest.get() != null) {
            this.triggerJob(true);
        }
        if (this.scheduledAtEndOfRequest.get() != null) {
            this.triggerJob(false);
        }
    }

    private void triggerJob(boolean useRamScheduler) {
        List<JobDetail> jobList;
        if (useRamScheduler) {
            jobList = this.ramScheduledAtEndOfRequest.get();
            this.ramScheduledAtEndOfRequest.set(null);
        } else {
            jobList = this.scheduledAtEndOfRequest.get();
            this.scheduledAtEndOfRequest.set(null);
        }
        if (jobList != null) {
            for (JobDetail detail : jobList) {
                try {
                    this.scheduleJobNow(detail, useRamScheduler);
                }
                catch (SchedulerException e) {
                    logger.error("Cannot schedule job", (Throwable)e);
                }
            }
        }
    }

    public void setRamScheduler(Scheduler ramscheduler) {
        this.ramScheduler = ramscheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void start() throws JahiaInitializationException {
        try {
            this.ramScheduler.addSchedulerListener((SchedulerListener)new JahiaSchedulerListener(this.ramScheduler));
            this.scheduler.addSchedulerListener((SchedulerListener)new JahiaSchedulerListener(this.scheduler));
            this.ramScheduler.addGlobalJobListener((JobListener)new JahiaJobListener(true));
            this.scheduler.addGlobalJobListener((JobListener)new JahiaJobListener(false));
        }
        catch (SchedulerException se) {
            if (se.getUnderlyingException() != null) {
                throw new JahiaInitializationException("Error while initializing scheduler service", se.getUnderlyingException());
            }
            throw new JahiaInitializationException("Error while initializing scheduler service", se);
        }
    }

    @Override
    public void stop() {
        if (this.scheduler == null || this.ramScheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            this.ramScheduler.shutdown(true);
            this.scheduler = null;
            this.ramScheduler = null;
        }
        catch (Exception se) {
            logger.error(se.getMessage(), (Throwable)se);
        }
    }

    public static class JahiaSchedulerFactoryBean
    extends SchedulerFactoryBean {
        public void start() {
        }
    }
}

