/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.osgi.BundleUtils;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;

public class ModulesResourceLoaderClassLoadHelper
extends ResourceLoaderClassLoadHelper {
    private Map<String, Boolean> coreClassesChecks = new ConcurrentHashMap<String, Boolean>();

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Boolean result = this.coreClassesChecks.get(className);
        if (result == null) {
            try {
                Class clazz = super.loadClass(className);
                this.coreClassesChecks.put(className, Boolean.TRUE);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                this.coreClassesChecks.put(className, Boolean.FALSE);
            }
        } else if (result.booleanValue()) {
            return super.loadClass(className);
        }
        return BundleUtils.loadModuleClass(className);
    }
}

