/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;

public class DefaultCacheKeyGenerator
implements CacheKeyGenerator {
    private List<CacheKeyPartGenerator> partGenerators;
    private LinkedHashMap<String, Integer> fields;

    public List<CacheKeyPartGenerator> getPartGenerators() {
        return this.partGenerators;
    }

    public void setPartGenerators(List<CacheKeyPartGenerator> partGenerators) {
        this.partGenerators = partGenerators;
        this.fields = new LinkedHashMap(17);
        int index = 0;
        for (CacheKeyPartGenerator generator : partGenerators) {
            String key = generator.getKey();
            if (this.fields.containsKey(key)) {
                throw new RuntimeException("Cannot register key part generator with existing key " + key + " , " + generator);
            }
            this.fields.put(key, index++);
        }
    }

    @Override
    public String generate(Resource resource, RenderContext renderContext, Properties properties) {
        return StringUtils.join((Collection)this.getArguments(resource, renderContext, properties), (String)"@@");
    }

    private Collection getArguments(Resource resource, RenderContext renderContext, Properties properties) {
        LinkedList<String> args = new LinkedList<String>();
        for (CacheKeyPartGenerator generator : this.partGenerators) {
            args.add(generator.getValue(resource, renderContext, properties));
        }
        return args;
    }

    @Override
    public Map<String, String> parse(String key) {
        String[] values = this.getSplit(key);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.fields.size());
        if (values.length != this.fields.size()) {
            throw new IllegalStateException("Mismatched number of fields and values.");
        }
        for (Map.Entry<String, Integer> entry : this.fields.entrySet()) {
            String value = values[entry.getValue()];
            result.put(entry.getKey(), value == null || value.equals("null") ? null : value);
        }
        return result;
    }

    @Override
    public String replaceField(String key, String fieldName, String newValue) {
        Object[] args = this.getSplit(key);
        args[this.fields.get((Object)fieldName).intValue()] = newValue;
        return StringUtils.join((Object[])args, (String)"@@");
    }

    @Override
    public CacheKeyPartGenerator getPartGenerator(String field) {
        return this.partGenerators.get(this.fields.get(field));
    }

    @Override
    public String replacePlaceholdersInCacheKey(RenderContext renderContext, String key) {
        String[] args = this.getSplit(key);
        Object[] newArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String value = args[i];
            newArgs[i] = this.partGenerators.get(i).replacePlaceholders(renderContext, value);
        }
        String s = StringUtils.join((Object[])newArgs, (String)"@@");
        return s;
    }

    private String[] getSplit(String key) {
        int end;
        String[] res = new String[this.fields.size()];
        int index = 0;
        int start = 0;
        while ((end = key.indexOf("@@", start)) > -1) {
            res[index++] = key.substring(start, end);
            start = end + 2;
        }
        res[index++] = key.substring(start);
        while (index < res.length) {
            res[index++] = "";
        }
        return res;
    }
}

