/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.errors.ErrorFileDumper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.View;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;
import org.springframework.util.StopWatch;

public class TemplateScriptFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(TemplateScriptFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        Profiler profiler = (Profiler)renderContext.getRequest().getAttribute("profiler");
        if (profiler != null) {
            profiler.start("render template " + resource.getResolvedTemplate());
        }
        HttpServletRequest request = renderContext.getRequest();
        Script script = (Script)request.getAttribute("script");
        renderContext.getResourcesStack().push(resource);
        StringBuilder output = null;
        String outputString = null;
        Stack<StopWatch> stopWatchStack = null;
        try {
            boolean moduleInfo;
            if (logger.isDebugEnabled()) {
                logger.debug("Render " + script.getView().getPath() + " for resource: " + resource);
                if (renderContext.getRequest().getAttribute("previousTemplate") != null) {
                    logger.debug("previousTemplate object for rendering before script: " + ((Template)renderContext.getRequest().getAttribute("previousTemplate")).serialize());
                } else {
                    logger.debug("previousTemplate object for rendering before script is null.");
                }
                if (renderContext.getRequest().getAttribute("usedTemplate") != null) {
                    logger.debug("usedTemplate object for rendering before script: " + ((Template)renderContext.getRequest().getAttribute("usedTemplate")).serialize());
                } else {
                    logger.debug("usedTemplate object for rendering before script is null.");
                }
            }
            long start = 0L;
            StopWatch stopWatch = null;
            boolean bl = moduleInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("moduleinfo")) != false && !resource.getNode().isNodeType("jnt:template");
            if (moduleInfo) {
                output = new StringBuilder();
                output.append("\n<fieldset class=\"moduleinfo\"> ");
                start = System.currentTimeMillis();
                stopWatchStack = (Stack)renderContext.getRequest().getAttribute("stopWatchStack");
                if (stopWatchStack == null) {
                    stopWatchStack = new Stack<StopWatch>();
                    renderContext.getRequest().setAttribute("stopWatchStack", stopWatchStack);
                }
                if (!stopWatchStack.isEmpty()) {
                    ((StopWatch)stopWatchStack.peek()).stop();
                }
                stopWatch = new StopWatch();
                stopWatchStack.push(stopWatch);
                stopWatch.start();
            }
            outputString = script.execute(resource, renderContext);
            if (logger.isDebugEnabled()) {
                if (renderContext.getRequest().getAttribute("previousTemplate") != null) {
                    logger.debug("Current previousTemplate object for rendering after script: " + ((Template)renderContext.getRequest().getAttribute("previousTemplate")).serialize());
                } else {
                    logger.debug("previousTemplate object for rendering after script is null.");
                }
                if (renderContext.getRequest().getAttribute("usedTemplate") != null) {
                    logger.debug("Current usedTemplate object for rendering after script: " + ((Template)renderContext.getRequest().getAttribute("usedTemplate")).serialize());
                } else {
                    logger.debug("usedTemplate object for rendering after script is null.");
                }
            }
            if (moduleInfo) {
                output.append(outputString);
                stopWatch.stop();
                View view = script.getView();
                output.append("<legend>").append("<img src=\"").append(renderContext.getURLGenerator().getContext()).append("/modules/default/images/icons/information.png").append("\" title=\"Module: ").append(view.getModule().getId()).append("-").append(view.getModuleVersion()).append(" ").append(view.getInfo()).append(" node : ").append(resource.getNode().getPath()).append(" in total: ").append(System.currentTimeMillis() - start).append("ms").append(" , own time: ").append(stopWatch.getTotalTimeMillis()).append("ms").append("\"/></legend>");
                output.append("</fieldset>");
                outputString = output.toString();
            }
        }
        finally {
            renderContext.getResourcesStack().pop();
            if (stopWatchStack != null) {
                stopWatchStack.pop();
                if (!stopWatchStack.isEmpty()) {
                    ((StopWatch)stopWatchStack.peek()).start();
                }
            }
        }
        return outputString.trim();
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain renderChain, Exception e) {
        if (renderContext.isEditMode() && SettingsBean.getInstance().isDevelopmentMode()) {
            if (!ErrorFileDumper.isShutdown()) {
                try {
                    ErrorFileDumper.dumpToFile(e, renderContext.getRequest());
                }
                catch (IOException e1) {
                    logger.error("Cannot log error", (Throwable)e1);
                }
            }
            logger.error("Error while rendering content", (Throwable)e);
            return "<pre>" + this.getExceptionDetails(e) + "</pre>";
        }
        return super.getContentForError(renderContext, resource, renderChain, e);
    }

    private String getExceptionDetails(Throwable ex) {
        StringWriter out = new StringWriter();
        out.append(ex.getMessage()).append("\n");
        ex.printStackTrace(new PrintWriter(out));
        out.append("\n");
        return out.toString();
    }
}

