/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.Messages;

public class TemplatePermissionCheckFilter
extends AbstractFilter {
    private JahiaUserManagerService userManagerService;

    @Override
    public String prepare(RenderContext renderContext, final Resource resource, RenderChain chain) throws Exception {
        boolean invert;
        Script script = (Script)renderContext.getRequest().getAttribute("script");
        JCRNodeWrapper node = resource.getNode();
        if (script != null) {
            String requirePermissions = script.getView().getProperties().getProperty("requirePermissions");
            if (requirePermissions == null) {
                requirePermissions = script.getView().getDefaultProperties().getProperty("requirePermissions");
            }
            if (requirePermissions != null) {
                if (requirePermissions.indexOf(32) != -1) {
                    String[] perms;
                    for (String perm : perms = Patterns.SPACE.split(requirePermissions)) {
                        if (this.hasPermission(node, perm)) continue;
                        return "";
                    }
                } else if (!this.hasPermission(node, requirePermissions)) {
                    return "";
                }
            }
        } else {
            throw new TemplateNotFoundException("Unable to resolve script: " + resource.getResolvedTemplate());
        }
        boolean bl = invert = node.hasProperty("j:invertCondition") && node.getProperty("j:invertCondition").getBoolean();
        if (!renderContext.isEditMode() && node.hasProperty("j:requiredMode")) {
            String req = node.getProperty("j:requiredMode").getString();
            if (!renderContext.getMode().equals(req) && !invert) {
                throw new RequiredModeException(req, renderContext.getMainResourceLocale());
            }
        }
        if (!"studiomode".equals(renderContext.getEditModeConfigName())) {
            JahiaUser aliasedUser = JCRSessionFactory.getInstance().getCurrentAliasedUser();
            if (node.hasProperty("j:requiredPermissionNames") || node.hasProperty("j:requiredPermissions")) {
                Value[] values;
                final ArrayList<String> perms = new ArrayList<String>();
                if (node.hasProperty("j:requiredPermissions") && !node.hasProperty("j:requiredPermissionNames")) {
                    values = node.getProperty("j:requiredPermissions").getValues();
                    perms.addAll((Collection)JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<List<String>>(){

                        @Override
                        public List<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            ArrayList<String> permissionNames = new ArrayList<String>();
                            for (Value value : values) {
                                permissionNames.add(session.getNodeByUUID(value.getString()).getName());
                            }
                            return permissionNames;
                        }
                    }));
                } else {
                    for (Value value : values = node.getProperty("j:requiredPermissionNames").getValues()) {
                        perms.add(value.getString());
                    }
                }
                JCRNodeWrapper contextNode = renderContext.getAjaxResource() != null ? renderContext.getAjaxResource().getNode() : renderContext.getMainResource().getNode();
                try {
                    String contextPath;
                    if (node.hasProperty("j:contextNodePath") && !StringUtils.isEmpty((String)(contextPath = node.getProperty("j:contextNodePath").getString()))) {
                        contextNode = contextPath.startsWith("/") ? JCRSessionFactory.getInstance().getCurrentUserSession().getNode(contextPath) : contextNode.getNode(contextPath);
                    }
                }
                catch (PathNotFoundException e) {
                    return invert ? null : "";
                }
                for (String perm : perms) {
                    if (contextNode.hasPermission(perm)) continue;
                    return invert ? null : "";
                }
                if (aliasedUser != null && !JCRTemplate.getInstance().doExecute(aliasedUser, node.getSession().getWorkspace().getName(), null, new JCRCallback<Boolean>(){

                    @Override
                    public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper aliasedNode = session.getNode(resource.getNode().getPath());
                        for (String perm : perms) {
                            if (aliasedNode.hasPermission(perm)) continue;
                            return false;
                        }
                        return true;
                    }
                }).booleanValue()) {
                    return invert ? null : "";
                }
            }
            if (node.hasProperty("j:requireLoggedUser") && node.getProperty("j:requireLoggedUser").getBoolean()) {
                if (!renderContext.isLoggedIn()) {
                    return invert ? null : "";
                }
                if (aliasedUser != null && JahiaUserManagerService.isGuest(aliasedUser)) {
                    return invert ? null : "";
                }
            }
            if (node.hasProperty("j:requirePrivilegedUser") && node.getProperty("j:requirePrivilegedUser").getBoolean()) {
                JCRUserNode aliasedUserNode;
                JCRUserNode userNode = this.userManagerService.lookupUserByPath(renderContext.getUser().getLocalPath());
                if (userNode != null && !userNode.isMemberOfGroup(null, "privileged")) {
                    return invert ? null : "";
                }
                if (aliasedUser != null && (aliasedUserNode = this.userManagerService.lookupUserByPath(aliasedUser.getLocalPath())) != null && !aliasedUserNode.isMemberOfGroup(null, "privileged")) {
                    return invert ? null : "";
                }
            }
        }
        return invert ? "" : null;
    }

    private boolean hasPermission(JCRNodeWrapper node, String perm) {
        String[] perms;
        if (perm.indexOf(124) == -1) {
            return node.hasPermission(perm);
        }
        for (String p : perms = Patterns.PIPE.split(perm)) {
            if (!node.hasPermission(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String out = super.execute(previousOut, renderContext, resource, chain);
        JCRNodeWrapper node = resource.getNode();
        if (node.hasProperty("j:requiredMode")) {
            String req = node.getProperty("j:requiredMode").getString();
            if (!renderContext.isLiveMode() && req.equals("live")) {
                out = "<div style=\"position:relative;overflow:hidden\"><div style=\"position:absolute; opacity:0.5; width:100%; height:100%\" class=\"area-liveOnly\"></div>" + out + "</div>";
            }
        }
        return out;
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain chain, Exception e) {
        super.getContentForError(renderContext, resource, chain, e);
        if ("page".equals(resource.getContextConfiguration())) {
            return null;
        }
        try {
            if (e instanceof AccessDeniedException && renderContext.getMode().equals("preview") && resource.getNode().hasProperty("j:requiredMode")) {
                return "<p>" + e.getLocalizedMessage() + "</p>";
            }
        }
        catch (Exception e1) {
            return null;
        }
        return null;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    class RequiredModeException
    extends AccessDeniedException {
        private static final long serialVersionUID = -984310772102680834L;
        private Locale locale;
        private String localizedMessage;
        private String mode;

        RequiredModeException(String mode, Locale locale) {
            super("Content can only be accessed in " + mode);
            this.mode = mode;
            this.locale = locale;
        }

        public String getLocalizedMessage() {
            if (this.localizedMessage == null && this.locale != null) {
                if (this.locale != null) {
                    this.localizedMessage = Messages.getInternal("message.requiredMode." + this.mode, this.locale, this.getMessage());
                } else {
                    return super.getLocalizedMessage();
                }
            }
            return this.localizedMessage;
        }
    }
}

