/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.org.mozilla.javascript.ErrorReporter;
import com.yahoo.platform.yui.org.mozilla.javascript.EvaluatorException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.apache.commons.collections.map.LazySortedMap;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.utils.GWTInitializer;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.render.AssetsMapFactory;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public class StaticAssetsFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent>,
InitializingBean {
    private static final Transformer LOW_CASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toLowerCase() : null;
        }
    };
    private static final Pattern CLEANUP_REGEXP = Pattern.compile("<!-- jahia:temp value=\".*?\" -->");
    private static final FastHashMap RANK;
    private static final Pattern URL_PATTERN_1;
    private static final Pattern URL_PATTERN_2;
    private static final Pattern URL_PATTERN_3;
    private static final Pattern URL_PATTERN_4;
    private static final String[] OPTIONAL_ATTRIBUTES;
    private static final String TARGET_TAG = "targetTag";
    private static final String STATIC_ASSETS = "staticAssets";
    private String jahiaContext = null;
    private boolean addLastModifiedDate = false;
    private File generatedResourcesFolder;
    private static final Comparator<String> ASSET_COMPARATOR;
    private static Logger logger;
    private String ajaxResolvedTemplate;
    private String ajaxTemplate;
    private String ajaxTemplateExtension;
    private String ckeditorJavaScript = "/modules/ckeditor/javascript/ckeditor.js";
    private String resolvedTemplate;
    private ScriptEngineUtils scriptEngineUtils;
    private String template;
    private String templateExtension;
    private boolean aggregateAndCompress;
    private List<String> excludesFromAggregateAndCompress = new ArrayList<String>();
    private Set<String> ieHeaderRecognitions = new HashSet<String>();
    private boolean forceLiveIEcompatiblity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void atomicMove(File src, File dest) throws IOException {
        if (src.exists()) {
            try {
                Files.move(Paths.get(src.toURI()), Paths.get(dest.toURI()), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception e) {
                logger.warn("Unable to move the file {} into {}. Copying it instead.", (Object)src, (Object)dest);
                try {
                    FileUtils.copyFile((File)src, (File)dest);
                }
                finally {
                    FileUtils.deleteQuietly((File)src);
                }
            }
        }
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String targetTag;
        String out = previousOut;
        Source source = new Source((CharSequence)previousOut);
        LinkedHashMap<String, Map> assetsByTarget = new LinkedHashMap<String, Map>();
        List esiResourceTags = source.getAllStartTags("jahia:resource");
        HashSet<String> keys = new HashSet<String>();
        for (StartTag esiResourceTag : esiResourceTags) {
            LinkedHashMap<String, Map<String, String>> my;
            Map assets;
            targetTag = esiResourceTag.getAttributeValue(TARGET_TAG);
            targetTag = targetTag == null ? "HEAD" : targetTag.toUpperCase();
            if (!assetsByTarget.containsKey(targetTag)) {
                assets = LazySortedMap.decorate((SortedMap)TransformedSortedMap.decorate(new TreeMap(ASSET_COMPARATOR), (Transformer)LOW_CASE_TRANSFORMER, (Transformer)NOPTransformer.INSTANCE), (Factory)new AssetsMapFactory());
                assetsByTarget.put(targetTag, assets);
            } else {
                assets = (Map)assetsByTarget.get(targetTag);
            }
            String type = esiResourceTag.getAttributeValue("type");
            String path = esiResourceTag.getAttributeValue("path");
            path = URLDecoder.decode(path, "UTF-8");
            Boolean insert = Boolean.parseBoolean(esiResourceTag.getAttributeValue("insert"));
            String key = esiResourceTag.getAttributeValue("key");
            Map<String, String> optionsMap = this.getOptionMaps(esiResourceTag);
            LinkedHashMap<String, Map<String, String>> stringMap = (LinkedHashMap<String, Map<String, String>>)assets.get(type);
            if (stringMap == null) {
                LinkedHashMap assetMap = new LinkedHashMap();
                stringMap = assets.put(type, assetMap);
            }
            if (insert.booleanValue()) {
                my = new LinkedHashMap<String, Map<String, String>>();
                my.put(path, optionsMap);
                my.putAll(stringMap);
                stringMap = my;
            } else if ("".equals(key) || !keys.contains(key)) {
                my = new LinkedHashMap();
                my.put(path, optionsMap);
                stringMap.putAll(my);
                keys.add(key);
            }
            assets.put(type, stringMap);
        }
        OutputDocument outputDocument = new OutputDocument(source);
        if (renderContext.isAjaxRequest()) {
            String templateContent = this.getAjaxResolvedTemplate();
            if (templateContent != null) {
                for (Map.Entry entry : assetsByTarget.entrySet()) {
                    renderContext.getRequest().setAttribute(STATIC_ASSETS, entry.getValue());
                    Element element = source.getFirstElement(TARGET_TAG);
                    EndTag tag = element != null ? element.getEndTag() : null;
                    ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.ajaxTemplateExtension);
                    AssetsScriptContext scriptContext = new AssetsScriptContext();
                    Bindings bindings = scriptEngine.createBindings();
                    bindings.put(TARGET_TAG, entry.getKey());
                    bindings.put("renderContext", (Object)renderContext);
                    bindings.put("resource", (Object)resource);
                    scriptContext.setBindings(bindings, 200);
                    bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                    scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
                    StringWriter writer = (StringWriter)scriptContext.getWriter();
                    String staticsAsset = writer.toString();
                    if (!StringUtils.isNotBlank((String)staticsAsset)) continue;
                    if (tag != null) {
                        outputDocument.replace(tag.getBegin(), tag.getBegin() + 1, (CharSequence)("\n" + staticsAsset + "\n<"));
                        out = outputDocument.toString();
                        continue;
                    }
                    out = staticsAsset + "\n" + previousOut;
                }
            }
        } else if (resource.getContextConfiguration().equals("page")) {
            if (renderContext.isEditMode() && renderContext.getServletPath().endsWith("frame")) {
                List bodyElementList;
                boolean doParse = true;
                if (renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing() != null) {
                    for (String nt : renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing()) {
                        doParse = !resource.getNode().isNodeType(nt);
                        if (doParse) continue;
                        break;
                    }
                }
                if ((bodyElementList = source.getAllElements("body")).size() > 0) {
                    Element bodyElement = (Element)bodyElementList.get(bodyElementList.size() - 1);
                    EndTag bodyEndTag = bodyElement.getEndTag();
                    outputDocument.replace(bodyEndTag.getBegin(), bodyEndTag.getBegin() + 1, (CharSequence)"</div><");
                    bodyElement = (Element)bodyElementList.get(0);
                    StartTag bodyStartTag = bodyElement.getStartTag();
                    outputDocument.replace(bodyStartTag.getEnd(), bodyStartTag.getEnd(), (CharSequence)("\n<div jahiatype=\"mainmodule\" path=\"" + resource.getNode().getPath() + "\" locale=\"" + resource.getLocale() + "\"" + " template=\"" + (resource.getTemplate() != null ? resource.getTemplate() : "default") + "\"" + " nodetypes=\"" + ConstraintsHelper.getConstraints(renderContext.getMainResource().getNode()) + "\"" + ">"));
                    if (doParse) {
                        outputDocument.replace(bodyStartTag.getEnd() - 1, bodyStartTag.getEnd(), (CharSequence)" jahia-parse-html=\"true\">");
                    }
                }
            }
            if (!assetsByTarget.containsKey("HEAD")) {
                this.addResources(renderContext, resource, source, outputDocument, "HEAD", new HashMap<String, Map<String, Map<String, String>>>());
            }
            for (Map.Entry entry : assetsByTarget.entrySet()) {
                targetTag = (String)entry.getKey();
                Map assets = (Map)entry.getValue();
                this.addResources(renderContext, resource, source, outputDocument, targetTag, assets);
            }
            out = outputDocument.toString();
        }
        source = new Source((CharSequence)out);
        esiResourceTags = new Source((CharSequence)out).getAllStartTags("jahia:resource");
        outputDocument = new OutputDocument(source);
        for (StartTag segment : esiResourceTags) {
            outputDocument.replace((Segment)segment, (CharSequence)"");
        }
        String s = outputDocument.toString();
        s = StaticAssetsFilter.removeTempTags(s);
        return s.trim();
    }

    private void addResources(RenderContext renderContext, Resource resource, Source source, OutputDocument outputDocument, String targetTag, Map<String, Map<String, Map<String, String>>> assets) throws IOException, ScriptException {
        renderContext.getRequest().setAttribute(STATIC_ASSETS, assets);
        Element element = source.getFirstElement(targetTag);
        String templateContent = this.getResolvedTemplate();
        if (element == null) {
            logger.warn("Trying to add resources to output but didn't find {} tag", (Object)targetTag);
            return;
        }
        if (templateContent != null) {
            EndTag headEndTag = element.getEndTag();
            ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.templateExtension);
            AssetsScriptContext scriptContext = new AssetsScriptContext();
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("contextJsParameters", this.getContextJsParameters(assets, renderContext));
            if (this.aggregateAndCompress && resource.getWorkspace().equals("live")) {
                Map<String, Map<String, String>> javascriptAssets;
                Map<String, Map<String, String>> cssAssets = assets.get("css");
                if (cssAssets != null) {
                    assets.put("css", this.aggregate(cssAssets, "css"));
                }
                if ((javascriptAssets = assets.get("javascript")) != null) {
                    LinkedHashMap<String, Map<String, String>> scripts = new LinkedHashMap<String, Map<String, String>>(javascriptAssets);
                    Map<String, Map<String, String>> newScripts = this.aggregate(javascriptAssets, "js");
                    assets.put("javascript", newScripts);
                    scripts.keySet().removeAll(newScripts.keySet());
                    assets.put("aggregatedjavascript", scripts);
                }
            } else if (this.addLastModifiedDate) {
                this.addLastModified(assets);
            }
            bindings.put(TARGET_TAG, (Object)targetTag);
            bindings.put("renderContext", (Object)renderContext);
            bindings.put("resource", (Object)resource);
            bindings.put("contextPath", (Object)renderContext.getRequest().getContextPath());
            scriptContext.setBindings(bindings, 200);
            bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
            scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
            StringWriter writer = (StringWriter)scriptContext.getWriter();
            String staticsAsset = writer.toString();
            if (StringUtils.isNotBlank((String)staticsAsset)) {
                outputDocument.replace(headEndTag.getBegin(), headEndTag.getBegin() + 1, (CharSequence)("\n" + AggregateCacheFilter.removeCacheTags(staticsAsset) + "\n<"));
            }
        }
        if (this.isEnforceIECompatibilityMode(renderContext)) {
            int idx = element.getBegin() + element.toString().indexOf(">");
            String str = ">\n<meta http-equiv=\"X-UA-Compatible\" content=\"" + SettingsBean.getInstance().getInternetExplorerCompatibility() + "\"/>";
            outputDocument.replace(idx, idx + 1, (CharSequence)str);
        }
        if (renderContext.isPreviewMode() && !Boolean.valueOf((String)renderContext.getRequest().getAttribute("org.jahia.StaticAssetFilter.doNotModifyDocumentTitle")).booleanValue()) {
            for (Element title : element.getAllElements("title")) {
                int idx = title.getBegin() + title.toString().indexOf(">");
                String str = Messages.getInternal("label.preview", renderContext.getUILocale());
                str = ">" + str + " - ";
                outputDocument.replace(idx, idx + 1, (CharSequence)str);
            }
        }
    }

    private Map<String, String> getOptionMaps(StartTag esiResourceTag) {
        Map<String, String> optionsMap = null;
        for (String attributeName : OPTIONAL_ATTRIBUTES) {
            String attribute = esiResourceTag.getAttributeValue(attributeName);
            if (attribute == null || (attribute = attribute.trim()).isEmpty()) continue;
            if (optionsMap == null) {
                optionsMap = new HashMap<String, String>(OPTIONAL_ATTRIBUTES.length);
            }
            optionsMap.put(attributeName, attribute);
        }
        return optionsMap != null ? optionsMap : Collections.emptyMap();
    }

    private void addLastModified(Map<String, Map<String, Map<String, String>>> assets) throws IOException {
        for (Map.Entry<String, Map<String, Map<String, String>>> assetsEntry : assets.entrySet()) {
            if (!assetsEntry.getKey().equals("css") && !assetsEntry.getKey().equals("javascript")) continue;
            LinkedHashMap<String, Map<String, String>> newMap = new LinkedHashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : assetsEntry.getValue().entrySet()) {
                org.springframework.core.io.Resource r = this.getResource(this.getKey(entry.getKey()));
                if (r != null) {
                    newMap.put(entry.getKey() + "?" + r.lastModified(), entry.getValue());
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            assetsEntry.getValue().clear();
            assetsEntry.getValue().putAll(newMap);
        }
    }

    private Object getContextJsParameters(Map<String, Map<String, Map<String, String>>> assets, RenderContext ctx) {
        String customCkeditorConfig;
        StringBuilder params = new StringBuilder(1024);
        params.append("{contextPath:\"").append(ctx.getRequest().getContextPath()).append("\",lang:\"").append(ctx.getMainResourceLocale()).append("\",uilang:\"").append(ctx.getUILocale());
        try {
            params.append("\",siteUuid:\"").append(ctx.getSite() != null ? ctx.getSite().getIdentifier() : "''");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        params.append("\",wcag:").append(ctx.getSiteInfo() != null ? Boolean.valueOf(ctx.getSiteInfo().isWCAGComplianceCheckEnabled()) : "false");
        Map<String, Map<String, String>> js = assets.get("javascript");
        if (js != null && js.containsKey(this.ckeditorJavaScript) && (customCkeditorConfig = GWTInitializer.getCustomCKEditorConfig(ctx)) != null) {
            params.append(",ckeCfg:\"").append(customCkeditorConfig).append("\"");
        }
        params.append(",ckeCfg:\"\"}");
        return params.toString();
    }

    private boolean isEnforceIECompatibilityMode(RenderContext renderContext) {
        if (!this.forceLiveIEcompatiblity && !renderContext.isEditMode()) {
            return false;
        }
        String header = renderContext.getRequest().getHeader("user-agent");
        if (header == null || header.length() == 0) {
            return false;
        }
        header = header.toLowerCase();
        for (String ieHeaderRecognition : this.getIeHeaderRecognitions()) {
            if (!header.contains(ieHeaderRecognition)) continue;
            return true;
        }
        return false;
    }

    public static String removeTempTags(String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            return CLEANUP_REGEXP.matcher(content).replaceAll("");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> aggregate(Map<String, Map<String, String>> map, String type) throws IOException {
        ArrayList<Map.Entry<String, Map<String, String>>> entries = new ArrayList<Map.Entry<String, Map<String, String>>>(map.entrySet());
        LinkedHashMap<String, Map<String, String>> newCss = new LinkedHashMap<String, Map<String, String>>();
        int i = 0;
        while (i < entries.size()) {
            org.springframework.core.io.Resource r;
            block26: {
                String ctx;
                String minifiedAggregatedPath;
                block25: {
                    File minifiedAggregatedFile;
                    long filesDates = 0L;
                    LinkedHashMap<String, org.springframework.core.io.Resource> pathsToAggregate = new LinkedHashMap<String, org.springframework.core.io.Resource>();
                    while (i < entries.size()) {
                        Map.Entry entry = (Map.Entry)entries.get(i);
                        String key = this.getKey((String)entry.getKey());
                        org.springframework.core.io.Resource r2 = this.getResource(key);
                        if (!((Map)entry.getValue()).isEmpty() || this.excludesFromAggregateAndCompress.contains(key) || r2 == null) break;
                        pathsToAggregate.put(key, r2);
                        long lastModified = r2.lastModified();
                        if (filesDates < lastModified) {
                            filesDates = lastModified;
                        }
                        ++i;
                    }
                    if (pathsToAggregate.isEmpty()) break block26;
                    String aggregatedKey = this.generateAggregateName(pathsToAggregate.keySet());
                    minifiedAggregatedPath = "/generated-resources/" + aggregatedKey + ".min." + type;
                    String minifiedAggregatedRealPath = this.getFileSystemPath(minifiedAggregatedPath);
                    if (this.addLastModifiedDate) {
                        minifiedAggregatedPath = minifiedAggregatedPath + "?" + filesDates;
                    }
                    if ((minifiedAggregatedFile = new File(minifiedAggregatedRealPath)).exists() && minifiedAggregatedFile.lastModified() >= filesDates) break block25;
                    this.generatedResourcesFolder.mkdirs();
                    LinkedHashMap<String, String> minifiedPaths = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : pathsToAggregate.entrySet()) {
                        String path = (String)entry.getKey();
                        String minifiedPath = "/generated-resources/" + Patterns.SLASH.matcher(path).replaceAll("_") + ".min." + type;
                        File minifiedFile = new File(this.getFileSystemPath(minifiedPath));
                        org.springframework.core.io.Resource f = (org.springframework.core.io.Resource)entry.getValue();
                        if (!minifiedFile.exists() || minifiedFile.lastModified() < f.lastModified()) {
                            File tmpMinifiedFile;
                            OutputStreamWriter writer;
                            Reader reader;
                            block24: {
                                reader = null;
                                writer = null;
                                tmpMinifiedFile = new File(minifiedFile.getParentFile(), minifiedFile.getName() + "." + System.nanoTime());
                                try {
                                    reader = new InputStreamReader(f.getInputStream(), "UTF-8");
                                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpMinifiedFile), "UTF-8");
                                    boolean compress = true;
                                    if (compress && type.equals("css")) {
                                        String s = IOUtils.toString((Reader)reader);
                                        IOUtils.closeQuietly((Reader)reader);
                                        if (s.indexOf("url(") != -1) {
                                            String url = StringUtils.substringBeforeLast((String)path, (String)"/") + "/";
                                            s = URL_PATTERN_1.matcher(s).replaceAll("url(");
                                            s = URL_PATTERN_2.matcher(s).replaceAll("url(\".." + url);
                                            s = URL_PATTERN_3.matcher(s).replaceAll("url('.." + url);
                                            s = URL_PATTERN_4.matcher(s).replaceAll("url(.." + url);
                                        }
                                        reader = new StringReader(s);
                                        CssCompressor compressor = new CssCompressor(reader);
                                        compressor.compress((Writer)writer, -1);
                                        break block24;
                                    }
                                    if (compress && type.equals("js")) {
                                        JavaScriptCompressor compressor = null;
                                        try {
                                            compressor = new JavaScriptCompressor(reader, new ErrorReporter(){

                                                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                                    if (!logger.isDebugEnabled()) {
                                                        return;
                                                    }
                                                    if (line < 0) {
                                                        logger.debug(message);
                                                    } else {
                                                        logger.debug(line + ":" + lineOffset + ":" + message);
                                                    }
                                                }

                                                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                                    if (line < 0) {
                                                        logger.error(message);
                                                    } else {
                                                        logger.error(line + ":" + lineOffset + ":" + message);
                                                    }
                                                }

                                                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                                    this.error(message, sourceName, line, lineSource, lineOffset);
                                                    return new EvaluatorException(message);
                                                }
                                            });
                                            compressor.compress((Writer)writer, -1, true, true, false, false);
                                        }
                                        catch (EvaluatorException e) {
                                            logger.error("Error when minifying " + path, (Throwable)e);
                                            IOUtils.closeQuietly((Reader)reader);
                                            IOUtils.closeQuietly((Writer)writer);
                                            reader = new InputStreamReader(f.getInputStream(), "UTF-8");
                                            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpMinifiedFile), "UTF-8");
                                            IOUtils.copy((Reader)reader, (Writer)writer);
                                        }
                                        break block24;
                                    }
                                    BufferedWriter bw = new BufferedWriter(writer);
                                    BufferedReader br = new BufferedReader(reader);
                                    String s = null;
                                    while ((s = br.readLine()) != null) {
                                        bw.write(s);
                                        bw.write("\n");
                                    }
                                    IOUtils.closeQuietly((Writer)bw);
                                    IOUtils.closeQuietly((Reader)br);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(reader);
                                    IOUtils.closeQuietly(writer);
                                    StaticAssetsFilter.atomicMove(tmpMinifiedFile, minifiedFile);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((Reader)reader);
                            IOUtils.closeQuietly((Writer)writer);
                            StaticAssetsFilter.atomicMove(tmpMinifiedFile, minifiedFile);
                        }
                        minifiedPaths.put(path, minifiedPath);
                    }
                    try {
                        File tmpMinifiedAggregatedFile = new File(minifiedAggregatedFile.getParentFile(), minifiedAggregatedFile.getName() + "." + System.nanoTime());
                        BufferedOutputStream outMerged = new BufferedOutputStream(new FileOutputStream(tmpMinifiedAggregatedFile));
                        FileInputStream is = null;
                        try {
                            for (Map.Entry entry : minifiedPaths.entrySet()) {
                                if (type.equals("js")) {
                                    ((OutputStream)outMerged).write("//".getBytes());
                                    ((OutputStream)outMerged).write(((String)entry.getValue()).getBytes());
                                    ((OutputStream)outMerged).write("\n".getBytes());
                                }
                                is = new FileInputStream(this.getFileSystemPath((String)entry.getValue()));
                                IOUtils.copy((InputStream)is, (OutputStream)outMerged);
                                if (type.equals("js")) {
                                    ((OutputStream)outMerged).write(";\n".getBytes());
                                }
                                IOUtils.closeQuietly((InputStream)is);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)outMerged);
                            IOUtils.closeQuietly(is);
                            StaticAssetsFilter.atomicMove(tmpMinifiedAggregatedFile, minifiedAggregatedFile);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                newCss.put((ctx = Jahia.getContextPath()).length() > 0 ? ctx + minifiedAggregatedPath : minifiedAggregatedPath, new HashMap());
            }
            if (i >= entries.size()) continue;
            if (this.addLastModifiedDate && (r = this.getResource(this.getKey((String)((Map.Entry)entries.get(i)).getKey()))) != null) {
                newCss.put((String)((Map.Entry)entries.get(i)).getKey() + "?lastModified=" + r.lastModified(), (Map<String, String>)((Map.Entry)entries.get(i)).getValue());
            } else {
                newCss.put((String)((Map.Entry)entries.get(i)).getKey(), (Map<String, String>)((Map.Entry)entries.get(i)).getValue());
            }
            ++i;
        }
        return newCss;
    }

    private String getKey(String key) {
        if (Jahia.getContextPath().length() > 0 && key.startsWith(this.jahiaContext)) {
            key = key.substring(Jahia.getContextPath().length());
        }
        return key;
    }

    private org.springframework.core.io.Resource getResource(String key) {
        org.springframework.core.io.Resource r = null;
        String filePath = StringUtils.substringAfter((String)key.substring(1), (String)"/");
        String moduleId = StringUtils.substringBefore((String)filePath, (String)"/");
        filePath = StringUtils.substringAfter((String)filePath, (String)"/");
        if (key.startsWith("/modules/")) {
            r = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleId).getResource(filePath);
        } else if (key.startsWith("/files/")) {
            r = this.getResourceFromFile(moduleId, "/" + filePath);
        }
        return r;
    }

    private String getFileSystemPath(String minifiedAggregatedPath) {
        return SettingsBean.getInstance().getJahiaVarDiskPath() + minifiedAggregatedPath;
    }

    private org.springframework.core.io.Resource getResourceFromFile(String workspace, String fFilePath) {
        try {
            final JCRNodeWrapper contentNode = JCRSessionFactory.getInstance().getCurrentUserSession(workspace).getNode(fFilePath);
            return new org.springframework.core.io.Resource(){

                public boolean exists() {
                    return true;
                }

                public boolean isReadable() {
                    return false;
                }

                public boolean isOpen() {
                    return false;
                }

                public URL getURL() throws IOException {
                    return null;
                }

                public URI getURI() throws IOException {
                    return null;
                }

                public File getFile() throws IOException {
                    return null;
                }

                public long contentLength() throws IOException {
                    return contentNode.getFileContent().getContentLength();
                }

                public long lastModified() throws IOException {
                    return contentNode.getLastModifiedAsDate().getTime();
                }

                public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
                    return null;
                }

                public String getFilename() {
                    return contentNode.getName();
                }

                public String getDescription() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return contentNode.getFileContent().downloadFile();
                }
            };
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    private String generateAggregateName(Collection<String> m) {
        StringBuilder sb = new StringBuilder(m.size() * 128);
        for (String s1 : m) {
            sb.append(s1);
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            byte[] digest = digester.digest(sb.toString().getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder(digest.length * 2);
            for (byte aDigest : digest) {
                hexString.append(Integer.toHexString(0xFF & aDigest));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAjaxResolvedTemplate() throws IOException {
        if (this.ajaxResolvedTemplate == null) {
            this.ajaxResolvedTemplate = WebUtils.getResourceAsString(this.ajaxTemplate);
            if (this.ajaxResolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.ajaxTemplate);
            }
        }
        return this.ajaxResolvedTemplate;
    }

    protected String getResolvedTemplate() throws IOException {
        if (this.resolvedTemplate == null) {
            this.resolvedTemplate = WebUtils.getResourceAsString(this.template);
            if (this.resolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.template);
            }
        }
        return this.resolvedTemplate;
    }

    public void setAjaxTemplate(String ajaxTemplate) {
        this.ajaxTemplate = ajaxTemplate;
        if (ajaxTemplate != null) {
            this.ajaxTemplateExtension = StringUtils.substringAfterLast((String)ajaxTemplate, (String)".");
        }
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (template != null) {
            this.templateExtension = StringUtils.substringAfterLast((String)template, (String)".");
        }
    }

    public void setAggregateAndCompress(boolean aggregateAndCompress) {
        this.aggregateAndCompress = aggregateAndCompress;
    }

    public void setExcludesFromAggregateAndCompress(List<String> skipAggregation) {
        this.excludesFromAggregateAndCompress = skipAggregation;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.ajaxResolvedTemplate = null;
        this.resolvedTemplate = null;
    }

    public void afterPropertiesSet() throws Exception {
        this.jahiaContext = Jahia.getContextPath() + "/";
        this.generatedResourcesFolder = new File(this.getFileSystemPath("/generated-resources"));
    }

    public Set<String> getIeHeaderRecognitions() {
        return this.ieHeaderRecognitions;
    }

    public void setIeHeaderRecognitions(Set<String> ieHeaderRecognitions) {
        this.ieHeaderRecognitions = ieHeaderRecognitions;
    }

    public void setCkeditorJavaScript(String ckeditorJavaScript) {
        this.ckeditorJavaScript = ckeditorJavaScript;
    }

    public void setAddLastModifiedDate(boolean addLastModifiedDate) {
        this.addLastModifiedDate = addLastModifiedDate;
    }

    public void setForceLiveIEcompatiblity(boolean forceLiveIEcompatiblity) {
        this.forceLiveIEcompatiblity = forceLiveIEcompatiblity;
    }

    static {
        URL_PATTERN_1 = Pattern.compile("url\\( ");
        URL_PATTERN_2 = Pattern.compile("url\\(\"(?!(/|http:|https:|data:))");
        URL_PATTERN_3 = Pattern.compile("url\\('(?!(/|http:|https:|data:))");
        URL_PATTERN_4 = Pattern.compile("url\\((?!(/|'|\"|http:|https:|data:))");
        OPTIONAL_ATTRIBUTES = new String[]{"title", "rel", "media", "condition"};
        RANK = new FastHashMap();
        RANK.put((Object)"inlinebefore", (Object)0);
        RANK.put((Object)"css", (Object)1);
        RANK.put((Object)"inlinecss", (Object)2);
        RANK.put((Object)"javascript", (Object)3);
        RANK.put((Object)"inlinejavascript", (Object)4);
        RANK.put((Object)"inline", (Object)5);
        RANK.put((Object)"unknown", (Object)6);
        RANK.setFast(true);
        ASSET_COMPARATOR = ComparatorUtils.transformedComparator(null, (Transformer)new Transformer(){

            public Object transform(Object input) {
                Object rank = null;
                if (input != null) {
                    rank = (Integer)RANK.get((Object)input.toString());
                }
                return rank != null ? rank : RANK.get((Object)"unknown");
            }
        });
        logger = LoggerFactory.getLogger(StaticAssetsFilter.class);
    }

    class AssetsScriptContext
    extends SimpleScriptContext {
        private Writer writer = null;

        AssetsScriptContext() {
        }

        @Override
        public Writer getWriter() {
            if (this.writer == null) {
                this.writer = new StringWriter();
            }
            return this.writer;
        }
    }
}

