/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.scripting.Script;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilter
implements RenderFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFilter.class);
    private List<ExecutionCondition> conditions = new LinkedList<ExecutionCondition>();
    private String description;
    private boolean disabled;
    private int priority = 99;
    protected RenderService service;

    public AbstractFilter() {
    }

    public AbstractFilter(ExecutionCondition ... conditions) {
        this();
        for (ExecutionCondition cond : conditions) {
            this.addCondition(cond);
        }
    }

    public void addCondition(ExecutionCondition condition) {
        this.conditions.add(condition);
    }

    public void addCondition(int index, ExecutionCondition condition) {
        this.conditions.add(index, condition);
    }

    @Override
    public boolean areConditionsMatched(RenderContext renderContext, Resource resource) {
        if (this.disabled) {
            return false;
        }
        boolean matches = true;
        for (ExecutionCondition condition : this.conditions) {
            if (condition.matches(renderContext, resource)) continue;
            matches = false;
            break;
        }
        return matches;
    }

    @Override
    public int compareTo(RenderFilter o) {
        int i = this.getPriority() - o.getPriority();
        return i != 0 ? i : this.getClass().getName().compareTo(o.getClass().getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.getPriority() == ((AbstractFilter)obj).getPriority();
        }
        return false;
    }

    public int hashCode() {
        int result = this.getClass().getName().hashCode();
        result = 31 * result + this.priority;
        return result;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        return previousOut;
    }

    @Override
    public void finalize(RenderContext renderContext, Resource resource, RenderChain renderChain) {
    }

    public String getConditionsSummary() {
        StringBuilder out = new StringBuilder();
        if (this.conditions.isEmpty()) {
            out.append("<none>");
        }
        boolean first = true;
        for (ExecutionCondition cond : this.conditions) {
            if (!first) {
                out.append(" && ");
            } else {
                first = false;
            }
            out.append("(").append(cond).append(")");
        }
        return out.toString();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain renderChain, Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling exception {} in {}", (Object)e.getMessage(), (Object)resource.getNode().getPath());
        }
        return null;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        return null;
    }

    public void setApplyOnConfigurations(String configurations) {
        if (configurations.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String conf : Patterns.COMMA.split(configurations)) {
                condition.add(new ConfigurationCondition(conf.trim()));
            }
            this.addCondition(0, condition);
        } else {
            this.addCondition(0, new ConfigurationCondition(configurations));
        }
    }

    public void setApplyOnMainResource(boolean bool) {
        if (bool) {
            this.addCondition(new MainResourceCondition());
        }
    }

    public void setApplyOnModes(String modes) {
        if (modes.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String mode : Patterns.COMMA.split(modes)) {
                condition.add(new ModeCondition(mode.trim()));
            }
            this.addCondition(0, condition);
        } else {
            this.addCondition(0, new ModeCondition(modes));
        }
    }

    public void setApplyOnEditMode(Boolean applyOnEditMode) {
        if (applyOnEditMode.booleanValue()) {
            this.addCondition(0, new EditModeCondition());
        }
    }

    public void setApplyOnModules(String modules) {
        if (modules.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String module : Patterns.COMMA.split(modules)) {
                condition.add(new ModuleCondition(module.trim()));
            }
            this.addCondition(condition);
        } else {
            this.addCondition(new ModuleCondition(modules));
        }
    }

    public void setApplyOnNodeTypes(String nodeTypes) {
        if (nodeTypes.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String nodeType : Patterns.COMMA.split(nodeTypes)) {
                condition.add(new NodeTypeCondition(nodeType.trim()));
            }
            this.addCondition(condition);
        } else {
            this.addCondition(new NodeTypeCondition(nodeTypes));
        }
    }

    public void setApplyOnTemplates(String templates) {
        if (templates.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String template : Patterns.COMMA.split(templates)) {
                condition.add(new TemplateCondition(template.trim()));
            }
            this.addCondition(condition);
        } else {
            this.addCondition(new TemplateCondition(templates));
        }
    }

    public void setApplyOnTemplateTypes(String templateTypes) {
        if (templateTypes.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String templateType : Patterns.COMMA.split(templateTypes)) {
                condition.add(new TemplateTypeCondition(templateType.trim(), true));
            }
            this.addCondition(condition);
        } else {
            this.addCondition(new TemplateTypeCondition(templateTypes, true));
        }
    }

    public void setApplyOnSiteTemplateSets(String templateSets) {
        if (templateSets.contains(",")) {
            AnyOfCondition condition = new AnyOfCondition();
            for (String templateSet : Patterns.COMMA.split(templateSets)) {
                condition.add(new SiteTemplateSetCondition(templateSet.trim()));
            }
            this.addCondition(condition);
        } else {
            this.addCondition(new SiteTemplateSetCondition(templateSets));
        }
    }

    public void setConditions(Set<ExecutionCondition> conditions) {
        this.conditions.addAll(conditions);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final void setRenderService(RenderService service) {
        this.service = service;
    }

    public void setSkipOnAjaxRequest(Boolean skip) {
        if (skip.booleanValue()) {
            this.addCondition(new NotCondition(new AjaxRequestCondition()));
        }
    }

    @Deprecated
    public void setSkipOnConfiguration(String configurations) {
        this.setSkipOnConfigurations(configurations);
    }

    public void setSkipOnConfigurations(String configurations) {
        ExecutionCondition condition = null;
        if (configurations.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String configuration : Patterns.COMMA.split(configurations)) {
                anyOf.add(new ConfigurationCondition(configuration.trim()));
            }
            condition = anyOf;
        } else {
            condition = new ConfigurationCondition(configurations);
        }
        this.addCondition(0, new NotCondition(condition));
    }

    public void setSkipOnMainResource(boolean bool) {
        if (bool) {
            this.addCondition(new NotCondition(new MainResourceCondition()));
        }
    }

    public void setSkipOnModes(String modes) {
        ExecutionCondition condition = null;
        if (modes.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String mode : Patterns.COMMA.split(modes)) {
                anyOf.add(new ModeCondition(mode.trim()));
            }
            condition = anyOf;
        } else {
            condition = new ModeCondition(modes);
        }
        this.addCondition(0, new NotCondition(condition));
    }

    public void setSkipOnEditMode(Boolean skipOnEditMode) {
        if (skipOnEditMode.booleanValue()) {
            this.addCondition(new NotCondition(new EditModeCondition()));
        }
    }

    public void setSkipOnModules(String modules) {
        ExecutionCondition condition = null;
        if (modules.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String module : Patterns.COMMA.split(modules)) {
                anyOf.add(new ModuleCondition(module.trim()));
            }
            condition = anyOf;
        } else {
            condition = new ModuleCondition(modules);
        }
        this.addCondition(new NotCondition(condition));
    }

    public void setSkipOnNodeTypes(String nodeTypes) {
        ExecutionCondition condition = null;
        if (nodeTypes.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String nodeType : Patterns.COMMA.split(nodeTypes)) {
                anyOf.add(new NodeTypeCondition(nodeType.trim()));
            }
            condition = anyOf;
        } else {
            condition = new NodeTypeCondition(nodeTypes);
        }
        this.addCondition(new NotCondition(condition));
    }

    public void setSkipOnTemplates(String templates) {
        ExecutionCondition condition = null;
        if (templates.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String template : Patterns.COMMA.split(templates)) {
                anyOf.add(new TemplateCondition(template.trim()));
            }
            condition = anyOf;
        } else {
            condition = new TemplateCondition(templates);
        }
        this.addCondition(new NotCondition(condition));
    }

    public void setSkipOnTemplateTypes(String templateTypes) {
        ExecutionCondition condition = null;
        if (templateTypes.contains(",")) {
            AnyOfCondition anyOf = new AnyOfCondition();
            for (String templateType : Patterns.COMMA.split(templateTypes)) {
                anyOf.add(new TemplateTypeCondition(templateType.trim(), true));
            }
            condition = anyOf;
        } else {
            condition = new TemplateTypeCondition(templateTypes, true);
        }
        this.addCondition(new NotCondition(condition));
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.description != null) {
            out.append("Description: ").append(this.description).append("\n");
        }
        out.append("Conditions: ").append(this.getConditionsSummary());
        return out.toString();
    }

    public static class SiteTemplateSetCondition
    implements ExecutionCondition {
        private String templateSet;

        public SiteTemplateSetCondition(String templateSet) {
            this.templateSet = templateSet;
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return renderContext.getSite() != null && renderContext.getSite().getInstalledModules().contains(this.templateSet);
        }

        public String toString() {
            return "siteTemplateSet == " + this.templateSet;
        }
    }

    public static class TemplateTypeCondition
    extends PatternCondition {
        public TemplateTypeCondition(String templateType) {
            super(templateType, false);
        }

        public TemplateTypeCondition(String templateType, boolean isRegExp) {
            super(templateType, isRegExp);
        }

        @Override
        public String getValue(RenderContext renderContext, Resource resource) {
            return resource.getTemplateType();
        }

        @Override
        public String toString() {
            return "template type " + super.toString();
        }
    }

    public static class TemplateCondition
    extends PatternCondition {
        public TemplateCondition(String template) {
            super(template, false);
        }

        public TemplateCondition(String template, boolean isRegExp) {
            super(template, isRegExp);
        }

        @Override
        public String getValue(RenderContext renderContext, Resource resource) {
            return resource.getResolvedTemplate();
        }

        @Override
        public String toString() {
            return "template " + super.toString();
        }
    }

    public static class RequestParameterCondition
    extends RequestCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return this.name != null && StringUtils.equals((String)renderContext.getRequest().getParameter(this.name), (String)this.value);
        }
    }

    public static class RequestHeaderCondition
    extends RequestCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return this.name != null && StringUtils.equals((String)renderContext.getRequest().getHeader(this.name), (String)this.value);
        }
    }

    public static abstract class RequestCondition
    implements ExecutionCondition {
        protected String name;
        protected String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class RequestAttributeCondition
    extends RequestCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return this.name != null && StringUtils.equals((String)String.valueOf(renderContext.getRequest().getAttribute(this.name)), (String)this.value);
        }
    }

    public static abstract class PatternCondition
    implements ExecutionCondition {
        private String exactMatch;
        private Pattern pattern;

        public PatternCondition(String pattern, boolean isRegExp) {
            if (isRegExp) {
                this.pattern = Pattern.compile(pattern);
            } else {
                this.exactMatch = pattern;
            }
        }

        protected abstract String getValue(RenderContext var1, Resource var2);

        @Override
        public final boolean matches(RenderContext renderContext, Resource resource) {
            return this.pattern != null ? this.pattern.matcher(this.getValue(renderContext, resource)).matches() : this.exactMatch.equals(this.getValue(renderContext, resource));
        }

        public String toString() {
            return this.pattern != null ? "matches " + this.pattern.pattern() : "is " + this.exactMatch;
        }
    }

    public static class NotCondition
    implements ExecutionCondition {
        private ExecutionCondition condition;

        public NotCondition(ExecutionCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return !this.condition.matches(renderContext, resource);
        }

        public String toString() {
            return "not (" + this.condition + ")";
        }
    }

    public static class NodeTypeCondition
    implements ExecutionCondition {
        private String nodeTypeName;

        public NodeTypeCondition(String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            boolean matches = false;
            JCRNodeWrapper node = resource.getNode();
            if (node != null) {
                try {
                    matches = node.isNodeType(this.nodeTypeName);
                }
                catch (RepositoryException e) {
                    logger.warn("Unable to evaluate filter execution condition for resource " + resource, (Throwable)e);
                }
            } else {
                logger.warn("Unable to evaluate filter execution condition.Node is null for resource " + resource);
            }
            return matches;
        }

        public String toString() {
            return "nodeTypeName == " + this.nodeTypeName;
        }
    }

    public static class ModuleCondition
    extends PatternCondition {
        public ModuleCondition(String module) {
            super(module, false);
        }

        public ModuleCondition(String module, boolean isRegExp) {
            super(module, isRegExp);
        }

        @Override
        public String getValue(RenderContext renderContext, Resource resource) {
            return ((Script)renderContext.getRequest().getAttribute("script")).getView().getModule().getName();
        }

        @Override
        public String toString() {
            return "module " + super.toString();
        }
    }

    public static class EditModeCondition
    implements ExecutionCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return renderContext.isEditMode();
        }

        public String toString() {
            return "render context is in edit mode";
        }
    }

    public static class ModeCondition
    implements ExecutionCondition {
        private String mode;

        public static boolean matches(RenderContext renderContext, String mode) {
            if (mode.equals("contribution")) {
                mode = "contribute";
            }
            return renderContext.getMode() != null && renderContext.getMode().equals(mode);
        }

        public ModeCondition(String mode) {
            this.mode = mode;
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return ModeCondition.matches(renderContext, this.mode);
        }

        public String toString() {
            return "mode == " + this.mode;
        }
    }

    public static class MainResourceCondition
    implements ExecutionCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return renderContext.getMainResource().getNode().getPath().equals(resource.getNode().getPath());
        }

        public String toString() {
            return "is main resource";
        }
    }

    public static interface ExecutionCondition {
        public boolean matches(RenderContext var1, Resource var2);
    }

    public static class ConfigurationCondition
    implements ExecutionCondition {
        private String conf;

        public ConfigurationCondition(String conf) {
            this.conf = conf;
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return resource.getContextConfiguration().equals(this.conf);
        }

        public String toString() {
            return "configuration == " + this.conf;
        }
    }

    public static class AnyOfCondition
    implements ExecutionCondition {
        private List<ExecutionCondition> conditions = new LinkedList<ExecutionCondition>();

        public void add(ExecutionCondition condition) {
            this.conditions.add(condition);
        }

        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            boolean matches = false;
            for (ExecutionCondition condition : this.conditions) {
                if (!condition.matches(renderContext, resource)) continue;
                matches = true;
                break;
            }
            return matches;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            for (ExecutionCondition cond : this.conditions) {
                if (out.length() > 0) {
                    out.append(" || ");
                }
                out.append("(").append(cond).append(")");
            }
            return out.toString();
        }
    }

    public static class AjaxRequestCondition
    implements ExecutionCondition {
        @Override
        public boolean matches(RenderContext renderContext, Resource resource) {
            return renderContext.isAjaxRequest();
        }

        public String toString() {
            return "is Ajax request";
        }
    }
}

