/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.cache.CacheImplementation;
import org.jahia.services.cache.CacheProvider;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.View;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.RenderServiceAware;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.render.scripting.ScriptResolver;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RenderService {
    private static final Comparator<Template> TEMPLATE_PRIORITY_COMPARATOR = new TemplatePriorityComparator();
    public static final String RENDER_SERVICE_TEMPLATES_CACHE = "RenderService.TemplatesCache";
    private CacheImplementation<String, List<String>> templatesCache;
    private ChannelService channelService;
    private JahiaUserManagerService userManagerService;
    private static final Logger logger = LoggerFactory.getLogger(RenderService.class);
    private static volatile RenderService instance;
    private JahiaTemplateManagerService templateManagerService;
    private Collection<ScriptResolver> scriptResolvers;
    private List<RenderFilter> filters = new LinkedList<RenderFilter>();

    private void addFilter(RenderFilter renderFilter) {
        if (this.filters.contains(renderFilter)) {
            this.filters.remove(renderFilter);
        }
        this.filters.add(renderFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RenderService getInstance() {
        if (instance != null) return instance;
        Class<RenderService> clazz = RenderService.class;
        synchronized (RenderService.class) {
            if (instance != null) return instance;
            instance = new RenderService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public void setScriptResolvers(Collection<ScriptResolver> scriptResolvers) {
        this.scriptResolvers = scriptResolvers;
    }

    public Collection<ScriptResolver> getScriptResolvers() {
        return this.scriptResolvers;
    }

    public void start() throws JahiaInitializationException {
    }

    public void stop() throws JahiaException {
    }

    public String render(Resource resource, RenderContext context) throws RenderException {
        if (context.getResourcesStack().contains(resource)) {
            String resourceMessage = Messages.getInternal("label.render.loop", context.getUILocale());
            String formattedMessage = MessageFormat.format(resourceMessage, resource.getPath());
            logger.warn("Loop detected while rendering resource {}. Please check your content structure and references.", (Object)resource.getPath());
            return formattedMessage;
        }
        String output = this.getRenderChainInstance().doFilter(context, resource);
        return output;
    }

    public Script resolveScript(Resource resource, RenderContext context) throws RepositoryException, TemplateNotFoundException {
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            try {
                Script s = scriptResolver.resolveScript(resource, context);
                if (s == null) continue;
                return s;
            }
            catch (TemplateNotFoundException tnfe) {
            }
        }
        throw new TemplateNotFoundException("Unable to find the template for resource " + resource);
    }

    public boolean hasView(JCRNodeWrapper node, String key, String templateType, RenderContext renderContext) {
        try {
            if (this.hasView(node.getPrimaryNodeType(), key, renderContext.getSite(), templateType, renderContext)) {
                return true;
            }
            for (ExtendedNodeType type : node.getMixinNodeTypes()) {
                if (!this.hasView(type, key, renderContext.getSite(), templateType, renderContext)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return false;
    }

    public boolean hasView(ExtendedNodeType nt, String key, JCRSiteNode site, String templateType, RenderContext renderContext) {
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.hasView(nt, key, site, templateType)) continue;
            return true;
        }
        return false;
    }

    public RenderChain getRenderChainInstance() {
        return new RenderChain(this.filters, this.templateManagerService.getRenderFilters());
    }

    public SortedSet<View> getViewsSet(ExtendedNodeType nt, JCRSiteNode site, String templateType) {
        TreeSet<View> set = new TreeSet<View>();
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            set.addAll(scriptResolver.getViewsSet(nt, site, templateType));
        }
        return set;
    }

    public Template resolveTemplate(Resource resource, RenderContext renderContext) throws RepositoryException {
        JCRNodeWrapper node = resource.getNode();
        String templateName = resource.getTemplate();
        if ("default".equals(templateName)) {
            templateName = null;
        }
        Template template = null;
        JCRSiteNode site = renderContext.getSite();
        if (site == null) {
            site = node.getResolveSite();
        }
        if (node.isNodeType("jnt:template")) {
            if (!node.hasProperty("j:view") || "default".equals(node.getProperty("j:view").getString())) {
                JCRNodeWrapper parent = node.getParent();
                while (!parent.isNodeType("jnt:templatesFolder")) {
                    template = new Template(parent.hasProperty("j:view") ? parent.getProperty("j:view").getString() : templateName, parent.getIdentifier(), template, parent.getName());
                    parent = parent.getParent();
                }
                String packageName = "templates-system";
                if (parent.hasProperty("j:templateSetContext")) {
                    renderContext.setSite((JCRSiteNode)parent.getProperty("j:templateSetContext").getNode());
                    packageName = parent.getProperty("j:templateSetContext").getNode().getName();
                }
                LinkedHashSet<String> installed = new LinkedHashSet<String>();
                installed.add(packageName);
                for (JahiaTemplatesPackage aPackage : this.templateManagerService.getTemplatePackageById(packageName).getDependencies()) {
                    installed.add(aPackage.getId());
                }
                template = this.addContextualTemplates(resource, renderContext, template, parent, installed);
            }
        } else {
            if (resource.getTemplate().equals("default") && node.hasProperty("j:templateName")) {
                templateName = node.getProperty("j:templateName").getString();
            }
            LinkedHashSet<String> installedModules = new LinkedHashSet<String>(site.getInstalledModulesWithAllDependencies());
            installedModules.add("templates-system");
            String type = "jnt:contentTemplate";
            if (resource.getNode().isNodeType("jnt:page")) {
                type = "jnt:pageTemplate";
            }
            if ((template = this.addTemplate(resource, renderContext, templateName, installedModules, type)) != null) {
                JCRNodeWrapper templateNode = resource.getNode().getSession().getNodeByIdentifier(template.getNode()).getParent();
                while (!templateNode.isNodeType("jnt:templatesFolder")) {
                    template = new Template(templateNode.hasProperty("j:view") ? templateNode.getProperty("j:view").getString() : null, templateNode.getIdentifier(), template, templateNode.getName());
                    templateNode = templateNode.getParent();
                }
                template = this.addContextualTemplates(resource, renderContext, template, templateNode, installedModules);
            } else {
                return null;
            }
        }
        if (template != null) {
            Template currentTemplate = template;
            do {
                if (currentTemplate.getView().equals("default")) continue;
                template = currentTemplate;
            } while ((currentTemplate = currentTemplate.getNext()) != null);
        } else {
            template = new Template(null, null, null, null);
        }
        return template;
    }

    private Template addContextualTemplates(Resource resource, RenderContext renderContext, Template template, JCRNodeWrapper parent, Set<String> modules) throws RepositoryException {
        if (parent.isNodeType("jnt:templatesFolder") && parent.hasProperty("j:rootTemplatePath")) {
            Template t;
            String rootTemplatePath = parent.getProperty("j:rootTemplatePath").getString();
            if (rootTemplatePath.contains("/")) {
                rootTemplatePath = StringUtils.substringAfterLast((String)rootTemplatePath, (String)"/");
            }
            if (!StringUtils.isEmpty((String)rootTemplatePath) && (t = this.addTemplate(resource, renderContext, rootTemplatePath, modules, "jnt:template")) != null) {
                t.setNext(template);
                return t;
            }
        }
        return template;
    }

    private Template addTemplate(Resource resource, RenderContext renderContext, String templateName, Set<String> installedModules, String type) throws RepositoryException {
        TreeSet<Template> templates = new TreeSet<Template>(TEMPLATE_PRIORITY_COMPARATOR);
        for (String s : installedModules) {
            JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById(s);
            if (pack == null) continue;
            JCRNodeWrapper templateNode = resource.getNode().getSession().getNode("/modules/" + s + "/" + pack.getVersion());
            templates.addAll(this.addTemplates(resource, renderContext, templateName, templateNode, type));
        }
        return templates.isEmpty() ? null : (Template)templates.last();
    }

    private SortedSet<Template> addTemplates(Resource resource, RenderContext renderContext, String templateName, JCRNodeWrapper templateNode, String type) throws RepositoryException {
        List<JCRNodeWrapper> nodes = this.getTemplateNodes(templateName, templateNode.getPath(), type, templateName == null, templateNode.getSession());
        TreeSet<Template> templates = new TreeSet<Template>(TEMPLATE_PRIORITY_COMPARATOR);
        for (JCRNodeWrapper contentTemplateNode : nodes) {
            this.addTemplate(resource, renderContext, contentTemplateNode, templates);
        }
        return templates;
    }

    public List<JCRNodeWrapper> getTemplateNodes(String templateName, String path, String type, boolean defaultOnly, JCRSessionWrapper session) throws RepositoryException {
        String key = path + type + defaultOnly + (templateName != null ? templateName : "*all*");
        ArrayList<JCRNodeWrapper> nodes = new ArrayList<JCRNodeWrapper>();
        List<String> nodeIds = this.templatesCache.get(key);
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                JCRNodeWrapper node = session.getNodeByIdentifier(nodeId);
                nodes.add(node);
            }
        } else {
            String query = "select * from [" + type + "] as w where isdescendantnode(w, ['" + JCRContentUtils.sqlEncode(path) + "'])";
            if (templateName != null) {
                query = query + " and name(w)='" + templateName + "'";
            }
            if (defaultOnly) {
                query = query + " and [j:defaultTemplate]=true";
            }
            query = query + " order by [j:priority] desc";
            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
            QueryResultWrapper result = q.execute();
            nodeIds = new ArrayList<String>();
            for (JCRNodeWrapper wrapper : result.getNodes()) {
                nodes.add(wrapper);
                nodeIds.add(wrapper.getIdentifier());
            }
            this.templatesCache.put(key, null, nodeIds);
        }
        return nodes;
    }

    private void addTemplate(Resource resource, RenderContext renderContext, JCRNodeWrapper templateNode, SortedSet<Template> templates) throws RepositoryException {
        if (templateNode.hasProperty("j:applyOn")) {
            JCRValueWrapper[] values;
            boolean ok = false;
            for (JCRValueWrapper value : values = templateNode.getProperty("j:applyOn").getValues()) {
                if (!resource.getNode().isNodeType(value.getString())) continue;
                ok = true;
                break;
            }
            if (values.length == 0) {
                ok = true;
            }
            if (!ok) {
                return;
            }
        }
        if (!this.checkChannel(renderContext, templateNode)) {
            return;
        }
        if (!this.checkTemplatePermission(resource, renderContext, templateNode)) {
            return;
        }
        templates.add(new Template(templateNode.hasProperty("j:view") ? templateNode.getProperty("j:view").getString() : null, templateNode.getIdentifier(), null, templateNode.getName(), templateNode.hasProperty("j:priority") ? (int)templateNode.getProperty("j:priority").getLong() : 0));
    }

    private boolean checkChannel(RenderContext renderContext, JCRNodeWrapper templateNode) throws RepositoryException {
        if (templateNode.isNodeType("jmix:channelSelection") && templateNode.hasProperty("j:channelSelection")) {
            JCRPropertyWrapper channelExclusionProperty = templateNode.getProperty("j:channelSelection");
            String includeOrExclude = templateNode.hasProperty("j:channelIncludeOrExclude") ? templateNode.getProperty("j:channelIncludeOrExclude").getString() : "exclude";
            Value[] channelExclusionValues = channelExclusionProperty.getValues();
            Channel currentChannel = renderContext.getChannel();
            for (Value channelExclusionValue : channelExclusionValues) {
                if (channelExclusionValue.getString() == null) continue;
                boolean inList = this.channelService.matchChannel(channelExclusionValue.getString(), currentChannel);
                if (inList && includeOrExclude.equals("exclude")) {
                    return renderContext.isEditMode() && (renderContext.getChannel() == null || renderContext.getChannel().getIdentifier().equals("generic"));
                }
                if (!inList || !includeOrExclude.equals("include")) continue;
                return true;
            }
            if (includeOrExclude.equals("include")) {
                return renderContext.isEditMode() && (renderContext.getChannel() == null || renderContext.getChannel().getIdentifier().equals("generic"));
            }
        }
        return true;
    }

    private boolean checkTemplatePermission(Resource resource, RenderContext renderContext, JCRNodeWrapper templateNode) throws RepositoryException {
        JCRUserNode userNode;
        boolean invert;
        boolean bl = invert = templateNode.hasProperty("j:invertCondition") && templateNode.getProperty("j:invertCondition").getBoolean();
        if (templateNode.hasProperty("j:requiredMode") && renderContext.getMode() != null) {
            String req = templateNode.getProperty("j:requiredMode").getString();
            if (!renderContext.getMode().equals(req)) {
                return invert;
            }
        }
        if (templateNode.hasProperty("j:requiredPermissionNames") || templateNode.hasProperty("j:requiredPermissions")) {
            String contextPath;
            Value[] values;
            ArrayList<String> perms = new ArrayList<String>();
            if (templateNode.hasProperty("j:requiredPermissions") && !templateNode.hasProperty("j:requiredPermissionNames")) {
                values = templateNode.getProperty("j:requiredPermissions").getValues();
                perms.addAll((Collection)JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<List<String>>(){

                    @Override
                    public List<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        ArrayList<String> permissionNames = new ArrayList<String>();
                        for (Value value : values) {
                            permissionNames.add(session.getNodeByUUID(value.getString()).getName());
                        }
                        return permissionNames;
                    }
                }));
            } else {
                for (Value value : values = templateNode.getProperty("j:requiredPermissionNames").getValues()) {
                    perms.add(value.getString());
                }
            }
            JCRNodeWrapper contextNode = resource.getNode();
            if (templateNode.hasProperty("j:contextNodePath") && !StringUtils.isEmpty((String)(contextPath = templateNode.getProperty("j:contextNodePath").getString()))) {
                contextNode = contextPath.startsWith("/") ? contextNode.getSession().getNode(contextPath) : contextNode.getNode(contextPath);
            }
            for (String perm : perms) {
                if (contextNode.hasPermission(perm)) continue;
                return invert;
            }
        }
        if (templateNode.hasProperty("j:requireLoggedUser") && templateNode.getProperty("j:requireLoggedUser").getBoolean() && !renderContext.isLoggedIn()) {
            return invert;
        }
        if (templateNode.hasProperty("j:requirePrivilegedUser") && templateNode.getProperty("j:requirePrivilegedUser").getBoolean() && (userNode = this.userManagerService.lookupUserByPath(renderContext.getUser().getLocalPath())) != null && !userNode.isMemberOfGroup(null, "privileged")) {
            return invert;
        }
        return !invert;
    }

    public void flushCache(String group) {
        HashSet<String> keys = new HashSet<String>(this.templatesCache.getKeys());
        for (String s : keys) {
            if (!s.startsWith(group)) continue;
            this.templatesCache.remove(s);
        }
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.templatesCache = cacheProvider.newCacheImplementation(RENDER_SERVICE_TEMPLATES_CACHE);
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public static class RenderServiceBeanPostProcessor
    implements BeanPostProcessor {
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RenderServiceAware) {
                ((RenderServiceAware)bean).setRenderService(RenderService.getInstance());
            }
            if (bean instanceof RenderFilter) {
                logger.debug("Registering render filter {}", (Object)bean.getClass().getName());
                RenderService.getInstance().addFilter((RenderFilter)bean);
            }
            return bean;
        }
    }

    private static class TemplatePriorityComparator
    implements Comparator<Template>,
    Serializable {
        private static final long serialVersionUID = 3462731866743025112L;

        private TemplatePriorityComparator() {
        }

        @Override
        public int compare(Template o1, Template o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

