/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.render.BaseView;
import org.osgi.framework.Bundle;

public class BundleView
extends BaseView {
    private String resource;

    public BundleView(String resource, String key, JahiaTemplatesPackage module, String displayName) {
        super(resource, key, module, displayName);
        this.resource = resource;
    }

    @Override
    public String getPath() {
        return this.getModule().getRootFolderPath() + this.resource;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getBundle().getBundleId() == ((BundleView)o).getBundle().getBundleId();
    }

    public Bundle getBundle() {
        return this.getModule().getBundle();
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(this.resource);
    }

    @Override
    protected InputStream getInputStream(String resource) throws IOException {
        URL url = this.getResource(resource);
        return url != null ? url.openStream() : null;
    }

    public String getResource() {
        return this.resource;
    }

    @Override
    protected URL getResource(String resource) {
        return this.getBundle().getResource(resource);
    }

    @Override
    protected String getResourcePath(String resource) {
        URL url = this.getResource(resource);
        return url != null ? this.getModule().getRootFolderPath() + resource : null;
    }

    @Override
    public int hashCode() {
        long bundleId = this.getBundle().getBundleId();
        return 31 * super.hashCode() + (int)(bundleId ^ bundleId >>> 32);
    }
}

